// services/device/public/mojom/usb_device.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_SHARED_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/usb_device.mojom-shared-internal.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/device/public/mojom/usb_device.mojom-data-view.h"




namespace std {

template <>
struct hash<::device::mojom::UsbOpenDeviceSuccess>
    : public mojo::internal::EnumHashImpl<::device::mojom::UsbOpenDeviceSuccess> {};

template <>
struct hash<::device::mojom::UsbOpenDeviceError>
    : public mojo::internal::EnumHashImpl<::device::mojom::UsbOpenDeviceError> {};

template <>
struct hash<::device::mojom::UsbClaimInterfaceResult>
    : public mojo::internal::EnumHashImpl<::device::mojom::UsbClaimInterfaceResult> {};

template <>
struct hash<::device::mojom::UsbTransferDirection>
    : public mojo::internal::EnumHashImpl<::device::mojom::UsbTransferDirection> {};

template <>
struct hash<::device::mojom::UsbControlTransferType>
    : public mojo::internal::EnumHashImpl<::device::mojom::UsbControlTransferType> {};

template <>
struct hash<::device::mojom::UsbControlTransferRecipient>
    : public mojo::internal::EnumHashImpl<::device::mojom::UsbControlTransferRecipient> {};

template <>
struct hash<::device::mojom::UsbTransferType>
    : public mojo::internal::EnumHashImpl<::device::mojom::UsbTransferType> {};

template <>
struct hash<::device::mojom::UsbSynchronizationType>
    : public mojo::internal::EnumHashImpl<::device::mojom::UsbSynchronizationType> {};

template <>
struct hash<::device::mojom::UsbUsageType>
    : public mojo::internal::EnumHashImpl<::device::mojom::UsbUsageType> {};

template <>
struct hash<::device::mojom::UsbTransferStatus>
    : public mojo::internal::EnumHashImpl<::device::mojom::UsbTransferStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbOpenDeviceSuccess, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::UsbOpenDeviceSuccess, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::UsbOpenDeviceSuccess>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbOpenDeviceError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::UsbOpenDeviceError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::UsbOpenDeviceError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbClaimInterfaceResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::UsbClaimInterfaceResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::UsbClaimInterfaceResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbTransferDirection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::UsbTransferDirection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::UsbTransferDirection>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbControlTransferType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::UsbControlTransferType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::UsbControlTransferType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbControlTransferRecipient, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::UsbControlTransferRecipient, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::UsbControlTransferRecipient>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbTransferType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::UsbTransferType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::UsbTransferType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbSynchronizationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::UsbSynchronizationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::UsbSynchronizationType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbUsageType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::UsbUsageType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::UsbUsageType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbTransferStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::UsbTransferStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::UsbTransferStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbEndpointInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::UsbEndpointInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::UsbEndpointInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->endpoint_number = Traits::endpoint_number(input);

    
    mojo::internal::Serialize<::device::mojom::UsbTransferDirection>(
      Traits::direction(input),
      &fragment->direction);

    
    mojo::internal::Serialize<::device::mojom::UsbTransferType>(
      Traits::type(input),
      &fragment->type);

    fragment->packet_size = Traits::packet_size(input);

    
    mojo::internal::Serialize<::device::mojom::UsbSynchronizationType>(
      Traits::synchronization_type(input),
      &fragment->synchronization_type);

    
    mojo::internal::Serialize<::device::mojom::UsbUsageType>(
      Traits::usage_type(input),
      &fragment->usage_type);

    fragment->polling_interval = Traits::polling_interval(input);

    decltype(Traits::extra_data(input)) in_extra_data = Traits::extra_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extra_data)::BaseType>
        extra_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& extra_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_extra_data,
      extra_data_fragment,
      &extra_data_validate_params);

    fragment->extra_data.Set(
        extra_data_fragment.is_null() ? nullptr : extra_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->extra_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extra_data in UsbEndpointInfo struct");
  }

  static bool Deserialize(::device::mojom::internal::UsbEndpointInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::UsbEndpointInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbAlternateInterfaceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::UsbAlternateInterfaceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::UsbAlternateInterfaceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->alternate_setting = Traits::alternate_setting(input);

    fragment->class_code = Traits::class_code(input);

    fragment->subclass_code = Traits::subclass_code(input);

    fragment->protocol_code = Traits::protocol_code(input);

    decltype(Traits::interface_name(input)) in_interface_name = Traits::interface_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->interface_name)::BaseType> interface_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_interface_name,
      interface_name_fragment);

    fragment->interface_name.Set(
        interface_name_fragment.is_null() ? nullptr : interface_name_fragment.data());

    decltype(Traits::endpoints(input)) in_endpoints = Traits::endpoints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->endpoints)::BaseType>
        endpoints_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& endpoints_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbEndpointInfoDataView>>(
      in_endpoints,
      endpoints_fragment,
      &endpoints_validate_params);

    fragment->endpoints.Set(
        endpoints_fragment.is_null() ? nullptr : endpoints_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->endpoints.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null endpoints in UsbAlternateInterfaceInfo struct");

    decltype(Traits::extra_data(input)) in_extra_data = Traits::extra_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extra_data)::BaseType>
        extra_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& extra_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_extra_data,
      extra_data_fragment,
      &extra_data_validate_params);

    fragment->extra_data.Set(
        extra_data_fragment.is_null() ? nullptr : extra_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->extra_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extra_data in UsbAlternateInterfaceInfo struct");
  }

  static bool Deserialize(::device::mojom::internal::UsbAlternateInterfaceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::UsbAlternateInterfaceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbInterfaceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::UsbInterfaceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::UsbInterfaceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->interface_number = Traits::interface_number(input);

    fragment->first_interface = Traits::first_interface(input);

    decltype(Traits::alternates(input)) in_alternates = Traits::alternates(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->alternates)::BaseType>
        alternates_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& alternates_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbAlternateInterfaceInfoDataView>>(
      in_alternates,
      alternates_fragment,
      &alternates_validate_params);

    fragment->alternates.Set(
        alternates_fragment.is_null() ? nullptr : alternates_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->alternates.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alternates in UsbInterfaceInfo struct");
  }

  static bool Deserialize(::device::mojom::internal::UsbInterfaceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::UsbInterfaceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbConfigurationInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::UsbConfigurationInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::UsbConfigurationInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->configuration_value = Traits::configuration_value(input);

    decltype(Traits::configuration_name(input)) in_configuration_name = Traits::configuration_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->configuration_name)::BaseType> configuration_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_configuration_name,
      configuration_name_fragment);

    fragment->configuration_name.Set(
        configuration_name_fragment.is_null() ? nullptr : configuration_name_fragment.data());

    fragment->self_powered = Traits::self_powered(input);

    fragment->remote_wakeup = Traits::remote_wakeup(input);

    fragment->maximum_power = Traits::maximum_power(input);

    decltype(Traits::interfaces(input)) in_interfaces = Traits::interfaces(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->interfaces)::BaseType>
        interfaces_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& interfaces_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbInterfaceInfoDataView>>(
      in_interfaces,
      interfaces_fragment,
      &interfaces_validate_params);

    fragment->interfaces.Set(
        interfaces_fragment.is_null() ? nullptr : interfaces_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->interfaces.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null interfaces in UsbConfigurationInfo struct");

    decltype(Traits::extra_data(input)) in_extra_data = Traits::extra_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extra_data)::BaseType>
        extra_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& extra_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_extra_data,
      extra_data_fragment,
      &extra_data_validate_params);

    fragment->extra_data.Set(
        extra_data_fragment.is_null() ? nullptr : extra_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->extra_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extra_data in UsbConfigurationInfo struct");
  }

  static bool Deserialize(::device::mojom::internal::UsbConfigurationInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::UsbConfigurationInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbDeviceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::UsbDeviceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::UsbDeviceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::guid(input)) in_guid = Traits::guid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->guid)::BaseType> guid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_guid,
      guid_fragment);

    fragment->guid.Set(
        guid_fragment.is_null() ? nullptr : guid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->guid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null guid in UsbDeviceInfo struct");

    fragment->usb_version_major = Traits::usb_version_major(input);

    fragment->usb_version_minor = Traits::usb_version_minor(input);

    fragment->usb_version_subminor = Traits::usb_version_subminor(input);

    fragment->class_code = Traits::class_code(input);

    fragment->subclass_code = Traits::subclass_code(input);

    fragment->protocol_code = Traits::protocol_code(input);

    fragment->bus_number = Traits::bus_number(input);

    fragment->port_number = Traits::port_number(input);

    fragment->vendor_id = Traits::vendor_id(input);

    fragment->product_id = Traits::product_id(input);

    fragment->device_version_major = Traits::device_version_major(input);

    fragment->device_version_minor = Traits::device_version_minor(input);

    fragment->device_version_subminor = Traits::device_version_subminor(input);

    decltype(Traits::manufacturer_name(input)) in_manufacturer_name = Traits::manufacturer_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->manufacturer_name)::BaseType> manufacturer_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_manufacturer_name,
      manufacturer_name_fragment);

    fragment->manufacturer_name.Set(
        manufacturer_name_fragment.is_null() ? nullptr : manufacturer_name_fragment.data());

    decltype(Traits::product_name(input)) in_product_name = Traits::product_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->product_name)::BaseType> product_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_product_name,
      product_name_fragment);

    fragment->product_name.Set(
        product_name_fragment.is_null() ? nullptr : product_name_fragment.data());

    decltype(Traits::serial_number(input)) in_serial_number = Traits::serial_number(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->serial_number)::BaseType> serial_number_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_serial_number,
      serial_number_fragment);

    fragment->serial_number.Set(
        serial_number_fragment.is_null() ? nullptr : serial_number_fragment.data());

    decltype(Traits::webusb_landing_page(input)) in_webusb_landing_page = Traits::webusb_landing_page(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->webusb_landing_page)::BaseType> webusb_landing_page_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_webusb_landing_page,
      webusb_landing_page_fragment);

    fragment->webusb_landing_page.Set(
        webusb_landing_page_fragment.is_null() ? nullptr : webusb_landing_page_fragment.data());

    fragment->active_configuration = Traits::active_configuration(input);

    decltype(Traits::configurations(input)) in_configurations = Traits::configurations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->configurations)::BaseType>
        configurations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& configurations_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbConfigurationInfoDataView>>(
      in_configurations,
      configurations_fragment,
      &configurations_validate_params);

    fragment->configurations.Set(
        configurations_fragment.is_null() ? nullptr : configurations_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->configurations.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null configurations in UsbDeviceInfo struct");
  }

  static bool Deserialize(::device::mojom::internal::UsbDeviceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::UsbDeviceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbControlTransferParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::UsbControlTransferParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::UsbControlTransferParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::device::mojom::UsbControlTransferType>(
      Traits::type(input),
      &fragment->type);

    
    mojo::internal::Serialize<::device::mojom::UsbControlTransferRecipient>(
      Traits::recipient(input),
      &fragment->recipient);

    fragment->request = Traits::request(input);

    fragment->value = Traits::value(input);

    fragment->index = Traits::index(input);
  }

  static bool Deserialize(::device::mojom::internal::UsbControlTransferParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::UsbControlTransferParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbIsochronousPacketDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::UsbIsochronousPacketDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::UsbIsochronousPacket_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->length = Traits::length(input);

    fragment->transferred_length = Traits::transferred_length(input);

    
    mojo::internal::Serialize<::device::mojom::UsbTransferStatus>(
      Traits::status(input),
      &fragment->status);
  }

  static bool Deserialize(::device::mojom::internal::UsbIsochronousPacket_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::UsbIsochronousPacketDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UsbOpenDeviceResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::UsbOpenDeviceResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::UsbOpenDeviceResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::UsbOpenDeviceResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
        
mojo::internal::Serialize<::device::mojom::UsbOpenDeviceSuccess>(
  in_success,
  &fragment->data.f_success);
    break;
  }
  case ::device::mojom::UsbOpenDeviceResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::UsbOpenDeviceError>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }

  static bool Deserialize(::device::mojom::internal::UsbOpenDeviceResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::UsbOpenDeviceResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {

inline void UsbEndpointInfoDataView::GetExtraDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->extra_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void UsbAlternateInterfaceInfoDataView::GetInterfaceNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->interface_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void UsbAlternateInterfaceInfoDataView::GetEndpointsDataView(
    mojo::ArrayDataView<UsbEndpointInfoDataView>* output) {
  auto pointer = data_->endpoints.Get();
  *output = mojo::ArrayDataView<UsbEndpointInfoDataView>(pointer, message_);
}
inline void UsbAlternateInterfaceInfoDataView::GetExtraDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->extra_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void UsbInterfaceInfoDataView::GetAlternatesDataView(
    mojo::ArrayDataView<UsbAlternateInterfaceInfoDataView>* output) {
  auto pointer = data_->alternates.Get();
  *output = mojo::ArrayDataView<UsbAlternateInterfaceInfoDataView>(pointer, message_);
}


inline void UsbConfigurationInfoDataView::GetConfigurationNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->configuration_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void UsbConfigurationInfoDataView::GetInterfacesDataView(
    mojo::ArrayDataView<UsbInterfaceInfoDataView>* output) {
  auto pointer = data_->interfaces.Get();
  *output = mojo::ArrayDataView<UsbInterfaceInfoDataView>(pointer, message_);
}
inline void UsbConfigurationInfoDataView::GetExtraDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->extra_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void UsbDeviceInfoDataView::GetGuidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->guid.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void UsbDeviceInfoDataView::GetManufacturerNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->manufacturer_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void UsbDeviceInfoDataView::GetProductNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->product_name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void UsbDeviceInfoDataView::GetSerialNumberDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->serial_number.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void UsbDeviceInfoDataView::GetWebusbLandingPageDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->webusb_landing_page.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void UsbDeviceInfoDataView::GetConfigurationsDataView(
    mojo::ArrayDataView<UsbConfigurationInfoDataView>* output) {
  auto pointer = data_->configurations.Get();
  *output = mojo::ArrayDataView<UsbConfigurationInfoDataView>(pointer, message_);
}








}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::UsbOpenDeviceSuccess> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::UsbOpenDeviceSuccess value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::UsbOpenDeviceError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::UsbOpenDeviceError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::UsbClaimInterfaceResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::UsbClaimInterfaceResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::UsbTransferDirection> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::UsbTransferDirection value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::UsbControlTransferType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::UsbControlTransferType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::UsbControlTransferRecipient> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::UsbControlTransferRecipient value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::UsbTransferType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::UsbTransferType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::UsbSynchronizationType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::UsbSynchronizationType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::UsbUsageType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::UsbUsageType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::UsbTransferStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::UsbTransferStatus value);
};

} // namespace perfetto

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_SHARED_H_