// services/device/public/mojom/usb_device.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_SEND_VALIDATION_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_SEND_VALIDATION_H_

#include "services/device/public/mojom/usb_device.mojom-shared-internal.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "services/device/public/mojom/usb_device.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::UsbOpenDeviceSuccess, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::UsbOpenDeviceError, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::UsbClaimInterfaceResult, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::UsbTransferDirection, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::UsbControlTransferType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::UsbControlTransferRecipient, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::UsbTransferType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::UsbSynchronizationType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::UsbUsageType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::UsbTransferStatus, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::UsbEndpointInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::UsbEndpointInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::UsbEndpointInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->endpoint_number = Traits::endpoint_number(input);

      
      mojo::internal::Serialize<::device::mojom::UsbTransferDirection>(
        Traits::direction(input),
        &fragment->direction);

      
      mojo::internal::Serialize<::device::mojom::UsbTransferType>(
        Traits::type(input),
        &fragment->type);

      fragment->packet_size = Traits::packet_size(input);

      
      mojo::internal::Serialize<::device::mojom::UsbSynchronizationType>(
        Traits::synchronization_type(input),
        &fragment->synchronization_type);

      
      mojo::internal::Serialize<::device::mojom::UsbUsageType>(
        Traits::usage_type(input),
        &fragment->usage_type);

      fragment->polling_interval = Traits::polling_interval(input);

      decltype(Traits::extra_data(input)) in_extra_data = Traits::extra_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->extra_data)::BaseType>
          extra_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& extra_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_extra_data,
        extra_data_fragment,
        &extra_data_validate_params);

      fragment->extra_data.Set(
          extra_data_fragment.is_null() ? nullptr : extra_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->extra_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extra_data in UsbEndpointInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::UsbAlternateInterfaceInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::UsbAlternateInterfaceInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::UsbAlternateInterfaceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->alternate_setting = Traits::alternate_setting(input);

      fragment->class_code = Traits::class_code(input);

      fragment->subclass_code = Traits::subclass_code(input);

      fragment->protocol_code = Traits::protocol_code(input);

      decltype(Traits::interface_name(input)) in_interface_name = Traits::interface_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->interface_name)::BaseType> interface_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_interface_name,
        interface_name_fragment);

      fragment->interface_name.Set(
          interface_name_fragment.is_null() ? nullptr : interface_name_fragment.data());

      decltype(Traits::endpoints(input)) in_endpoints = Traits::endpoints(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->endpoints)::BaseType>
          endpoints_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& endpoints_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbEndpointInfoDataView>, send_validation>(
        in_endpoints,
        endpoints_fragment,
        &endpoints_validate_params);

      fragment->endpoints.Set(
          endpoints_fragment.is_null() ? nullptr : endpoints_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->endpoints.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null endpoints in UsbAlternateInterfaceInfo struct");

      decltype(Traits::extra_data(input)) in_extra_data = Traits::extra_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->extra_data)::BaseType>
          extra_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& extra_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_extra_data,
        extra_data_fragment,
        &extra_data_validate_params);

      fragment->extra_data.Set(
          extra_data_fragment.is_null() ? nullptr : extra_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->extra_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extra_data in UsbAlternateInterfaceInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::UsbInterfaceInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::UsbInterfaceInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::UsbInterfaceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->interface_number = Traits::interface_number(input);

      fragment->first_interface = Traits::first_interface(input);

      decltype(Traits::alternates(input)) in_alternates = Traits::alternates(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->alternates)::BaseType>
          alternates_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& alternates_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbAlternateInterfaceInfoDataView>, send_validation>(
        in_alternates,
        alternates_fragment,
        &alternates_validate_params);

      fragment->alternates.Set(
          alternates_fragment.is_null() ? nullptr : alternates_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->alternates.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null alternates in UsbInterfaceInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::UsbConfigurationInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::UsbConfigurationInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::UsbConfigurationInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->configuration_value = Traits::configuration_value(input);

      decltype(Traits::configuration_name(input)) in_configuration_name = Traits::configuration_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->configuration_name)::BaseType> configuration_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_configuration_name,
        configuration_name_fragment);

      fragment->configuration_name.Set(
          configuration_name_fragment.is_null() ? nullptr : configuration_name_fragment.data());

      fragment->self_powered = Traits::self_powered(input);

      fragment->remote_wakeup = Traits::remote_wakeup(input);

      fragment->maximum_power = Traits::maximum_power(input);

      decltype(Traits::interfaces(input)) in_interfaces = Traits::interfaces(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->interfaces)::BaseType>
          interfaces_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& interfaces_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbInterfaceInfoDataView>, send_validation>(
        in_interfaces,
        interfaces_fragment,
        &interfaces_validate_params);

      fragment->interfaces.Set(
          interfaces_fragment.is_null() ? nullptr : interfaces_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->interfaces.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null interfaces in UsbConfigurationInfo struct");

      decltype(Traits::extra_data(input)) in_extra_data = Traits::extra_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->extra_data)::BaseType>
          extra_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& extra_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_extra_data,
        extra_data_fragment,
        &extra_data_validate_params);

      fragment->extra_data.Set(
          extra_data_fragment.is_null() ? nullptr : extra_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->extra_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extra_data in UsbConfigurationInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::UsbDeviceInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::UsbDeviceInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::UsbDeviceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::guid(input)) in_guid = Traits::guid(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->guid)::BaseType> guid_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_guid,
        guid_fragment);

      fragment->guid.Set(
          guid_fragment.is_null() ? nullptr : guid_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->guid.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null guid in UsbDeviceInfo struct");

      fragment->usb_version_major = Traits::usb_version_major(input);

      fragment->usb_version_minor = Traits::usb_version_minor(input);

      fragment->usb_version_subminor = Traits::usb_version_subminor(input);

      fragment->class_code = Traits::class_code(input);

      fragment->subclass_code = Traits::subclass_code(input);

      fragment->protocol_code = Traits::protocol_code(input);

      fragment->bus_number = Traits::bus_number(input);

      fragment->port_number = Traits::port_number(input);

      fragment->vendor_id = Traits::vendor_id(input);

      fragment->product_id = Traits::product_id(input);

      fragment->device_version_major = Traits::device_version_major(input);

      fragment->device_version_minor = Traits::device_version_minor(input);

      fragment->device_version_subminor = Traits::device_version_subminor(input);

      decltype(Traits::manufacturer_name(input)) in_manufacturer_name = Traits::manufacturer_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->manufacturer_name)::BaseType> manufacturer_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_manufacturer_name,
        manufacturer_name_fragment);

      fragment->manufacturer_name.Set(
          manufacturer_name_fragment.is_null() ? nullptr : manufacturer_name_fragment.data());

      decltype(Traits::product_name(input)) in_product_name = Traits::product_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->product_name)::BaseType> product_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_product_name,
        product_name_fragment);

      fragment->product_name.Set(
          product_name_fragment.is_null() ? nullptr : product_name_fragment.data());

      decltype(Traits::serial_number(input)) in_serial_number = Traits::serial_number(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->serial_number)::BaseType> serial_number_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_serial_number,
        serial_number_fragment);

      fragment->serial_number.Set(
          serial_number_fragment.is_null() ? nullptr : serial_number_fragment.data());

      decltype(Traits::webusb_landing_page(input)) in_webusb_landing_page = Traits::webusb_landing_page(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->webusb_landing_page)::BaseType> webusb_landing_page_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_webusb_landing_page,
        webusb_landing_page_fragment);

      fragment->webusb_landing_page.Set(
          webusb_landing_page_fragment.is_null() ? nullptr : webusb_landing_page_fragment.data());

      fragment->active_configuration = Traits::active_configuration(input);

      decltype(Traits::configurations(input)) in_configurations = Traits::configurations(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->configurations)::BaseType>
          configurations_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& configurations_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::UsbConfigurationInfoDataView>, send_validation>(
        in_configurations,
        configurations_fragment,
        &configurations_validate_params);

      fragment->configurations.Set(
          configurations_fragment.is_null() ? nullptr : configurations_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->configurations.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null configurations in UsbDeviceInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::UsbControlTransferParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::UsbControlTransferParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::UsbControlTransferParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::device::mojom::UsbControlTransferType>(
        Traits::type(input),
        &fragment->type);

      
      mojo::internal::Serialize<::device::mojom::UsbControlTransferRecipient>(
        Traits::recipient(input),
        &fragment->recipient);

      fragment->request = Traits::request(input);

      fragment->value = Traits::value(input);

      fragment->index = Traits::index(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::UsbIsochronousPacketDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::UsbIsochronousPacketDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::UsbIsochronousPacket_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->length = Traits::length(input);

      fragment->transferred_length = Traits::transferred_length(input);

      
      mojo::internal::Serialize<::device::mojom::UsbTransferStatus>(
        Traits::status(input),
        &fragment->status);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::UsbOpenDeviceResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::UsbOpenDeviceResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::UsbOpenDeviceResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::UsbOpenDeviceResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
        
mojo::internal::Serialize<::device::mojom::UsbOpenDeviceSuccess, send_validation>(
  in_success,
  &fragment->data.f_success);
    break;
  }
  case ::device::mojom::UsbOpenDeviceResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::UsbOpenDeviceError, send_validation>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_SEND_VALIDATION_H_