// services/device/public/mojom/usb_device.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_PARAMS_DATA_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace device::mojom {
namespace internal {
class  UsbDevice_Open_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_Open_Params_Data>;

  UsbDevice_Open_Params_Data();
  ~UsbDevice_Open_Params_Data() = delete;
};
static_assert(sizeof(UsbDevice_Open_Params_Data) == 8,
              "Bad sizeof(UsbDevice_Open_Params_Data)");
class  UsbDevice_Open_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::UsbOpenDeviceResult_Data result;

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_Open_ResponseParams_Data>;

  UsbDevice_Open_ResponseParams_Data();
  ~UsbDevice_Open_ResponseParams_Data() = delete;
};
static_assert(sizeof(UsbDevice_Open_ResponseParams_Data) == 24,
              "Bad sizeof(UsbDevice_Open_ResponseParams_Data)");
class  UsbDevice_Close_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_Close_Params_Data>;

  UsbDevice_Close_Params_Data();
  ~UsbDevice_Close_Params_Data() = delete;
};
static_assert(sizeof(UsbDevice_Close_Params_Data) == 8,
              "Bad sizeof(UsbDevice_Close_Params_Data)");
class  UsbDevice_Close_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_Close_ResponseParams_Data>;

  UsbDevice_Close_ResponseParams_Data();
  ~UsbDevice_Close_ResponseParams_Data() = delete;
};
static_assert(sizeof(UsbDevice_Close_ResponseParams_Data) == 8,
              "Bad sizeof(UsbDevice_Close_ResponseParams_Data)");
class  UsbDevice_SetConfiguration_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t value;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_SetConfiguration_Params_Data>;

  UsbDevice_SetConfiguration_Params_Data();
  ~UsbDevice_SetConfiguration_Params_Data() = delete;
};
static_assert(sizeof(UsbDevice_SetConfiguration_Params_Data) == 16,
              "Bad sizeof(UsbDevice_SetConfiguration_Params_Data)");
class  UsbDevice_SetConfiguration_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_SetConfiguration_ResponseParams_Data>;

  UsbDevice_SetConfiguration_ResponseParams_Data();
  ~UsbDevice_SetConfiguration_ResponseParams_Data() = delete;
};
static_assert(sizeof(UsbDevice_SetConfiguration_ResponseParams_Data) == 16,
              "Bad sizeof(UsbDevice_SetConfiguration_ResponseParams_Data)");
class  UsbDevice_ClaimInterface_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t interface_number;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_ClaimInterface_Params_Data>;

  UsbDevice_ClaimInterface_Params_Data();
  ~UsbDevice_ClaimInterface_Params_Data() = delete;
};
static_assert(sizeof(UsbDevice_ClaimInterface_Params_Data) == 16,
              "Bad sizeof(UsbDevice_ClaimInterface_Params_Data)");
class  UsbDevice_ClaimInterface_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t result;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_ClaimInterface_ResponseParams_Data>;

  UsbDevice_ClaimInterface_ResponseParams_Data();
  ~UsbDevice_ClaimInterface_ResponseParams_Data() = delete;
};
static_assert(sizeof(UsbDevice_ClaimInterface_ResponseParams_Data) == 16,
              "Bad sizeof(UsbDevice_ClaimInterface_ResponseParams_Data)");
class  UsbDevice_ReleaseInterface_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t interface_number;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_ReleaseInterface_Params_Data>;

  UsbDevice_ReleaseInterface_Params_Data();
  ~UsbDevice_ReleaseInterface_Params_Data() = delete;
};
static_assert(sizeof(UsbDevice_ReleaseInterface_Params_Data) == 16,
              "Bad sizeof(UsbDevice_ReleaseInterface_Params_Data)");
class  UsbDevice_ReleaseInterface_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_ReleaseInterface_ResponseParams_Data>;

  UsbDevice_ReleaseInterface_ResponseParams_Data();
  ~UsbDevice_ReleaseInterface_ResponseParams_Data() = delete;
};
static_assert(sizeof(UsbDevice_ReleaseInterface_ResponseParams_Data) == 16,
              "Bad sizeof(UsbDevice_ReleaseInterface_ResponseParams_Data)");
class  UsbDevice_SetInterfaceAlternateSetting_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t interface_number;
  uint8_t alternate_setting;
  uint8_t padfinal_[6];

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_SetInterfaceAlternateSetting_Params_Data>;

  UsbDevice_SetInterfaceAlternateSetting_Params_Data();
  ~UsbDevice_SetInterfaceAlternateSetting_Params_Data() = delete;
};
static_assert(sizeof(UsbDevice_SetInterfaceAlternateSetting_Params_Data) == 16,
              "Bad sizeof(UsbDevice_SetInterfaceAlternateSetting_Params_Data)");
class  UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data>;

  UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data();
  ~UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data() = delete;
};
static_assert(sizeof(UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data) == 16,
              "Bad sizeof(UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data)");
class  UsbDevice_Reset_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_Reset_Params_Data>;

  UsbDevice_Reset_Params_Data();
  ~UsbDevice_Reset_Params_Data() = delete;
};
static_assert(sizeof(UsbDevice_Reset_Params_Data) == 8,
              "Bad sizeof(UsbDevice_Reset_Params_Data)");
class  UsbDevice_Reset_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_Reset_ResponseParams_Data>;

  UsbDevice_Reset_ResponseParams_Data();
  ~UsbDevice_Reset_ResponseParams_Data() = delete;
};
static_assert(sizeof(UsbDevice_Reset_ResponseParams_Data) == 16,
              "Bad sizeof(UsbDevice_Reset_ResponseParams_Data)");
class  UsbDevice_ClearHalt_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t direction;
  uint8_t endpoint_number;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_ClearHalt_Params_Data>;

  UsbDevice_ClearHalt_Params_Data();
  ~UsbDevice_ClearHalt_Params_Data() = delete;
};
static_assert(sizeof(UsbDevice_ClearHalt_Params_Data) == 16,
              "Bad sizeof(UsbDevice_ClearHalt_Params_Data)");
class  UsbDevice_ClearHalt_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_ClearHalt_ResponseParams_Data>;

  UsbDevice_ClearHalt_ResponseParams_Data();
  ~UsbDevice_ClearHalt_ResponseParams_Data() = delete;
};
static_assert(sizeof(UsbDevice_ClearHalt_ResponseParams_Data) == 16,
              "Bad sizeof(UsbDevice_ClearHalt_ResponseParams_Data)");
class  UsbDevice_ControlTransferIn_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::UsbControlTransferParams_Data> params;
  uint32_t length;
  uint32_t timeout;

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_ControlTransferIn_Params_Data>;

  UsbDevice_ControlTransferIn_Params_Data();
  ~UsbDevice_ControlTransferIn_Params_Data() = delete;
};
static_assert(sizeof(UsbDevice_ControlTransferIn_Params_Data) == 24,
              "Bad sizeof(UsbDevice_ControlTransferIn_Params_Data)");
class  UsbDevice_ControlTransferIn_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyBuffer_Data> data;

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_ControlTransferIn_ResponseParams_Data>;

  UsbDevice_ControlTransferIn_ResponseParams_Data();
  ~UsbDevice_ControlTransferIn_ResponseParams_Data() = delete;
};
static_assert(sizeof(UsbDevice_ControlTransferIn_ResponseParams_Data) == 24,
              "Bad sizeof(UsbDevice_ControlTransferIn_ResponseParams_Data)");
class  UsbDevice_ControlTransferOut_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::UsbControlTransferParams_Data> params;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyBuffer_Data> data;
  uint32_t timeout;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_ControlTransferOut_Params_Data>;

  UsbDevice_ControlTransferOut_Params_Data();
  ~UsbDevice_ControlTransferOut_Params_Data() = delete;
};
static_assert(sizeof(UsbDevice_ControlTransferOut_Params_Data) == 32,
              "Bad sizeof(UsbDevice_ControlTransferOut_Params_Data)");
class  UsbDevice_ControlTransferOut_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_ControlTransferOut_ResponseParams_Data>;

  UsbDevice_ControlTransferOut_ResponseParams_Data();
  ~UsbDevice_ControlTransferOut_ResponseParams_Data() = delete;
};
static_assert(sizeof(UsbDevice_ControlTransferOut_ResponseParams_Data) == 16,
              "Bad sizeof(UsbDevice_ControlTransferOut_ResponseParams_Data)");
class  UsbDevice_GenericTransferIn_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t endpoint_number;
  uint8_t pad0_[3];
  uint32_t length;
  uint32_t timeout;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_GenericTransferIn_Params_Data>;

  UsbDevice_GenericTransferIn_Params_Data();
  ~UsbDevice_GenericTransferIn_Params_Data() = delete;
};
static_assert(sizeof(UsbDevice_GenericTransferIn_Params_Data) == 24,
              "Bad sizeof(UsbDevice_GenericTransferIn_Params_Data)");
class  UsbDevice_GenericTransferIn_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyBuffer_Data> data;

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_GenericTransferIn_ResponseParams_Data>;

  UsbDevice_GenericTransferIn_ResponseParams_Data();
  ~UsbDevice_GenericTransferIn_ResponseParams_Data() = delete;
};
static_assert(sizeof(UsbDevice_GenericTransferIn_ResponseParams_Data) == 24,
              "Bad sizeof(UsbDevice_GenericTransferIn_ResponseParams_Data)");
class  UsbDevice_GenericTransferOut_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t endpoint_number;
  uint8_t pad0_[3];
  uint32_t timeout;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyBuffer_Data> data;

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_GenericTransferOut_Params_Data>;

  UsbDevice_GenericTransferOut_Params_Data();
  ~UsbDevice_GenericTransferOut_Params_Data() = delete;
};
static_assert(sizeof(UsbDevice_GenericTransferOut_Params_Data) == 24,
              "Bad sizeof(UsbDevice_GenericTransferOut_Params_Data)");
class  UsbDevice_GenericTransferOut_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_GenericTransferOut_ResponseParams_Data>;

  UsbDevice_GenericTransferOut_ResponseParams_Data();
  ~UsbDevice_GenericTransferOut_ResponseParams_Data() = delete;
};
static_assert(sizeof(UsbDevice_GenericTransferOut_ResponseParams_Data) == 16,
              "Bad sizeof(UsbDevice_GenericTransferOut_ResponseParams_Data)");
class  UsbDevice_IsochronousTransferIn_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t endpoint_number;
  uint8_t pad0_[3];
  uint32_t timeout;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> packet_lengths;

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_IsochronousTransferIn_Params_Data>;

  UsbDevice_IsochronousTransferIn_Params_Data();
  ~UsbDevice_IsochronousTransferIn_Params_Data() = delete;
};
static_assert(sizeof(UsbDevice_IsochronousTransferIn_Params_Data) == 24,
              "Bad sizeof(UsbDevice_IsochronousTransferIn_Params_Data)");
class  UsbDevice_IsochronousTransferIn_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyBuffer_Data> data;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::UsbIsochronousPacket_Data>>> packets;

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_IsochronousTransferIn_ResponseParams_Data>;

  UsbDevice_IsochronousTransferIn_ResponseParams_Data();
  ~UsbDevice_IsochronousTransferIn_ResponseParams_Data() = delete;
};
static_assert(sizeof(UsbDevice_IsochronousTransferIn_ResponseParams_Data) == 24,
              "Bad sizeof(UsbDevice_IsochronousTransferIn_ResponseParams_Data)");
class  UsbDevice_IsochronousTransferOut_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t endpoint_number;
  uint8_t pad0_[3];
  uint32_t timeout;
  mojo::internal::Pointer<::mojo_base::mojom::internal::ReadOnlyBuffer_Data> data;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint32_t>> packet_lengths;

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_IsochronousTransferOut_Params_Data>;

  UsbDevice_IsochronousTransferOut_Params_Data();
  ~UsbDevice_IsochronousTransferOut_Params_Data() = delete;
};
static_assert(sizeof(UsbDevice_IsochronousTransferOut_Params_Data) == 32,
              "Bad sizeof(UsbDevice_IsochronousTransferOut_Params_Data)");
class  UsbDevice_IsochronousTransferOut_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::UsbIsochronousPacket_Data>>> packets;

 private:
  friend class mojo::internal::MessageFragment<UsbDevice_IsochronousTransferOut_ResponseParams_Data>;

  UsbDevice_IsochronousTransferOut_ResponseParams_Data();
  ~UsbDevice_IsochronousTransferOut_ResponseParams_Data() = delete;
};
static_assert(sizeof(UsbDevice_IsochronousTransferOut_ResponseParams_Data) == 16,
              "Bad sizeof(UsbDevice_IsochronousTransferOut_ResponseParams_Data)");
class  UsbDeviceClient_OnDeviceOpened_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<UsbDeviceClient_OnDeviceOpened_Params_Data>;

  UsbDeviceClient_OnDeviceOpened_Params_Data();
  ~UsbDeviceClient_OnDeviceOpened_Params_Data() = delete;
};
static_assert(sizeof(UsbDeviceClient_OnDeviceOpened_Params_Data) == 8,
              "Bad sizeof(UsbDeviceClient_OnDeviceOpened_Params_Data)");
class  UsbDeviceClient_OnDeviceClosed_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<UsbDeviceClient_OnDeviceClosed_Params_Data>;

  UsbDeviceClient_OnDeviceClosed_Params_Data();
  ~UsbDeviceClient_OnDeviceClosed_Params_Data() = delete;
};
static_assert(sizeof(UsbDeviceClient_OnDeviceClosed_Params_Data) == 8,
              "Bad sizeof(UsbDeviceClient_OnDeviceClosed_Params_Data)");

}  // namespace internal


class UsbDevice_Open_ParamsDataView {
 public:
  UsbDevice_Open_ParamsDataView() = default;

  UsbDevice_Open_ParamsDataView(
      internal::UsbDevice_Open_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::UsbDevice_Open_Params_Data* data_ = nullptr;
};


class UsbDevice_Open_ResponseParamsDataView {
 public:
  UsbDevice_Open_ResponseParamsDataView() = default;

  UsbDevice_Open_ResponseParamsDataView(
      internal::UsbDevice_Open_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      UsbOpenDeviceResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = !data_->result.is_null() ? &data_->result : nullptr;
    return mojo::internal::Deserialize<::device::mojom::UsbOpenDeviceResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::UsbDevice_Open_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UsbDevice_Close_ParamsDataView {
 public:
  UsbDevice_Close_ParamsDataView() = default;

  UsbDevice_Close_ParamsDataView(
      internal::UsbDevice_Close_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::UsbDevice_Close_Params_Data* data_ = nullptr;
};


class UsbDevice_Close_ResponseParamsDataView {
 public:
  UsbDevice_Close_ResponseParamsDataView() = default;

  UsbDevice_Close_ResponseParamsDataView(
      internal::UsbDevice_Close_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::UsbDevice_Close_ResponseParams_Data* data_ = nullptr;
};


class UsbDevice_SetConfiguration_ParamsDataView {
 public:
  UsbDevice_SetConfiguration_ParamsDataView() = default;

  UsbDevice_SetConfiguration_ParamsDataView(
      internal::UsbDevice_SetConfiguration_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint8_t value() const {
    return data_->value;
  }
 private:
  internal::UsbDevice_SetConfiguration_Params_Data* data_ = nullptr;
};


class UsbDevice_SetConfiguration_ResponseParamsDataView {
 public:
  UsbDevice_SetConfiguration_ResponseParamsDataView() = default;

  UsbDevice_SetConfiguration_ResponseParamsDataView(
      internal::UsbDevice_SetConfiguration_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::UsbDevice_SetConfiguration_ResponseParams_Data* data_ = nullptr;
};


class UsbDevice_ClaimInterface_ParamsDataView {
 public:
  UsbDevice_ClaimInterface_ParamsDataView() = default;

  UsbDevice_ClaimInterface_ParamsDataView(
      internal::UsbDevice_ClaimInterface_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint8_t interface_number() const {
    return data_->interface_number;
  }
 private:
  internal::UsbDevice_ClaimInterface_Params_Data* data_ = nullptr;
};


class UsbDevice_ClaimInterface_ResponseParamsDataView {
 public:
  UsbDevice_ClaimInterface_ResponseParamsDataView() = default;

  UsbDevice_ClaimInterface_ResponseParamsDataView(
      internal::UsbDevice_ClaimInterface_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) const {
    auto data_value = data_->result;
    return mojo::internal::Deserialize<::device::mojom::UsbClaimInterfaceResult>(
        data_value, output);
  }
  UsbClaimInterfaceResult result() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::UsbClaimInterfaceResult>(data_->result));
  }
 private:
  internal::UsbDevice_ClaimInterface_ResponseParams_Data* data_ = nullptr;
};


class UsbDevice_ReleaseInterface_ParamsDataView {
 public:
  UsbDevice_ReleaseInterface_ParamsDataView() = default;

  UsbDevice_ReleaseInterface_ParamsDataView(
      internal::UsbDevice_ReleaseInterface_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint8_t interface_number() const {
    return data_->interface_number;
  }
 private:
  internal::UsbDevice_ReleaseInterface_Params_Data* data_ = nullptr;
};


class UsbDevice_ReleaseInterface_ResponseParamsDataView {
 public:
  UsbDevice_ReleaseInterface_ResponseParamsDataView() = default;

  UsbDevice_ReleaseInterface_ResponseParamsDataView(
      internal::UsbDevice_ReleaseInterface_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::UsbDevice_ReleaseInterface_ResponseParams_Data* data_ = nullptr;
};


class UsbDevice_SetInterfaceAlternateSetting_ParamsDataView {
 public:
  UsbDevice_SetInterfaceAlternateSetting_ParamsDataView() = default;

  UsbDevice_SetInterfaceAlternateSetting_ParamsDataView(
      internal::UsbDevice_SetInterfaceAlternateSetting_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint8_t interface_number() const {
    return data_->interface_number;
  }
  uint8_t alternate_setting() const {
    return data_->alternate_setting;
  }
 private:
  internal::UsbDevice_SetInterfaceAlternateSetting_Params_Data* data_ = nullptr;
};


class UsbDevice_SetInterfaceAlternateSetting_ResponseParamsDataView {
 public:
  UsbDevice_SetInterfaceAlternateSetting_ResponseParamsDataView() = default;

  UsbDevice_SetInterfaceAlternateSetting_ResponseParamsDataView(
      internal::UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::UsbDevice_SetInterfaceAlternateSetting_ResponseParams_Data* data_ = nullptr;
};


class UsbDevice_Reset_ParamsDataView {
 public:
  UsbDevice_Reset_ParamsDataView() = default;

  UsbDevice_Reset_ParamsDataView(
      internal::UsbDevice_Reset_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::UsbDevice_Reset_Params_Data* data_ = nullptr;
};


class UsbDevice_Reset_ResponseParamsDataView {
 public:
  UsbDevice_Reset_ResponseParamsDataView() = default;

  UsbDevice_Reset_ResponseParamsDataView(
      internal::UsbDevice_Reset_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::UsbDevice_Reset_ResponseParams_Data* data_ = nullptr;
};


class UsbDevice_ClearHalt_ParamsDataView {
 public:
  UsbDevice_ClearHalt_ParamsDataView() = default;

  UsbDevice_ClearHalt_ParamsDataView(
      internal::UsbDevice_ClearHalt_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadDirection(UserType* output) const {
    auto data_value = data_->direction;
    return mojo::internal::Deserialize<::device::mojom::UsbTransferDirection>(
        data_value, output);
  }
  UsbTransferDirection direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::UsbTransferDirection>(data_->direction));
  }
  uint8_t endpoint_number() const {
    return data_->endpoint_number;
  }
 private:
  internal::UsbDevice_ClearHalt_Params_Data* data_ = nullptr;
};


class UsbDevice_ClearHalt_ResponseParamsDataView {
 public:
  UsbDevice_ClearHalt_ResponseParamsDataView() = default;

  UsbDevice_ClearHalt_ResponseParamsDataView(
      internal::UsbDevice_ClearHalt_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::UsbDevice_ClearHalt_ResponseParams_Data* data_ = nullptr;
};


class UsbDevice_ControlTransferIn_ParamsDataView {
 public:
  UsbDevice_ControlTransferIn_ParamsDataView() = default;

  UsbDevice_ControlTransferIn_ParamsDataView(
      internal::UsbDevice_ControlTransferIn_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      UsbControlTransferParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::device::mojom::UsbControlTransferParamsDataView>(
        pointer, output, message_);
  }
  uint32_t length() const {
    return data_->length;
  }
  uint32_t timeout() const {
    return data_->timeout;
  }
 private:
  internal::UsbDevice_ControlTransferIn_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UsbDevice_ControlTransferIn_ResponseParamsDataView {
 public:
  UsbDevice_ControlTransferIn_ResponseParamsDataView() = default;

  UsbDevice_ControlTransferIn_ResponseParamsDataView(
      internal::UsbDevice_ControlTransferIn_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::device::mojom::UsbTransferStatus>(
        data_value, output);
  }
  UsbTransferStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::UsbTransferStatus>(data_->status));
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::ReadOnlyBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::UsbDevice_ControlTransferIn_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UsbDevice_ControlTransferOut_ParamsDataView {
 public:
  UsbDevice_ControlTransferOut_ParamsDataView() = default;

  UsbDevice_ControlTransferOut_ParamsDataView(
      internal::UsbDevice_ControlTransferOut_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      UsbControlTransferParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::device::mojom::UsbControlTransferParamsDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::ReadOnlyBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
        pointer, output, message_);
  }
  uint32_t timeout() const {
    return data_->timeout;
  }
 private:
  internal::UsbDevice_ControlTransferOut_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UsbDevice_ControlTransferOut_ResponseParamsDataView {
 public:
  UsbDevice_ControlTransferOut_ResponseParamsDataView() = default;

  UsbDevice_ControlTransferOut_ResponseParamsDataView(
      internal::UsbDevice_ControlTransferOut_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::device::mojom::UsbTransferStatus>(
        data_value, output);
  }
  UsbTransferStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::UsbTransferStatus>(data_->status));
  }
 private:
  internal::UsbDevice_ControlTransferOut_ResponseParams_Data* data_ = nullptr;
};


class UsbDevice_GenericTransferIn_ParamsDataView {
 public:
  UsbDevice_GenericTransferIn_ParamsDataView() = default;

  UsbDevice_GenericTransferIn_ParamsDataView(
      internal::UsbDevice_GenericTransferIn_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint8_t endpoint_number() const {
    return data_->endpoint_number;
  }
  uint32_t length() const {
    return data_->length;
  }
  uint32_t timeout() const {
    return data_->timeout;
  }
 private:
  internal::UsbDevice_GenericTransferIn_Params_Data* data_ = nullptr;
};


class UsbDevice_GenericTransferIn_ResponseParamsDataView {
 public:
  UsbDevice_GenericTransferIn_ResponseParamsDataView() = default;

  UsbDevice_GenericTransferIn_ResponseParamsDataView(
      internal::UsbDevice_GenericTransferIn_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::device::mojom::UsbTransferStatus>(
        data_value, output);
  }
  UsbTransferStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::UsbTransferStatus>(data_->status));
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::ReadOnlyBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::UsbDevice_GenericTransferIn_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UsbDevice_GenericTransferOut_ParamsDataView {
 public:
  UsbDevice_GenericTransferOut_ParamsDataView() = default;

  UsbDevice_GenericTransferOut_ParamsDataView(
      internal::UsbDevice_GenericTransferOut_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint8_t endpoint_number() const {
    return data_->endpoint_number;
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::ReadOnlyBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
        pointer, output, message_);
  }
  uint32_t timeout() const {
    return data_->timeout;
  }
 private:
  internal::UsbDevice_GenericTransferOut_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UsbDevice_GenericTransferOut_ResponseParamsDataView {
 public:
  UsbDevice_GenericTransferOut_ResponseParamsDataView() = default;

  UsbDevice_GenericTransferOut_ResponseParamsDataView(
      internal::UsbDevice_GenericTransferOut_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::device::mojom::UsbTransferStatus>(
        data_value, output);
  }
  UsbTransferStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::UsbTransferStatus>(data_->status));
  }
 private:
  internal::UsbDevice_GenericTransferOut_ResponseParams_Data* data_ = nullptr;
};


class UsbDevice_IsochronousTransferIn_ParamsDataView {
 public:
  UsbDevice_IsochronousTransferIn_ParamsDataView() = default;

  UsbDevice_IsochronousTransferIn_ParamsDataView(
      internal::UsbDevice_IsochronousTransferIn_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint8_t endpoint_number() const {
    return data_->endpoint_number;
  }
  inline void GetPacketLengthsDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPacketLengths(UserType* output) {
    
    auto* pointer = data_->packet_lengths.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  uint32_t timeout() const {
    return data_->timeout;
  }
 private:
  internal::UsbDevice_IsochronousTransferIn_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UsbDevice_IsochronousTransferIn_ResponseParamsDataView {
 public:
  UsbDevice_IsochronousTransferIn_ResponseParamsDataView() = default;

  UsbDevice_IsochronousTransferIn_ResponseParamsDataView(
      internal::UsbDevice_IsochronousTransferIn_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      ::mojo_base::mojom::ReadOnlyBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
        pointer, output, message_);
  }
  inline void GetPacketsDataView(
      mojo::ArrayDataView<UsbIsochronousPacketDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPackets(UserType* output) {
    
    auto* pointer = data_->packets.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::UsbIsochronousPacketDataView>>(
        pointer, output, message_);
  }
 private:
  internal::UsbDevice_IsochronousTransferIn_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UsbDevice_IsochronousTransferOut_ParamsDataView {
 public:
  UsbDevice_IsochronousTransferOut_ParamsDataView() = default;

  UsbDevice_IsochronousTransferOut_ParamsDataView(
      internal::UsbDevice_IsochronousTransferOut_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint8_t endpoint_number() const {
    return data_->endpoint_number;
  }
  inline void GetDataDataView(
      ::mojo_base::mojom::ReadOnlyBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyBufferDataView>(
        pointer, output, message_);
  }
  inline void GetPacketLengthsDataView(
      mojo::ArrayDataView<uint32_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPacketLengths(UserType* output) {
    
    auto* pointer = data_->packet_lengths.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint32_t>>(
        pointer, output, message_);
  }
  uint32_t timeout() const {
    return data_->timeout;
  }
 private:
  internal::UsbDevice_IsochronousTransferOut_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UsbDevice_IsochronousTransferOut_ResponseParamsDataView {
 public:
  UsbDevice_IsochronousTransferOut_ResponseParamsDataView() = default;

  UsbDevice_IsochronousTransferOut_ResponseParamsDataView(
      internal::UsbDevice_IsochronousTransferOut_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPacketsDataView(
      mojo::ArrayDataView<UsbIsochronousPacketDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPackets(UserType* output) {
    
    auto* pointer = data_->packets.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::UsbIsochronousPacketDataView>>(
        pointer, output, message_);
  }
 private:
  internal::UsbDevice_IsochronousTransferOut_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UsbDeviceClient_OnDeviceOpened_ParamsDataView {
 public:
  UsbDeviceClient_OnDeviceOpened_ParamsDataView() = default;

  UsbDeviceClient_OnDeviceOpened_ParamsDataView(
      internal::UsbDeviceClient_OnDeviceOpened_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::UsbDeviceClient_OnDeviceOpened_Params_Data* data_ = nullptr;
};


class UsbDeviceClient_OnDeviceClosed_ParamsDataView {
 public:
  UsbDeviceClient_OnDeviceClosed_ParamsDataView() = default;

  UsbDeviceClient_OnDeviceClosed_ParamsDataView(
      internal::UsbDeviceClient_OnDeviceClosed_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::UsbDeviceClient_OnDeviceClosed_Params_Data* data_ = nullptr;
};



inline void UsbDevice_Open_ResponseParamsDataView::GetResultDataView(
    UsbOpenDeviceResultDataView* output) {
  auto pointer = &data_->result;
  *output = UsbOpenDeviceResultDataView(pointer, message_);
}






























inline void UsbDevice_ControlTransferIn_ParamsDataView::GetParamsDataView(
    UsbControlTransferParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = UsbControlTransferParamsDataView(pointer, message_);
}


inline void UsbDevice_ControlTransferIn_ResponseParamsDataView::GetDataDataView(
    ::mojo_base::mojom::ReadOnlyBufferDataView* output) {
  auto pointer = data_->data.Get();
  *output = ::mojo_base::mojom::ReadOnlyBufferDataView(pointer, message_);
}


inline void UsbDevice_ControlTransferOut_ParamsDataView::GetParamsDataView(
    UsbControlTransferParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = UsbControlTransferParamsDataView(pointer, message_);
}
inline void UsbDevice_ControlTransferOut_ParamsDataView::GetDataDataView(
    ::mojo_base::mojom::ReadOnlyBufferDataView* output) {
  auto pointer = data_->data.Get();
  *output = ::mojo_base::mojom::ReadOnlyBufferDataView(pointer, message_);
}






inline void UsbDevice_GenericTransferIn_ResponseParamsDataView::GetDataDataView(
    ::mojo_base::mojom::ReadOnlyBufferDataView* output) {
  auto pointer = data_->data.Get();
  *output = ::mojo_base::mojom::ReadOnlyBufferDataView(pointer, message_);
}


inline void UsbDevice_GenericTransferOut_ParamsDataView::GetDataDataView(
    ::mojo_base::mojom::ReadOnlyBufferDataView* output) {
  auto pointer = data_->data.Get();
  *output = ::mojo_base::mojom::ReadOnlyBufferDataView(pointer, message_);
}




inline void UsbDevice_IsochronousTransferIn_ParamsDataView::GetPacketLengthsDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->packet_lengths.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}


inline void UsbDevice_IsochronousTransferIn_ResponseParamsDataView::GetDataDataView(
    ::mojo_base::mojom::ReadOnlyBufferDataView* output) {
  auto pointer = data_->data.Get();
  *output = ::mojo_base::mojom::ReadOnlyBufferDataView(pointer, message_);
}
inline void UsbDevice_IsochronousTransferIn_ResponseParamsDataView::GetPacketsDataView(
    mojo::ArrayDataView<UsbIsochronousPacketDataView>* output) {
  auto pointer = data_->packets.Get();
  *output = mojo::ArrayDataView<UsbIsochronousPacketDataView>(pointer, message_);
}


inline void UsbDevice_IsochronousTransferOut_ParamsDataView::GetDataDataView(
    ::mojo_base::mojom::ReadOnlyBufferDataView* output) {
  auto pointer = data_->data.Get();
  *output = ::mojo_base::mojom::ReadOnlyBufferDataView(pointer, message_);
}
inline void UsbDevice_IsochronousTransferOut_ParamsDataView::GetPacketLengthsDataView(
    mojo::ArrayDataView<uint32_t>* output) {
  auto pointer = data_->packet_lengths.Get();
  *output = mojo::ArrayDataView<uint32_t>(pointer, message_);
}


inline void UsbDevice_IsochronousTransferOut_ResponseParamsDataView::GetPacketsDataView(
    mojo::ArrayDataView<UsbIsochronousPacketDataView>* output) {
  auto pointer = data_->packets.Get();
  *output = mojo::ArrayDataView<UsbIsochronousPacketDataView>(pointer, message_);
}







}  // device::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_PARAMS_DATA_H_