// services/device/public/mojom/usb_device.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_DATA_VIEW_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/device/public/mojom/usb_device.mojom-shared-internal.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace device::mojom {
class UsbEndpointInfoDataView;

class UsbAlternateInterfaceInfoDataView;

class UsbInterfaceInfoDataView;

class UsbConfigurationInfoDataView;

class UsbDeviceInfoDataView;

class UsbControlTransferParamsDataView;

class UsbIsochronousPacketDataView;

class UsbOpenDeviceResultDataView;


}  // device::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::UsbEndpointInfoDataView> {
  using Data = ::device::mojom::internal::UsbEndpointInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::UsbAlternateInterfaceInfoDataView> {
  using Data = ::device::mojom::internal::UsbAlternateInterfaceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::UsbInterfaceInfoDataView> {
  using Data = ::device::mojom::internal::UsbInterfaceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::UsbConfigurationInfoDataView> {
  using Data = ::device::mojom::internal::UsbConfigurationInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::UsbDeviceInfoDataView> {
  using Data = ::device::mojom::internal::UsbDeviceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::UsbControlTransferParamsDataView> {
  using Data = ::device::mojom::internal::UsbControlTransferParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::UsbIsochronousPacketDataView> {
  using Data = ::device::mojom::internal::UsbIsochronousPacket_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::UsbOpenDeviceResultDataView> {
  using Data = ::device::mojom::internal::UsbOpenDeviceResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class UsbOpenDeviceSuccess : int32_t {
  
  OK = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, UsbOpenDeviceSuccess value);
inline bool IsKnownEnumValue(UsbOpenDeviceSuccess value) {
  return internal::UsbOpenDeviceSuccess_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class UsbOpenDeviceError : int32_t {
  
  ACCESS_DENIED = 0,
  
  ALREADY_OPEN = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, UsbOpenDeviceError value);
inline bool IsKnownEnumValue(UsbOpenDeviceError value) {
  return internal::UsbOpenDeviceError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class UsbClaimInterfaceResult : int32_t {
  
  kSuccess = 0,
  
  kProtectedClass = 1,
  
  kFailure = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, UsbClaimInterfaceResult value);
inline bool IsKnownEnumValue(UsbClaimInterfaceResult value) {
  return internal::UsbClaimInterfaceResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class UsbTransferDirection : int32_t {
  
  INBOUND = 0,
  
  OUTBOUND = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, UsbTransferDirection value);
inline bool IsKnownEnumValue(UsbTransferDirection value) {
  return internal::UsbTransferDirection_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class UsbControlTransferType : int32_t {
  
  STANDARD = 0,
  
  CLASS = 1,
  
  VENDOR = 2,
  
  RESERVED = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, UsbControlTransferType value);
inline bool IsKnownEnumValue(UsbControlTransferType value) {
  return internal::UsbControlTransferType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class UsbControlTransferRecipient : int32_t {
  
  DEVICE = 0,
  
  INTERFACE = 1,
  
  ENDPOINT = 2,
  
  OTHER = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, UsbControlTransferRecipient value);
inline bool IsKnownEnumValue(UsbControlTransferRecipient value) {
  return internal::UsbControlTransferRecipient_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class UsbTransferType : int32_t {
  
  CONTROL = 0,
  
  ISOCHRONOUS = 1,
  
  BULK = 2,
  
  INTERRUPT = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, UsbTransferType value);
inline bool IsKnownEnumValue(UsbTransferType value) {
  return internal::UsbTransferType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class UsbSynchronizationType : int32_t {
  
  NONE = 0,
  
  ASYNCHRONOUS = 1,
  
  ADAPTIVE = 2,
  
  SYNCHRONOUS = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, UsbSynchronizationType value);
inline bool IsKnownEnumValue(UsbSynchronizationType value) {
  return internal::UsbSynchronizationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class UsbUsageType : int32_t {
  
  DATA = 0,
  
  FEEDBACK = 1,
  
  EXPLICIT_FEEDBACK = 2,
  
  PERIODIC = 3,
  
  NOTIFICATION = 4,
  
  RESERVED = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, UsbUsageType value);
inline bool IsKnownEnumValue(UsbUsageType value) {
  return internal::UsbUsageType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class UsbTransferStatus : int32_t {
  
  COMPLETED = 0,
  
  TRANSFER_ERROR = 1,
  
  TIMEOUT = 2,
  
  CANCELLED = 3,
  
  STALLED = 4,
  
  DISCONNECT = 5,
  
  BABBLE = 6,
  
  SHORT_PACKET = 7,
  
  PERMISSION_DENIED = 8,
  kMinValue = 0,
  kMaxValue = 8,
};

 std::ostream& operator<<(std::ostream& os, UsbTransferStatus value);
inline bool IsKnownEnumValue(UsbTransferStatus value) {
  return internal::UsbTransferStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class UsbDeviceInterfaceBase {};

using UsbDevicePtrDataView =
    mojo::InterfacePtrDataView<UsbDeviceInterfaceBase>;
using UsbDeviceRequestDataView =
    mojo::InterfaceRequestDataView<UsbDeviceInterfaceBase>;
using UsbDeviceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UsbDeviceInterfaceBase>;
using UsbDeviceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UsbDeviceInterfaceBase>;
class UsbDeviceClientInterfaceBase {};

using UsbDeviceClientPtrDataView =
    mojo::InterfacePtrDataView<UsbDeviceClientInterfaceBase>;
using UsbDeviceClientRequestDataView =
    mojo::InterfaceRequestDataView<UsbDeviceClientInterfaceBase>;
using UsbDeviceClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UsbDeviceClientInterfaceBase>;
using UsbDeviceClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UsbDeviceClientInterfaceBase>;


class UsbEndpointInfoDataView {
 public:
  UsbEndpointInfoDataView() = default;

  UsbEndpointInfoDataView(
      internal::UsbEndpointInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint8_t endpoint_number() const {
    return data_->endpoint_number;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDirection(UserType* output) const {
    auto data_value = data_->direction;
    return mojo::internal::Deserialize<::device::mojom::UsbTransferDirection>(
        data_value, output);
  }
  UsbTransferDirection direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::UsbTransferDirection>(data_->direction));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::device::mojom::UsbTransferType>(
        data_value, output);
  }
  UsbTransferType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::UsbTransferType>(data_->type));
  }
  uint32_t packet_size() const {
    return data_->packet_size;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSynchronizationType(UserType* output) const {
    auto data_value = data_->synchronization_type;
    return mojo::internal::Deserialize<::device::mojom::UsbSynchronizationType>(
        data_value, output);
  }
  UsbSynchronizationType synchronization_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::UsbSynchronizationType>(data_->synchronization_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUsageType(UserType* output) const {
    auto data_value = data_->usage_type;
    return mojo::internal::Deserialize<::device::mojom::UsbUsageType>(
        data_value, output);
  }
  UsbUsageType usage_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::UsbUsageType>(data_->usage_type));
  }
  uint8_t polling_interval() const {
    return data_->polling_interval;
  }
  inline void GetExtraDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtraData(UserType* output) {
    
    auto* pointer = data_->extra_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::UsbEndpointInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UsbAlternateInterfaceInfoDataView {
 public:
  UsbAlternateInterfaceInfoDataView() = default;

  UsbAlternateInterfaceInfoDataView(
      internal::UsbAlternateInterfaceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint8_t alternate_setting() const {
    return data_->alternate_setting;
  }
  uint8_t class_code() const {
    return data_->class_code;
  }
  uint8_t subclass_code() const {
    return data_->subclass_code;
  }
  uint8_t protocol_code() const {
    return data_->protocol_code;
  }
  inline void GetInterfaceNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterfaceName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `interface_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInterfaceName` instead "
    "of `ReadInterfaceName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->interface_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetEndpointsDataView(
      mojo::ArrayDataView<UsbEndpointInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEndpoints(UserType* output) {
    
    auto* pointer = data_->endpoints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::UsbEndpointInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetExtraDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtraData(UserType* output) {
    
    auto* pointer = data_->extra_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::UsbAlternateInterfaceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UsbInterfaceInfoDataView {
 public:
  UsbInterfaceInfoDataView() = default;

  UsbInterfaceInfoDataView(
      internal::UsbInterfaceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint8_t interface_number() const {
    return data_->interface_number;
  }
  uint8_t first_interface() const {
    return data_->first_interface;
  }
  inline void GetAlternatesDataView(
      mojo::ArrayDataView<UsbAlternateInterfaceInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlternates(UserType* output) {
    
    auto* pointer = data_->alternates.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::UsbAlternateInterfaceInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::UsbInterfaceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UsbConfigurationInfoDataView {
 public:
  UsbConfigurationInfoDataView() = default;

  UsbConfigurationInfoDataView(
      internal::UsbConfigurationInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint8_t configuration_value() const {
    return data_->configuration_value;
  }
  inline void GetConfigurationNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfigurationName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `configuration_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadConfigurationName` instead "
    "of `ReadConfigurationName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->configuration_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool self_powered() const {
    return data_->self_powered;
  }
  bool remote_wakeup() const {
    return data_->remote_wakeup;
  }
  uint8_t maximum_power() const {
    return data_->maximum_power;
  }
  inline void GetInterfacesDataView(
      mojo::ArrayDataView<UsbInterfaceInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInterfaces(UserType* output) {
    
    auto* pointer = data_->interfaces.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::UsbInterfaceInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetExtraDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtraData(UserType* output) {
    
    auto* pointer = data_->extra_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::UsbConfigurationInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UsbDeviceInfoDataView {
 public:
  UsbDeviceInfoDataView() = default;

  UsbDeviceInfoDataView(
      internal::UsbDeviceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGuidDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGuid(UserType* output) {
    
    auto* pointer = data_->guid.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint8_t usb_version_major() const {
    return data_->usb_version_major;
  }
  uint8_t usb_version_minor() const {
    return data_->usb_version_minor;
  }
  uint8_t usb_version_subminor() const {
    return data_->usb_version_subminor;
  }
  uint8_t class_code() const {
    return data_->class_code;
  }
  uint8_t subclass_code() const {
    return data_->subclass_code;
  }
  uint8_t protocol_code() const {
    return data_->protocol_code;
  }
  uint32_t bus_number() const {
    return data_->bus_number;
  }
  uint32_t port_number() const {
    return data_->port_number;
  }
  uint16_t vendor_id() const {
    return data_->vendor_id;
  }
  uint16_t product_id() const {
    return data_->product_id;
  }
  uint8_t device_version_major() const {
    return data_->device_version_major;
  }
  uint8_t device_version_minor() const {
    return data_->device_version_minor;
  }
  uint8_t device_version_subminor() const {
    return data_->device_version_subminor;
  }
  inline void GetManufacturerNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadManufacturerName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `manufacturer_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadManufacturerName` instead "
    "of `ReadManufacturerName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->manufacturer_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetProductNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProductName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `product_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProductName` instead "
    "of `ReadProductName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->product_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetSerialNumberDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSerialNumber(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `serial_number` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSerialNumber` instead "
    "of `ReadSerialNumber if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->serial_number.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetWebusbLandingPageDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebusbLandingPage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `webusb_landing_page` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWebusbLandingPage` instead "
    "of `ReadWebusbLandingPage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->webusb_landing_page.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  uint8_t active_configuration() const {
    return data_->active_configuration;
  }
  inline void GetConfigurationsDataView(
      mojo::ArrayDataView<UsbConfigurationInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfigurations(UserType* output) {
    
    auto* pointer = data_->configurations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::UsbConfigurationInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::UsbDeviceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UsbControlTransferParamsDataView {
 public:
  UsbControlTransferParamsDataView() = default;

  UsbControlTransferParamsDataView(
      internal::UsbControlTransferParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::device::mojom::UsbControlTransferType>(
        data_value, output);
  }
  UsbControlTransferType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::UsbControlTransferType>(data_->type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRecipient(UserType* output) const {
    auto data_value = data_->recipient;
    return mojo::internal::Deserialize<::device::mojom::UsbControlTransferRecipient>(
        data_value, output);
  }
  UsbControlTransferRecipient recipient() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::UsbControlTransferRecipient>(data_->recipient));
  }
  uint8_t request() const {
    return data_->request;
  }
  uint16_t value() const {
    return data_->value;
  }
  uint16_t index() const {
    return data_->index;
  }
 private:
  internal::UsbControlTransferParams_Data* data_ = nullptr;
};


class UsbIsochronousPacketDataView {
 public:
  UsbIsochronousPacketDataView() = default;

  UsbIsochronousPacketDataView(
      internal::UsbIsochronousPacket_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t length() const {
    return data_->length;
  }
  uint32_t transferred_length() const {
    return data_->transferred_length;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::device::mojom::UsbTransferStatus>(
        data_value, output);
  }
  UsbTransferStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::UsbTransferStatus>(data_->status));
  }
 private:
  internal::UsbIsochronousPacket_Data* data_ = nullptr;
};


class UsbOpenDeviceResultDataView {
 public:
  using Tag = internal::UsbOpenDeviceResult_Data::UsbOpenDeviceResult_Tag;

  UsbOpenDeviceResultDataView() = default;

  UsbOpenDeviceResultDataView(
      internal::UsbOpenDeviceResult_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    CHECK(is_success());
    return mojo::internal::Deserialize<::device::mojom::UsbOpenDeviceSuccess>(
        data_->data.f_success, output);
  }
  UsbOpenDeviceSuccess success() const {
    CHECK(is_success());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::UsbOpenDeviceSuccess>(data_->data.f_success));
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::UsbOpenDeviceError>(
        data_->data.f_error, output);
  }
  UsbOpenDeviceError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::UsbOpenDeviceError>(data_->data.f_error));
  }

 private:
  internal::UsbOpenDeviceResult_Data* data_ = nullptr;
};



}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_DATA_VIEW_H_