// services/device/public/mojom/smart_card.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SmartCardSuccessSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SmartCardSuccess = {
  
  kOk: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SmartCardErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SmartCardError = {
  
  kRemovedCard: 0,
  kResetCard: 1,
  kUnpoweredCard: 2,
  kUnresponsiveCard: 3,
  kUnsupportedCard: 4,
  kReaderUnavailable: 5,
  kSharingViolation: 6,
  kNotTransacted: 7,
  kNoSmartcard: 8,
  kProtoMismatch: 9,
  kSystemCancelled: 10,
  kNotReady: 11,
  kCancelled: 12,
  kInsufficientBuffer: 13,
  kInvalidHandle: 14,
  kInvalidParameter: 15,
  kInvalidValue: 16,
  kNoMemory: 17,
  kTimeout: 18,
  kUnknownReader: 19,
  kUnsupportedFeature: 20,
  kNoReadersAvailable: 21,
  kServiceStopped: 22,
  kNoService: 23,
  kCommError: 24,
  kInternalError: 25,
  kUnknownError: 26,
  kServerTooBusy: 27,
  kUnexpected: 28,
  kShutdown: 29,
  kUnknown: 30,
  kPermissionDenied: 31,
  MIN_VALUE: 0,
  MAX_VALUE: 31,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SmartCardShareModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SmartCardShareMode = {
  
  kShared: 0,
  kExclusive: 1,
  kDirect: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SmartCardProtocolSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SmartCardProtocol = {
  
  kUndefined: 0,
  kT0: 1,
  kT1: 2,
  kRaw: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SmartCardDispositionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SmartCardDisposition = {
  
  kLeave: 0,
  kReset: 1,
  kUnpower: 2,
  kEject: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SmartCardConnectionStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SmartCardConnectionState = {
  
  kAbsent: 0,
  kPresent: 1,
  kSwallowed: 2,
  kPowered: 3,
  kNegotiable: 4,
  kSpecific: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SmartCardTransactionPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.SmartCardTransaction', scope);
  }
}

/** @interface */
export class SmartCardTransactionInterface {
  
  /**
   * @param { !SmartCardDisposition } disposition
   * @return {!Promise<{
        result: !SmartCardResult,
   *  }>}
   */

  endTransaction(disposition) {}
}

/**
 * @implements { SmartCardTransactionInterface }
 */
export class SmartCardTransactionRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SmartCardTransactionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SmartCardTransactionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SmartCardTransactionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !SmartCardDisposition } disposition
   * @return {!Promise<{
        result: !SmartCardResult,
   *  }>}
   */

  endTransaction(
      disposition) {
    return this.proxy.sendMessage(
        0,
        SmartCardTransaction_EndTransaction_ParamsSpec.$,
        SmartCardTransaction_EndTransaction_ResponseParamsSpec.$,
        [
          disposition
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SmartCardTransaction
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SmartCardTransactionReceiver {
  /**
   * @param {!SmartCardTransactionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SmartCardTransactionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SmartCardTransactionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SmartCardTransactionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SmartCardTransaction_EndTransaction_ParamsSpec.$,
        SmartCardTransaction_EndTransaction_ResponseParamsSpec.$,
        impl.endTransaction.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SmartCardTransaction {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SmartCardTransaction";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SmartCardTransactionRemote}
   */
  static getRemote() {
    let remote = new SmartCardTransactionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SmartCardTransaction
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SmartCardTransactionCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SmartCardTransactionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SmartCardTransactionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.endTransaction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SmartCardTransaction_EndTransaction_ParamsSpec.$,
        SmartCardTransaction_EndTransaction_ResponseParamsSpec.$,
        this.endTransaction.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SmartCardConnectionPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.SmartCardConnection', scope);
  }
}

/** @interface */
export class SmartCardConnectionInterface {
  
  /**
   * @param { !SmartCardDisposition } disposition
   * @return {!Promise<{
        result: !SmartCardResult,
   *  }>}
   */

  disconnect(disposition) {}
  
  /**
   * @param { !SmartCardProtocol } protocol
   * @param { !Array<!number> } data
   * @return {!Promise<{
        result: !SmartCardDataResult,
   *  }>}
   */

  transmit(protocol, data) {}
  
  /**
   * @param { !number } controlCode
   * @param { !Array<!number> } data
   * @return {!Promise<{
        result: !SmartCardDataResult,
   *  }>}
   */

  control(controlCode, data) {}
  
  /**
   * @param { !number } id
   * @return {!Promise<{
        result: !SmartCardDataResult,
   *  }>}
   */

  getAttrib(id) {}
  
  /**
   * @param { !number } id
   * @param { !Array<!number> } data
   * @return {!Promise<{
        result: !SmartCardResult,
   *  }>}
   */

  setAttrib(id, data) {}
  
  /**
   * @return {!Promise<{
        result: !SmartCardStatusResult,
   *  }>}
   */

  status() {}
  
  /**
   * @return {!Promise<{
        result: !SmartCardTransactionResult,
   *  }>}
   */

  beginTransaction() {}
}

/**
 * @implements { SmartCardConnectionInterface }
 */
export class SmartCardConnectionRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SmartCardConnectionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SmartCardConnectionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SmartCardConnectionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !SmartCardDisposition } disposition
   * @return {!Promise<{
        result: !SmartCardResult,
   *  }>}
   */

  disconnect(
      disposition) {
    return this.proxy.sendMessage(
        0,
        SmartCardConnection_Disconnect_ParamsSpec.$,
        SmartCardConnection_Disconnect_ResponseParamsSpec.$,
        [
          disposition
        ],
        false);
  }

  
  /**
   * @param { !SmartCardProtocol } protocol
   * @param { !Array<!number> } data
   * @return {!Promise<{
        result: !SmartCardDataResult,
   *  }>}
   */

  transmit(
      protocol,
      data) {
    return this.proxy.sendMessage(
        1,
        SmartCardConnection_Transmit_ParamsSpec.$,
        SmartCardConnection_Transmit_ResponseParamsSpec.$,
        [
          protocol,
          data
        ],
        false);
  }

  
  /**
   * @param { !number } controlCode
   * @param { !Array<!number> } data
   * @return {!Promise<{
        result: !SmartCardDataResult,
   *  }>}
   */

  control(
      controlCode,
      data) {
    return this.proxy.sendMessage(
        2,
        SmartCardConnection_Control_ParamsSpec.$,
        SmartCardConnection_Control_ResponseParamsSpec.$,
        [
          controlCode,
          data
        ],
        false);
  }

  
  /**
   * @param { !number } id
   * @return {!Promise<{
        result: !SmartCardDataResult,
   *  }>}
   */

  getAttrib(
      id) {
    return this.proxy.sendMessage(
        3,
        SmartCardConnection_GetAttrib_ParamsSpec.$,
        SmartCardConnection_GetAttrib_ResponseParamsSpec.$,
        [
          id
        ],
        false);
  }

  
  /**
   * @param { !number } id
   * @param { !Array<!number> } data
   * @return {!Promise<{
        result: !SmartCardResult,
   *  }>}
   */

  setAttrib(
      id,
      data) {
    return this.proxy.sendMessage(
        4,
        SmartCardConnection_SetAttrib_ParamsSpec.$,
        SmartCardConnection_SetAttrib_ResponseParamsSpec.$,
        [
          id,
          data
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !SmartCardStatusResult,
   *  }>}
   */

  status() {
    return this.proxy.sendMessage(
        5,
        SmartCardConnection_Status_ParamsSpec.$,
        SmartCardConnection_Status_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !SmartCardTransactionResult,
   *  }>}
   */

  beginTransaction() {
    return this.proxy.sendMessage(
        6,
        SmartCardConnection_BeginTransaction_ParamsSpec.$,
        SmartCardConnection_BeginTransaction_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SmartCardConnection
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SmartCardConnectionReceiver {
  /**
   * @param {!SmartCardConnectionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SmartCardConnectionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SmartCardConnectionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SmartCardConnectionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SmartCardConnection_Disconnect_ParamsSpec.$,
        SmartCardConnection_Disconnect_ResponseParamsSpec.$,
        impl.disconnect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SmartCardConnection_Transmit_ParamsSpec.$,
        SmartCardConnection_Transmit_ResponseParamsSpec.$,
        impl.transmit.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SmartCardConnection_Control_ParamsSpec.$,
        SmartCardConnection_Control_ResponseParamsSpec.$,
        impl.control.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SmartCardConnection_GetAttrib_ParamsSpec.$,
        SmartCardConnection_GetAttrib_ResponseParamsSpec.$,
        impl.getAttrib.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        SmartCardConnection_SetAttrib_ParamsSpec.$,
        SmartCardConnection_SetAttrib_ResponseParamsSpec.$,
        impl.setAttrib.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        SmartCardConnection_Status_ParamsSpec.$,
        SmartCardConnection_Status_ResponseParamsSpec.$,
        impl.status.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        SmartCardConnection_BeginTransaction_ParamsSpec.$,
        SmartCardConnection_BeginTransaction_ResponseParamsSpec.$,
        impl.beginTransaction.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SmartCardConnection {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SmartCardConnection";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SmartCardConnectionRemote}
   */
  static getRemote() {
    let remote = new SmartCardConnectionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SmartCardConnection
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SmartCardConnectionCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SmartCardConnectionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SmartCardConnectionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.disconnect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SmartCardConnection_Disconnect_ParamsSpec.$,
        SmartCardConnection_Disconnect_ResponseParamsSpec.$,
        this.disconnect.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.transmit =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SmartCardConnection_Transmit_ParamsSpec.$,
        SmartCardConnection_Transmit_ResponseParamsSpec.$,
        this.transmit.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.control =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SmartCardConnection_Control_ParamsSpec.$,
        SmartCardConnection_Control_ResponseParamsSpec.$,
        this.control.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAttrib =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SmartCardConnection_GetAttrib_ParamsSpec.$,
        SmartCardConnection_GetAttrib_ResponseParamsSpec.$,
        this.getAttrib.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAttrib =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        SmartCardConnection_SetAttrib_ParamsSpec.$,
        SmartCardConnection_SetAttrib_ResponseParamsSpec.$,
        this.setAttrib.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.status =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        SmartCardConnection_Status_ParamsSpec.$,
        SmartCardConnection_Status_ResponseParamsSpec.$,
        this.status.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.beginTransaction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        SmartCardConnection_BeginTransaction_ParamsSpec.$,
        SmartCardConnection_BeginTransaction_ResponseParamsSpec.$,
        this.beginTransaction.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SmartCardConnectionWatcherPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.SmartCardConnectionWatcher', scope);
  }
}

/** @interface */
export class SmartCardConnectionWatcherInterface {
  
  /**
   */

  notifyConnectionUsed() {}
}

/**
 * @implements { SmartCardConnectionWatcherInterface }
 */
export class SmartCardConnectionWatcherRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SmartCardConnectionWatcherPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SmartCardConnectionWatcherPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SmartCardConnectionWatcherPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  notifyConnectionUsed() {
    this.proxy.sendMessage(
        0,
        SmartCardConnectionWatcher_NotifyConnectionUsed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SmartCardConnectionWatcher
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SmartCardConnectionWatcherReceiver {
  /**
   * @param {!SmartCardConnectionWatcherInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SmartCardConnectionWatcherRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SmartCardConnectionWatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SmartCardConnectionWatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SmartCardConnectionWatcher_NotifyConnectionUsed_ParamsSpec.$,
        null,
        impl.notifyConnectionUsed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SmartCardConnectionWatcher {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SmartCardConnectionWatcher";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SmartCardConnectionWatcherRemote}
   */
  static getRemote() {
    let remote = new SmartCardConnectionWatcherRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SmartCardConnectionWatcher
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SmartCardConnectionWatcherCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SmartCardConnectionWatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SmartCardConnectionWatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyConnectionUsed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SmartCardConnectionWatcher_NotifyConnectionUsed_ParamsSpec.$,
        null,
        this.notifyConnectionUsed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SmartCardContextPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.SmartCardContext', scope);
  }
}

/** @interface */
export class SmartCardContextInterface {
  
  /**
   * @return {!Promise<{
        result: !SmartCardListReadersResult,
   *  }>}
   */

  listReaders() {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } timeout
   * @param { !Array<!SmartCardReaderStateIn> } readerStates
   * @return {!Promise<{
        result: !SmartCardStatusChangeResult,
   *  }>}
   */

  getStatusChange(timeout, readerStates) {}
  
  /**
   * @return {!Promise<{
        result: !SmartCardResult,
   *  }>}
   */

  cancel() {}
  
  /**
   * @param { !string } reader
   * @param { !SmartCardShareMode } shareMode
   * @param { !SmartCardProtocols } preferredProtocols
   * @param { ?SmartCardConnectionWatcherRemote } connectionWatcher
   * @return {!Promise<{
        result: !SmartCardConnectResult,
   *  }>}
   */

  connect(reader, shareMode, preferredProtocols, connectionWatcher) {}
}

/**
 * @implements { SmartCardContextInterface }
 */
export class SmartCardContextRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SmartCardContextPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SmartCardContextPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SmartCardContextPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: !SmartCardListReadersResult,
   *  }>}
   */

  listReaders() {
    return this.proxy.sendMessage(
        0,
        SmartCardContext_ListReaders_ParamsSpec.$,
        SmartCardContext_ListReaders_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } timeout
   * @param { !Array<!SmartCardReaderStateIn> } readerStates
   * @return {!Promise<{
        result: !SmartCardStatusChangeResult,
   *  }>}
   */

  getStatusChange(
      timeout,
      readerStates) {
    return this.proxy.sendMessage(
        1,
        SmartCardContext_GetStatusChange_ParamsSpec.$,
        SmartCardContext_GetStatusChange_ResponseParamsSpec.$,
        [
          timeout,
          readerStates
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !SmartCardResult,
   *  }>}
   */

  cancel() {
    return this.proxy.sendMessage(
        2,
        SmartCardContext_Cancel_ParamsSpec.$,
        SmartCardContext_Cancel_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } reader
   * @param { !SmartCardShareMode } shareMode
   * @param { !SmartCardProtocols } preferredProtocols
   * @param { ?SmartCardConnectionWatcherRemote } connectionWatcher
   * @return {!Promise<{
        result: !SmartCardConnectResult,
   *  }>}
   */

  connect(
      reader,
      shareMode,
      preferredProtocols,
      connectionWatcher) {
    return this.proxy.sendMessage(
        3,
        SmartCardContext_Connect_ParamsSpec.$,
        SmartCardContext_Connect_ResponseParamsSpec.$,
        [
          reader,
          shareMode,
          preferredProtocols,
          connectionWatcher
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SmartCardContext
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SmartCardContextReceiver {
  /**
   * @param {!SmartCardContextInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SmartCardContextRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SmartCardContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SmartCardContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SmartCardContext_ListReaders_ParamsSpec.$,
        SmartCardContext_ListReaders_ResponseParamsSpec.$,
        impl.listReaders.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SmartCardContext_GetStatusChange_ParamsSpec.$,
        SmartCardContext_GetStatusChange_ResponseParamsSpec.$,
        impl.getStatusChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SmartCardContext_Cancel_ParamsSpec.$,
        SmartCardContext_Cancel_ResponseParamsSpec.$,
        impl.cancel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        SmartCardContext_Connect_ParamsSpec.$,
        SmartCardContext_Connect_ResponseParamsSpec.$,
        impl.connect.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SmartCardContext {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SmartCardContext";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SmartCardContextRemote}
   */
  static getRemote() {
    let remote = new SmartCardContextRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SmartCardContext
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SmartCardContextCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SmartCardContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SmartCardContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.listReaders =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SmartCardContext_ListReaders_ParamsSpec.$,
        SmartCardContext_ListReaders_ResponseParamsSpec.$,
        this.listReaders.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStatusChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SmartCardContext_GetStatusChange_ParamsSpec.$,
        SmartCardContext_GetStatusChange_ResponseParamsSpec.$,
        this.getStatusChange.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SmartCardContext_Cancel_ParamsSpec.$,
        SmartCardContext_Cancel_ResponseParamsSpec.$,
        this.cancel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        SmartCardContext_Connect_ParamsSpec.$,
        SmartCardContext_Connect_ResponseParamsSpec.$,
        this.connect.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SmartCardContextFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.SmartCardContextFactory', scope);
  }
}

/** @interface */
export class SmartCardContextFactoryInterface {
  
  /**
   * @return {!Promise<{
        result: !SmartCardCreateContextResult,
   *  }>}
   */

  createContext() {}
}

/**
 * @implements { SmartCardContextFactoryInterface }
 */
export class SmartCardContextFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SmartCardContextFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SmartCardContextFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SmartCardContextFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: !SmartCardCreateContextResult,
   *  }>}
   */

  createContext() {
    return this.proxy.sendMessage(
        0,
        SmartCardContextFactory_CreateContext_ParamsSpec.$,
        SmartCardContextFactory_CreateContext_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SmartCardContextFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SmartCardContextFactoryReceiver {
  /**
   * @param {!SmartCardContextFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SmartCardContextFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SmartCardContextFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SmartCardContextFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SmartCardContextFactory_CreateContext_ParamsSpec.$,
        SmartCardContextFactory_CreateContext_ResponseParamsSpec.$,
        impl.createContext.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SmartCardContextFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SmartCardContextFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SmartCardContextFactoryRemote}
   */
  static getRemote() {
    let remote = new SmartCardContextFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SmartCardContextFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SmartCardContextFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SmartCardContextFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SmartCardContextFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SmartCardContextFactory_CreateContext_ParamsSpec.$,
        SmartCardContextFactory_CreateContext_ResponseParamsSpec.$,
        this.createContext.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardReaderStateFlagsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardReaderStateInSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardReaderStateOutSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardProtocolsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardStatusSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardConnectSuccessSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardTransaction_EndTransaction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardTransaction_EndTransaction_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardConnection_Disconnect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardConnection_Disconnect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardConnection_Transmit_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardConnection_Transmit_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardConnection_Control_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardConnection_Control_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardConnection_GetAttrib_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardConnection_GetAttrib_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardConnection_SetAttrib_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardConnection_SetAttrib_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardConnection_Status_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardConnection_Status_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardConnection_BeginTransaction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardConnection_BeginTransaction_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardConnectionWatcher_NotifyConnectionUsed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardContext_ListReaders_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardContext_ListReaders_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardContext_GetStatusChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardContext_GetStatusChange_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardContext_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardContext_Cancel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardContext_Connect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardContext_Connect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardContextFactory_CreateContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SmartCardContextFactory_CreateContext_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const SmartCardResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const SmartCardStatusChangeResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const SmartCardListReadersResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const SmartCardCreateContextResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const SmartCardConnectResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const SmartCardDataResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const SmartCardStatusResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const SmartCardTransactionResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SmartCardReaderStateFlagsSpec.$,
    'SmartCardReaderStateFlags',
    [
      mojo.internal.StructField(
        'unaware', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ignore', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'changed', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'unknown', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'unavailable', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'empty', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'present', 0,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'exclusive', 0,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inuse', 1,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mute', 1,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'unpowered', 1,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SmartCardReaderStateFlags {
  constructor() {
    /** @type { !boolean } */
    this.unaware;
    /** @type { !boolean } */
    this.ignore;
    /** @type { !boolean } */
    this.changed;
    /** @type { !boolean } */
    this.unknown;
    /** @type { !boolean } */
    this.unavailable;
    /** @type { !boolean } */
    this.empty;
    /** @type { !boolean } */
    this.present;
    /** @type { !boolean } */
    this.exclusive;
    /** @type { !boolean } */
    this.inuse;
    /** @type { !boolean } */
    this.mute;
    /** @type { !boolean } */
    this.unpowered;
  }
}



mojo.internal.Struct(
    SmartCardReaderStateInSpec.$,
    'SmartCardReaderStateIn',
    [
      mojo.internal.StructField(
        'reader', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'currentState', 8,
        0,
        SmartCardReaderStateFlagsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'currentCount', 16,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SmartCardReaderStateIn {
  constructor() {
    /** @type { !string } */
    this.reader;
    /** @type { !SmartCardReaderStateFlags } */
    this.currentState;
    /** @type { !number } */
    this.currentCount;
  }
}



mojo.internal.Struct(
    SmartCardReaderStateOutSpec.$,
    'SmartCardReaderStateOut',
    [
      mojo.internal.StructField(
        'reader', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventState', 8,
        0,
        SmartCardReaderStateFlagsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventCount', 16,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'answerToReset', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class SmartCardReaderStateOut {
  constructor() {
    /** @type { !string } */
    this.reader;
    /** @type { !SmartCardReaderStateFlags } */
    this.eventState;
    /** @type { !number } */
    this.eventCount;
    /** @type { !Array<!number> } */
    this.answerToReset;
  }
}



mojo.internal.Struct(
    SmartCardProtocolsSpec.$,
    'SmartCardProtocols',
    [
      mojo.internal.StructField(
        't0', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        't1', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'raw', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SmartCardProtocols {
  constructor() {
    /** @type { !boolean } */
    this.t0;
    /** @type { !boolean } */
    this.t1;
    /** @type { !boolean } */
    this.raw;
  }
}



mojo.internal.Struct(
    SmartCardStatusSpec.$,
    'SmartCardStatus',
    [
      mojo.internal.StructField(
        'readerName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'state', 8,
        0,
        SmartCardConnectionStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'protocol', 12,
        0,
        SmartCardProtocolSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'answerToReset', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SmartCardStatus {
  constructor() {
    /** @type { !string } */
    this.readerName;
    /** @type { !SmartCardConnectionState } */
    this.state;
    /** @type { !SmartCardProtocol } */
    this.protocol;
    /** @type { !Array<!number> } */
    this.answerToReset;
  }
}



mojo.internal.Struct(
    SmartCardConnectSuccessSpec.$,
    'SmartCardConnectSuccess',
    [
      mojo.internal.StructField(
        'connection', 0,
        0,
        mojo.internal.InterfaceProxy(SmartCardConnectionRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'activeProtocol', 8,
        0,
        SmartCardProtocolSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardConnectSuccess {
  constructor() {
    /** @type { !SmartCardConnectionRemote } */
    this.connection;
    /** @type { !SmartCardProtocol } */
    this.activeProtocol;
  }
}



mojo.internal.Struct(
    SmartCardTransaction_EndTransaction_ParamsSpec.$,
    'SmartCardTransaction_EndTransaction_Params',
    [
      mojo.internal.StructField(
        'disposition', 0,
        0,
        SmartCardDispositionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SmartCardTransaction_EndTransaction_Params {
  constructor() {
    /** @type { !SmartCardDisposition } */
    this.disposition;
  }
}



mojo.internal.Struct(
    SmartCardTransaction_EndTransaction_ResponseParamsSpec.$,
    'SmartCardTransaction_EndTransaction_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SmartCardResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardTransaction_EndTransaction_ResponseParams {
  constructor() {
    /** @type { !SmartCardResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SmartCardConnection_Disconnect_ParamsSpec.$,
    'SmartCardConnection_Disconnect_Params',
    [
      mojo.internal.StructField(
        'disposition', 0,
        0,
        SmartCardDispositionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SmartCardConnection_Disconnect_Params {
  constructor() {
    /** @type { !SmartCardDisposition } */
    this.disposition;
  }
}



mojo.internal.Struct(
    SmartCardConnection_Disconnect_ResponseParamsSpec.$,
    'SmartCardConnection_Disconnect_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SmartCardResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardConnection_Disconnect_ResponseParams {
  constructor() {
    /** @type { !SmartCardResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SmartCardConnection_Transmit_ParamsSpec.$,
    'SmartCardConnection_Transmit_Params',
    [
      mojo.internal.StructField(
        'protocol', 0,
        0,
        SmartCardProtocolSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardConnection_Transmit_Params {
  constructor() {
    /** @type { !SmartCardProtocol } */
    this.protocol;
    /** @type { !Array<!number> } */
    this.data;
  }
}



mojo.internal.Struct(
    SmartCardConnection_Transmit_ResponseParamsSpec.$,
    'SmartCardConnection_Transmit_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SmartCardDataResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardConnection_Transmit_ResponseParams {
  constructor() {
    /** @type { !SmartCardDataResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SmartCardConnection_Control_ParamsSpec.$,
    'SmartCardConnection_Control_Params',
    [
      mojo.internal.StructField(
        'controlCode', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardConnection_Control_Params {
  constructor() {
    /** @type { !number } */
    this.controlCode;
    /** @type { !Array<!number> } */
    this.data;
  }
}



mojo.internal.Struct(
    SmartCardConnection_Control_ResponseParamsSpec.$,
    'SmartCardConnection_Control_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SmartCardDataResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardConnection_Control_ResponseParams {
  constructor() {
    /** @type { !SmartCardDataResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SmartCardConnection_GetAttrib_ParamsSpec.$,
    'SmartCardConnection_GetAttrib_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SmartCardConnection_GetAttrib_Params {
  constructor() {
    /** @type { !number } */
    this.id;
  }
}



mojo.internal.Struct(
    SmartCardConnection_GetAttrib_ResponseParamsSpec.$,
    'SmartCardConnection_GetAttrib_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SmartCardDataResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardConnection_GetAttrib_ResponseParams {
  constructor() {
    /** @type { !SmartCardDataResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SmartCardConnection_SetAttrib_ParamsSpec.$,
    'SmartCardConnection_SetAttrib_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardConnection_SetAttrib_Params {
  constructor() {
    /** @type { !number } */
    this.id;
    /** @type { !Array<!number> } */
    this.data;
  }
}



mojo.internal.Struct(
    SmartCardConnection_SetAttrib_ResponseParamsSpec.$,
    'SmartCardConnection_SetAttrib_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SmartCardResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardConnection_SetAttrib_ResponseParams {
  constructor() {
    /** @type { !SmartCardResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SmartCardConnection_Status_ParamsSpec.$,
    'SmartCardConnection_Status_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SmartCardConnection_Status_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SmartCardConnection_Status_ResponseParamsSpec.$,
    'SmartCardConnection_Status_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SmartCardStatusResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardConnection_Status_ResponseParams {
  constructor() {
    /** @type { !SmartCardStatusResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SmartCardConnection_BeginTransaction_ParamsSpec.$,
    'SmartCardConnection_BeginTransaction_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SmartCardConnection_BeginTransaction_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SmartCardConnection_BeginTransaction_ResponseParamsSpec.$,
    'SmartCardConnection_BeginTransaction_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SmartCardTransactionResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardConnection_BeginTransaction_ResponseParams {
  constructor() {
    /** @type { !SmartCardTransactionResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SmartCardConnectionWatcher_NotifyConnectionUsed_ParamsSpec.$,
    'SmartCardConnectionWatcher_NotifyConnectionUsed_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SmartCardConnectionWatcher_NotifyConnectionUsed_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SmartCardContext_ListReaders_ParamsSpec.$,
    'SmartCardContext_ListReaders_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SmartCardContext_ListReaders_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SmartCardContext_ListReaders_ResponseParamsSpec.$,
    'SmartCardContext_ListReaders_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SmartCardListReadersResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardContext_ListReaders_ResponseParams {
  constructor() {
    /** @type { !SmartCardListReadersResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SmartCardContext_GetStatusChange_ParamsSpec.$,
    'SmartCardContext_GetStatusChange_Params',
    [
      mojo.internal.StructField(
        'timeout', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'readerStates', 8,
        0,
        mojo.internal.Array(SmartCardReaderStateInSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardContext_GetStatusChange_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.timeout;
    /** @type { !Array<!SmartCardReaderStateIn> } */
    this.readerStates;
  }
}



mojo.internal.Struct(
    SmartCardContext_GetStatusChange_ResponseParamsSpec.$,
    'SmartCardContext_GetStatusChange_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SmartCardStatusChangeResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardContext_GetStatusChange_ResponseParams {
  constructor() {
    /** @type { !SmartCardStatusChangeResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SmartCardContext_Cancel_ParamsSpec.$,
    'SmartCardContext_Cancel_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SmartCardContext_Cancel_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SmartCardContext_Cancel_ResponseParamsSpec.$,
    'SmartCardContext_Cancel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SmartCardResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardContext_Cancel_ResponseParams {
  constructor() {
    /** @type { !SmartCardResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SmartCardContext_Connect_ParamsSpec.$,
    'SmartCardContext_Connect_Params',
    [
      mojo.internal.StructField(
        'reader', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shareMode', 8,
        0,
        SmartCardShareModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'preferredProtocols', 16,
        0,
        SmartCardProtocolsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'connectionWatcher', 24,
        0,
        mojo.internal.InterfaceProxy(SmartCardConnectionWatcherRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class SmartCardContext_Connect_Params {
  constructor() {
    /** @type { !string } */
    this.reader;
    /** @type { !SmartCardShareMode } */
    this.shareMode;
    /** @type { !SmartCardProtocols } */
    this.preferredProtocols;
    /** @type { (SmartCardConnectionWatcherRemote|undefined) } */
    this.connectionWatcher;
  }
}



mojo.internal.Struct(
    SmartCardContext_Connect_ResponseParamsSpec.$,
    'SmartCardContext_Connect_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SmartCardConnectResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardContext_Connect_ResponseParams {
  constructor() {
    /** @type { !SmartCardConnectResult } */
    this.result;
  }
}



mojo.internal.Struct(
    SmartCardContextFactory_CreateContext_ParamsSpec.$,
    'SmartCardContextFactory_CreateContext_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SmartCardContextFactory_CreateContext_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SmartCardContextFactory_CreateContext_ResponseParamsSpec.$,
    'SmartCardContextFactory_CreateContext_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        SmartCardCreateContextResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SmartCardContextFactory_CreateContext_ResponseParams {
  constructor() {
    /** @type { !SmartCardCreateContextResult } */
    this.result;
  }
}

mojo.internal.Union(
    SmartCardResultSpec.$, 'SmartCardResult',
    {
      'success': {
        'ordinal': 0,
        'type': SmartCardSuccessSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': SmartCardErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!SmartCardSuccess|undefined),
 *   error: (!SmartCardError|undefined),
 * } }
 */
export const SmartCardResult = {};
mojo.internal.Union(
    SmartCardStatusChangeResultSpec.$, 'SmartCardStatusChangeResult',
    {
      'readerStates': {
        'ordinal': 0,
        'type': mojo.internal.Array(SmartCardReaderStateOutSpec.$, false),
      },
      'error': {
        'ordinal': 1,
        'type': SmartCardErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   readerStates: (!Array<!SmartCardReaderStateOut>|undefined),
 *   error: (!SmartCardError|undefined),
 * } }
 */
export const SmartCardStatusChangeResult = {};
mojo.internal.Union(
    SmartCardListReadersResultSpec.$, 'SmartCardListReadersResult',
    {
      'readers': {
        'ordinal': 0,
        'type': mojo.internal.Array(mojo.internal.String, false),
      },
      'error': {
        'ordinal': 1,
        'type': SmartCardErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   readers: (!Array<!string>|undefined),
 *   error: (!SmartCardError|undefined),
 * } }
 */
export const SmartCardListReadersResult = {};
mojo.internal.Union(
    SmartCardCreateContextResultSpec.$, 'SmartCardCreateContextResult',
    {
      'context': {
        'ordinal': 0,
        'type': mojo.internal.InterfaceProxy(SmartCardContextRemote),
      },
      'error': {
        'ordinal': 1,
        'type': SmartCardErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   context: (!SmartCardContextRemote|undefined),
 *   error: (!SmartCardError|undefined),
 * } }
 */
export const SmartCardCreateContextResult = {};
mojo.internal.Union(
    SmartCardConnectResultSpec.$, 'SmartCardConnectResult',
    {
      'success': {
        'ordinal': 0,
        'type': SmartCardConnectSuccessSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': SmartCardErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!SmartCardConnectSuccess|undefined),
 *   error: (!SmartCardError|undefined),
 * } }
 */
export const SmartCardConnectResult = {};
mojo.internal.Union(
    SmartCardDataResultSpec.$, 'SmartCardDataResult',
    {
      'data': {
        'ordinal': 0,
        'type': mojo.internal.Array(mojo.internal.Uint8, false),
      },
      'error': {
        'ordinal': 1,
        'type': SmartCardErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   data: (!Array<!number>|undefined),
 *   error: (!SmartCardError|undefined),
 * } }
 */
export const SmartCardDataResult = {};
mojo.internal.Union(
    SmartCardStatusResultSpec.$, 'SmartCardStatusResult',
    {
      'status': {
        'ordinal': 0,
        'type': SmartCardStatusSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': SmartCardErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   status: (!SmartCardStatus|undefined),
 *   error: (!SmartCardError|undefined),
 * } }
 */
export const SmartCardStatusResult = {};
mojo.internal.Union(
    SmartCardTransactionResultSpec.$, 'SmartCardTransactionResult',
    {
      'transaction': {
        'ordinal': 0,
        'type': mojo.internal.AssociatedInterfaceProxy(SmartCardTransactionRemote),
      },
      'error': {
        'ordinal': 1,
        'type': SmartCardErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   transaction: (!Object|undefined),
 *   error: (!SmartCardError|undefined),
 * } }
 */
export const SmartCardTransactionResult = {};
