// services/device/public/mojom/smart_card.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_SHARED_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/smart_card.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/device/public/mojom/smart_card.mojom-data-view.h"




namespace std {

template <>
struct hash<::device::mojom::SmartCardSuccess>
    : public mojo::internal::EnumHashImpl<::device::mojom::SmartCardSuccess> {};

template <>
struct hash<::device::mojom::SmartCardError>
    : public mojo::internal::EnumHashImpl<::device::mojom::SmartCardError> {};

template <>
struct hash<::device::mojom::SmartCardShareMode>
    : public mojo::internal::EnumHashImpl<::device::mojom::SmartCardShareMode> {};

template <>
struct hash<::device::mojom::SmartCardProtocol>
    : public mojo::internal::EnumHashImpl<::device::mojom::SmartCardProtocol> {};

template <>
struct hash<::device::mojom::SmartCardDisposition>
    : public mojo::internal::EnumHashImpl<::device::mojom::SmartCardDisposition> {};

template <>
struct hash<::device::mojom::SmartCardConnectionState>
    : public mojo::internal::EnumHashImpl<::device::mojom::SmartCardConnectionState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardSuccess, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::SmartCardSuccess, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardSuccess>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::SmartCardError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardShareMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::SmartCardShareMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardShareMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardProtocol, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::SmartCardProtocol, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardProtocol>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardDisposition, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::SmartCardDisposition, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardDisposition>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardConnectionState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::SmartCardConnectionState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardConnectionState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardReaderStateFlagsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardReaderStateFlagsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardReaderStateFlags_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->unaware = Traits::unaware(input);

    fragment->ignore = Traits::ignore(input);

    fragment->changed = Traits::changed(input);

    fragment->unknown = Traits::unknown(input);

    fragment->unavailable = Traits::unavailable(input);

    fragment->empty = Traits::empty(input);

    fragment->present = Traits::present(input);

    fragment->exclusive = Traits::exclusive(input);

    fragment->inuse = Traits::inuse(input);

    fragment->mute = Traits::mute(input);

    fragment->unpowered = Traits::unpowered(input);
  }

  static bool Deserialize(::device::mojom::internal::SmartCardReaderStateFlags_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardReaderStateFlagsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardReaderStateInDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardReaderStateInDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardReaderStateIn_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::reader(input)) in_reader = Traits::reader(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reader)::BaseType> reader_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_reader,
      reader_fragment);

    fragment->reader.Set(
        reader_fragment.is_null() ? nullptr : reader_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->reader.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reader in SmartCardReaderStateIn struct");

    decltype(Traits::current_state(input)) in_current_state = Traits::current_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->current_state)::BaseType> current_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::SmartCardReaderStateFlagsDataView>(
      in_current_state,
      current_state_fragment);

    fragment->current_state.Set(
        current_state_fragment.is_null() ? nullptr : current_state_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->current_state.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null current_state in SmartCardReaderStateIn struct");

    fragment->current_count = Traits::current_count(input);
  }

  static bool Deserialize(::device::mojom::internal::SmartCardReaderStateIn_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardReaderStateInDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardReaderStateOutDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardReaderStateOutDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardReaderStateOut_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::reader(input)) in_reader = Traits::reader(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reader)::BaseType> reader_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_reader,
      reader_fragment);

    fragment->reader.Set(
        reader_fragment.is_null() ? nullptr : reader_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->reader.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reader in SmartCardReaderStateOut struct");

    decltype(Traits::event_state(input)) in_event_state = Traits::event_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->event_state)::BaseType> event_state_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::SmartCardReaderStateFlagsDataView>(
      in_event_state,
      event_state_fragment);

    fragment->event_state.Set(
        event_state_fragment.is_null() ? nullptr : event_state_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->event_state.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_state in SmartCardReaderStateOut struct");

    fragment->event_count = Traits::event_count(input);

    decltype(Traits::answer_to_reset(input)) in_answer_to_reset = Traits::answer_to_reset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->answer_to_reset)::BaseType>
        answer_to_reset_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& answer_to_reset_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_answer_to_reset,
      answer_to_reset_fragment,
      &answer_to_reset_validate_params);

    fragment->answer_to_reset.Set(
        answer_to_reset_fragment.is_null() ? nullptr : answer_to_reset_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->answer_to_reset.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null answer_to_reset in SmartCardReaderStateOut struct");
  }

  static bool Deserialize(::device::mojom::internal::SmartCardReaderStateOut_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardReaderStateOutDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardProtocolsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardProtocolsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardProtocols_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->t0 = Traits::t0(input);

    fragment->t1 = Traits::t1(input);

    fragment->raw = Traits::raw(input);
  }

  static bool Deserialize(::device::mojom::internal::SmartCardProtocols_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardProtocolsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardStatusDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardStatusDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::reader_name(input)) in_reader_name = Traits::reader_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reader_name)::BaseType> reader_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_reader_name,
      reader_name_fragment);

    fragment->reader_name.Set(
        reader_name_fragment.is_null() ? nullptr : reader_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->reader_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null reader_name in SmartCardStatus struct");

    
    mojo::internal::Serialize<::device::mojom::SmartCardConnectionState>(
      Traits::state(input),
      &fragment->state);

    
    mojo::internal::Serialize<::device::mojom::SmartCardProtocol>(
      Traits::protocol(input),
      &fragment->protocol);

    decltype(Traits::answer_to_reset(input)) in_answer_to_reset = Traits::answer_to_reset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->answer_to_reset)::BaseType>
        answer_to_reset_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& answer_to_reset_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_answer_to_reset,
      answer_to_reset_fragment,
      &answer_to_reset_validate_params);

    fragment->answer_to_reset.Set(
        answer_to_reset_fragment.is_null() ? nullptr : answer_to_reset_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->answer_to_reset.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null answer_to_reset in SmartCardStatus struct");
  }

  static bool Deserialize(::device::mojom::internal::SmartCardStatus_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardStatusDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardConnectSuccessDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardConnectSuccessDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardConnectSuccess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::connection(input)) in_connection = Traits::connection(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::SmartCardConnectionInterfaceBase>>(
      in_connection,
      &fragment->connection,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->connection)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid connection in SmartCardConnectSuccess struct");

    
    mojo::internal::Serialize<::device::mojom::SmartCardProtocol>(
      Traits::active_protocol(input),
      &fragment->active_protocol);
  }

  static bool Deserialize(::device::mojom::internal::SmartCardConnectSuccess_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardConnectSuccessDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::SmartCardResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardSuccess>(
  in_success,
  &fragment->data.f_success);
    break;
  }
  case ::device::mojom::SmartCardResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardError>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }

  static bool Deserialize(::device::mojom::internal::SmartCardResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardStatusChangeResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardStatusChangeResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardStatusChangeResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::SmartCardStatusChangeResultDataView::Tag::kReaderStates: {
    decltype(Traits::reader_states(input))
    in_reader_states = Traits::reader_states(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_reader_states)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& reader_states_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::SmartCardReaderStateOutDataView>>(
  in_reader_states,
  value_fragment,
  &reader_states_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null reader_states in SmartCardStatusChangeResult union");
    fragment->data.f_reader_states.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::SmartCardStatusChangeResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardError>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }

  static bool Deserialize(::device::mojom::internal::SmartCardStatusChangeResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardStatusChangeResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardListReadersResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardListReadersResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardListReadersResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::SmartCardListReadersResultDataView::Tag::kReaders: {
    decltype(Traits::readers(input))
    in_readers = Traits::readers(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_readers)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& readers_validate_params =
            mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
        
mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
  in_readers,
  value_fragment,
  &readers_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null readers in SmartCardListReadersResult union");
    fragment->data.f_readers.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::SmartCardListReadersResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardError>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }

  static bool Deserialize(::device::mojom::internal::SmartCardListReadersResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardListReadersResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardCreateContextResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardCreateContextResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardCreateContextResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::SmartCardCreateContextResultDataView::Tag::kContext: {
    decltype(Traits::context(input))
    in_context = Traits::context(input);
        
mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::SmartCardContextInterfaceBase>>(
  in_context,
  &fragment->data.f_context,
  &fragment.message());
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_context)),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
  "null context in SmartCardCreateContextResult union");
    break;
  }
  case ::device::mojom::SmartCardCreateContextResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardError>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }

  static bool Deserialize(::device::mojom::internal::SmartCardCreateContextResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardCreateContextResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardConnectResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardConnectResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardConnectResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::SmartCardConnectResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::device::mojom::SmartCardConnectSuccessDataView>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in SmartCardConnectResult union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::SmartCardConnectResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardError>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }

  static bool Deserialize(::device::mojom::internal::SmartCardConnectResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardConnectResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardDataResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardDataResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardDataResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::SmartCardDataResultDataView::Tag::kData: {
    decltype(Traits::data(input))
    in_data = Traits::data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_data)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
  in_data,
  value_fragment,
  &data_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null data in SmartCardDataResult union");
    fragment->data.f_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::SmartCardDataResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardError>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }

  static bool Deserialize(::device::mojom::internal::SmartCardDataResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardDataResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardStatusResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardStatusResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardStatusResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::SmartCardStatusResultDataView::Tag::kStatus: {
    decltype(Traits::status(input))
    in_status = Traits::status(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_status)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::device::mojom::SmartCardStatusDataView>(
  in_status,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null status in SmartCardStatusResult union");
    fragment->data.f_status.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::SmartCardStatusResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardError>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }

  static bool Deserialize(::device::mojom::internal::SmartCardStatusResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardStatusResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardTransactionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardTransactionResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardTransactionResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::SmartCardTransactionResultDataView::Tag::kTransaction: {
    decltype(Traits::transaction(input))
    in_transaction = Traits::transaction(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardTransactionAssociatedPtrInfoDataView>(
  in_transaction,
  &fragment->data.f_transaction,
  &fragment.message());
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_transaction)),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
  "null transaction in SmartCardTransactionResult union");
    break;
  }
  case ::device::mojom::SmartCardTransactionResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardError>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }

  static bool Deserialize(::device::mojom::internal::SmartCardTransactionResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardTransactionResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {



inline void SmartCardReaderStateInDataView::GetReaderDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reader.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SmartCardReaderStateInDataView::GetCurrentStateDataView(
    SmartCardReaderStateFlagsDataView* output) {
  auto pointer = data_->current_state.Get();
  *output = SmartCardReaderStateFlagsDataView(pointer, message_);
}


inline void SmartCardReaderStateOutDataView::GetReaderDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reader.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SmartCardReaderStateOutDataView::GetEventStateDataView(
    SmartCardReaderStateFlagsDataView* output) {
  auto pointer = data_->event_state.Get();
  *output = SmartCardReaderStateFlagsDataView(pointer, message_);
}
inline void SmartCardReaderStateOutDataView::GetAnswerToResetDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->answer_to_reset.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}




inline void SmartCardStatusDataView::GetReaderNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reader_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SmartCardStatusDataView::GetAnswerToResetDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->answer_to_reset.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}





inline void SmartCardStatusChangeResultDataView::GetReaderStatesDataView(
    mojo::ArrayDataView<SmartCardReaderStateOutDataView>* output) const {
  CHECK(is_reader_states());
  *output = mojo::ArrayDataView<SmartCardReaderStateOutDataView>(data_->data.f_reader_states.Get(), message_);
}

inline void SmartCardListReadersResultDataView::GetReadersDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) const {
  CHECK(is_readers());
  *output = mojo::ArrayDataView<mojo::StringDataView>(data_->data.f_readers.Get(), message_);
}


inline void SmartCardConnectResultDataView::GetSuccessDataView(
    SmartCardConnectSuccessDataView* output) const {
  CHECK(is_success());
  *output = SmartCardConnectSuccessDataView(data_->data.f_success.Get(), message_);
}

inline void SmartCardDataResultDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) const {
  CHECK(is_data());
  *output = mojo::ArrayDataView<uint8_t>(data_->data.f_data.Get(), message_);
}

inline void SmartCardStatusResultDataView::GetStatusDataView(
    SmartCardStatusDataView* output) const {
  CHECK(is_status());
  *output = SmartCardStatusDataView(data_->data.f_status.Get(), message_);
}



}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::SmartCardSuccess> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::SmartCardSuccess value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::SmartCardError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::SmartCardError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::SmartCardShareMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::SmartCardShareMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::SmartCardProtocol> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::SmartCardProtocol value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::SmartCardDisposition> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::SmartCardDisposition value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::SmartCardConnectionState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::SmartCardConnectionState value);
};

} // namespace perfetto

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_SHARED_H_