// services/device/public/mojom/smart_card.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_SEND_VALIDATION_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_SEND_VALIDATION_H_

#include "services/device/public/mojom/smart_card.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "services/device/public/mojom/smart_card.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::SmartCardSuccess, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::SmartCardError, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::SmartCardShareMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::SmartCardProtocol, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::SmartCardDisposition, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::SmartCardConnectionState, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SmartCardReaderStateFlagsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardReaderStateFlagsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardReaderStateFlags_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->unaware = Traits::unaware(input);

      fragment->ignore = Traits::ignore(input);

      fragment->changed = Traits::changed(input);

      fragment->unknown = Traits::unknown(input);

      fragment->unavailable = Traits::unavailable(input);

      fragment->empty = Traits::empty(input);

      fragment->present = Traits::present(input);

      fragment->exclusive = Traits::exclusive(input);

      fragment->inuse = Traits::inuse(input);

      fragment->mute = Traits::mute(input);

      fragment->unpowered = Traits::unpowered(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SmartCardReaderStateInDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardReaderStateInDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardReaderStateIn_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::reader(input)) in_reader = Traits::reader(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reader)::BaseType> reader_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_reader,
        reader_fragment);

      fragment->reader.Set(
          reader_fragment.is_null() ? nullptr : reader_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reader.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reader in SmartCardReaderStateIn struct");

      decltype(Traits::current_state(input)) in_current_state = Traits::current_state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->current_state)::BaseType> current_state_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::SmartCardReaderStateFlagsDataView, send_validation>(
        in_current_state,
        current_state_fragment);

      fragment->current_state.Set(
          current_state_fragment.is_null() ? nullptr : current_state_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->current_state.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null current_state in SmartCardReaderStateIn struct");

      fragment->current_count = Traits::current_count(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SmartCardReaderStateOutDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardReaderStateOutDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardReaderStateOut_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::reader(input)) in_reader = Traits::reader(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reader)::BaseType> reader_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_reader,
        reader_fragment);

      fragment->reader.Set(
          reader_fragment.is_null() ? nullptr : reader_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reader.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reader in SmartCardReaderStateOut struct");

      decltype(Traits::event_state(input)) in_event_state = Traits::event_state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->event_state)::BaseType> event_state_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::SmartCardReaderStateFlagsDataView, send_validation>(
        in_event_state,
        event_state_fragment);

      fragment->event_state.Set(
          event_state_fragment.is_null() ? nullptr : event_state_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->event_state.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event_state in SmartCardReaderStateOut struct");

      fragment->event_count = Traits::event_count(input);

      decltype(Traits::answer_to_reset(input)) in_answer_to_reset = Traits::answer_to_reset(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->answer_to_reset)::BaseType>
          answer_to_reset_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& answer_to_reset_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_answer_to_reset,
        answer_to_reset_fragment,
        &answer_to_reset_validate_params);

      fragment->answer_to_reset.Set(
          answer_to_reset_fragment.is_null() ? nullptr : answer_to_reset_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->answer_to_reset.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null answer_to_reset in SmartCardReaderStateOut struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SmartCardProtocolsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardProtocolsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardProtocols_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->t0 = Traits::t0(input);

      fragment->t1 = Traits::t1(input);

      fragment->raw = Traits::raw(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SmartCardStatusDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardStatusDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::reader_name(input)) in_reader_name = Traits::reader_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reader_name)::BaseType> reader_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_reader_name,
        reader_name_fragment);

      fragment->reader_name.Set(
          reader_name_fragment.is_null() ? nullptr : reader_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->reader_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reader_name in SmartCardStatus struct");

      
      mojo::internal::Serialize<::device::mojom::SmartCardConnectionState>(
        Traits::state(input),
        &fragment->state);

      
      mojo::internal::Serialize<::device::mojom::SmartCardProtocol>(
        Traits::protocol(input),
        &fragment->protocol);

      decltype(Traits::answer_to_reset(input)) in_answer_to_reset = Traits::answer_to_reset(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->answer_to_reset)::BaseType>
          answer_to_reset_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& answer_to_reset_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_answer_to_reset,
        answer_to_reset_fragment,
        &answer_to_reset_validate_params);

      fragment->answer_to_reset.Set(
          answer_to_reset_fragment.is_null() ? nullptr : answer_to_reset_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->answer_to_reset.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null answer_to_reset in SmartCardStatus struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SmartCardConnectSuccessDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardConnectSuccessDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardConnectSuccess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::connection(input)) in_connection = Traits::connection(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::SmartCardConnectionInterfaceBase>>(
        in_connection,
        &fragment->connection,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->connection)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid connection in SmartCardConnectSuccess struct");

      
      mojo::internal::Serialize<::device::mojom::SmartCardProtocol>(
        Traits::active_protocol(input),
        &fragment->active_protocol);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SmartCardResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::SmartCardResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardSuccess, send_validation>(
  in_success,
  &fragment->data.f_success);
    break;
  }
  case ::device::mojom::SmartCardResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardError, send_validation>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SmartCardStatusChangeResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardStatusChangeResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardStatusChangeResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::SmartCardStatusChangeResultDataView::Tag::kReaderStates: {
    decltype(Traits::reader_states(input))
    in_reader_states = Traits::reader_states(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_reader_states)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& reader_states_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::SmartCardReaderStateOutDataView>, send_validation>(
  in_reader_states,
  value_fragment,
  &reader_states_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null reader_states in SmartCardStatusChangeResult union");
    fragment->data.f_reader_states.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::SmartCardStatusChangeResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardError, send_validation>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SmartCardListReadersResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardListReadersResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardListReadersResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::SmartCardListReadersResultDataView::Tag::kReaders: {
    decltype(Traits::readers(input))
    in_readers = Traits::readers(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_readers)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& readers_validate_params =
            mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
        
mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
  in_readers,
  value_fragment,
  &readers_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null readers in SmartCardListReadersResult union");
    fragment->data.f_readers.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::SmartCardListReadersResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardError, send_validation>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SmartCardCreateContextResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardCreateContextResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardCreateContextResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::SmartCardCreateContextResultDataView::Tag::kContext: {
    decltype(Traits::context(input))
    in_context = Traits::context(input);
        
mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::SmartCardContextInterfaceBase>, send_validation>(
  in_context,
  &fragment->data.f_context,
  &fragment.message());
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_context)),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
  "null context in SmartCardCreateContextResult union");
    break;
  }
  case ::device::mojom::SmartCardCreateContextResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardError, send_validation>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SmartCardConnectResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardConnectResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardConnectResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::SmartCardConnectResultDataView::Tag::kSuccess: {
    decltype(Traits::success(input))
    in_success = Traits::success(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_success)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::device::mojom::SmartCardConnectSuccessDataView, send_validation>(
  in_success,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null success in SmartCardConnectResult union");
    fragment->data.f_success.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::SmartCardConnectResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardError, send_validation>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SmartCardDataResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardDataResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardDataResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::SmartCardDataResultDataView::Tag::kData: {
    decltype(Traits::data(input))
    in_data = Traits::data(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_data)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
  in_data,
  value_fragment,
  &data_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null data in SmartCardDataResult union");
    fragment->data.f_data.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::SmartCardDataResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardError, send_validation>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SmartCardStatusResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardStatusResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardStatusResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::SmartCardStatusResultDataView::Tag::kStatus: {
    decltype(Traits::status(input))
    in_status = Traits::status(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_status)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::device::mojom::SmartCardStatusDataView, send_validation>(
  in_status,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null status in SmartCardStatusResult union");
    fragment->data.f_status.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::SmartCardStatusResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardError, send_validation>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SmartCardTransactionResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardTransactionResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardTransactionResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::SmartCardTransactionResultDataView::Tag::kTransaction: {
    decltype(Traits::transaction(input))
    in_transaction = Traits::transaction(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardTransactionAssociatedPtrInfoDataView, send_validation>(
  in_transaction,
  &fragment->data.f_transaction,
  &fragment.message());
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_transaction)),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
  "null transaction in SmartCardTransactionResult union");
    break;
  }
  case ::device::mojom::SmartCardTransactionResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::SmartCardError, send_validation>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_SEND_VALIDATION_H_