// services/device/public/mojom/smart_card.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.TimeDelta');




goog.provide('device.mojom.SmartCardSuccess');
goog.provide('device.mojom.SmartCardSuccessSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.SmartCardSuccessSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.SmartCardSuccess = {
  
  kOk: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};

goog.provide('device.mojom.SmartCardError');
goog.provide('device.mojom.SmartCardErrorSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.SmartCardErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.SmartCardError = {
  
  kRemovedCard: 0,
  kResetCard: 1,
  kUnpoweredCard: 2,
  kUnresponsiveCard: 3,
  kUnsupportedCard: 4,
  kReaderUnavailable: 5,
  kSharingViolation: 6,
  kNotTransacted: 7,
  kNoSmartcard: 8,
  kProtoMismatch: 9,
  kSystemCancelled: 10,
  kNotReady: 11,
  kCancelled: 12,
  kInsufficientBuffer: 13,
  kInvalidHandle: 14,
  kInvalidParameter: 15,
  kInvalidValue: 16,
  kNoMemory: 17,
  kTimeout: 18,
  kUnknownReader: 19,
  kUnsupportedFeature: 20,
  kNoReadersAvailable: 21,
  kServiceStopped: 22,
  kNoService: 23,
  kCommError: 24,
  kInternalError: 25,
  kUnknownError: 26,
  kServerTooBusy: 27,
  kUnexpected: 28,
  kShutdown: 29,
  kUnknown: 30,
  kPermissionDenied: 31,
  MIN_VALUE: 0,
  MAX_VALUE: 31,
};

goog.provide('device.mojom.SmartCardShareMode');
goog.provide('device.mojom.SmartCardShareModeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.SmartCardShareModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.SmartCardShareMode = {
  
  kShared: 0,
  kExclusive: 1,
  kDirect: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('device.mojom.SmartCardProtocol');
goog.provide('device.mojom.SmartCardProtocolSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.SmartCardProtocolSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.SmartCardProtocol = {
  
  kUndefined: 0,
  kT0: 1,
  kT1: 2,
  kRaw: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('device.mojom.SmartCardDisposition');
goog.provide('device.mojom.SmartCardDispositionSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.SmartCardDispositionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.SmartCardDisposition = {
  
  kLeave: 0,
  kReset: 1,
  kUnpower: 2,
  kEject: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('device.mojom.SmartCardConnectionState');
goog.provide('device.mojom.SmartCardConnectionStateSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.SmartCardConnectionStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.SmartCardConnectionState = {
  
  kAbsent: 0,
  kPresent: 1,
  kSwallowed: 2,
  kPowered: 3,
  kNegotiable: 4,
  kSpecific: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};



goog.provide('device.mojom.SmartCardTransaction');
goog.provide('device.mojom.SmartCardTransactionReceiver');
goog.provide('device.mojom.SmartCardTransactionCallbackRouter');
goog.provide('device.mojom.SmartCardTransactionInterface');
goog.provide('device.mojom.SmartCardTransactionRemote');
goog.provide('device.mojom.SmartCardTransactionPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.SmartCardTransactionPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.SmartCardTransaction.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.SmartCardTransactionInterface = class {
  
  /**
   * @param { !device.mojom.SmartCardDisposition } disposition
   * @return {!Promise<{
        result: !device.mojom.SmartCardResult,
   *  }>}
   */

  endTransaction(disposition) {}
};

/**
 * @export
 * @implements { device.mojom.SmartCardTransactionInterface }
 */
device.mojom.SmartCardTransactionRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.SmartCardTransactionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.SmartCardTransactionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.SmartCardTransactionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.SmartCardDisposition } disposition
   * @return {!Promise<{
        result: !device.mojom.SmartCardResult,
   *  }>}
   */

  endTransaction(
      disposition) {
    return this.proxy.sendMessage(
        0,
        device.mojom.SmartCardTransaction_EndTransaction_ParamsSpec.$,
        device.mojom.SmartCardTransaction_EndTransaction_ResponseParamsSpec.$,
        [
          disposition
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SmartCardTransaction
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.SmartCardTransactionReceiver = class {
  /**
   * @param {!device.mojom.SmartCardTransactionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.SmartCardTransactionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.SmartCardTransactionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SmartCardTransactionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.SmartCardTransaction_EndTransaction_ParamsSpec.$,
        device.mojom.SmartCardTransaction_EndTransaction_ResponseParamsSpec.$,
        impl.endTransaction.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.SmartCardTransaction = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SmartCardTransaction";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.SmartCardTransactionRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.SmartCardTransactionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SmartCardTransaction
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.SmartCardTransactionCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.SmartCardTransactionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SmartCardTransactionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.endTransaction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.SmartCardTransaction_EndTransaction_ParamsSpec.$,
        device.mojom.SmartCardTransaction_EndTransaction_ResponseParamsSpec.$,
        this.endTransaction.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.SmartCardConnection');
goog.provide('device.mojom.SmartCardConnectionReceiver');
goog.provide('device.mojom.SmartCardConnectionCallbackRouter');
goog.provide('device.mojom.SmartCardConnectionInterface');
goog.provide('device.mojom.SmartCardConnectionRemote');
goog.provide('device.mojom.SmartCardConnectionPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.SmartCardConnectionPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.SmartCardConnection.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.SmartCardConnectionInterface = class {
  
  /**
   * @param { !device.mojom.SmartCardDisposition } disposition
   * @return {!Promise<{
        result: !device.mojom.SmartCardResult,
   *  }>}
   */

  disconnect(disposition) {}
  
  /**
   * @param { !device.mojom.SmartCardProtocol } protocol
   * @param { !Array<!number> } data
   * @return {!Promise<{
        result: !device.mojom.SmartCardDataResult,
   *  }>}
   */

  transmit(protocol, data) {}
  
  /**
   * @param { !number } controlCode
   * @param { !Array<!number> } data
   * @return {!Promise<{
        result: !device.mojom.SmartCardDataResult,
   *  }>}
   */

  control(controlCode, data) {}
  
  /**
   * @param { !number } id
   * @return {!Promise<{
        result: !device.mojom.SmartCardDataResult,
   *  }>}
   */

  getAttrib(id) {}
  
  /**
   * @param { !number } id
   * @param { !Array<!number> } data
   * @return {!Promise<{
        result: !device.mojom.SmartCardResult,
   *  }>}
   */

  setAttrib(id, data) {}
  
  /**
   * @return {!Promise<{
        result: !device.mojom.SmartCardStatusResult,
   *  }>}
   */

  status() {}
  
  /**
   * @return {!Promise<{
        result: !device.mojom.SmartCardTransactionResult,
   *  }>}
   */

  beginTransaction() {}
};

/**
 * @export
 * @implements { device.mojom.SmartCardConnectionInterface }
 */
device.mojom.SmartCardConnectionRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.SmartCardConnectionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.SmartCardConnectionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.SmartCardConnectionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.SmartCardDisposition } disposition
   * @return {!Promise<{
        result: !device.mojom.SmartCardResult,
   *  }>}
   */

  disconnect(
      disposition) {
    return this.proxy.sendMessage(
        0,
        device.mojom.SmartCardConnection_Disconnect_ParamsSpec.$,
        device.mojom.SmartCardConnection_Disconnect_ResponseParamsSpec.$,
        [
          disposition
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.SmartCardProtocol } protocol
   * @param { !Array<!number> } data
   * @return {!Promise<{
        result: !device.mojom.SmartCardDataResult,
   *  }>}
   */

  transmit(
      protocol,
      data) {
    return this.proxy.sendMessage(
        1,
        device.mojom.SmartCardConnection_Transmit_ParamsSpec.$,
        device.mojom.SmartCardConnection_Transmit_ResponseParamsSpec.$,
        [
          protocol,
          data
        ],
        false);
  }

  
  /**
   * @param { !number } controlCode
   * @param { !Array<!number> } data
   * @return {!Promise<{
        result: !device.mojom.SmartCardDataResult,
   *  }>}
   */

  control(
      controlCode,
      data) {
    return this.proxy.sendMessage(
        2,
        device.mojom.SmartCardConnection_Control_ParamsSpec.$,
        device.mojom.SmartCardConnection_Control_ResponseParamsSpec.$,
        [
          controlCode,
          data
        ],
        false);
  }

  
  /**
   * @param { !number } id
   * @return {!Promise<{
        result: !device.mojom.SmartCardDataResult,
   *  }>}
   */

  getAttrib(
      id) {
    return this.proxy.sendMessage(
        3,
        device.mojom.SmartCardConnection_GetAttrib_ParamsSpec.$,
        device.mojom.SmartCardConnection_GetAttrib_ResponseParamsSpec.$,
        [
          id
        ],
        false);
  }

  
  /**
   * @param { !number } id
   * @param { !Array<!number> } data
   * @return {!Promise<{
        result: !device.mojom.SmartCardResult,
   *  }>}
   */

  setAttrib(
      id,
      data) {
    return this.proxy.sendMessage(
        4,
        device.mojom.SmartCardConnection_SetAttrib_ParamsSpec.$,
        device.mojom.SmartCardConnection_SetAttrib_ResponseParamsSpec.$,
        [
          id,
          data
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !device.mojom.SmartCardStatusResult,
   *  }>}
   */

  status() {
    return this.proxy.sendMessage(
        5,
        device.mojom.SmartCardConnection_Status_ParamsSpec.$,
        device.mojom.SmartCardConnection_Status_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !device.mojom.SmartCardTransactionResult,
   *  }>}
   */

  beginTransaction() {
    return this.proxy.sendMessage(
        6,
        device.mojom.SmartCardConnection_BeginTransaction_ParamsSpec.$,
        device.mojom.SmartCardConnection_BeginTransaction_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SmartCardConnection
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.SmartCardConnectionReceiver = class {
  /**
   * @param {!device.mojom.SmartCardConnectionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.SmartCardConnectionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.SmartCardConnectionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SmartCardConnectionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.SmartCardConnection_Disconnect_ParamsSpec.$,
        device.mojom.SmartCardConnection_Disconnect_ResponseParamsSpec.$,
        impl.disconnect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.SmartCardConnection_Transmit_ParamsSpec.$,
        device.mojom.SmartCardConnection_Transmit_ResponseParamsSpec.$,
        impl.transmit.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.SmartCardConnection_Control_ParamsSpec.$,
        device.mojom.SmartCardConnection_Control_ResponseParamsSpec.$,
        impl.control.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        device.mojom.SmartCardConnection_GetAttrib_ParamsSpec.$,
        device.mojom.SmartCardConnection_GetAttrib_ResponseParamsSpec.$,
        impl.getAttrib.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        device.mojom.SmartCardConnection_SetAttrib_ParamsSpec.$,
        device.mojom.SmartCardConnection_SetAttrib_ResponseParamsSpec.$,
        impl.setAttrib.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        device.mojom.SmartCardConnection_Status_ParamsSpec.$,
        device.mojom.SmartCardConnection_Status_ResponseParamsSpec.$,
        impl.status.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        device.mojom.SmartCardConnection_BeginTransaction_ParamsSpec.$,
        device.mojom.SmartCardConnection_BeginTransaction_ResponseParamsSpec.$,
        impl.beginTransaction.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.SmartCardConnection = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SmartCardConnection";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.SmartCardConnectionRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.SmartCardConnectionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SmartCardConnection
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.SmartCardConnectionCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.SmartCardConnectionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SmartCardConnectionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.disconnect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.SmartCardConnection_Disconnect_ParamsSpec.$,
        device.mojom.SmartCardConnection_Disconnect_ResponseParamsSpec.$,
        this.disconnect.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.transmit =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.SmartCardConnection_Transmit_ParamsSpec.$,
        device.mojom.SmartCardConnection_Transmit_ResponseParamsSpec.$,
        this.transmit.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.control =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.SmartCardConnection_Control_ParamsSpec.$,
        device.mojom.SmartCardConnection_Control_ResponseParamsSpec.$,
        this.control.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAttrib =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        device.mojom.SmartCardConnection_GetAttrib_ParamsSpec.$,
        device.mojom.SmartCardConnection_GetAttrib_ResponseParamsSpec.$,
        this.getAttrib.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAttrib =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        device.mojom.SmartCardConnection_SetAttrib_ParamsSpec.$,
        device.mojom.SmartCardConnection_SetAttrib_ResponseParamsSpec.$,
        this.setAttrib.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.status =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        device.mojom.SmartCardConnection_Status_ParamsSpec.$,
        device.mojom.SmartCardConnection_Status_ResponseParamsSpec.$,
        this.status.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.beginTransaction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        device.mojom.SmartCardConnection_BeginTransaction_ParamsSpec.$,
        device.mojom.SmartCardConnection_BeginTransaction_ResponseParamsSpec.$,
        this.beginTransaction.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.SmartCardConnectionWatcher');
goog.provide('device.mojom.SmartCardConnectionWatcherReceiver');
goog.provide('device.mojom.SmartCardConnectionWatcherCallbackRouter');
goog.provide('device.mojom.SmartCardConnectionWatcherInterface');
goog.provide('device.mojom.SmartCardConnectionWatcherRemote');
goog.provide('device.mojom.SmartCardConnectionWatcherPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.SmartCardConnectionWatcherPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.SmartCardConnectionWatcher.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.SmartCardConnectionWatcherInterface = class {
  
  /**
   */

  notifyConnectionUsed() {}
};

/**
 * @export
 * @implements { device.mojom.SmartCardConnectionWatcherInterface }
 */
device.mojom.SmartCardConnectionWatcherRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.SmartCardConnectionWatcherPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.SmartCardConnectionWatcherPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.SmartCardConnectionWatcherPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  notifyConnectionUsed() {
    this.proxy.sendMessage(
        0,
        device.mojom.SmartCardConnectionWatcher_NotifyConnectionUsed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SmartCardConnectionWatcher
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.SmartCardConnectionWatcherReceiver = class {
  /**
   * @param {!device.mojom.SmartCardConnectionWatcherInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.SmartCardConnectionWatcherRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.SmartCardConnectionWatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SmartCardConnectionWatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.SmartCardConnectionWatcher_NotifyConnectionUsed_ParamsSpec.$,
        null,
        impl.notifyConnectionUsed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.SmartCardConnectionWatcher = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SmartCardConnectionWatcher";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.SmartCardConnectionWatcherRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.SmartCardConnectionWatcherRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SmartCardConnectionWatcher
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.SmartCardConnectionWatcherCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.SmartCardConnectionWatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SmartCardConnectionWatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyConnectionUsed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.SmartCardConnectionWatcher_NotifyConnectionUsed_ParamsSpec.$,
        null,
        this.notifyConnectionUsed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.SmartCardContext');
goog.provide('device.mojom.SmartCardContextReceiver');
goog.provide('device.mojom.SmartCardContextCallbackRouter');
goog.provide('device.mojom.SmartCardContextInterface');
goog.provide('device.mojom.SmartCardContextRemote');
goog.provide('device.mojom.SmartCardContextPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.SmartCardContextPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.SmartCardContext.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.SmartCardContextInterface = class {
  
  /**
   * @return {!Promise<{
        result: !device.mojom.SmartCardListReadersResult,
   *  }>}
   */

  listReaders() {}
  
  /**
   * @param { !mojoBase.mojom.TimeDelta } timeout
   * @param { !Array<!device.mojom.SmartCardReaderStateIn> } readerStates
   * @return {!Promise<{
        result: !device.mojom.SmartCardStatusChangeResult,
   *  }>}
   */

  getStatusChange(timeout, readerStates) {}
  
  /**
   * @return {!Promise<{
        result: !device.mojom.SmartCardResult,
   *  }>}
   */

  cancel() {}
  
  /**
   * @param { !string } reader
   * @param { !device.mojom.SmartCardShareMode } shareMode
   * @param { !device.mojom.SmartCardProtocols } preferredProtocols
   * @param { ?device.mojom.SmartCardConnectionWatcherRemote } connectionWatcher
   * @return {!Promise<{
        result: !device.mojom.SmartCardConnectResult,
   *  }>}
   */

  connect(reader, shareMode, preferredProtocols, connectionWatcher) {}
};

/**
 * @export
 * @implements { device.mojom.SmartCardContextInterface }
 */
device.mojom.SmartCardContextRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.SmartCardContextPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.SmartCardContextPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.SmartCardContextPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: !device.mojom.SmartCardListReadersResult,
   *  }>}
   */

  listReaders() {
    return this.proxy.sendMessage(
        0,
        device.mojom.SmartCardContext_ListReaders_ParamsSpec.$,
        device.mojom.SmartCardContext_ListReaders_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.TimeDelta } timeout
   * @param { !Array<!device.mojom.SmartCardReaderStateIn> } readerStates
   * @return {!Promise<{
        result: !device.mojom.SmartCardStatusChangeResult,
   *  }>}
   */

  getStatusChange(
      timeout,
      readerStates) {
    return this.proxy.sendMessage(
        1,
        device.mojom.SmartCardContext_GetStatusChange_ParamsSpec.$,
        device.mojom.SmartCardContext_GetStatusChange_ResponseParamsSpec.$,
        [
          timeout,
          readerStates
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !device.mojom.SmartCardResult,
   *  }>}
   */

  cancel() {
    return this.proxy.sendMessage(
        2,
        device.mojom.SmartCardContext_Cancel_ParamsSpec.$,
        device.mojom.SmartCardContext_Cancel_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } reader
   * @param { !device.mojom.SmartCardShareMode } shareMode
   * @param { !device.mojom.SmartCardProtocols } preferredProtocols
   * @param { ?device.mojom.SmartCardConnectionWatcherRemote } connectionWatcher
   * @return {!Promise<{
        result: !device.mojom.SmartCardConnectResult,
   *  }>}
   */

  connect(
      reader,
      shareMode,
      preferredProtocols,
      connectionWatcher) {
    return this.proxy.sendMessage(
        3,
        device.mojom.SmartCardContext_Connect_ParamsSpec.$,
        device.mojom.SmartCardContext_Connect_ResponseParamsSpec.$,
        [
          reader,
          shareMode,
          preferredProtocols,
          connectionWatcher
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SmartCardContext
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.SmartCardContextReceiver = class {
  /**
   * @param {!device.mojom.SmartCardContextInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.SmartCardContextRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.SmartCardContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SmartCardContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.SmartCardContext_ListReaders_ParamsSpec.$,
        device.mojom.SmartCardContext_ListReaders_ResponseParamsSpec.$,
        impl.listReaders.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.SmartCardContext_GetStatusChange_ParamsSpec.$,
        device.mojom.SmartCardContext_GetStatusChange_ResponseParamsSpec.$,
        impl.getStatusChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.SmartCardContext_Cancel_ParamsSpec.$,
        device.mojom.SmartCardContext_Cancel_ResponseParamsSpec.$,
        impl.cancel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        device.mojom.SmartCardContext_Connect_ParamsSpec.$,
        device.mojom.SmartCardContext_Connect_ResponseParamsSpec.$,
        impl.connect.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.SmartCardContext = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SmartCardContext";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.SmartCardContextRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.SmartCardContextRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SmartCardContext
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.SmartCardContextCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.SmartCardContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SmartCardContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.listReaders =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.SmartCardContext_ListReaders_ParamsSpec.$,
        device.mojom.SmartCardContext_ListReaders_ResponseParamsSpec.$,
        this.listReaders.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getStatusChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.SmartCardContext_GetStatusChange_ParamsSpec.$,
        device.mojom.SmartCardContext_GetStatusChange_ResponseParamsSpec.$,
        this.getStatusChange.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.SmartCardContext_Cancel_ParamsSpec.$,
        device.mojom.SmartCardContext_Cancel_ResponseParamsSpec.$,
        this.cancel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        device.mojom.SmartCardContext_Connect_ParamsSpec.$,
        device.mojom.SmartCardContext_Connect_ResponseParamsSpec.$,
        this.connect.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.SmartCardContextFactory');
goog.provide('device.mojom.SmartCardContextFactoryReceiver');
goog.provide('device.mojom.SmartCardContextFactoryCallbackRouter');
goog.provide('device.mojom.SmartCardContextFactoryInterface');
goog.provide('device.mojom.SmartCardContextFactoryRemote');
goog.provide('device.mojom.SmartCardContextFactoryPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.SmartCardContextFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.SmartCardContextFactory.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.SmartCardContextFactoryInterface = class {
  
  /**
   * @return {!Promise<{
        result: !device.mojom.SmartCardCreateContextResult,
   *  }>}
   */

  createContext() {}
};

/**
 * @export
 * @implements { device.mojom.SmartCardContextFactoryInterface }
 */
device.mojom.SmartCardContextFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.SmartCardContextFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.SmartCardContextFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.SmartCardContextFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: !device.mojom.SmartCardCreateContextResult,
   *  }>}
   */

  createContext() {
    return this.proxy.sendMessage(
        0,
        device.mojom.SmartCardContextFactory_CreateContext_ParamsSpec.$,
        device.mojom.SmartCardContextFactory_CreateContext_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SmartCardContextFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.SmartCardContextFactoryReceiver = class {
  /**
   * @param {!device.mojom.SmartCardContextFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.SmartCardContextFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.SmartCardContextFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SmartCardContextFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.SmartCardContextFactory_CreateContext_ParamsSpec.$,
        device.mojom.SmartCardContextFactory_CreateContext_ResponseParamsSpec.$,
        impl.createContext.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.SmartCardContextFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SmartCardContextFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.SmartCardContextFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.SmartCardContextFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SmartCardContextFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.SmartCardContextFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.SmartCardContextFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.SmartCardContextFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.SmartCardContextFactory_CreateContext_ParamsSpec.$,
        device.mojom.SmartCardContextFactory_CreateContext_ResponseParamsSpec.$,
        this.createContext.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.SmartCardReaderStateFlagsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardReaderStateFlagsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardReaderStateInSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardReaderStateInSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardReaderStateOutSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardReaderStateOutSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardProtocolsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardProtocolsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardStatusSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardStatusSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardConnectSuccessSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardConnectSuccessSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardTransaction_EndTransaction_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardTransaction_EndTransaction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardTransaction_EndTransaction_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardTransaction_EndTransaction_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardConnection_Disconnect_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardConnection_Disconnect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardConnection_Disconnect_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardConnection_Disconnect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardConnection_Transmit_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardConnection_Transmit_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardConnection_Transmit_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardConnection_Transmit_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardConnection_Control_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardConnection_Control_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardConnection_Control_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardConnection_Control_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardConnection_GetAttrib_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardConnection_GetAttrib_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardConnection_GetAttrib_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardConnection_GetAttrib_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardConnection_SetAttrib_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardConnection_SetAttrib_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardConnection_SetAttrib_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardConnection_SetAttrib_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardConnection_Status_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardConnection_Status_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardConnection_Status_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardConnection_Status_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardConnection_BeginTransaction_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardConnection_BeginTransaction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardConnection_BeginTransaction_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardConnection_BeginTransaction_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardConnectionWatcher_NotifyConnectionUsed_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardConnectionWatcher_NotifyConnectionUsed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardContext_ListReaders_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardContext_ListReaders_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardContext_ListReaders_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardContext_ListReaders_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardContext_GetStatusChange_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardContext_GetStatusChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardContext_GetStatusChange_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardContext_GetStatusChange_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardContext_Cancel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardContext_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardContext_Cancel_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardContext_Cancel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardContext_Connect_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardContext_Connect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardContext_Connect_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardContext_Connect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardContextFactory_CreateContext_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardContextFactory_CreateContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardContextFactory_CreateContext_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.SmartCardContextFactory_CreateContext_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
device.mojom.SmartCardResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardStatusChangeResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
device.mojom.SmartCardStatusChangeResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardListReadersResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
device.mojom.SmartCardListReadersResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardCreateContextResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
device.mojom.SmartCardCreateContextResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardConnectResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
device.mojom.SmartCardConnectResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardDataResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
device.mojom.SmartCardDataResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardStatusResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
device.mojom.SmartCardStatusResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.SmartCardTransactionResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
device.mojom.SmartCardTransactionResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.SmartCardReaderStateFlagsSpec.$,
    'SmartCardReaderStateFlags',
    [
      mojo.internal.StructField(
        'unaware', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'ignore', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'changed', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'unknown', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'unavailable', 0,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'empty', 0,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'present', 0,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'exclusive', 0,
        7,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inuse', 1,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mute', 1,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'unpowered', 1,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.SmartCardReaderStateFlags');

/** @record */
device.mojom.SmartCardReaderStateFlags = class {
  constructor() {
    /** @export { !boolean } */
    this.unaware;
    /** @export { !boolean } */
    this.ignore;
    /** @export { !boolean } */
    this.changed;
    /** @export { !boolean } */
    this.unknown;
    /** @export { !boolean } */
    this.unavailable;
    /** @export { !boolean } */
    this.empty;
    /** @export { !boolean } */
    this.present;
    /** @export { !boolean } */
    this.exclusive;
    /** @export { !boolean } */
    this.inuse;
    /** @export { !boolean } */
    this.mute;
    /** @export { !boolean } */
    this.unpowered;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardReaderStateInSpec.$,
    'SmartCardReaderStateIn',
    [
      mojo.internal.StructField(
        'reader', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'currentState', 8,
        0,
        device.mojom.SmartCardReaderStateFlagsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'currentCount', 16,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('device.mojom.SmartCardReaderStateIn');

/** @record */
device.mojom.SmartCardReaderStateIn = class {
  constructor() {
    /** @export { !string } */
    this.reader;
    /** @export { !device.mojom.SmartCardReaderStateFlags } */
    this.currentState;
    /** @export { !number } */
    this.currentCount;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardReaderStateOutSpec.$,
    'SmartCardReaderStateOut',
    [
      mojo.internal.StructField(
        'reader', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventState', 8,
        0,
        device.mojom.SmartCardReaderStateFlagsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'eventCount', 16,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'answerToReset', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('device.mojom.SmartCardReaderStateOut');

/** @record */
device.mojom.SmartCardReaderStateOut = class {
  constructor() {
    /** @export { !string } */
    this.reader;
    /** @export { !device.mojom.SmartCardReaderStateFlags } */
    this.eventState;
    /** @export { !number } */
    this.eventCount;
    /** @export { !Array<!number> } */
    this.answerToReset;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardProtocolsSpec.$,
    'SmartCardProtocols',
    [
      mojo.internal.StructField(
        't0', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        't1', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'raw', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.SmartCardProtocols');

/** @record */
device.mojom.SmartCardProtocols = class {
  constructor() {
    /** @export { !boolean } */
    this.t0;
    /** @export { !boolean } */
    this.t1;
    /** @export { !boolean } */
    this.raw;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardStatusSpec.$,
    'SmartCardStatus',
    [
      mojo.internal.StructField(
        'readerName', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'state', 8,
        0,
        device.mojom.SmartCardConnectionStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'protocol', 12,
        0,
        device.mojom.SmartCardProtocolSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'answerToReset', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('device.mojom.SmartCardStatus');

/** @record */
device.mojom.SmartCardStatus = class {
  constructor() {
    /** @export { !string } */
    this.readerName;
    /** @export { !device.mojom.SmartCardConnectionState } */
    this.state;
    /** @export { !device.mojom.SmartCardProtocol } */
    this.protocol;
    /** @export { !Array<!number> } */
    this.answerToReset;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardConnectSuccessSpec.$,
    'SmartCardConnectSuccess',
    [
      mojo.internal.StructField(
        'connection', 0,
        0,
        mojo.internal.InterfaceProxy(device.mojom.SmartCardConnectionRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'activeProtocol', 8,
        0,
        device.mojom.SmartCardProtocolSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardConnectSuccess');

/** @record */
device.mojom.SmartCardConnectSuccess = class {
  constructor() {
    /** @export { !device.mojom.SmartCardConnectionRemote } */
    this.connection;
    /** @export { !device.mojom.SmartCardProtocol } */
    this.activeProtocol;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardTransaction_EndTransaction_ParamsSpec.$,
    'SmartCardTransaction_EndTransaction_Params',
    [
      mojo.internal.StructField(
        'disposition', 0,
        0,
        device.mojom.SmartCardDispositionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.SmartCardTransaction_EndTransaction_Params');

/** @record */
device.mojom.SmartCardTransaction_EndTransaction_Params = class {
  constructor() {
    /** @export { !device.mojom.SmartCardDisposition } */
    this.disposition;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardTransaction_EndTransaction_ResponseParamsSpec.$,
    'SmartCardTransaction_EndTransaction_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.SmartCardResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardTransaction_EndTransaction_ResponseParams');

/** @record */
device.mojom.SmartCardTransaction_EndTransaction_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.SmartCardResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardConnection_Disconnect_ParamsSpec.$,
    'SmartCardConnection_Disconnect_Params',
    [
      mojo.internal.StructField(
        'disposition', 0,
        0,
        device.mojom.SmartCardDispositionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.SmartCardConnection_Disconnect_Params');

/** @record */
device.mojom.SmartCardConnection_Disconnect_Params = class {
  constructor() {
    /** @export { !device.mojom.SmartCardDisposition } */
    this.disposition;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardConnection_Disconnect_ResponseParamsSpec.$,
    'SmartCardConnection_Disconnect_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.SmartCardResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardConnection_Disconnect_ResponseParams');

/** @record */
device.mojom.SmartCardConnection_Disconnect_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.SmartCardResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardConnection_Transmit_ParamsSpec.$,
    'SmartCardConnection_Transmit_Params',
    [
      mojo.internal.StructField(
        'protocol', 0,
        0,
        device.mojom.SmartCardProtocolSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardConnection_Transmit_Params');

/** @record */
device.mojom.SmartCardConnection_Transmit_Params = class {
  constructor() {
    /** @export { !device.mojom.SmartCardProtocol } */
    this.protocol;
    /** @export { !Array<!number> } */
    this.data;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardConnection_Transmit_ResponseParamsSpec.$,
    'SmartCardConnection_Transmit_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.SmartCardDataResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardConnection_Transmit_ResponseParams');

/** @record */
device.mojom.SmartCardConnection_Transmit_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.SmartCardDataResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardConnection_Control_ParamsSpec.$,
    'SmartCardConnection_Control_Params',
    [
      mojo.internal.StructField(
        'controlCode', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardConnection_Control_Params');

/** @record */
device.mojom.SmartCardConnection_Control_Params = class {
  constructor() {
    /** @export { !number } */
    this.controlCode;
    /** @export { !Array<!number> } */
    this.data;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardConnection_Control_ResponseParamsSpec.$,
    'SmartCardConnection_Control_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.SmartCardDataResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardConnection_Control_ResponseParams');

/** @record */
device.mojom.SmartCardConnection_Control_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.SmartCardDataResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardConnection_GetAttrib_ParamsSpec.$,
    'SmartCardConnection_GetAttrib_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.SmartCardConnection_GetAttrib_Params');

/** @record */
device.mojom.SmartCardConnection_GetAttrib_Params = class {
  constructor() {
    /** @export { !number } */
    this.id;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardConnection_GetAttrib_ResponseParamsSpec.$,
    'SmartCardConnection_GetAttrib_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.SmartCardDataResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardConnection_GetAttrib_ResponseParams');

/** @record */
device.mojom.SmartCardConnection_GetAttrib_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.SmartCardDataResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardConnection_SetAttrib_ParamsSpec.$,
    'SmartCardConnection_SetAttrib_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardConnection_SetAttrib_Params');

/** @record */
device.mojom.SmartCardConnection_SetAttrib_Params = class {
  constructor() {
    /** @export { !number } */
    this.id;
    /** @export { !Array<!number> } */
    this.data;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardConnection_SetAttrib_ResponseParamsSpec.$,
    'SmartCardConnection_SetAttrib_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.SmartCardResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardConnection_SetAttrib_ResponseParams');

/** @record */
device.mojom.SmartCardConnection_SetAttrib_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.SmartCardResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardConnection_Status_ParamsSpec.$,
    'SmartCardConnection_Status_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.SmartCardConnection_Status_Params');

/** @record */
device.mojom.SmartCardConnection_Status_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardConnection_Status_ResponseParamsSpec.$,
    'SmartCardConnection_Status_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.SmartCardStatusResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardConnection_Status_ResponseParams');

/** @record */
device.mojom.SmartCardConnection_Status_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.SmartCardStatusResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardConnection_BeginTransaction_ParamsSpec.$,
    'SmartCardConnection_BeginTransaction_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.SmartCardConnection_BeginTransaction_Params');

/** @record */
device.mojom.SmartCardConnection_BeginTransaction_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardConnection_BeginTransaction_ResponseParamsSpec.$,
    'SmartCardConnection_BeginTransaction_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.SmartCardTransactionResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardConnection_BeginTransaction_ResponseParams');

/** @record */
device.mojom.SmartCardConnection_BeginTransaction_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.SmartCardTransactionResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardConnectionWatcher_NotifyConnectionUsed_ParamsSpec.$,
    'SmartCardConnectionWatcher_NotifyConnectionUsed_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.SmartCardConnectionWatcher_NotifyConnectionUsed_Params');

/** @record */
device.mojom.SmartCardConnectionWatcher_NotifyConnectionUsed_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardContext_ListReaders_ParamsSpec.$,
    'SmartCardContext_ListReaders_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.SmartCardContext_ListReaders_Params');

/** @record */
device.mojom.SmartCardContext_ListReaders_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardContext_ListReaders_ResponseParamsSpec.$,
    'SmartCardContext_ListReaders_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.SmartCardListReadersResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardContext_ListReaders_ResponseParams');

/** @record */
device.mojom.SmartCardContext_ListReaders_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.SmartCardListReadersResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardContext_GetStatusChange_ParamsSpec.$,
    'SmartCardContext_GetStatusChange_Params',
    [
      mojo.internal.StructField(
        'timeout', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'readerStates', 8,
        0,
        mojo.internal.Array(device.mojom.SmartCardReaderStateInSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardContext_GetStatusChange_Params');

/** @record */
device.mojom.SmartCardContext_GetStatusChange_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.timeout;
    /** @export { !Array<!device.mojom.SmartCardReaderStateIn> } */
    this.readerStates;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardContext_GetStatusChange_ResponseParamsSpec.$,
    'SmartCardContext_GetStatusChange_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.SmartCardStatusChangeResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardContext_GetStatusChange_ResponseParams');

/** @record */
device.mojom.SmartCardContext_GetStatusChange_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.SmartCardStatusChangeResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardContext_Cancel_ParamsSpec.$,
    'SmartCardContext_Cancel_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.SmartCardContext_Cancel_Params');

/** @record */
device.mojom.SmartCardContext_Cancel_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardContext_Cancel_ResponseParamsSpec.$,
    'SmartCardContext_Cancel_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.SmartCardResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardContext_Cancel_ResponseParams');

/** @record */
device.mojom.SmartCardContext_Cancel_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.SmartCardResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardContext_Connect_ParamsSpec.$,
    'SmartCardContext_Connect_Params',
    [
      mojo.internal.StructField(
        'reader', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shareMode', 8,
        0,
        device.mojom.SmartCardShareModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'preferredProtocols', 16,
        0,
        device.mojom.SmartCardProtocolsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'connectionWatcher', 24,
        0,
        mojo.internal.InterfaceProxy(device.mojom.SmartCardConnectionWatcherRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('device.mojom.SmartCardContext_Connect_Params');

/** @record */
device.mojom.SmartCardContext_Connect_Params = class {
  constructor() {
    /** @export { !string } */
    this.reader;
    /** @export { !device.mojom.SmartCardShareMode } */
    this.shareMode;
    /** @export { !device.mojom.SmartCardProtocols } */
    this.preferredProtocols;
    /** @export { (device.mojom.SmartCardConnectionWatcherRemote|undefined) } */
    this.connectionWatcher;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardContext_Connect_ResponseParamsSpec.$,
    'SmartCardContext_Connect_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.SmartCardConnectResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardContext_Connect_ResponseParams');

/** @record */
device.mojom.SmartCardContext_Connect_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.SmartCardConnectResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardContextFactory_CreateContext_ParamsSpec.$,
    'SmartCardContextFactory_CreateContext_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.SmartCardContextFactory_CreateContext_Params');

/** @record */
device.mojom.SmartCardContextFactory_CreateContext_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.SmartCardContextFactory_CreateContext_ResponseParamsSpec.$,
    'SmartCardContextFactory_CreateContext_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.SmartCardCreateContextResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.SmartCardContextFactory_CreateContext_ResponseParams');

/** @record */
device.mojom.SmartCardContextFactory_CreateContext_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.SmartCardCreateContextResult } */
    this.result;
  }
};

goog.provide('device.mojom.SmartCardResult');


mojo.internal.Union(
    device.mojom.SmartCardResultSpec.$, 'SmartCardResult',
    {
      'success': {
        'ordinal': 0,
        'type': device.mojom.SmartCardSuccessSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': device.mojom.SmartCardErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!device.mojom.SmartCardSuccess|undefined),
 *   error: (!device.mojom.SmartCardError|undefined),
 * } }
 */
device.mojom.SmartCardResult;
goog.provide('device.mojom.SmartCardStatusChangeResult');


mojo.internal.Union(
    device.mojom.SmartCardStatusChangeResultSpec.$, 'SmartCardStatusChangeResult',
    {
      'readerStates': {
        'ordinal': 0,
        'type': mojo.internal.Array(device.mojom.SmartCardReaderStateOutSpec.$, false),
      },
      'error': {
        'ordinal': 1,
        'type': device.mojom.SmartCardErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   readerStates: (!Array<!device.mojom.SmartCardReaderStateOut>|undefined),
 *   error: (!device.mojom.SmartCardError|undefined),
 * } }
 */
device.mojom.SmartCardStatusChangeResult;
goog.provide('device.mojom.SmartCardListReadersResult');


mojo.internal.Union(
    device.mojom.SmartCardListReadersResultSpec.$, 'SmartCardListReadersResult',
    {
      'readers': {
        'ordinal': 0,
        'type': mojo.internal.Array(mojo.internal.String, false),
      },
      'error': {
        'ordinal': 1,
        'type': device.mojom.SmartCardErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   readers: (!Array<!string>|undefined),
 *   error: (!device.mojom.SmartCardError|undefined),
 * } }
 */
device.mojom.SmartCardListReadersResult;
goog.provide('device.mojom.SmartCardCreateContextResult');


mojo.internal.Union(
    device.mojom.SmartCardCreateContextResultSpec.$, 'SmartCardCreateContextResult',
    {
      'context': {
        'ordinal': 0,
        'type': mojo.internal.InterfaceProxy(device.mojom.SmartCardContextRemote),
      },
      'error': {
        'ordinal': 1,
        'type': device.mojom.SmartCardErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   context: (!device.mojom.SmartCardContextRemote|undefined),
 *   error: (!device.mojom.SmartCardError|undefined),
 * } }
 */
device.mojom.SmartCardCreateContextResult;
goog.provide('device.mojom.SmartCardConnectResult');


mojo.internal.Union(
    device.mojom.SmartCardConnectResultSpec.$, 'SmartCardConnectResult',
    {
      'success': {
        'ordinal': 0,
        'type': device.mojom.SmartCardConnectSuccessSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': device.mojom.SmartCardErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!device.mojom.SmartCardConnectSuccess|undefined),
 *   error: (!device.mojom.SmartCardError|undefined),
 * } }
 */
device.mojom.SmartCardConnectResult;
goog.provide('device.mojom.SmartCardDataResult');


mojo.internal.Union(
    device.mojom.SmartCardDataResultSpec.$, 'SmartCardDataResult',
    {
      'data': {
        'ordinal': 0,
        'type': mojo.internal.Array(mojo.internal.Uint8, false),
      },
      'error': {
        'ordinal': 1,
        'type': device.mojom.SmartCardErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   data: (!Array<!number>|undefined),
 *   error: (!device.mojom.SmartCardError|undefined),
 * } }
 */
device.mojom.SmartCardDataResult;
goog.provide('device.mojom.SmartCardStatusResult');


mojo.internal.Union(
    device.mojom.SmartCardStatusResultSpec.$, 'SmartCardStatusResult',
    {
      'status': {
        'ordinal': 0,
        'type': device.mojom.SmartCardStatusSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': device.mojom.SmartCardErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   status: (!device.mojom.SmartCardStatus|undefined),
 *   error: (!device.mojom.SmartCardError|undefined),
 * } }
 */
device.mojom.SmartCardStatusResult;
goog.provide('device.mojom.SmartCardTransactionResult');


mojo.internal.Union(
    device.mojom.SmartCardTransactionResultSpec.$, 'SmartCardTransactionResult',
    {
      'transaction': {
        'ordinal': 0,
        'type': mojo.internal.AssociatedInterfaceProxy(device.mojom.SmartCardTransactionRemote),
      },
      'error': {
        'ordinal': 1,
        'type': device.mojom.SmartCardErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   transaction: (!Object|undefined),
 *   error: (!device.mojom.SmartCardError|undefined),
 * } }
 */
device.mojom.SmartCardTransactionResult;
