// services/device/public/mojom/smart_card.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_DATA_VIEW_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/device/public/mojom/smart_card.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace device::mojom {
class SmartCardReaderStateFlagsDataView;

class SmartCardReaderStateInDataView;

class SmartCardReaderStateOutDataView;

class SmartCardProtocolsDataView;

class SmartCardStatusDataView;

class SmartCardConnectSuccessDataView;

class SmartCardResultDataView;
class SmartCardStatusChangeResultDataView;
class SmartCardListReadersResultDataView;
class SmartCardCreateContextResultDataView;
class SmartCardConnectResultDataView;
class SmartCardDataResultDataView;
class SmartCardStatusResultDataView;
class SmartCardTransactionResultDataView;


}  // device::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::SmartCardReaderStateFlagsDataView> {
  using Data = ::device::mojom::internal::SmartCardReaderStateFlags_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardReaderStateInDataView> {
  using Data = ::device::mojom::internal::SmartCardReaderStateIn_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardReaderStateOutDataView> {
  using Data = ::device::mojom::internal::SmartCardReaderStateOut_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardProtocolsDataView> {
  using Data = ::device::mojom::internal::SmartCardProtocols_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardStatusDataView> {
  using Data = ::device::mojom::internal::SmartCardStatus_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardConnectSuccessDataView> {
  using Data = ::device::mojom::internal::SmartCardConnectSuccess_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardResultDataView> {
  using Data = ::device::mojom::internal::SmartCardResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardStatusChangeResultDataView> {
  using Data = ::device::mojom::internal::SmartCardStatusChangeResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardListReadersResultDataView> {
  using Data = ::device::mojom::internal::SmartCardListReadersResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardCreateContextResultDataView> {
  using Data = ::device::mojom::internal::SmartCardCreateContextResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardConnectResultDataView> {
  using Data = ::device::mojom::internal::SmartCardConnectResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardDataResultDataView> {
  using Data = ::device::mojom::internal::SmartCardDataResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardStatusResultDataView> {
  using Data = ::device::mojom::internal::SmartCardStatusResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardTransactionResultDataView> {
  using Data = ::device::mojom::internal::SmartCardTransactionResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class SmartCardSuccess : int32_t {
  
  kOk = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, SmartCardSuccess value);
inline bool IsKnownEnumValue(SmartCardSuccess value) {
  return internal::SmartCardSuccess_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SmartCardError : int32_t {
  
  kRemovedCard = 0,
  
  kResetCard = 1,
  
  kUnpoweredCard = 2,
  
  kUnresponsiveCard = 3,
  
  kUnsupportedCard = 4,
  
  kReaderUnavailable = 5,
  
  kSharingViolation = 6,
  
  kNotTransacted = 7,
  
  kNoSmartcard = 8,
  
  kProtoMismatch = 9,
  
  kSystemCancelled = 10,
  
  kNotReady = 11,
  
  kCancelled = 12,
  
  kInsufficientBuffer = 13,
  
  kInvalidHandle = 14,
  
  kInvalidParameter = 15,
  
  kInvalidValue = 16,
  
  kNoMemory = 17,
  
  kTimeout = 18,
  
  kUnknownReader = 19,
  
  kUnsupportedFeature = 20,
  
  kNoReadersAvailable = 21,
  
  kServiceStopped = 22,
  
  kNoService = 23,
  
  kCommError = 24,
  
  kInternalError = 25,
  
  kUnknownError = 26,
  
  kServerTooBusy = 27,
  
  kUnexpected = 28,
  
  kShutdown = 29,
  
  kUnknown = 30,
  
  kPermissionDenied = 31,
  kMinValue = 0,
  kMaxValue = 31,
};

 std::ostream& operator<<(std::ostream& os, SmartCardError value);
inline bool IsKnownEnumValue(SmartCardError value) {
  return internal::SmartCardError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SmartCardShareMode : int32_t {
  
  kShared = 0,
  
  kExclusive = 1,
  
  kDirect = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SmartCardShareMode value);
inline bool IsKnownEnumValue(SmartCardShareMode value) {
  return internal::SmartCardShareMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SmartCardProtocol : int32_t {
  
  kUndefined = 0,
  
  kT0 = 1,
  
  kT1 = 2,
  
  kRaw = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, SmartCardProtocol value);
inline bool IsKnownEnumValue(SmartCardProtocol value) {
  return internal::SmartCardProtocol_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SmartCardDisposition : int32_t {
  
  kLeave = 0,
  
  kReset = 1,
  
  kUnpower = 2,
  
  kEject = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, SmartCardDisposition value);
inline bool IsKnownEnumValue(SmartCardDisposition value) {
  return internal::SmartCardDisposition_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SmartCardConnectionState : int32_t {
  
  kAbsent = 0,
  
  kPresent = 1,
  
  kSwallowed = 2,
  
  kPowered = 3,
  
  kNegotiable = 4,
  
  kSpecific = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, SmartCardConnectionState value);
inline bool IsKnownEnumValue(SmartCardConnectionState value) {
  return internal::SmartCardConnectionState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SmartCardTransactionInterfaceBase {};

using SmartCardTransactionPtrDataView =
    mojo::InterfacePtrDataView<SmartCardTransactionInterfaceBase>;
using SmartCardTransactionRequestDataView =
    mojo::InterfaceRequestDataView<SmartCardTransactionInterfaceBase>;
using SmartCardTransactionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SmartCardTransactionInterfaceBase>;
using SmartCardTransactionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SmartCardTransactionInterfaceBase>;
class SmartCardConnectionInterfaceBase {};

using SmartCardConnectionPtrDataView =
    mojo::InterfacePtrDataView<SmartCardConnectionInterfaceBase>;
using SmartCardConnectionRequestDataView =
    mojo::InterfaceRequestDataView<SmartCardConnectionInterfaceBase>;
using SmartCardConnectionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SmartCardConnectionInterfaceBase>;
using SmartCardConnectionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SmartCardConnectionInterfaceBase>;
class SmartCardConnectionWatcherInterfaceBase {};

using SmartCardConnectionWatcherPtrDataView =
    mojo::InterfacePtrDataView<SmartCardConnectionWatcherInterfaceBase>;
using SmartCardConnectionWatcherRequestDataView =
    mojo::InterfaceRequestDataView<SmartCardConnectionWatcherInterfaceBase>;
using SmartCardConnectionWatcherAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SmartCardConnectionWatcherInterfaceBase>;
using SmartCardConnectionWatcherAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SmartCardConnectionWatcherInterfaceBase>;
class SmartCardContextInterfaceBase {};

using SmartCardContextPtrDataView =
    mojo::InterfacePtrDataView<SmartCardContextInterfaceBase>;
using SmartCardContextRequestDataView =
    mojo::InterfaceRequestDataView<SmartCardContextInterfaceBase>;
using SmartCardContextAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SmartCardContextInterfaceBase>;
using SmartCardContextAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SmartCardContextInterfaceBase>;
class SmartCardContextFactoryInterfaceBase {};

using SmartCardContextFactoryPtrDataView =
    mojo::InterfacePtrDataView<SmartCardContextFactoryInterfaceBase>;
using SmartCardContextFactoryRequestDataView =
    mojo::InterfaceRequestDataView<SmartCardContextFactoryInterfaceBase>;
using SmartCardContextFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SmartCardContextFactoryInterfaceBase>;
using SmartCardContextFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SmartCardContextFactoryInterfaceBase>;


class SmartCardReaderStateFlagsDataView {
 public:
  SmartCardReaderStateFlagsDataView() = default;

  SmartCardReaderStateFlagsDataView(
      internal::SmartCardReaderStateFlags_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool unaware() const {
    return data_->unaware;
  }
  bool ignore() const {
    return data_->ignore;
  }
  bool changed() const {
    return data_->changed;
  }
  bool unknown() const {
    return data_->unknown;
  }
  bool unavailable() const {
    return data_->unavailable;
  }
  bool empty() const {
    return data_->empty;
  }
  bool present() const {
    return data_->present;
  }
  bool exclusive() const {
    return data_->exclusive;
  }
  bool inuse() const {
    return data_->inuse;
  }
  bool mute() const {
    return data_->mute;
  }
  bool unpowered() const {
    return data_->unpowered;
  }
 private:
  internal::SmartCardReaderStateFlags_Data* data_ = nullptr;
};


class SmartCardReaderStateInDataView {
 public:
  SmartCardReaderStateInDataView() = default;

  SmartCardReaderStateInDataView(
      internal::SmartCardReaderStateIn_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReaderDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReader(UserType* output) {
    
    auto* pointer = data_->reader.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCurrentStateDataView(
      SmartCardReaderStateFlagsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCurrentState(UserType* output) {
    
    auto* pointer = data_->current_state.Get();
    return mojo::internal::Deserialize<::device::mojom::SmartCardReaderStateFlagsDataView>(
        pointer, output, message_);
  }
  uint16_t current_count() const {
    return data_->current_count;
  }
 private:
  internal::SmartCardReaderStateIn_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SmartCardReaderStateOutDataView {
 public:
  SmartCardReaderStateOutDataView() = default;

  SmartCardReaderStateOutDataView(
      internal::SmartCardReaderStateOut_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReaderDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReader(UserType* output) {
    
    auto* pointer = data_->reader.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetEventStateDataView(
      SmartCardReaderStateFlagsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventState(UserType* output) {
    
    auto* pointer = data_->event_state.Get();
    return mojo::internal::Deserialize<::device::mojom::SmartCardReaderStateFlagsDataView>(
        pointer, output, message_);
  }
  uint16_t event_count() const {
    return data_->event_count;
  }
  inline void GetAnswerToResetDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnswerToReset(UserType* output) {
    
    auto* pointer = data_->answer_to_reset.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::SmartCardReaderStateOut_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SmartCardProtocolsDataView {
 public:
  SmartCardProtocolsDataView() = default;

  SmartCardProtocolsDataView(
      internal::SmartCardProtocols_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool t0() const {
    return data_->t0;
  }
  bool t1() const {
    return data_->t1;
  }
  bool raw() const {
    return data_->raw;
  }
 private:
  internal::SmartCardProtocols_Data* data_ = nullptr;
};


class SmartCardStatusDataView {
 public:
  SmartCardStatusDataView() = default;

  SmartCardStatusDataView(
      internal::SmartCardStatus_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReaderNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReaderName(UserType* output) {
    
    auto* pointer = data_->reader_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::device::mojom::SmartCardConnectionState>(
        data_value, output);
  }
  SmartCardConnectionState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::SmartCardConnectionState>(data_->state));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProtocol(UserType* output) const {
    auto data_value = data_->protocol;
    return mojo::internal::Deserialize<::device::mojom::SmartCardProtocol>(
        data_value, output);
  }
  SmartCardProtocol protocol() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::SmartCardProtocol>(data_->protocol));
  }
  inline void GetAnswerToResetDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnswerToReset(UserType* output) {
    
    auto* pointer = data_->answer_to_reset.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::SmartCardStatus_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SmartCardConnectSuccessDataView {
 public:
  SmartCardConnectSuccessDataView() = default;

  SmartCardConnectSuccessDataView(
      internal::SmartCardConnectSuccess_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeConnection() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::SmartCardConnectionInterfaceBase>>(
            &data_->connection, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadActiveProtocol(UserType* output) const {
    auto data_value = data_->active_protocol;
    return mojo::internal::Deserialize<::device::mojom::SmartCardProtocol>(
        data_value, output);
  }
  SmartCardProtocol active_protocol() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::SmartCardProtocol>(data_->active_protocol));
  }
 private:
  internal::SmartCardConnectSuccess_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SmartCardResultDataView {
 public:
  using Tag = internal::SmartCardResult_Data::SmartCardResult_Tag;

  SmartCardResultDataView() = default;

  SmartCardResultDataView(
      internal::SmartCardResult_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    CHECK(is_success());
    return mojo::internal::Deserialize<::device::mojom::SmartCardSuccess>(
        data_->data.f_success, output);
  }
  SmartCardSuccess success() const {
    CHECK(is_success());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardSuccess>(data_->data.f_success));
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::SmartCardError>(
        data_->data.f_error, output);
  }
  SmartCardError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(data_->data.f_error));
  }

 private:
  internal::SmartCardResult_Data* data_ = nullptr;
};



class SmartCardStatusChangeResultDataView {
 public:
  using Tag = internal::SmartCardStatusChangeResult_Data::SmartCardStatusChangeResult_Tag;

  SmartCardStatusChangeResultDataView() = default;

  SmartCardStatusChangeResultDataView(
      internal::SmartCardStatusChangeResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_reader_states() const { return data_->tag == Tag::kReaderStates; }
  inline void GetReaderStatesDataView(
      mojo::ArrayDataView<SmartCardReaderStateOutDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadReaderStates(UserType* output) const {
    
    CHECK(is_reader_states());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::SmartCardReaderStateOutDataView>>(
        data_->data.f_reader_states.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::SmartCardError>(
        data_->data.f_error, output);
  }
  SmartCardError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(data_->data.f_error));
  }

 private:
  internal::SmartCardStatusChangeResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class SmartCardListReadersResultDataView {
 public:
  using Tag = internal::SmartCardListReadersResult_Data::SmartCardListReadersResult_Tag;

  SmartCardListReadersResultDataView() = default;

  SmartCardListReadersResultDataView(
      internal::SmartCardListReadersResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_readers() const { return data_->tag == Tag::kReaders; }
  inline void GetReadersDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadReaders(UserType* output) const {
    
    CHECK(is_readers());
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        data_->data.f_readers.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::SmartCardError>(
        data_->data.f_error, output);
  }
  SmartCardError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(data_->data.f_error));
  }

 private:
  internal::SmartCardListReadersResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class SmartCardCreateContextResultDataView {
 public:
  using Tag = internal::SmartCardCreateContextResult_Data::SmartCardCreateContextResult_Tag;

  SmartCardCreateContextResultDataView() = default;

  SmartCardCreateContextResultDataView(
      internal::SmartCardCreateContextResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_context() const { return data_->tag == Tag::kContext; }
  template <typename UserType>
  UserType TakeContext() {
    CHECK(is_context());
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::SmartCardContextInterfaceBase>>(
            &data_->data.f_context, &result, message_);
    CHECK(ret);
    return result;
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::SmartCardError>(
        data_->data.f_error, output);
  }
  SmartCardError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(data_->data.f_error));
  }

 private:
  internal::SmartCardCreateContextResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class SmartCardConnectResultDataView {
 public:
  using Tag = internal::SmartCardConnectResult_Data::SmartCardConnectResult_Tag;

  SmartCardConnectResultDataView() = default;

  SmartCardConnectResultDataView(
      internal::SmartCardConnectResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      SmartCardConnectSuccessDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::device::mojom::SmartCardConnectSuccessDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::SmartCardError>(
        data_->data.f_error, output);
  }
  SmartCardError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(data_->data.f_error));
  }

 private:
  internal::SmartCardConnectResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class SmartCardDataResultDataView {
 public:
  using Tag = internal::SmartCardDataResult_Data::SmartCardDataResult_Tag;

  SmartCardDataResultDataView() = default;

  SmartCardDataResultDataView(
      internal::SmartCardDataResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_data() const { return data_->tag == Tag::kData; }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) const {
    
    CHECK(is_data());
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        data_->data.f_data.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::SmartCardError>(
        data_->data.f_error, output);
  }
  SmartCardError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(data_->data.f_error));
  }

 private:
  internal::SmartCardDataResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class SmartCardStatusResultDataView {
 public:
  using Tag = internal::SmartCardStatusResult_Data::SmartCardStatusResult_Tag;

  SmartCardStatusResultDataView() = default;

  SmartCardStatusResultDataView(
      internal::SmartCardStatusResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_status() const { return data_->tag == Tag::kStatus; }
  inline void GetStatusDataView(
      SmartCardStatusDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    
    CHECK(is_status());
    return mojo::internal::Deserialize<::device::mojom::SmartCardStatusDataView>(
        data_->data.f_status.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::SmartCardError>(
        data_->data.f_error, output);
  }
  SmartCardError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(data_->data.f_error));
  }

 private:
  internal::SmartCardStatusResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class SmartCardTransactionResultDataView {
 public:
  using Tag = internal::SmartCardTransactionResult_Data::SmartCardTransactionResult_Tag;

  SmartCardTransactionResultDataView() = default;

  SmartCardTransactionResultDataView(
      internal::SmartCardTransactionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_transaction() const { return data_->tag == Tag::kTransaction; }
  template <typename UserType>
  UserType TakeTransaction() {
    CHECK(is_transaction());
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::device::mojom::SmartCardTransactionAssociatedPtrInfoDataView>(
            &data_->data.f_transaction, &result, message_);
    CHECK(ret);
    return result;
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::SmartCardError>(
        data_->data.f_error, output);
  }
  SmartCardError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(data_->data.f_error));
  }

 private:
  internal::SmartCardTransactionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_DATA_VIEW_H_