// services/device/public/mojom/sensor_provider.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_PROVIDER_MOJOM_SHARED_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_PROVIDER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/sensor_provider.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "services/device/public/mojom/sensor.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/device/public/mojom/sensor_provider.mojom-data-view.h"




namespace std {

template <>
struct hash<::device::mojom::SensorCreationResult>
    : public mojo::internal::EnumHashImpl<::device::mojom::SensorCreationResult> {};

template <>
struct hash<::device::mojom::CreateVirtualSensorResult>
    : public mojo::internal::EnumHashImpl<::device::mojom::CreateVirtualSensorResult> {};

template <>
struct hash<::device::mojom::UpdateVirtualSensorResult>
    : public mojo::internal::EnumHashImpl<::device::mojom::UpdateVirtualSensorResult> {};

template <>
struct hash<::device::mojom::GetVirtualSensorInformationError>
    : public mojo::internal::EnumHashImpl<::device::mojom::GetVirtualSensorInformationError> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SensorCreationResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::SensorCreationResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SensorCreationResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::CreateVirtualSensorResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::CreateVirtualSensorResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::CreateVirtualSensorResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::UpdateVirtualSensorResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::UpdateVirtualSensorResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::UpdateVirtualSensorResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GetVirtualSensorInformationError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::GetVirtualSensorInformationError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::GetVirtualSensorInformationError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SensorInitParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SensorInitParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SensorInitParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::sensor(input)) in_sensor = Traits::sensor(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::SensorInterfaceBase>>(
      in_sensor,
      &fragment->sensor,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->sensor)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid sensor in SensorInitParams struct");

    decltype(Traits::client_receiver(input)) in_client_receiver = Traits::client_receiver(input);

    
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::SensorClientInterfaceBase>>(
      in_client_receiver,
      &fragment->client_receiver,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->client_receiver)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client_receiver in SensorInitParams struct");

    decltype(Traits::memory(input)) in_memory = Traits::memory(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->memory)::BaseType> memory_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
      in_memory,
      memory_fragment);

    fragment->memory.Set(
        memory_fragment.is_null() ? nullptr : memory_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->memory.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null memory in SensorInitParams struct");

    fragment->buffer_offset = Traits::buffer_offset(input);

    
    mojo::internal::Serialize<::device::mojom::ReportingMode>(
      Traits::mode(input),
      &fragment->mode);

    decltype(Traits::default_configuration(input)) in_default_configuration = Traits::default_configuration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->default_configuration)::BaseType> default_configuration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::SensorConfigurationDataView>(
      in_default_configuration,
      default_configuration_fragment);

    fragment->default_configuration.Set(
        default_configuration_fragment.is_null() ? nullptr : default_configuration_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->default_configuration.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_configuration in SensorInitParams struct");

    fragment->maximum_frequency = Traits::maximum_frequency(input);

    fragment->minimum_frequency = Traits::minimum_frequency(input);
  }

  static bool Deserialize(::device::mojom::internal::SensorInitParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SensorInitParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::VirtualSensorMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::VirtualSensorMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::VirtualSensorMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->available = Traits::available(input);
    fragment->maximum_frequency_$flag = Traits::maximum_frequency(input).has_value();
    if (Traits::maximum_frequency(input).has_value()) {
      fragment->maximum_frequency_$value = Traits::maximum_frequency(input).value();
    }
    fragment->minimum_frequency_$flag = Traits::minimum_frequency(input).has_value();
    if (Traits::minimum_frequency(input).has_value()) {
      fragment->minimum_frequency_$value = Traits::minimum_frequency(input).value();
    }
    fragment->reporting_mode_$flag = Traits::reporting_mode(input).has_value();
    if (Traits::reporting_mode(input).has_value()) {
      
      mojo::internal::Serialize<::device::mojom::ReportingMode>(
        Traits::reporting_mode(input).value(),
        &fragment->reporting_mode_$value);
    } else {
      fragment->reporting_mode_$value =
          static_cast<int32_t>(::device::mojom::ReportingMode::kMinValue);
    }
  }

  static bool Deserialize(::device::mojom::internal::VirtualSensorMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::VirtualSensorMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::VirtualSensorInformationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::VirtualSensorInformationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::VirtualSensorInformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->sampling_frequency = Traits::sampling_frequency(input);
  }

  static bool Deserialize(::device::mojom::internal::VirtualSensorInformation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::VirtualSensorInformationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GetVirtualSensorInformationResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::GetVirtualSensorInformationResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::GetVirtualSensorInformationResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::GetVirtualSensorInformationResultDataView::Tag::kInfo: {
    decltype(Traits::info(input))
    in_info = Traits::info(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_info)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::device::mojom::VirtualSensorInformationDataView>(
  in_info,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null info in GetVirtualSensorInformationResult union");
    fragment->data.f_info.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::GetVirtualSensorInformationResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::GetVirtualSensorInformationError>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }

  static bool Deserialize(::device::mojom::internal::GetVirtualSensorInformationResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::GetVirtualSensorInformationResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {

inline void SensorInitParamsDataView::GetMemoryDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) {
  auto pointer = data_->memory.Get();
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(pointer, message_);
}
inline void SensorInitParamsDataView::GetDefaultConfigurationDataView(
    ::device::mojom::SensorConfigurationDataView* output) {
  auto pointer = data_->default_configuration.Get();
  *output = ::device::mojom::SensorConfigurationDataView(pointer, message_);
}






inline void GetVirtualSensorInformationResultDataView::GetInfoDataView(
    VirtualSensorInformationDataView* output) const {
  CHECK(is_info());
  *output = VirtualSensorInformationDataView(data_->data.f_info.Get(), message_);
}


}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::SensorCreationResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::SensorCreationResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::CreateVirtualSensorResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::CreateVirtualSensorResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::UpdateVirtualSensorResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::UpdateVirtualSensorResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::GetVirtualSensorInformationError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::GetVirtualSensorInformationError value);
};

} // namespace perfetto

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_PROVIDER_MOJOM_SHARED_H_