// services/device/public/mojom/sensor.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SensorTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SensorType = {
  
  AMBIENT_LIGHT: 0,
  ACCELEROMETER: 1,
  LINEAR_ACCELERATION: 2,
  GRAVITY: 3,
  GYROSCOPE: 4,
  MAGNETOMETER: 5,
  ABSOLUTE_ORIENTATION_EULER_ANGLES: 6,
  ABSOLUTE_ORIENTATION_QUATERNION: 7,
  RELATIVE_ORIENTATION_EULER_ANGLES: 8,
  RELATIVE_ORIENTATION_QUATERNION: 9,
  MIN_VALUE: 0,
  MAX_VALUE: 9,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ReportingModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ReportingMode = {
  
  ON_CHANGE: 0,
  CONTINUOUS: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SensorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.Sensor', scope);
  }
}

/** @interface */
export class SensorInterface {
  
  /**
   * @return {!Promise<{
        configuration: !SensorConfiguration,
   *  }>}
   */

  getDefaultConfiguration() {}
  
  /**
   * @param { !SensorConfiguration } configuration
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  addConfiguration(configuration) {}
  
  /**
   * @param { !SensorConfiguration } configuration
   */

  removeConfiguration(configuration) {}
  
  /**
   */

  suspend() {}
  
  /**
   */

  resume() {}
  
  /**
   * @param { !boolean } enabled
   */

  configureReadingChangeNotifications(enabled) {}
}

/**
 * @implements { SensorInterface }
 */
export class SensorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SensorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SensorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SensorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        configuration: !SensorConfiguration,
   *  }>}
   */

  getDefaultConfiguration() {
    return this.proxy.sendMessage(
        0,
        Sensor_GetDefaultConfiguration_ParamsSpec.$,
        Sensor_GetDefaultConfiguration_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !SensorConfiguration } configuration
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  addConfiguration(
      configuration) {
    return this.proxy.sendMessage(
        1,
        Sensor_AddConfiguration_ParamsSpec.$,
        Sensor_AddConfiguration_ResponseParamsSpec.$,
        [
          configuration
        ],
        false);
  }

  
  /**
   * @param { !SensorConfiguration } configuration
   */

  removeConfiguration(
      configuration) {
    this.proxy.sendMessage(
        2,
        Sensor_RemoveConfiguration_ParamsSpec.$,
        null,
        [
          configuration
        ],
        false);
  }

  
  /**
   */

  suspend() {
    this.proxy.sendMessage(
        3,
        Sensor_Suspend_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resume() {
    this.proxy.sendMessage(
        4,
        Sensor_Resume_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } enabled
   */

  configureReadingChangeNotifications(
      enabled) {
    this.proxy.sendMessage(
        5,
        Sensor_ConfigureReadingChangeNotifications_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }
}

/**
 * An object which receives request messages for the Sensor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SensorReceiver {
  /**
   * @param {!SensorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SensorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SensorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SensorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Sensor_GetDefaultConfiguration_ParamsSpec.$,
        Sensor_GetDefaultConfiguration_ResponseParamsSpec.$,
        impl.getDefaultConfiguration.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Sensor_AddConfiguration_ParamsSpec.$,
        Sensor_AddConfiguration_ResponseParamsSpec.$,
        impl.addConfiguration.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Sensor_RemoveConfiguration_ParamsSpec.$,
        null,
        impl.removeConfiguration.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Sensor_Suspend_ParamsSpec.$,
        null,
        impl.suspend.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Sensor_Resume_ParamsSpec.$,
        null,
        impl.resume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Sensor_ConfigureReadingChangeNotifications_ParamsSpec.$,
        null,
        impl.configureReadingChangeNotifications.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Sensor {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.Sensor";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SensorRemote}
   */
  static getRemote() {
    let remote = new SensorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the Sensor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SensorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SensorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SensorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDefaultConfiguration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Sensor_GetDefaultConfiguration_ParamsSpec.$,
        Sensor_GetDefaultConfiguration_ResponseParamsSpec.$,
        this.getDefaultConfiguration.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addConfiguration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Sensor_AddConfiguration_ParamsSpec.$,
        Sensor_AddConfiguration_ResponseParamsSpec.$,
        this.addConfiguration.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeConfiguration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Sensor_RemoveConfiguration_ParamsSpec.$,
        null,
        this.removeConfiguration.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suspend =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Sensor_Suspend_ParamsSpec.$,
        null,
        this.suspend.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Sensor_Resume_ParamsSpec.$,
        null,
        this.resume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.configureReadingChangeNotifications =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Sensor_ConfigureReadingChangeNotifications_ParamsSpec.$,
        null,
        this.configureReadingChangeNotifications.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SensorClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.SensorClient', scope);
  }
}

/** @interface */
export class SensorClientInterface {
  
  /**
   */

  raiseError() {}
  
  /**
   */

  sensorReadingChanged() {}
}

/**
 * @implements { SensorClientInterface }
 */
export class SensorClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SensorClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SensorClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SensorClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  raiseError() {
    this.proxy.sendMessage(
        0,
        SensorClient_RaiseError_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  sensorReadingChanged() {
    this.proxy.sendMessage(
        1,
        SensorClient_SensorReadingChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SensorClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SensorClientReceiver {
  /**
   * @param {!SensorClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SensorClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SensorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SensorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SensorClient_RaiseError_ParamsSpec.$,
        null,
        impl.raiseError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SensorClient_SensorReadingChanged_ParamsSpec.$,
        null,
        impl.sensorReadingChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SensorClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.SensorClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SensorClientRemote}
   */
  static getRemote() {
    let remote = new SensorClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SensorClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SensorClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SensorClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SensorClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.raiseError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SensorClient_RaiseError_ParamsSpec.$,
        null,
        this.raiseError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sensorReadingChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SensorClient_SensorReadingChanged_ParamsSpec.$,
        null,
        this.sensorReadingChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SensorReadingRawSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SensorConfigurationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Sensor_GetDefaultConfiguration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Sensor_GetDefaultConfiguration_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Sensor_AddConfiguration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Sensor_AddConfiguration_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Sensor_RemoveConfiguration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Sensor_Suspend_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Sensor_Resume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Sensor_ConfigureReadingChangeNotifications_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SensorClient_RaiseError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SensorClient_SensorReadingChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SensorReadingRawSpec.$,
    'SensorReadingRaw',
    [
      mojo.internal.StructField(
        'timestamp', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'values', 8,
        0,
        mojo.internal.Array(mojo.internal.Double, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SensorReadingRaw {
  constructor() {
    /** @type { !number } */
    this.timestamp;
    /** @type { !Array<!number> } */
    this.values;
  }
}



mojo.internal.Struct(
    SensorConfigurationSpec.$,
    'SensorConfiguration',
    [
      mojo.internal.StructField(
        'frequency', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SensorConfiguration {
  constructor() {
    /** @type { !number } */
    this.frequency;
  }
}



mojo.internal.Struct(
    Sensor_GetDefaultConfiguration_ParamsSpec.$,
    'Sensor_GetDefaultConfiguration_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Sensor_GetDefaultConfiguration_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Sensor_GetDefaultConfiguration_ResponseParamsSpec.$,
    'Sensor_GetDefaultConfiguration_ResponseParams',
    [
      mojo.internal.StructField(
        'configuration', 0,
        0,
        SensorConfigurationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Sensor_GetDefaultConfiguration_ResponseParams {
  constructor() {
    /** @type { !SensorConfiguration } */
    this.configuration;
  }
}



mojo.internal.Struct(
    Sensor_AddConfiguration_ParamsSpec.$,
    'Sensor_AddConfiguration_Params',
    [
      mojo.internal.StructField(
        'configuration', 0,
        0,
        SensorConfigurationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Sensor_AddConfiguration_Params {
  constructor() {
    /** @type { !SensorConfiguration } */
    this.configuration;
  }
}



mojo.internal.Struct(
    Sensor_AddConfiguration_ResponseParamsSpec.$,
    'Sensor_AddConfiguration_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Sensor_AddConfiguration_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    Sensor_RemoveConfiguration_ParamsSpec.$,
    'Sensor_RemoveConfiguration_Params',
    [
      mojo.internal.StructField(
        'configuration', 0,
        0,
        SensorConfigurationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Sensor_RemoveConfiguration_Params {
  constructor() {
    /** @type { !SensorConfiguration } */
    this.configuration;
  }
}



mojo.internal.Struct(
    Sensor_Suspend_ParamsSpec.$,
    'Sensor_Suspend_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Sensor_Suspend_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Sensor_Resume_ParamsSpec.$,
    'Sensor_Resume_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Sensor_Resume_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Sensor_ConfigureReadingChangeNotifications_ParamsSpec.$,
    'Sensor_ConfigureReadingChangeNotifications_Params',
    [
      mojo.internal.StructField(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Sensor_ConfigureReadingChangeNotifications_Params {
  constructor() {
    /** @type { !boolean } */
    this.enabled;
  }
}



mojo.internal.Struct(
    SensorClient_RaiseError_ParamsSpec.$,
    'SensorClient_RaiseError_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SensorClient_RaiseError_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SensorClient_SensorReadingChanged_ParamsSpec.$,
    'SensorClient_SensorReadingChanged_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SensorClient_SensorReadingChanged_Params {
  constructor() {
  }
}

