// services/device/public/mojom/screen_orientation.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('device.mojom.ScreenOrientationLockResult');
goog.require('device.mojom.ScreenOrientationLockType');






goog.provide('device.mojom.ScreenOrientation');
goog.provide('device.mojom.ScreenOrientationReceiver');
goog.provide('device.mojom.ScreenOrientationCallbackRouter');
goog.provide('device.mojom.ScreenOrientationInterface');
goog.provide('device.mojom.ScreenOrientationRemote');
goog.provide('device.mojom.ScreenOrientationPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.ScreenOrientationPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.ScreenOrientation.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.ScreenOrientationInterface = class {
  
  /**
   * @param { !device.mojom.ScreenOrientationLockType } orientation
   * @return {!Promise<{
        result: !device.mojom.ScreenOrientationLockResult,
   *  }>}
   */

  lockOrientation(orientation) {}
  
  /**
   */

  unlockOrientation() {}
};

/**
 * @export
 * @implements { device.mojom.ScreenOrientationInterface }
 */
device.mojom.ScreenOrientationRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.ScreenOrientationPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.ScreenOrientationPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.ScreenOrientationPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.ScreenOrientationLockType } orientation
   * @return {!Promise<{
        result: !device.mojom.ScreenOrientationLockResult,
   *  }>}
   */

  lockOrientation(
      orientation) {
    return this.proxy.sendMessage(
        0,
        device.mojom.ScreenOrientation_LockOrientation_ParamsSpec.$,
        device.mojom.ScreenOrientation_LockOrientation_ResponseParamsSpec.$,
        [
          orientation
        ],
        false);
  }

  
  /**
   */

  unlockOrientation() {
    this.proxy.sendMessage(
        1,
        device.mojom.ScreenOrientation_UnlockOrientation_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ScreenOrientation
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.ScreenOrientationReceiver = class {
  /**
   * @param {!device.mojom.ScreenOrientationInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.ScreenOrientationRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.ScreenOrientationRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.ScreenOrientationRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.ScreenOrientation_LockOrientation_ParamsSpec.$,
        device.mojom.ScreenOrientation_LockOrientation_ResponseParamsSpec.$,
        impl.lockOrientation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.ScreenOrientation_UnlockOrientation_ParamsSpec.$,
        null,
        impl.unlockOrientation.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.ScreenOrientation = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.ScreenOrientation";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.ScreenOrientationRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.ScreenOrientationRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ScreenOrientation
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.ScreenOrientationCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.ScreenOrientationRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.ScreenOrientationRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.lockOrientation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.ScreenOrientation_LockOrientation_ParamsSpec.$,
        device.mojom.ScreenOrientation_LockOrientation_ResponseParamsSpec.$,
        this.lockOrientation.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.unlockOrientation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.ScreenOrientation_UnlockOrientation_ParamsSpec.$,
        null,
        this.unlockOrientation.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.ScreenOrientationListener');
goog.provide('device.mojom.ScreenOrientationListenerReceiver');
goog.provide('device.mojom.ScreenOrientationListenerCallbackRouter');
goog.provide('device.mojom.ScreenOrientationListenerInterface');
goog.provide('device.mojom.ScreenOrientationListenerRemote');
goog.provide('device.mojom.ScreenOrientationListenerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.ScreenOrientationListenerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.ScreenOrientationListener.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.ScreenOrientationListenerInterface = class {
  
  /**
   * @return {!Promise<{
        enabled: !boolean,
   *  }>}
   */

  isAutoRotateEnabledByUser() {}
};

/**
 * @export
 * @implements { device.mojom.ScreenOrientationListenerInterface }
 */
device.mojom.ScreenOrientationListenerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.ScreenOrientationListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.ScreenOrientationListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.ScreenOrientationListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        enabled: !boolean,
   *  }>}
   */

  isAutoRotateEnabledByUser() {
    return this.proxy.sendMessage(
        0,
        device.mojom.ScreenOrientationListener_IsAutoRotateEnabledByUser_ParamsSpec.$,
        device.mojom.ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ScreenOrientationListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.ScreenOrientationListenerReceiver = class {
  /**
   * @param {!device.mojom.ScreenOrientationListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.ScreenOrientationListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.ScreenOrientationListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.ScreenOrientationListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.ScreenOrientationListener_IsAutoRotateEnabledByUser_ParamsSpec.$,
        device.mojom.ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParamsSpec.$,
        impl.isAutoRotateEnabledByUser.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.ScreenOrientationListener = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.ScreenOrientationListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.ScreenOrientationListenerRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.ScreenOrientationListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ScreenOrientationListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.ScreenOrientationListenerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.ScreenOrientationListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.ScreenOrientationListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isAutoRotateEnabledByUser =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.ScreenOrientationListener_IsAutoRotateEnabledByUser_ParamsSpec.$,
        device.mojom.ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParamsSpec.$,
        this.isAutoRotateEnabledByUser.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.ScreenOrientation_LockOrientation_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.ScreenOrientation_LockOrientation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.ScreenOrientation_LockOrientation_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.ScreenOrientation_LockOrientation_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.ScreenOrientation_UnlockOrientation_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.ScreenOrientation_UnlockOrientation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.ScreenOrientationListener_IsAutoRotateEnabledByUser_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.ScreenOrientationListener_IsAutoRotateEnabledByUser_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.ScreenOrientation_LockOrientation_ParamsSpec.$,
    'ScreenOrientation_LockOrientation_Params',
    [
      mojo.internal.StructField(
        'orientation', 0,
        0,
        device.mojom.ScreenOrientationLockTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.ScreenOrientation_LockOrientation_Params');

/** @record */
device.mojom.ScreenOrientation_LockOrientation_Params = class {
  constructor() {
    /** @export { !device.mojom.ScreenOrientationLockType } */
    this.orientation;
  }
};



mojo.internal.Struct(
    device.mojom.ScreenOrientation_LockOrientation_ResponseParamsSpec.$,
    'ScreenOrientation_LockOrientation_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.ScreenOrientationLockResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.ScreenOrientation_LockOrientation_ResponseParams');

/** @record */
device.mojom.ScreenOrientation_LockOrientation_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.ScreenOrientationLockResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.ScreenOrientation_UnlockOrientation_ParamsSpec.$,
    'ScreenOrientation_UnlockOrientation_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.ScreenOrientation_UnlockOrientation_Params');

/** @record */
device.mojom.ScreenOrientation_UnlockOrientation_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.ScreenOrientationListener_IsAutoRotateEnabledByUser_ParamsSpec.$,
    'ScreenOrientationListener_IsAutoRotateEnabledByUser_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.ScreenOrientationListener_IsAutoRotateEnabledByUser_Params');

/** @record */
device.mojom.ScreenOrientationListener_IsAutoRotateEnabledByUser_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParamsSpec.$,
    'ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParams',
    [
      mojo.internal.StructField(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParams');

/** @record */
device.mojom.ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.enabled;
  }
};

