// services/device/public/mojom/pressure_update.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_PRESSURE_UPDATE_MOJOM_BLINK_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_PRESSURE_UPDATE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/pressure_update.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/pressure_update.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/pressure_update.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace device::mojom::blink {






class BLINK_PLATFORM_EXPORT PressureData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PressureData, T>::value>;
  using DataView = PressureDataDataView;
  using Data_ = internal::PressureData_Data;

  template <typename... Args>
  static PressureDataPtr New(Args&&... args) {
    return PressureDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PressureDataPtr From(const U& u) {
    return mojo::TypeConverter<PressureDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PressureData>::Convert(*this);
  }


  PressureData();

  PressureData(
      double cpu_utilization,
      double own_contribution_estimate);


  ~PressureData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PressureDataPtr>
  PressureDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PressureData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PressureData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PressureData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PressureData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PressureData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PressureData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PressureData_UnserializedMessageContext<
            UserType, PressureData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PressureData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PressureData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PressureData_UnserializedMessageContext<
            UserType, PressureData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PressureData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double cpu_utilization;
  
  double own_contribution_estimate;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PressureData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PressureData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PressureData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PressureData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_PLATFORM_EXPORT PressureUpdate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PressureUpdate, T>::value>;
  using DataView = PressureUpdateDataView;
  using Data_ = internal::PressureUpdate_Data;

  template <typename... Args>
  static PressureUpdatePtr New(Args&&... args) {
    return PressureUpdatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PressureUpdatePtr From(const U& u) {
    return mojo::TypeConverter<PressureUpdatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PressureUpdate>::Convert(*this);
  }


  PressureUpdate();

  PressureUpdate(
      PressureSource source,
      PressureDataPtr data,
      ::base::TimeTicks timestamp);

PressureUpdate(const PressureUpdate&) = delete;
PressureUpdate& operator=(const PressureUpdate&) = delete;

  ~PressureUpdate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PressureUpdatePtr>
  PressureUpdatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PressureUpdate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PressureUpdate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PressureUpdate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PressureUpdate::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PressureUpdate::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PressureUpdate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PressureUpdate_UnserializedMessageContext<
            UserType, PressureUpdate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PressureUpdate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PressureUpdate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PressureUpdate_UnserializedMessageContext<
            UserType, PressureUpdate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PressureUpdate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PressureSource source;
  
  PressureDataPtr data;
  
  ::base::TimeTicks timestamp;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PressureUpdate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PressureUpdate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PressureUpdate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PressureUpdate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
PressureUpdatePtr PressureUpdate::Clone() const {
  return New(
      mojo::Clone(source),
      mojo::Clone(data),
      mojo::Clone(timestamp)
  );
}

template <typename T, PressureUpdate::EnableIfSame<T>*>
bool PressureUpdate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  return true;
}

template <typename T, PressureUpdate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.source < rhs.source)
    return true;
  if (rhs.source < lhs.source)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  return false;
}
template <typename StructPtrType>
PressureDataPtr PressureData::Clone() const {
  return New(
      mojo::Clone(cpu_utilization),
      mojo::Clone(own_contribution_estimate)
  );
}

template <typename T, PressureData::EnableIfSame<T>*>
bool PressureData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cpu_utilization, other_struct.cpu_utilization))
    return false;
  if (!mojo::Equals(this->own_contribution_estimate, other_struct.own_contribution_estimate))
    return false;
  return true;
}

template <typename T, PressureData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cpu_utilization < rhs.cpu_utilization)
    return true;
  if (rhs.cpu_utilization < lhs.cpu_utilization)
    return false;
  if (lhs.own_contribution_estimate < rhs.own_contribution_estimate)
    return true;
  if (rhs.own_contribution_estimate < lhs.own_contribution_estimate)
    return false;
  return false;
}


}  // device::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::PressureUpdate::DataView,
                                         ::device::mojom::blink::PressureUpdatePtr> {
  static bool IsNull(const ::device::mojom::blink::PressureUpdatePtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::PressureUpdatePtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::PressureUpdate::source) source(
      const ::device::mojom::blink::PressureUpdatePtr& input) {
    return input->source;
  }

  static const decltype(::device::mojom::blink::PressureUpdate::data)& data(
      const ::device::mojom::blink::PressureUpdatePtr& input) {
    return input->data;
  }

  static const decltype(::device::mojom::blink::PressureUpdate::timestamp)& timestamp(
      const ::device::mojom::blink::PressureUpdatePtr& input) {
    return input->timestamp;
  }

  static bool Read(::device::mojom::blink::PressureUpdate::DataView input, ::device::mojom::blink::PressureUpdatePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::PressureData::DataView,
                                         ::device::mojom::blink::PressureDataPtr> {
  static bool IsNull(const ::device::mojom::blink::PressureDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::PressureDataPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::PressureData::cpu_utilization) cpu_utilization(
      const ::device::mojom::blink::PressureDataPtr& input) {
    return input->cpu_utilization;
  }

  static decltype(::device::mojom::blink::PressureData::own_contribution_estimate) own_contribution_estimate(
      const ::device::mojom::blink::PressureDataPtr& input) {
    return input->own_contribution_estimate;
  }

  static bool Read(::device::mojom::blink::PressureData::DataView input, ::device::mojom::blink::PressureDataPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_PRESSURE_UPDATE_MOJOM_BLINK_H_