// services/device/public/mojom/pressure_manager.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/device/public/mojom/pressure_manager.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('device.mojom');
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var pressure_update$ =
      mojo.internal.exposeNamespace('device.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/device/public/mojom/pressure_update.mojom', 'pressure_update.mojom.js');
  }


  var PressureManagerAddClientResult = {};
  PressureManagerAddClientResult.kNotSupported = 0;
  PressureManagerAddClientResult.kOk = 1;
  PressureManagerAddClientResult.MIN_VALUE = 0;
  PressureManagerAddClientResult.MAX_VALUE = 1;

  PressureManagerAddClientResult.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  PressureManagerAddClientResult.toKnownEnumValue = function(value) {
    return value;
  };

  PressureManagerAddClientResult.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function VirtualPressureSourceMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  VirtualPressureSourceMetadata.prototype.initDefaults_ = function() {
    this.available = true;
  };
  VirtualPressureSourceMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  VirtualPressureSourceMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  VirtualPressureSourceMetadata.encodedSize = codec.kStructHeaderSize + 8;

  VirtualPressureSourceMetadata.decode = function(decoder) {
    var packed;
    var val = new VirtualPressureSourceMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.available = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  VirtualPressureSourceMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(VirtualPressureSourceMetadata.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.available & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PressureManager_AddVirtualPressureSource_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PressureManager_AddVirtualPressureSource_Params.prototype.initDefaults_ = function() {
    this.token = null;
    this.source = 0;
    this.metadata = null;
  };
  PressureManager_AddVirtualPressureSource_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PressureManager_AddVirtualPressureSource_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PressureManager_AddVirtualPressureSource_Params.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PressureManager_AddVirtualPressureSource_Params.source
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, pressure_update$.PressureSource);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PressureManager_AddVirtualPressureSource_Params.metadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, VirtualPressureSourceMetadata, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PressureManager_AddVirtualPressureSource_Params.encodedSize = codec.kStructHeaderSize + 24;

  PressureManager_AddVirtualPressureSource_Params.decode = function(decoder) {
    var packed;
    var val = new PressureManager_AddVirtualPressureSource_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.source =
        decoder.decodeStruct(new codec.Enum(pressure_update$.PressureSource));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.metadata =
        decoder.decodeStructPointer(VirtualPressureSourceMetadata);
    return val;
  };

  PressureManager_AddVirtualPressureSource_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PressureManager_AddVirtualPressureSource_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.token);
    encoder.encodeStruct(codec.Int32, val.source);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(VirtualPressureSourceMetadata, val.metadata);
  };
  function PressureManager_AddVirtualPressureSource_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PressureManager_AddVirtualPressureSource_ResponseParams.prototype.initDefaults_ = function() {
  };
  PressureManager_AddVirtualPressureSource_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PressureManager_AddVirtualPressureSource_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PressureManager_AddVirtualPressureSource_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  PressureManager_AddVirtualPressureSource_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PressureManager_AddVirtualPressureSource_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PressureManager_AddVirtualPressureSource_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PressureManager_AddVirtualPressureSource_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function PressureManager_RemoveVirtualPressureSource_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PressureManager_RemoveVirtualPressureSource_Params.prototype.initDefaults_ = function() {
    this.token = null;
    this.source = 0;
  };
  PressureManager_RemoveVirtualPressureSource_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PressureManager_RemoveVirtualPressureSource_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PressureManager_RemoveVirtualPressureSource_Params.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PressureManager_RemoveVirtualPressureSource_Params.source
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, pressure_update$.PressureSource);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PressureManager_RemoveVirtualPressureSource_Params.encodedSize = codec.kStructHeaderSize + 16;

  PressureManager_RemoveVirtualPressureSource_Params.decode = function(decoder) {
    var packed;
    var val = new PressureManager_RemoveVirtualPressureSource_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.source =
        decoder.decodeStruct(new codec.Enum(pressure_update$.PressureSource));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PressureManager_RemoveVirtualPressureSource_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PressureManager_RemoveVirtualPressureSource_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.token);
    encoder.encodeStruct(codec.Int32, val.source);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PressureManager_RemoveVirtualPressureSource_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PressureManager_RemoveVirtualPressureSource_ResponseParams.prototype.initDefaults_ = function() {
  };
  PressureManager_RemoveVirtualPressureSource_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PressureManager_RemoveVirtualPressureSource_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PressureManager_RemoveVirtualPressureSource_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  PressureManager_RemoveVirtualPressureSource_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PressureManager_RemoveVirtualPressureSource_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PressureManager_RemoveVirtualPressureSource_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PressureManager_RemoveVirtualPressureSource_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function PressureManager_UpdateVirtualPressureSourceData_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PressureManager_UpdateVirtualPressureSourceData_Params.prototype.initDefaults_ = function() {
    this.token = null;
    this.source = 0;
    this.state = 0;
    this.ownContributionEstimate = 0;
  };
  PressureManager_UpdateVirtualPressureSourceData_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PressureManager_UpdateVirtualPressureSourceData_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PressureManager_UpdateVirtualPressureSourceData_Params.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PressureManager_UpdateVirtualPressureSourceData_Params.source
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, pressure_update$.PressureSource);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PressureManager_UpdateVirtualPressureSourceData_Params.state
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, pressure_update$.PressureState);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PressureManager_UpdateVirtualPressureSourceData_Params.encodedSize = codec.kStructHeaderSize + 24;

  PressureManager_UpdateVirtualPressureSourceData_Params.decode = function(decoder) {
    var packed;
    var val = new PressureManager_UpdateVirtualPressureSourceData_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.source =
        decoder.decodeStruct(new codec.Enum(pressure_update$.PressureSource));
    val.state =
        decoder.decodeStruct(new codec.Enum(pressure_update$.PressureState));
    val.ownContributionEstimate =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  PressureManager_UpdateVirtualPressureSourceData_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PressureManager_UpdateVirtualPressureSourceData_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.token);
    encoder.encodeStruct(codec.Int32, val.source);
    encoder.encodeStruct(codec.Int32, val.state);
    encoder.encodeStruct(codec.Double, val.ownContributionEstimate);
  };
  function PressureManager_UpdateVirtualPressureSourceData_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PressureManager_UpdateVirtualPressureSourceData_ResponseParams.prototype.initDefaults_ = function() {
  };
  PressureManager_UpdateVirtualPressureSourceData_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PressureManager_UpdateVirtualPressureSourceData_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PressureManager_UpdateVirtualPressureSourceData_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  PressureManager_UpdateVirtualPressureSourceData_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PressureManager_UpdateVirtualPressureSourceData_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PressureManager_UpdateVirtualPressureSourceData_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PressureManager_UpdateVirtualPressureSourceData_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function PressureManager_AddClient_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PressureManager_AddClient_Params.prototype.initDefaults_ = function() {
    this.source = 0;
    this.token = null;
    this.client = new associatedBindings.AssociatedInterfacePtrInfo();
  };
  PressureManager_AddClient_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PressureManager_AddClient_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PressureManager_AddClient_Params.source
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, pressure_update$.PressureSource);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PressureManager_AddClient_Params.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PressureManager_AddClient_Params.client
    err = messageValidator.validateAssociatedInterface(offset + codec.kStructHeaderSize + 16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PressureManager_AddClient_Params.encodedSize = codec.kStructHeaderSize + 24;

  PressureManager_AddClient_Params.decode = function(decoder) {
    var packed;
    var val = new PressureManager_AddClient_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.source =
        decoder.decodeStruct(new codec.Enum(pressure_update$.PressureSource));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.token =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.client =
        decoder.decodeStruct(codec.AssociatedInterfacePtrInfo);
    return val;
  };

  PressureManager_AddClient_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PressureManager_AddClient_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.source);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.token);
    encoder.encodeStruct(codec.AssociatedInterfacePtrInfo, val.client);
  };
  function PressureManager_AddClient_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PressureManager_AddClient_ResponseParams.prototype.initDefaults_ = function() {
    this.result = 0;
  };
  PressureManager_AddClient_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PressureManager_AddClient_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PressureManager_AddClient_ResponseParams.result
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, PressureManagerAddClientResult);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PressureManager_AddClient_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  PressureManager_AddClient_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PressureManager_AddClient_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(new codec.Enum(PressureManagerAddClientResult));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PressureManager_AddClient_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PressureManager_AddClient_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.result);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PressureClient_OnPressureUpdated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PressureClient_OnPressureUpdated_Params.prototype.initDefaults_ = function() {
    this.update = null;
  };
  PressureClient_OnPressureUpdated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PressureClient_OnPressureUpdated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PressureClient_OnPressureUpdated_Params.update
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, pressure_update$.PressureUpdate, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PressureClient_OnPressureUpdated_Params.encodedSize = codec.kStructHeaderSize + 8;

  PressureClient_OnPressureUpdated_Params.decode = function(decoder) {
    var packed;
    var val = new PressureClient_OnPressureUpdated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.update =
        decoder.decodeStructPointer(pressure_update$.PressureUpdate);
    return val;
  };

  PressureClient_OnPressureUpdated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PressureClient_OnPressureUpdated_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(pressure_update$.PressureUpdate, val.update);
  };
  var kPressureManager_AddVirtualPressureSource_Name = 0;
  var kPressureManager_RemoveVirtualPressureSource_Name = 1;
  var kPressureManager_UpdateVirtualPressureSourceData_Name = 2;
  var kPressureManager_AddClient_Name = 3;

  function PressureManagerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PressureManager,
                                                   handleOrPtrInfo);
  }

  function PressureManagerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PressureManager, associatedInterfacePtrInfo);
  }

  PressureManagerAssociatedPtr.prototype =
      Object.create(PressureManagerPtr.prototype);
  PressureManagerAssociatedPtr.prototype.constructor =
      PressureManagerAssociatedPtr;

  function PressureManagerProxy(receiver) {
    this.receiver_ = receiver;
  }
  PressureManagerPtr.prototype.addVirtualPressureSource = function() {
    return PressureManagerProxy.prototype.addVirtualPressureSource
        .apply(this.ptr.getProxy(), arguments);
  };

  PressureManagerProxy.prototype.addVirtualPressureSource = function(token, source, metadata) {
    var params_ = new PressureManager_AddVirtualPressureSource_Params();
    params_.token = token;
    params_.source = source;
    params_.metadata = metadata;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPressureManager_AddVirtualPressureSource_Name,
          codec.align(PressureManager_AddVirtualPressureSource_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PressureManager_AddVirtualPressureSource_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PressureManager_AddVirtualPressureSource_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PressureManagerPtr.prototype.removeVirtualPressureSource = function() {
    return PressureManagerProxy.prototype.removeVirtualPressureSource
        .apply(this.ptr.getProxy(), arguments);
  };

  PressureManagerProxy.prototype.removeVirtualPressureSource = function(token, source) {
    var params_ = new PressureManager_RemoveVirtualPressureSource_Params();
    params_.token = token;
    params_.source = source;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPressureManager_RemoveVirtualPressureSource_Name,
          codec.align(PressureManager_RemoveVirtualPressureSource_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PressureManager_RemoveVirtualPressureSource_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PressureManager_RemoveVirtualPressureSource_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PressureManagerPtr.prototype.updateVirtualPressureSourceData = function() {
    return PressureManagerProxy.prototype.updateVirtualPressureSourceData
        .apply(this.ptr.getProxy(), arguments);
  };

  PressureManagerProxy.prototype.updateVirtualPressureSourceData = function(token, source, state, ownContributionEstimate) {
    var params_ = new PressureManager_UpdateVirtualPressureSourceData_Params();
    params_.token = token;
    params_.source = source;
    params_.state = state;
    params_.ownContributionEstimate = ownContributionEstimate;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPressureManager_UpdateVirtualPressureSourceData_Name,
          codec.align(PressureManager_UpdateVirtualPressureSourceData_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PressureManager_UpdateVirtualPressureSourceData_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PressureManager_UpdateVirtualPressureSourceData_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PressureManagerPtr.prototype.addClient = function() {
    return PressureManagerProxy.prototype.addClient
        .apply(this.ptr.getProxy(), arguments);
  };

  PressureManagerProxy.prototype.addClient = function(source, token, client) {
    var params_ = new PressureManager_AddClient_Params();
    params_.source = source;
    params_.token = token;
    params_.client = client;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV2Builder(
          kPressureManager_AddClient_Name,
          codec.align(PressureManager_AddClient_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.setPayload(PressureManager_AddClient_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PressureManager_AddClient_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function PressureManagerStub(delegate) {
    this.delegate_ = delegate;
  }
  PressureManagerStub.prototype.addVirtualPressureSource = function(token, source, metadata) {
    return this.delegate_ && this.delegate_.addVirtualPressureSource && this.delegate_.addVirtualPressureSource(token, source, metadata);
  }
  PressureManagerStub.prototype.removeVirtualPressureSource = function(token, source) {
    return this.delegate_ && this.delegate_.removeVirtualPressureSource && this.delegate_.removeVirtualPressureSource(token, source);
  }
  PressureManagerStub.prototype.updateVirtualPressureSourceData = function(token, source, state, ownContributionEstimate) {
    return this.delegate_ && this.delegate_.updateVirtualPressureSourceData && this.delegate_.updateVirtualPressureSourceData(token, source, state, ownContributionEstimate);
  }
  PressureManagerStub.prototype.addClient = function(source, token, client) {
    return this.delegate_ && this.delegate_.addClient && this.delegate_.addClient(source, token, client);
  }

  PressureManagerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  PressureManagerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPressureManager_AddVirtualPressureSource_Name:
      var params = reader.decodeStruct(PressureManager_AddVirtualPressureSource_Params);
      this.addVirtualPressureSource(params.token, params.source, params.metadata).then(function(response) {
        var responseParams =
            new PressureManager_AddVirtualPressureSource_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kPressureManager_AddVirtualPressureSource_Name,
            codec.align(PressureManager_AddVirtualPressureSource_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PressureManager_AddVirtualPressureSource_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPressureManager_RemoveVirtualPressureSource_Name:
      var params = reader.decodeStruct(PressureManager_RemoveVirtualPressureSource_Params);
      this.removeVirtualPressureSource(params.token, params.source).then(function(response) {
        var responseParams =
            new PressureManager_RemoveVirtualPressureSource_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kPressureManager_RemoveVirtualPressureSource_Name,
            codec.align(PressureManager_RemoveVirtualPressureSource_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PressureManager_RemoveVirtualPressureSource_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPressureManager_UpdateVirtualPressureSourceData_Name:
      var params = reader.decodeStruct(PressureManager_UpdateVirtualPressureSourceData_Params);
      this.updateVirtualPressureSourceData(params.token, params.source, params.state, params.ownContributionEstimate).then(function(response) {
        var responseParams =
            new PressureManager_UpdateVirtualPressureSourceData_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kPressureManager_UpdateVirtualPressureSourceData_Name,
            codec.align(PressureManager_UpdateVirtualPressureSourceData_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PressureManager_UpdateVirtualPressureSourceData_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPressureManager_AddClient_Name:
      var params = reader.decodeStruct(PressureManager_AddClient_Params);
      this.addClient(params.source, params.token, params.client).then(function(response) {
        var responseParams =
            new PressureManager_AddClient_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV2Builder(
            kPressureManager_AddClient_Name,
            codec.align(PressureManager_AddClient_ResponseParams
                .encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.setPayload(PressureManager_AddClient_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validatePressureManagerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPressureManager_AddVirtualPressureSource_Name:
        if (message.expectsResponse())
          paramsClass = PressureManager_AddVirtualPressureSource_Params;
      break;
      case kPressureManager_RemoveVirtualPressureSource_Name:
        if (message.expectsResponse())
          paramsClass = PressureManager_RemoveVirtualPressureSource_Params;
      break;
      case kPressureManager_UpdateVirtualPressureSourceData_Name:
        if (message.expectsResponse())
          paramsClass = PressureManager_UpdateVirtualPressureSourceData_Params;
      break;
      case kPressureManager_AddClient_Name:
        if (message.expectsResponse())
          paramsClass = PressureManager_AddClient_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePressureManagerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kPressureManager_AddVirtualPressureSource_Name:
        if (message.isResponse())
          paramsClass = PressureManager_AddVirtualPressureSource_ResponseParams;
        break;
      case kPressureManager_RemoveVirtualPressureSource_Name:
        if (message.isResponse())
          paramsClass = PressureManager_RemoveVirtualPressureSource_ResponseParams;
        break;
      case kPressureManager_UpdateVirtualPressureSourceData_Name:
        if (message.isResponse())
          paramsClass = PressureManager_UpdateVirtualPressureSourceData_ResponseParams;
        break;
      case kPressureManager_AddClient_Name:
        if (message.isResponse())
          paramsClass = PressureManager_AddClient_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var PressureManager = {
    name: 'device.mojom.PressureManager',
    kVersion: 0,
    ptrClass: PressureManagerPtr,
    proxyClass: PressureManagerProxy,
    stubClass: PressureManagerStub,
    validateRequest: validatePressureManagerRequest,
    validateResponse: validatePressureManagerResponse,
  };
  PressureManagerStub.prototype.validator = validatePressureManagerRequest;
  PressureManagerProxy.prototype.validator = validatePressureManagerResponse;
  var kPressureClient_OnPressureUpdated_Name = 0;

  function PressureClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PressureClient,
                                                   handleOrPtrInfo);
  }

  function PressureClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PressureClient, associatedInterfacePtrInfo);
  }

  PressureClientAssociatedPtr.prototype =
      Object.create(PressureClientPtr.prototype);
  PressureClientAssociatedPtr.prototype.constructor =
      PressureClientAssociatedPtr;

  function PressureClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  PressureClientPtr.prototype.onPressureUpdated = function() {
    return PressureClientProxy.prototype.onPressureUpdated
        .apply(this.ptr.getProxy(), arguments);
  };

  PressureClientProxy.prototype.onPressureUpdated = function(update) {
    var params_ = new PressureClient_OnPressureUpdated_Params();
    params_.update = update;
    var builder = new codec.MessageV0Builder(
        kPressureClient_OnPressureUpdated_Name,
        codec.align(PressureClient_OnPressureUpdated_Params.encodedSize));
    builder.encodeStruct(PressureClient_OnPressureUpdated_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function PressureClientStub(delegate) {
    this.delegate_ = delegate;
  }
  PressureClientStub.prototype.onPressureUpdated = function(update) {
    return this.delegate_ && this.delegate_.onPressureUpdated && this.delegate_.onPressureUpdated(update);
  }

  PressureClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPressureClient_OnPressureUpdated_Name:
      var params = reader.decodeStruct(PressureClient_OnPressureUpdated_Params);
      this.onPressureUpdated(params.update);
      return true;
    default:
      return false;
    }
  };

  PressureClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validatePressureClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPressureClient_OnPressureUpdated_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PressureClient_OnPressureUpdated_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePressureClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var PressureClient = {
    name: 'device.mojom.PressureClient',
    kVersion: 0,
    ptrClass: PressureClientPtr,
    proxyClass: PressureClientProxy,
    stubClass: PressureClientStub,
    validateRequest: validatePressureClientRequest,
    validateResponse: null,
  };
  PressureClientStub.prototype.validator = validatePressureClientRequest;
  PressureClientProxy.prototype.validator = null;
  exports.PressureManagerAddClientResult = PressureManagerAddClientResult;
  exports.VirtualPressureSourceMetadata = VirtualPressureSourceMetadata;
  exports.PressureManager = PressureManager;
  exports.PressureManagerPtr = PressureManagerPtr;
  exports.PressureManagerAssociatedPtr = PressureManagerAssociatedPtr;
  exports.PressureClient = PressureClient;
  exports.PressureClientPtr = PressureClientPtr;
  exports.PressureClientAssociatedPtr = PressureClientAssociatedPtr;
})();