// services/device/public/mojom/power_monitor.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/power_monitor.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/power_monitor.mojom-params-data.h"
#include "services/device/public/mojom/power_monitor.mojom-shared-message-ids.h"

#include "services/device/public/mojom/power_monitor.mojom-import-headers.h"
#include "services/device/public/mojom/power_monitor.mojom-test-utils.h"


namespace device::mojom {
// The declaration includes the definition on other builds.

PowerMonitor::IPCStableHashFunction PowerMonitor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PowerMonitor>(message.name())) {
    case messages::PowerMonitor::kAddClient: {
      return &PowerMonitor::AddClient_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PowerMonitor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PowerMonitor>(message.name())) {
      case messages::PowerMonitor::kAddClient:
            return "Receive device::mojom::PowerMonitor::AddClient";
    }
  } else {
    switch (static_cast<messages::PowerMonitor>(message.name())) {
      case messages::PowerMonitor::kAddClient:
            return "Receive reply device::mojom::PowerMonitor::AddClient";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PowerMonitor::AddClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc826b648;  // IPCStableHash for device::mojom::PowerMonitor::AddClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PowerMonitorProxy::PowerMonitorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PowerMonitorProxy::AddClient(
    ::mojo::PendingRemote<PowerMonitorClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::PowerMonitor::AddClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<PowerMonitorClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PowerMonitor::kAddClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PowerMonitor_AddClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::PowerMonitorClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in PowerMonitor.AddClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PowerMonitor::Name_);
  message.set_method_name("AddClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PowerMonitorStubDispatch::Accept(
    PowerMonitor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PowerMonitor>(message->header()->name)) {
    case messages::PowerMonitor::kAddClient: {
      DCHECK(message->is_serialized());
      internal::PowerMonitor_AddClient_Params_Data* params =
          reinterpret_cast<internal::PowerMonitor_AddClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PowerMonitor.0
      bool success = true;
      ::mojo::PendingRemote<PowerMonitorClient> p_client{};
      PowerMonitor_AddClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PowerMonitor::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddClient(        
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool PowerMonitorStubDispatch::AcceptWithResponder(
    PowerMonitor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PowerMonitor>(message->header()->name)) {
    case messages::PowerMonitor::kAddClient: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPowerMonitorValidationInfo[] = {
    { &internal::PowerMonitor_AddClient_Params_Data::Validate,
     nullptr /* no response */},
};

bool PowerMonitorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::PowerMonitor::Name_,
    kPowerMonitorValidationInfo);
}

// The declaration includes the definition on other builds.

PowerMonitorClient::IPCStableHashFunction PowerMonitorClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PowerMonitorClient>(message.name())) {
    case messages::PowerMonitorClient::kPowerStateChange: {
      return &PowerMonitorClient::PowerStateChange_Sym::IPCStableHash;
    }
    case messages::PowerMonitorClient::kSuspend: {
      return &PowerMonitorClient::Suspend_Sym::IPCStableHash;
    }
    case messages::PowerMonitorClient::kResume: {
      return &PowerMonitorClient::Resume_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PowerMonitorClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PowerMonitorClient>(message.name())) {
      case messages::PowerMonitorClient::kPowerStateChange:
            return "Receive device::mojom::PowerMonitorClient::PowerStateChange";
      case messages::PowerMonitorClient::kSuspend:
            return "Receive device::mojom::PowerMonitorClient::Suspend";
      case messages::PowerMonitorClient::kResume:
            return "Receive device::mojom::PowerMonitorClient::Resume";
    }
  } else {
    switch (static_cast<messages::PowerMonitorClient>(message.name())) {
      case messages::PowerMonitorClient::kPowerStateChange:
            return "Receive reply device::mojom::PowerMonitorClient::PowerStateChange";
      case messages::PowerMonitorClient::kSuspend:
            return "Receive reply device::mojom::PowerMonitorClient::Suspend";
      case messages::PowerMonitorClient::kResume:
            return "Receive reply device::mojom::PowerMonitorClient::Resume";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PowerMonitorClient::PowerStateChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2e063adf;  // IPCStableHash for device::mojom::PowerMonitorClient::PowerStateChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PowerMonitorClient::Suspend_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf171ee8a;  // IPCStableHash for device::mojom::PowerMonitorClient::Suspend
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PowerMonitorClient::Resume_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xce1ec97a;  // IPCStableHash for device::mojom::PowerMonitorClient::Resume
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PowerMonitorClientProxy::PowerMonitorClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PowerMonitorClientProxy::PowerStateChange(
    ::base::PowerStateObserver::BatteryPowerStatus in_battery_power_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::PowerMonitorClient::PowerStateChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("battery_power_status"), in_battery_power_status,
                        "<value of type ::base::PowerStateObserver::BatteryPowerStatus>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PowerMonitorClient::kPowerStateChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PowerMonitorClient_PowerStateChange_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojo_base::mojom::BatteryPowerStatus>(
    in_battery_power_status,
    &params->battery_power_status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PowerMonitorClient::Name_);
  message.set_method_name("PowerStateChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PowerMonitorClientProxy::Suspend(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::PowerMonitorClient::Suspend");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PowerMonitorClient::kSuspend), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PowerMonitorClient_Suspend_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PowerMonitorClient::Name_);
  message.set_method_name("Suspend");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PowerMonitorClientProxy::Resume(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::PowerMonitorClient::Resume");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PowerMonitorClient::kResume), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PowerMonitorClient_Resume_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PowerMonitorClient::Name_);
  message.set_method_name("Resume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PowerMonitorClientStubDispatch::Accept(
    PowerMonitorClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PowerMonitorClient>(message->header()->name)) {
    case messages::PowerMonitorClient::kPowerStateChange: {
      DCHECK(message->is_serialized());
      internal::PowerMonitorClient_PowerStateChange_Params_Data* params =
          reinterpret_cast<internal::PowerMonitorClient_PowerStateChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PowerMonitorClient.0
      bool success = true;
      ::base::PowerStateObserver::BatteryPowerStatus p_battery_power_status{};
      PowerMonitorClient_PowerStateChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBatteryPowerStatus(&p_battery_power_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PowerMonitorClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PowerStateChange(        
        std::move(p_battery_power_status));
      return true;
    }
    case messages::PowerMonitorClient::kSuspend: {
      DCHECK(message->is_serialized());
      internal::PowerMonitorClient_Suspend_Params_Data* params =
          reinterpret_cast<internal::PowerMonitorClient_Suspend_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PowerMonitorClient.1
      bool success = true;
      PowerMonitorClient_Suspend_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PowerMonitorClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Suspend(        );
      return true;
    }
    case messages::PowerMonitorClient::kResume: {
      DCHECK(message->is_serialized());
      internal::PowerMonitorClient_Resume_Params_Data* params =
          reinterpret_cast<internal::PowerMonitorClient_Resume_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PowerMonitorClient.2
      bool success = true;
      PowerMonitorClient_Resume_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PowerMonitorClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Resume(        );
      return true;
    }
  }
  return false;
}

// static
bool PowerMonitorClientStubDispatch::AcceptWithResponder(
    PowerMonitorClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PowerMonitorClient>(message->header()->name)) {
    case messages::PowerMonitorClient::kPowerStateChange: {
      break;
    }
    case messages::PowerMonitorClient::kSuspend: {
      break;
    }
    case messages::PowerMonitorClient::kResume: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPowerMonitorClientValidationInfo[] = {
    { &internal::PowerMonitorClient_PowerStateChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PowerMonitorClient_Suspend_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PowerMonitorClient_Resume_Params_Data::Validate,
     nullptr /* no response */},
};

bool PowerMonitorClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::PowerMonitorClient::Name_,
    kPowerMonitorClientValidationInfo);
}



}  // device::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom {


void PowerMonitorInterceptorForTesting::AddClient(::mojo::PendingRemote<PowerMonitorClient> client) {
  GetForwardingInterface()->AddClient(
    std::move(client)
    );
}
PowerMonitorAsyncWaiter::PowerMonitorAsyncWaiter(
    PowerMonitor* proxy) : proxy_(proxy) {}

PowerMonitorAsyncWaiter::~PowerMonitorAsyncWaiter() = default;





void PowerMonitorClientInterceptorForTesting::PowerStateChange(::base::PowerStateObserver::BatteryPowerStatus battery_power_status) {
  GetForwardingInterface()->PowerStateChange(
    std::move(battery_power_status)
    );
}
void PowerMonitorClientInterceptorForTesting::Suspend() {
  GetForwardingInterface()->Suspend();
}
void PowerMonitorClientInterceptorForTesting::Resume() {
  GetForwardingInterface()->Resume();
}
PowerMonitorClientAsyncWaiter::PowerMonitorClientAsyncWaiter(
    PowerMonitorClient* proxy) : proxy_(proxy) {}

PowerMonitorClientAsyncWaiter::~PowerMonitorClientAsyncWaiter() = default;







}  // device::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif