// services/device/public/mojom/nfc.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_TEST_UTILS_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_TEST_UTILS_H_

#include "services/device/public/mojom/nfc.mojom.h"


namespace device::mojom {


class  NFCInterceptorForTesting : public NFC {
  virtual NFC* GetForwardingInterface() = 0;
  void SetClient(::mojo::PendingRemote<NFCClient> client) override;
  void Push(NDEFMessagePtr message, NDEFWriteOptionsPtr options, PushCallback callback) override;
  void CancelPush() override;
  void MakeReadOnly(MakeReadOnlyCallback callback) override;
  void CancelMakeReadOnly() override;
  void Watch(uint32_t id, WatchCallback callback) override;
  void CancelWatch(uint32_t id) override;
};
class  NFCAsyncWaiter {
 public:
  explicit NFCAsyncWaiter(NFC* proxy);

  NFCAsyncWaiter(const NFCAsyncWaiter&) = delete;
  NFCAsyncWaiter& operator=(const NFCAsyncWaiter&) = delete;

  ~NFCAsyncWaiter();
  void Push(
      NDEFMessagePtr message, NDEFWriteOptionsPtr options, NDEFErrorPtr* out_error);
  NDEFErrorPtr Push(NDEFMessagePtr message, NDEFWriteOptionsPtr options);
  void MakeReadOnly(
      NDEFErrorPtr* out_error);
  NDEFErrorPtr MakeReadOnly();
  void Watch(
      uint32_t id, NDEFErrorPtr* out_error);
  NDEFErrorPtr Watch(uint32_t id);

 private:
  NFC* const proxy_;
};


class  NFCClientInterceptorForTesting : public NFCClient {
  virtual NFCClient* GetForwardingInterface() = 0;
  void OnWatch(const std::vector<uint32_t>& watch_ids, const std::optional<std::string>& serial_number, NDEFMessagePtr message) override;
  void OnError(NDEFErrorPtr error) override;
};
class  NFCClientAsyncWaiter {
 public:
  explicit NFCClientAsyncWaiter(NFCClient* proxy);

  NFCClientAsyncWaiter(const NFCClientAsyncWaiter&) = delete;
  NFCClientAsyncWaiter& operator=(const NFCClientAsyncWaiter&) = delete;

  ~NFCClientAsyncWaiter();

 private:
  NFCClient* const proxy_;
};




}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_TEST_UTILS_H_