// services/device/public/mojom/nfc.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');





goog.provide('device.mojom.NDEFErrorType');
goog.provide('device.mojom.NDEFErrorTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.NDEFErrorTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.NDEFErrorType = {
  
  NOT_ALLOWED: 0,
  NOT_SUPPORTED: 1,
  NOT_READABLE: 2,
  INVALID_MESSAGE: 3,
  OPERATION_CANCELLED: 4,
  IO_ERROR: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

goog.provide('device.mojom.NDEFRecordTypeCategory');
goog.provide('device.mojom.NDEFRecordTypeCategorySpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.NDEFRecordTypeCategorySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.NDEFRecordTypeCategory = {
  
  kStandardized: 0,
  kExternal: 1,
  kLocal: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



goog.provide('device.mojom.NFC');
goog.provide('device.mojom.NFCReceiver');
goog.provide('device.mojom.NFCCallbackRouter');
goog.provide('device.mojom.NFCInterface');
goog.provide('device.mojom.NFCRemote');
goog.provide('device.mojom.NFCPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.NFCPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.NFC.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.NFCInterface = class {
  
  /**
   * @param { !device.mojom.NFCClientRemote } client
   */

  setClient(client) {}
  
  /**
   * @param { !device.mojom.NDEFMessage } message
   * @param { ?device.mojom.NDEFWriteOptions } options
   * @return {!Promise<{
        error: ?device.mojom.NDEFError,
   *  }>}
   */

  push(message, options) {}
  
  /**
   */

  cancelPush() {}
  
  /**
   * @return {!Promise<{
        error: ?device.mojom.NDEFError,
   *  }>}
   */

  makeReadOnly() {}
  
  /**
   */

  cancelMakeReadOnly() {}
  
  /**
   * @param { !number } id
   * @return {!Promise<{
        error: ?device.mojom.NDEFError,
   *  }>}
   */

  watch(id) {}
  
  /**
   * @param { !number } id
   */

  cancelWatch(id) {}
};

/**
 * @export
 * @implements { device.mojom.NFCInterface }
 */
device.mojom.NFCRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.NFCPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.NFCPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.NFCPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.NFCClientRemote } client
   */

  setClient(
      client) {
    this.proxy.sendMessage(
        0,
        device.mojom.NFC_SetClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.NDEFMessage } message
   * @param { ?device.mojom.NDEFWriteOptions } options
   * @return {!Promise<{
        error: ?device.mojom.NDEFError,
   *  }>}
   */

  push(
      message,
      options) {
    return this.proxy.sendMessage(
        1,
        device.mojom.NFC_Push_ParamsSpec.$,
        device.mojom.NFC_Push_ResponseParamsSpec.$,
        [
          message,
          options
        ],
        false);
  }

  
  /**
   */

  cancelPush() {
    this.proxy.sendMessage(
        2,
        device.mojom.NFC_CancelPush_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: ?device.mojom.NDEFError,
   *  }>}
   */

  makeReadOnly() {
    return this.proxy.sendMessage(
        3,
        device.mojom.NFC_MakeReadOnly_ParamsSpec.$,
        device.mojom.NFC_MakeReadOnly_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   */

  cancelMakeReadOnly() {
    this.proxy.sendMessage(
        4,
        device.mojom.NFC_CancelMakeReadOnly_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } id
   * @return {!Promise<{
        error: ?device.mojom.NDEFError,
   *  }>}
   */

  watch(
      id) {
    return this.proxy.sendMessage(
        5,
        device.mojom.NFC_Watch_ParamsSpec.$,
        device.mojom.NFC_Watch_ResponseParamsSpec.$,
        [
          id
        ],
        false);
  }

  
  /**
   * @param { !number } id
   */

  cancelWatch(
      id) {
    this.proxy.sendMessage(
        6,
        device.mojom.NFC_CancelWatch_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NFC
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.NFCReceiver = class {
  /**
   * @param {!device.mojom.NFCInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.NFCRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.NFCRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.NFCRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.NFC_SetClient_ParamsSpec.$,
        null,
        impl.setClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.NFC_Push_ParamsSpec.$,
        device.mojom.NFC_Push_ResponseParamsSpec.$,
        impl.push.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.NFC_CancelPush_ParamsSpec.$,
        null,
        impl.cancelPush.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        device.mojom.NFC_MakeReadOnly_ParamsSpec.$,
        device.mojom.NFC_MakeReadOnly_ResponseParamsSpec.$,
        impl.makeReadOnly.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        device.mojom.NFC_CancelMakeReadOnly_ParamsSpec.$,
        null,
        impl.cancelMakeReadOnly.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        device.mojom.NFC_Watch_ParamsSpec.$,
        device.mojom.NFC_Watch_ResponseParamsSpec.$,
        impl.watch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        device.mojom.NFC_CancelWatch_ParamsSpec.$,
        null,
        impl.cancelWatch.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.NFC = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.NFC";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.NFCRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.NFCRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the NFC
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.NFCCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.NFCRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.NFCRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.NFC_SetClient_ParamsSpec.$,
        null,
        this.setClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.push =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.NFC_Push_ParamsSpec.$,
        device.mojom.NFC_Push_ResponseParamsSpec.$,
        this.push.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelPush =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.NFC_CancelPush_ParamsSpec.$,
        null,
        this.cancelPush.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.makeReadOnly =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        device.mojom.NFC_MakeReadOnly_ParamsSpec.$,
        device.mojom.NFC_MakeReadOnly_ResponseParamsSpec.$,
        this.makeReadOnly.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelMakeReadOnly =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        device.mojom.NFC_CancelMakeReadOnly_ParamsSpec.$,
        null,
        this.cancelMakeReadOnly.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.watch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        device.mojom.NFC_Watch_ParamsSpec.$,
        device.mojom.NFC_Watch_ResponseParamsSpec.$,
        this.watch.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelWatch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        device.mojom.NFC_CancelWatch_ParamsSpec.$,
        null,
        this.cancelWatch.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.NFCClient');
goog.provide('device.mojom.NFCClientReceiver');
goog.provide('device.mojom.NFCClientCallbackRouter');
goog.provide('device.mojom.NFCClientInterface');
goog.provide('device.mojom.NFCClientRemote');
goog.provide('device.mojom.NFCClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.NFCClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.NFCClient.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.NFCClientInterface = class {
  
  /**
   * @param { !Array<!number> } watchIds
   * @param { ?string } serialNumber
   * @param { !device.mojom.NDEFMessage } message
   */

  onWatch(watchIds, serialNumber, message) {}
  
  /**
   * @param { !device.mojom.NDEFError } error
   */

  onError(error) {}
};

/**
 * @export
 * @implements { device.mojom.NFCClientInterface }
 */
device.mojom.NFCClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.NFCClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.NFCClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.NFCClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!number> } watchIds
   * @param { ?string } serialNumber
   * @param { !device.mojom.NDEFMessage } message
   */

  onWatch(
      watchIds,
      serialNumber,
      message) {
    this.proxy.sendMessage(
        0,
        device.mojom.NFCClient_OnWatch_ParamsSpec.$,
        null,
        [
          watchIds,
          serialNumber,
          message
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.NDEFError } error
   */

  onError(
      error) {
    this.proxy.sendMessage(
        1,
        device.mojom.NFCClient_OnError_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NFCClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.NFCClientReceiver = class {
  /**
   * @param {!device.mojom.NFCClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.NFCClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.NFCClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.NFCClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.NFCClient_OnWatch_ParamsSpec.$,
        null,
        impl.onWatch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.NFCClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.NFCClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.NFCClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.NFCClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.NFCClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the NFCClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.NFCClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.NFCClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.NFCClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWatch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.NFCClient_OnWatch_ParamsSpec.$,
        null,
        this.onWatch.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.NFCClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.NDEFErrorSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NDEFErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.NDEFRecordSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NDEFRecordSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.NDEFMessageSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NDEFMessageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.NDEFWriteOptionsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NDEFWriteOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.NFC_SetClient_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NFC_SetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.NFC_Push_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NFC_Push_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.NFC_Push_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NFC_Push_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.NFC_CancelPush_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NFC_CancelPush_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.NFC_MakeReadOnly_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NFC_MakeReadOnly_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.NFC_MakeReadOnly_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NFC_MakeReadOnly_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.NFC_CancelMakeReadOnly_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NFC_CancelMakeReadOnly_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.NFC_Watch_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NFC_Watch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.NFC_Watch_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NFC_Watch_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.NFC_CancelWatch_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NFC_CancelWatch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.NFCClient_OnWatch_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NFCClient_OnWatch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.NFCClient_OnError_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.NFCClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.NDEFErrorSpec.$,
    'NDEFError',
    [
      mojo.internal.StructField(
        'errorType', 0,
        0,
        device.mojom.NDEFErrorTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.NDEFError');

/** @record */
device.mojom.NDEFError = class {
  constructor() {
    /** @export { !device.mojom.NDEFErrorType } */
    this.errorType;
    /** @export { !string } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    device.mojom.NDEFRecordSpec.$,
    'NDEFRecord',
    [
      mojo.internal.StructField(
        'category', 0,
        0,
        device.mojom.NDEFRecordTypeCategorySpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'recordType', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mediaType', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'id', 24,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'encoding', 32,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'lang', 40,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 48,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'payloadMessage', 56,
        0,
        device.mojom.NDEFMessageSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 72],]);



goog.provide('device.mojom.NDEFRecord');

/** @record */
device.mojom.NDEFRecord = class {
  constructor() {
    /** @export { !device.mojom.NDEFRecordTypeCategory } */
    this.category;
    /** @export { !string } */
    this.recordType;
    /** @export { (string|undefined) } */
    this.mediaType;
    /** @export { (string|undefined) } */
    this.id;
    /** @export { (string|undefined) } */
    this.encoding;
    /** @export { (string|undefined) } */
    this.lang;
    /** @export { !Array<!number> } */
    this.data;
    /** @export { (device.mojom.NDEFMessage|undefined) } */
    this.payloadMessage;
  }
};



mojo.internal.Struct(
    device.mojom.NDEFMessageSpec.$,
    'NDEFMessage',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojo.internal.Array(device.mojom.NDEFRecordSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.NDEFMessage');

/** @record */
device.mojom.NDEFMessage = class {
  constructor() {
    /** @export { !Array<!device.mojom.NDEFRecord> } */
    this.data;
  }
};



mojo.internal.Struct(
    device.mojom.NDEFWriteOptionsSpec.$,
    'NDEFWriteOptions',
    [
      mojo.internal.StructField(
        'overwrite', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.NDEFWriteOptions');

/** @record */
device.mojom.NDEFWriteOptions = class {
  constructor() {
    /** @export { !boolean } */
    this.overwrite;
  }
};



mojo.internal.Struct(
    device.mojom.NFC_SetClient_ParamsSpec.$,
    'NFC_SetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(device.mojom.NFCClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.NFC_SetClient_Params');

/** @record */
device.mojom.NFC_SetClient_Params = class {
  constructor() {
    /** @export { !device.mojom.NFCClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    device.mojom.NFC_Push_ParamsSpec.$,
    'NFC_Push_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        device.mojom.NDEFMessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        device.mojom.NDEFWriteOptionsSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.NFC_Push_Params');

/** @record */
device.mojom.NFC_Push_Params = class {
  constructor() {
    /** @export { !device.mojom.NDEFMessage } */
    this.message;
    /** @export { (device.mojom.NDEFWriteOptions|undefined) } */
    this.options;
  }
};



mojo.internal.Struct(
    device.mojom.NFC_Push_ResponseParamsSpec.$,
    'NFC_Push_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        device.mojom.NDEFErrorSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.NFC_Push_ResponseParams');

/** @record */
device.mojom.NFC_Push_ResponseParams = class {
  constructor() {
    /** @export { (device.mojom.NDEFError|undefined) } */
    this.error;
  }
};



mojo.internal.Struct(
    device.mojom.NFC_CancelPush_ParamsSpec.$,
    'NFC_CancelPush_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.NFC_CancelPush_Params');

/** @record */
device.mojom.NFC_CancelPush_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.NFC_MakeReadOnly_ParamsSpec.$,
    'NFC_MakeReadOnly_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.NFC_MakeReadOnly_Params');

/** @record */
device.mojom.NFC_MakeReadOnly_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.NFC_MakeReadOnly_ResponseParamsSpec.$,
    'NFC_MakeReadOnly_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        device.mojom.NDEFErrorSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.NFC_MakeReadOnly_ResponseParams');

/** @record */
device.mojom.NFC_MakeReadOnly_ResponseParams = class {
  constructor() {
    /** @export { (device.mojom.NDEFError|undefined) } */
    this.error;
  }
};



mojo.internal.Struct(
    device.mojom.NFC_CancelMakeReadOnly_ParamsSpec.$,
    'NFC_CancelMakeReadOnly_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.NFC_CancelMakeReadOnly_Params');

/** @record */
device.mojom.NFC_CancelMakeReadOnly_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.NFC_Watch_ParamsSpec.$,
    'NFC_Watch_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.NFC_Watch_Params');

/** @record */
device.mojom.NFC_Watch_Params = class {
  constructor() {
    /** @export { !number } */
    this.id;
  }
};



mojo.internal.Struct(
    device.mojom.NFC_Watch_ResponseParamsSpec.$,
    'NFC_Watch_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        device.mojom.NDEFErrorSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.NFC_Watch_ResponseParams');

/** @record */
device.mojom.NFC_Watch_ResponseParams = class {
  constructor() {
    /** @export { (device.mojom.NDEFError|undefined) } */
    this.error;
  }
};



mojo.internal.Struct(
    device.mojom.NFC_CancelWatch_ParamsSpec.$,
    'NFC_CancelWatch_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.NFC_CancelWatch_Params');

/** @record */
device.mojom.NFC_CancelWatch_Params = class {
  constructor() {
    /** @export { !number } */
    this.id;
  }
};



mojo.internal.Struct(
    device.mojom.NFCClient_OnWatch_ParamsSpec.$,
    'NFCClient_OnWatch_Params',
    [
      mojo.internal.StructField(
        'watchIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serialNumber', 8,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 16,
        0,
        device.mojom.NDEFMessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('device.mojom.NFCClient_OnWatch_Params');

/** @record */
device.mojom.NFCClient_OnWatch_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.watchIds;
    /** @export { (string|undefined) } */
    this.serialNumber;
    /** @export { !device.mojom.NDEFMessage } */
    this.message;
  }
};



mojo.internal.Struct(
    device.mojom.NFCClient_OnError_ParamsSpec.$,
    'NFCClient_OnError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        device.mojom.NDEFErrorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.NFCClient_OnError_Params');

/** @record */
device.mojom.NFCClient_OnError_Params = class {
  constructor() {
    /** @export { !device.mojom.NDEFError } */
    this.error;
  }
};

