// services/device/public/mojom/input_service.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_INPUT_SERVICE_MOJOM_SEND_VALIDATION_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_INPUT_SERVICE_MOJOM_SEND_VALIDATION_H_

#include "services/device/public/mojom/input_service.mojom-shared-internal.h"

#include "services/device/public/mojom/input_service.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::InputDeviceSubsystem, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::InputDeviceType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::InputDeviceInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::InputDeviceInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::InputDeviceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in InputDeviceInfo struct");

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in InputDeviceInfo struct");

      
      mojo::internal::Serialize<::device::mojom::InputDeviceSubsystem>(
        Traits::subsystem(input),
        &fragment->subsystem);

      
      mojo::internal::Serialize<::device::mojom::InputDeviceType>(
        Traits::type(input),
        &fragment->type);

      fragment->is_accelerometer = Traits::is_accelerometer(input);

      fragment->is_joystick = Traits::is_joystick(input);

      fragment->is_key = Traits::is_key(input);

      fragment->is_keyboard = Traits::is_keyboard(input);

      fragment->is_mouse = Traits::is_mouse(input);

      fragment->is_tablet = Traits::is_tablet(input);

      fragment->is_touchpad = Traits::is_touchpad(input);

      fragment->is_touchscreen = Traits::is_touchscreen(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_INPUT_SERVICE_MOJOM_SEND_VALIDATION_H_