// services/device/public/mojom/input_service.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('device.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.InputDeviceSubsystemSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.InputDeviceSubsystem = {
  
  SUBSYSTEM_HID: 0,
  SUBSYSTEM_INPUT: 1,
  SUBSYSTEM_UNKNOWN: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.InputDeviceTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.InputDeviceType = {
  
  TYPE_BLUETOOTH: 0,
  TYPE_USB: 1,
  TYPE_SERIO: 2,
  TYPE_UNKNOWN: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.InputDeviceManagerClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.InputDeviceManagerClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { device.mojom.InputDeviceManagerClientInterface }
 */
device.mojom.InputDeviceManagerClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.InputDeviceManagerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.InputDeviceManagerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.InputDeviceManagerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.InputDeviceInfo } deviceInfo
   */

  inputDeviceAdded(
      deviceInfo) {
    this.proxy.sendMessage(
        0,
        device.mojom.InputDeviceManagerClient_InputDeviceAdded_ParamsSpec.$,
        null,
        [
          deviceInfo
        ],
        false);
  }

  
  /**
   * @param { !string } id
   */

  inputDeviceRemoved(
      id) {
    this.proxy.sendMessage(
        1,
        device.mojom.InputDeviceManagerClient_InputDeviceRemoved_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }
};

/**
 * An object which receives request messages for the InputDeviceManagerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.InputDeviceManagerClientReceiver = class {
  /**
   * @param {!device.mojom.InputDeviceManagerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.InputDeviceManagerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.InputDeviceManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.InputDeviceManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.InputDeviceManagerClient_InputDeviceAdded_ParamsSpec.$,
        null,
        impl.inputDeviceAdded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.InputDeviceManagerClient_InputDeviceRemoved_ParamsSpec.$,
        null,
        impl.inputDeviceRemoved.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.InputDeviceManagerClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.InputDeviceManagerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.InputDeviceManagerClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.InputDeviceManagerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the InputDeviceManagerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.InputDeviceManagerClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.InputDeviceManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.InputDeviceManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.inputDeviceAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.InputDeviceManagerClient_InputDeviceAdded_ParamsSpec.$,
        null,
        this.inputDeviceAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.inputDeviceRemoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.InputDeviceManagerClient_InputDeviceRemoved_ParamsSpec.$,
        null,
        this.inputDeviceRemoved.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.InputDeviceManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.InputDeviceManager.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { device.mojom.InputDeviceManagerInterface }
 */
device.mojom.InputDeviceManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.InputDeviceManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.InputDeviceManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.InputDeviceManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } client
   * @return {!Promise<{
        devices: !Array<!device.mojom.InputDeviceInfo>,
   *  }>}
   */

  getDevicesAndSetClient(
      client) {
    return this.proxy.sendMessage(
        0,
        device.mojom.InputDeviceManager_GetDevicesAndSetClient_ParamsSpec.$,
        device.mojom.InputDeviceManager_GetDevicesAndSetClient_ResponseParamsSpec.$,
        [
          client
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        devices: !Array<!device.mojom.InputDeviceInfo>,
   *  }>}
   */

  getDevices() {
    return this.proxy.sendMessage(
        1,
        device.mojom.InputDeviceManager_GetDevices_ParamsSpec.$,
        device.mojom.InputDeviceManager_GetDevices_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the InputDeviceManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.InputDeviceManagerReceiver = class {
  /**
   * @param {!device.mojom.InputDeviceManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.InputDeviceManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.InputDeviceManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.InputDeviceManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.InputDeviceManager_GetDevicesAndSetClient_ParamsSpec.$,
        device.mojom.InputDeviceManager_GetDevicesAndSetClient_ResponseParamsSpec.$,
        impl.getDevicesAndSetClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.InputDeviceManager_GetDevices_ParamsSpec.$,
        device.mojom.InputDeviceManager_GetDevices_ResponseParamsSpec.$,
        impl.getDevices.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.InputDeviceManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.InputDeviceManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.InputDeviceManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.InputDeviceManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the InputDeviceManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.InputDeviceManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.InputDeviceManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.InputDeviceManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDevicesAndSetClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.InputDeviceManager_GetDevicesAndSetClient_ParamsSpec.$,
        device.mojom.InputDeviceManager_GetDevicesAndSetClient_ResponseParamsSpec.$,
        this.getDevicesAndSetClient.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDevices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.InputDeviceManager_GetDevices_ParamsSpec.$,
        device.mojom.InputDeviceManager_GetDevices_ResponseParamsSpec.$,
        this.getDevices.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.InputDeviceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.InputDeviceManagerClient_InputDeviceAdded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.InputDeviceManagerClient_InputDeviceRemoved_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.InputDeviceManager_GetDevicesAndSetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.InputDeviceManager_GetDevicesAndSetClient_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.InputDeviceManager_GetDevices_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.InputDeviceManager_GetDevices_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.InputDeviceInfoSpec.$,
    'InputDeviceInfo',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subsystem', 16,
        0,
        device.mojom.InputDeviceSubsystemSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 20,
        0,
        device.mojom.InputDeviceTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isAccelerometer', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isJoystick', 24,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isKey', 24,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isKeyboard', 24,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isMouse', 24,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isTablet', 24,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isTouchpad', 24,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isTouchscreen', 24,
        7,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
device.mojom.InputDeviceInfo = class {
  constructor() {
    /** @export { !string } */
    this.id;
    /** @export { !string } */
    this.name;
    /** @export { !device.mojom.InputDeviceSubsystem } */
    this.subsystem;
    /** @export { !device.mojom.InputDeviceType } */
    this.type;
    /** @export { !boolean } */
    this.isAccelerometer;
    /** @export { !boolean } */
    this.isJoystick;
    /** @export { !boolean } */
    this.isKey;
    /** @export { !boolean } */
    this.isKeyboard;
    /** @export { !boolean } */
    this.isMouse;
    /** @export { !boolean } */
    this.isTablet;
    /** @export { !boolean } */
    this.isTouchpad;
    /** @export { !boolean } */
    this.isTouchscreen;
  }
};



mojo.internal.Struct(
    device.mojom.InputDeviceManagerClient_InputDeviceAdded_ParamsSpec.$,
    'InputDeviceManagerClient_InputDeviceAdded_Params',
    [
      mojo.internal.StructField(
        'deviceInfo', 0,
        0,
        device.mojom.InputDeviceInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.InputDeviceManagerClient_InputDeviceAdded_Params = class {
  constructor() {
    /** @export { !device.mojom.InputDeviceInfo } */
    this.deviceInfo;
  }
};



mojo.internal.Struct(
    device.mojom.InputDeviceManagerClient_InputDeviceRemoved_ParamsSpec.$,
    'InputDeviceManagerClient_InputDeviceRemoved_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.InputDeviceManagerClient_InputDeviceRemoved_Params = class {
  constructor() {
    /** @export { !string } */
    this.id;
  }
};



mojo.internal.Struct(
    device.mojom.InputDeviceManager_GetDevicesAndSetClient_ParamsSpec.$,
    'InputDeviceManager_GetDevicesAndSetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(device.mojom.InputDeviceManagerClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.InputDeviceManager_GetDevicesAndSetClient_Params = class {
  constructor() {
    /** @export { !Object } */
    this.client;
  }
};



mojo.internal.Struct(
    device.mojom.InputDeviceManager_GetDevicesAndSetClient_ResponseParamsSpec.$,
    'InputDeviceManager_GetDevicesAndSetClient_ResponseParams',
    [
      mojo.internal.StructField(
        'devices', 0,
        0,
        mojo.internal.Array(device.mojom.InputDeviceInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.InputDeviceManager_GetDevicesAndSetClient_ResponseParams = class {
  constructor() {
    /** @export { !Array<!device.mojom.InputDeviceInfo> } */
    this.devices;
  }
};



mojo.internal.Struct(
    device.mojom.InputDeviceManager_GetDevices_ParamsSpec.$,
    'InputDeviceManager_GetDevices_Params',
    [
    ],
    [[0, 8],]);





/** @record */
device.mojom.InputDeviceManager_GetDevices_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.InputDeviceManager_GetDevices_ResponseParamsSpec.$,
    'InputDeviceManager_GetDevices_ResponseParams',
    [
      mojo.internal.StructField(
        'devices', 0,
        0,
        mojo.internal.Array(device.mojom.InputDeviceInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
device.mojom.InputDeviceManager_GetDevices_ResponseParams = class {
  constructor() {
    /** @export { !Array<!device.mojom.InputDeviceInfo> } */
    this.devices;
  }
};

