// services/device/public/mojom/hid.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_TEST_UTILS_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_TEST_UTILS_H_

#include "services/device/public/mojom/hid.mojom.h"


namespace device::mojom {


class  HidManagerClientInterceptorForTesting : public HidManagerClient {
  virtual HidManagerClient* GetForwardingInterface() = 0;
  void DeviceAdded(HidDeviceInfoPtr device_info) override;
  void DeviceRemoved(HidDeviceInfoPtr device_info) override;
  void DeviceChanged(HidDeviceInfoPtr device_info) override;
};
class  HidManagerClientAsyncWaiter {
 public:
  explicit HidManagerClientAsyncWaiter(HidManagerClient* proxy);

  HidManagerClientAsyncWaiter(const HidManagerClientAsyncWaiter&) = delete;
  HidManagerClientAsyncWaiter& operator=(const HidManagerClientAsyncWaiter&) = delete;

  ~HidManagerClientAsyncWaiter();

 private:
  HidManagerClient* const proxy_;
};


class  HidManagerInterceptorForTesting : public HidManager {
  virtual HidManager* GetForwardingInterface() = 0;
  void GetDevicesAndSetClient(::mojo::PendingAssociatedRemote<HidManagerClient> client, GetDevicesAndSetClientCallback callback) override;
  void GetDevices(GetDevicesCallback callback) override;
  void Connect(const std::string& device_guid, ::mojo::PendingRemote<HidConnectionClient> connection_client, ::mojo::PendingRemote<HidConnectionWatcher> watcher, bool allow_protected_reports, bool allow_fido_reports, ConnectCallback callback) override;
  void AddReceiver(::mojo::PendingReceiver<HidManager> receiver) override;
};
class  HidManagerAsyncWaiter {
 public:
  explicit HidManagerAsyncWaiter(HidManager* proxy);

  HidManagerAsyncWaiter(const HidManagerAsyncWaiter&) = delete;
  HidManagerAsyncWaiter& operator=(const HidManagerAsyncWaiter&) = delete;

  ~HidManagerAsyncWaiter();
  void GetDevicesAndSetClient(
      ::mojo::PendingAssociatedRemote<HidManagerClient> client, std::vector<HidDeviceInfoPtr>* out_devices);
  std::vector<HidDeviceInfoPtr> GetDevicesAndSetClient(::mojo::PendingAssociatedRemote<HidManagerClient> client);
  void GetDevices(
      std::vector<HidDeviceInfoPtr>* out_devices);
  std::vector<HidDeviceInfoPtr> GetDevices();
  void Connect(
      const std::string& device_guid, ::mojo::PendingRemote<HidConnectionClient> connection_client, ::mojo::PendingRemote<HidConnectionWatcher> watcher, bool allow_protected_reports, bool allow_fido_reports, ::mojo::PendingRemote<HidConnection>* out_connection);
  ::mojo::PendingRemote<HidConnection> Connect(const std::string& device_guid, ::mojo::PendingRemote<HidConnectionClient> connection_client, ::mojo::PendingRemote<HidConnectionWatcher> watcher, bool allow_protected_reports, bool allow_fido_reports);

 private:
  HidManager* const proxy_;
};


class  HidConnectionInterceptorForTesting : public HidConnection {
  virtual HidConnection* GetForwardingInterface() = 0;
  void Read(ReadCallback callback) override;
  void Write(uint8_t report_id, const std::vector<uint8_t>& buffer, WriteCallback callback) override;
  void GetFeatureReport(uint8_t report_id, GetFeatureReportCallback callback) override;
  void SendFeatureReport(uint8_t report_id, const std::vector<uint8_t>& buffer, SendFeatureReportCallback callback) override;
};
class  HidConnectionAsyncWaiter {
 public:
  explicit HidConnectionAsyncWaiter(HidConnection* proxy);

  HidConnectionAsyncWaiter(const HidConnectionAsyncWaiter&) = delete;
  HidConnectionAsyncWaiter& operator=(const HidConnectionAsyncWaiter&) = delete;

  ~HidConnectionAsyncWaiter();
  void Read(
      bool* out_success, uint8_t* out_report_id, std::optional<std::vector<uint8_t>>* out_buffer);
  
  void Write(
      uint8_t report_id, const std::vector<uint8_t>& buffer, bool* out_success);
  bool Write(uint8_t report_id, const std::vector<uint8_t>& buffer);
  void GetFeatureReport(
      uint8_t report_id, bool* out_success, std::optional<std::vector<uint8_t>>* out_buffer);
  
  void SendFeatureReport(
      uint8_t report_id, const std::vector<uint8_t>& buffer, bool* out_success);
  bool SendFeatureReport(uint8_t report_id, const std::vector<uint8_t>& buffer);

 private:
  HidConnection* const proxy_;
};


class  HidConnectionClientInterceptorForTesting : public HidConnectionClient {
  virtual HidConnectionClient* GetForwardingInterface() = 0;
  void OnInputReport(uint8_t report_id, const std::vector<uint8_t>& buffer) override;
};
class  HidConnectionClientAsyncWaiter {
 public:
  explicit HidConnectionClientAsyncWaiter(HidConnectionClient* proxy);

  HidConnectionClientAsyncWaiter(const HidConnectionClientAsyncWaiter&) = delete;
  HidConnectionClientAsyncWaiter& operator=(const HidConnectionClientAsyncWaiter&) = delete;

  ~HidConnectionClientAsyncWaiter();

 private:
  HidConnectionClient* const proxy_;
};


class  HidConnectionWatcherInterceptorForTesting : public HidConnectionWatcher {
  virtual HidConnectionWatcher* GetForwardingInterface() = 0;
};
class  HidConnectionWatcherAsyncWaiter {
 public:
  explicit HidConnectionWatcherAsyncWaiter(HidConnectionWatcher* proxy);

  HidConnectionWatcherAsyncWaiter(const HidConnectionWatcherAsyncWaiter&) = delete;
  HidConnectionWatcherAsyncWaiter& operator=(const HidConnectionWatcherAsyncWaiter&) = delete;

  ~HidConnectionWatcherAsyncWaiter();

 private:
  HidConnectionWatcher* const proxy_;
};




}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_TEST_UTILS_H_