// services/device/public/mojom/hid.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_SHARED_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/hid.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/device/public/mojom/hid.mojom-data-view.h"




namespace std {

template <>
struct hash<::device::mojom::HidBusType>
    : public mojo::internal::EnumHashImpl<::device::mojom::HidBusType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::HidBusType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::HidBusType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::HidBusType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::HidUsageAndPageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::HidUsageAndPageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::HidUsageAndPage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->usage = Traits::usage(input);

    fragment->usage_page = Traits::usage_page(input);
  }

  static bool Deserialize(::device::mojom::internal::HidUsageAndPage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::HidUsageAndPageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::HidReportItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::HidReportItemDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::HidReportItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->is_range = Traits::is_range(input);

    fragment->is_constant = Traits::is_constant(input);

    fragment->is_variable = Traits::is_variable(input);

    fragment->is_relative = Traits::is_relative(input);

    fragment->wrap = Traits::wrap(input);

    fragment->is_non_linear = Traits::is_non_linear(input);

    fragment->no_preferred_state = Traits::no_preferred_state(input);

    fragment->has_null_position = Traits::has_null_position(input);

    fragment->is_volatile = Traits::is_volatile(input);

    fragment->is_buffered_bytes = Traits::is_buffered_bytes(input);

    decltype(Traits::usages(input)) in_usages = Traits::usages(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->usages)::BaseType>
        usages_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& usages_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidUsageAndPageDataView>>(
      in_usages,
      usages_fragment,
      &usages_validate_params);

    fragment->usages.Set(
        usages_fragment.is_null() ? nullptr : usages_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->usages.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null usages in HidReportItem struct");

    decltype(Traits::usage_minimum(input)) in_usage_minimum = Traits::usage_minimum(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->usage_minimum)::BaseType> usage_minimum_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::HidUsageAndPageDataView>(
      in_usage_minimum,
      usage_minimum_fragment);

    fragment->usage_minimum.Set(
        usage_minimum_fragment.is_null() ? nullptr : usage_minimum_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->usage_minimum.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null usage_minimum in HidReportItem struct");

    decltype(Traits::usage_maximum(input)) in_usage_maximum = Traits::usage_maximum(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->usage_maximum)::BaseType> usage_maximum_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::HidUsageAndPageDataView>(
      in_usage_maximum,
      usage_maximum_fragment);

    fragment->usage_maximum.Set(
        usage_maximum_fragment.is_null() ? nullptr : usage_maximum_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->usage_maximum.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null usage_maximum in HidReportItem struct");

    fragment->designator_minimum = Traits::designator_minimum(input);

    fragment->designator_maximum = Traits::designator_maximum(input);

    fragment->string_minimum = Traits::string_minimum(input);

    fragment->string_maximum = Traits::string_maximum(input);

    fragment->logical_minimum = Traits::logical_minimum(input);

    fragment->logical_maximum = Traits::logical_maximum(input);

    fragment->physical_minimum = Traits::physical_minimum(input);

    fragment->physical_maximum = Traits::physical_maximum(input);

    fragment->unit_exponent = Traits::unit_exponent(input);

    fragment->unit = Traits::unit(input);

    fragment->report_size = Traits::report_size(input);

    fragment->report_count = Traits::report_count(input);
  }

  static bool Deserialize(::device::mojom::internal::HidReportItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::HidReportItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::HidReportDescriptionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::HidReportDescriptionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::HidReportDescription_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->report_id = Traits::report_id(input);

    decltype(Traits::items(input)) in_items = Traits::items(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->items)::BaseType>
        items_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidReportItemDataView>>(
      in_items,
      items_fragment,
      &items_validate_params);

    fragment->items.Set(
        items_fragment.is_null() ? nullptr : items_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->items.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null items in HidReportDescription struct");
  }

  static bool Deserialize(::device::mojom::internal::HidReportDescription_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::HidReportDescriptionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::HidCollectionInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::HidCollectionInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::HidCollectionInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::usage(input)) in_usage = Traits::usage(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->usage)::BaseType> usage_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::HidUsageAndPageDataView>(
      in_usage,
      usage_fragment);

    fragment->usage.Set(
        usage_fragment.is_null() ? nullptr : usage_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->usage.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null usage in HidCollectionInfo struct");

    decltype(Traits::report_ids(input)) in_report_ids = Traits::report_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->report_ids)::BaseType>
        report_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& report_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_report_ids,
      report_ids_fragment,
      &report_ids_validate_params);

    fragment->report_ids.Set(
        report_ids_fragment.is_null() ? nullptr : report_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->report_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null report_ids in HidCollectionInfo struct");

    fragment->collection_type = Traits::collection_type(input);

    decltype(Traits::input_reports(input)) in_input_reports = Traits::input_reports(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_reports)::BaseType>
        input_reports_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& input_reports_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidReportDescriptionDataView>>(
      in_input_reports,
      input_reports_fragment,
      &input_reports_validate_params);

    fragment->input_reports.Set(
        input_reports_fragment.is_null() ? nullptr : input_reports_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_reports.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_reports in HidCollectionInfo struct");

    decltype(Traits::output_reports(input)) in_output_reports = Traits::output_reports(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->output_reports)::BaseType>
        output_reports_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& output_reports_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidReportDescriptionDataView>>(
      in_output_reports,
      output_reports_fragment,
      &output_reports_validate_params);

    fragment->output_reports.Set(
        output_reports_fragment.is_null() ? nullptr : output_reports_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->output_reports.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null output_reports in HidCollectionInfo struct");

    decltype(Traits::feature_reports(input)) in_feature_reports = Traits::feature_reports(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->feature_reports)::BaseType>
        feature_reports_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& feature_reports_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidReportDescriptionDataView>>(
      in_feature_reports,
      feature_reports_fragment,
      &feature_reports_validate_params);

    fragment->feature_reports.Set(
        feature_reports_fragment.is_null() ? nullptr : feature_reports_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->feature_reports.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null feature_reports in HidCollectionInfo struct");

    decltype(Traits::children(input)) in_children = Traits::children(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->children)::BaseType>
        children_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidCollectionInfoDataView>>(
      in_children,
      children_fragment,
      &children_validate_params);

    fragment->children.Set(
        children_fragment.is_null() ? nullptr : children_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->children.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null children in HidCollectionInfo struct");
  }

  static bool Deserialize(::device::mojom::internal::HidCollectionInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::HidCollectionInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::HidDeviceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::HidDeviceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::HidDeviceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::guid(input)) in_guid = Traits::guid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->guid)::BaseType> guid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_guid,
      guid_fragment);

    fragment->guid.Set(
        guid_fragment.is_null() ? nullptr : guid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->guid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null guid in HidDeviceInfo struct");

    decltype(Traits::physical_device_id(input)) in_physical_device_id = Traits::physical_device_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->physical_device_id)::BaseType> physical_device_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_physical_device_id,
      physical_device_id_fragment);

    fragment->physical_device_id.Set(
        physical_device_id_fragment.is_null() ? nullptr : physical_device_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->physical_device_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null physical_device_id in HidDeviceInfo struct");

    fragment->vendor_id = Traits::vendor_id(input);

    fragment->product_id = Traits::product_id(input);

    decltype(Traits::product_name(input)) in_product_name = Traits::product_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->product_name)::BaseType> product_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_product_name,
      product_name_fragment);

    fragment->product_name.Set(
        product_name_fragment.is_null() ? nullptr : product_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->product_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null product_name in HidDeviceInfo struct");

    decltype(Traits::serial_number(input)) in_serial_number = Traits::serial_number(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->serial_number)::BaseType> serial_number_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_serial_number,
      serial_number_fragment);

    fragment->serial_number.Set(
        serial_number_fragment.is_null() ? nullptr : serial_number_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->serial_number.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null serial_number in HidDeviceInfo struct");

    
    mojo::internal::Serialize<::device::mojom::HidBusType>(
      Traits::bus_type(input),
      &fragment->bus_type);

    decltype(Traits::report_descriptor(input)) in_report_descriptor = Traits::report_descriptor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->report_descriptor)::BaseType>
        report_descriptor_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& report_descriptor_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_report_descriptor,
      report_descriptor_fragment,
      &report_descriptor_validate_params);

    fragment->report_descriptor.Set(
        report_descriptor_fragment.is_null() ? nullptr : report_descriptor_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->report_descriptor.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null report_descriptor in HidDeviceInfo struct");

    decltype(Traits::collections(input)) in_collections = Traits::collections(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->collections)::BaseType>
        collections_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& collections_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidCollectionInfoDataView>>(
      in_collections,
      collections_fragment,
      &collections_validate_params);

    fragment->collections.Set(
        collections_fragment.is_null() ? nullptr : collections_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->collections.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null collections in HidDeviceInfo struct");

    fragment->has_report_id = Traits::has_report_id(input);

    fragment->max_input_report_size = Traits::max_input_report_size(input);

    fragment->max_output_report_size = Traits::max_output_report_size(input);

    fragment->max_feature_report_size = Traits::max_feature_report_size(input);

    decltype(Traits::device_node(input)) in_device_node = Traits::device_node(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_node)::BaseType> device_node_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_device_node,
      device_node_fragment);

    fragment->device_node.Set(
        device_node_fragment.is_null() ? nullptr : device_node_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->device_node.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null device_node in HidDeviceInfo struct");

    decltype(Traits::protected_input_report_ids(input)) in_protected_input_report_ids = Traits::protected_input_report_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->protected_input_report_ids)::BaseType>
        protected_input_report_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& protected_input_report_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_protected_input_report_ids,
      protected_input_report_ids_fragment,
      &protected_input_report_ids_validate_params);

    fragment->protected_input_report_ids.Set(
        protected_input_report_ids_fragment.is_null() ? nullptr : protected_input_report_ids_fragment.data());

    decltype(Traits::protected_output_report_ids(input)) in_protected_output_report_ids = Traits::protected_output_report_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->protected_output_report_ids)::BaseType>
        protected_output_report_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& protected_output_report_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_protected_output_report_ids,
      protected_output_report_ids_fragment,
      &protected_output_report_ids_validate_params);

    fragment->protected_output_report_ids.Set(
        protected_output_report_ids_fragment.is_null() ? nullptr : protected_output_report_ids_fragment.data());

    decltype(Traits::protected_feature_report_ids(input)) in_protected_feature_report_ids = Traits::protected_feature_report_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->protected_feature_report_ids)::BaseType>
        protected_feature_report_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& protected_feature_report_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_protected_feature_report_ids,
      protected_feature_report_ids_fragment,
      &protected_feature_report_ids_validate_params);

    fragment->protected_feature_report_ids.Set(
        protected_feature_report_ids_fragment.is_null() ? nullptr : protected_feature_report_ids_fragment.data());

    fragment->is_excluded_by_blocklist = Traits::is_excluded_by_blocklist(input);
  }

  static bool Deserialize(::device::mojom::internal::HidDeviceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::HidDeviceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {



inline void HidReportItemDataView::GetUsagesDataView(
    mojo::ArrayDataView<HidUsageAndPageDataView>* output) {
  auto pointer = data_->usages.Get();
  *output = mojo::ArrayDataView<HidUsageAndPageDataView>(pointer, message_);
}
inline void HidReportItemDataView::GetUsageMinimumDataView(
    HidUsageAndPageDataView* output) {
  auto pointer = data_->usage_minimum.Get();
  *output = HidUsageAndPageDataView(pointer, message_);
}
inline void HidReportItemDataView::GetUsageMaximumDataView(
    HidUsageAndPageDataView* output) {
  auto pointer = data_->usage_maximum.Get();
  *output = HidUsageAndPageDataView(pointer, message_);
}


inline void HidReportDescriptionDataView::GetItemsDataView(
    mojo::ArrayDataView<HidReportItemDataView>* output) {
  auto pointer = data_->items.Get();
  *output = mojo::ArrayDataView<HidReportItemDataView>(pointer, message_);
}


inline void HidCollectionInfoDataView::GetUsageDataView(
    HidUsageAndPageDataView* output) {
  auto pointer = data_->usage.Get();
  *output = HidUsageAndPageDataView(pointer, message_);
}
inline void HidCollectionInfoDataView::GetReportIdsDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->report_ids.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void HidCollectionInfoDataView::GetInputReportsDataView(
    mojo::ArrayDataView<HidReportDescriptionDataView>* output) {
  auto pointer = data_->input_reports.Get();
  *output = mojo::ArrayDataView<HidReportDescriptionDataView>(pointer, message_);
}
inline void HidCollectionInfoDataView::GetOutputReportsDataView(
    mojo::ArrayDataView<HidReportDescriptionDataView>* output) {
  auto pointer = data_->output_reports.Get();
  *output = mojo::ArrayDataView<HidReportDescriptionDataView>(pointer, message_);
}
inline void HidCollectionInfoDataView::GetFeatureReportsDataView(
    mojo::ArrayDataView<HidReportDescriptionDataView>* output) {
  auto pointer = data_->feature_reports.Get();
  *output = mojo::ArrayDataView<HidReportDescriptionDataView>(pointer, message_);
}
inline void HidCollectionInfoDataView::GetChildrenDataView(
    mojo::ArrayDataView<HidCollectionInfoDataView>* output) {
  auto pointer = data_->children.Get();
  *output = mojo::ArrayDataView<HidCollectionInfoDataView>(pointer, message_);
}


inline void HidDeviceInfoDataView::GetGuidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->guid.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HidDeviceInfoDataView::GetPhysicalDeviceIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->physical_device_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HidDeviceInfoDataView::GetProductNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->product_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HidDeviceInfoDataView::GetSerialNumberDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->serial_number.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HidDeviceInfoDataView::GetReportDescriptorDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->report_descriptor.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void HidDeviceInfoDataView::GetCollectionsDataView(
    mojo::ArrayDataView<HidCollectionInfoDataView>* output) {
  auto pointer = data_->collections.Get();
  *output = mojo::ArrayDataView<HidCollectionInfoDataView>(pointer, message_);
}
inline void HidDeviceInfoDataView::GetDeviceNodeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->device_node.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HidDeviceInfoDataView::GetProtectedInputReportIdsDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->header_.version >= 1
                 ? data_->protected_input_report_ids.Get() : nullptr;
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void HidDeviceInfoDataView::GetProtectedOutputReportIdsDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->header_.version >= 1
                 ? data_->protected_output_report_ids.Get() : nullptr;
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void HidDeviceInfoDataView::GetProtectedFeatureReportIdsDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->header_.version >= 1
                 ? data_->protected_feature_report_ids.Get() : nullptr;
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}



}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::HidBusType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::HidBusType value);
};

} // namespace perfetto

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_SHARED_H_