// services/device/public/mojom/hid.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');




goog.provide('device.mojom.PAGE_UNDEFINED');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_UNDEFINED = 0x00;
goog.provide('device.mojom.PAGE_GENERIC_DESKTOP');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_GENERIC_DESKTOP = 0x01;
goog.provide('device.mojom.PAGE_SIMULATION');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_SIMULATION = 0x02;
goog.provide('device.mojom.PAGE_VIRTUAL_REALITY');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_VIRTUAL_REALITY = 0x03;
goog.provide('device.mojom.PAGE_SPORT');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_SPORT = 0x04;
goog.provide('device.mojom.PAGE_GAME');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_GAME = 0x05;
goog.provide('device.mojom.PAGE_GENERIC_DEVICE');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_GENERIC_DEVICE = 0x06;
goog.provide('device.mojom.PAGE_KEYBOARD');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_KEYBOARD = 0x07;
goog.provide('device.mojom.PAGE_LED');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_LED = 0x08;
goog.provide('device.mojom.PAGE_BUTTON');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_BUTTON = 0x09;
goog.provide('device.mojom.PAGE_ORDINAL');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_ORDINAL = 0x0A;
goog.provide('device.mojom.PAGE_TELEPHONY');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_TELEPHONY = 0x0B;
goog.provide('device.mojom.PAGE_CONSUMER');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_CONSUMER = 0x0C;
goog.provide('device.mojom.PAGE_DIGITIZER');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_DIGITIZER = 0x0D;
goog.provide('device.mojom.PAGE_PID_PAGE');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_PID_PAGE = 0x0F;
goog.provide('device.mojom.PAGE_UNICODE');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_UNICODE = 0x10;
goog.provide('device.mojom.PAGE_ALPHANUMERIC_DISPLAY');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_ALPHANUMERIC_DISPLAY = 0x14;
goog.provide('device.mojom.PAGE_MEDICAL_INSTRUMENTS');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_MEDICAL_INSTRUMENTS = 0x40;
goog.provide('device.mojom.PAGE_MONITOR0');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_MONITOR0 = 0x80;
goog.provide('device.mojom.PAGE_MONITOR1');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_MONITOR1 = 0x81;
goog.provide('device.mojom.PAGE_MONITOR2');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_MONITOR2 = 0x82;
goog.provide('device.mojom.PAGE_MONITOR3');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_MONITOR3 = 0x83;
goog.provide('device.mojom.PAGE_POWER0');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_POWER0 = 0x84;
goog.provide('device.mojom.PAGE_POWER1');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_POWER1 = 0x85;
goog.provide('device.mojom.PAGE_POWER2');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_POWER2 = 0x86;
goog.provide('device.mojom.PAGE_POWER3');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_POWER3 = 0x87;
goog.provide('device.mojom.PAGE_BAR_CODE_SCANNER');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_BAR_CODE_SCANNER = 0x8C;
goog.provide('device.mojom.PAGE_SCALE');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_SCALE = 0x8D;
goog.provide('device.mojom.PAGE_MAGNETIC_STRIPE_READER');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_MAGNETIC_STRIPE_READER = 0x8E;
goog.provide('device.mojom.PAGE_RESERVED_POINT_OF_SALE');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_RESERVED_POINT_OF_SALE = 0x8F;
goog.provide('device.mojom.PAGE_CAMERA_CONTROL');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_CAMERA_CONTROL = 0x90;
goog.provide('device.mojom.PAGE_ARCADE');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_ARCADE = 0x91;
goog.provide('device.mojom.PAGE_FIDO');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_FIDO = 0xF1D0;
goog.provide('device.mojom.PAGE_VENDOR');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_VENDOR = 0xFF00;
goog.provide('device.mojom.PAGE_MEDIA_CENTER');
/**
 * @const { !number }
 * @export
 */
device.mojom.PAGE_MEDIA_CENTER = 0xFFBC;
goog.provide('device.mojom.GENERIC_DESKTOP_UNDEFINED');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_UNDEFINED = 0x00;
goog.provide('device.mojom.GENERIC_DESKTOP_POINTER');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_POINTER = 0x01;
goog.provide('device.mojom.GENERIC_DESKTOP_MOUSE');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_MOUSE = 0x02;
goog.provide('device.mojom.GENERIC_DESKTOP_JOYSTICK');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_JOYSTICK = 0x04;
goog.provide('device.mojom.GENERIC_DESKTOP_GAME_PAD');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_GAME_PAD = 0x05;
goog.provide('device.mojom.GENERIC_DESKTOP_KEYBOARD');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_KEYBOARD = 0x06;
goog.provide('device.mojom.GENERIC_DESKTOP_KEYPAD');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_KEYPAD = 0x07;
goog.provide('device.mojom.GENERIC_DESKTOP_MULTI_AXIS_CONTROLLER');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_MULTI_AXIS_CONTROLLER = 0x08;
goog.provide('device.mojom.GENERIC_DESKTOP_X');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_X = 0x30;
goog.provide('device.mojom.GENERIC_DESKTOP_Y');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_Y = 0x31;
goog.provide('device.mojom.GENERIC_DESKTOP_Z');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_Z = 0x32;
goog.provide('device.mojom.GENERIC_DESKTOP_RX');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_RX = 0x33;
goog.provide('device.mojom.GENERIC_DESKTOP_RY');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_RY = 0x34;
goog.provide('device.mojom.GENERIC_DESKTOP_RZ');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_RZ = 0x35;
goog.provide('device.mojom.GENERIC_DESKTOP_SLIDER');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SLIDER = 0x36;
goog.provide('device.mojom.GENERIC_DESKTOP_DIAL');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_DIAL = 0x37;
goog.provide('device.mojom.GENERIC_DESKTOP_WHEEL');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_WHEEL = 0x38;
goog.provide('device.mojom.GENERIC_DESKTOP_HAT_SWITCH');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_HAT_SWITCH = 0x39;
goog.provide('device.mojom.GENERIC_DESKTOP_COUNTED_BUFFER');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_COUNTED_BUFFER = 0x3a;
goog.provide('device.mojom.GENERIC_DESKTOP_BYTE_COUNT');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_BYTE_COUNT = 0x3b;
goog.provide('device.mojom.GENERIC_DESKTOP_MOTION_WAKEUP');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_MOTION_WAKEUP = 0x3c;
goog.provide('device.mojom.GENERIC_DESKTOP_START');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_START = 0x3d;
goog.provide('device.mojom.GENERIC_DESKTOP_SELECT');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SELECT = 0x3e;
goog.provide('device.mojom.GENERIC_DESKTOP_VX');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_VX = 0x40;
goog.provide('device.mojom.GENERIC_DESKTOP_VY');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_VY = 0x41;
goog.provide('device.mojom.GENERIC_DESKTOP_VZ');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_VZ = 0x42;
goog.provide('device.mojom.GENERIC_DESKTOP_VBRX');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_VBRX = 0x43;
goog.provide('device.mojom.GENERIC_DESKTOP_VBRY');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_VBRY = 0x44;
goog.provide('device.mojom.GENERIC_DESKTOP_VBRZ');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_VBRZ = 0x45;
goog.provide('device.mojom.GENERIC_DESKTOP_VNO');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_VNO = 0x46;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_CONTROL');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_CONTROL = 0x80;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_POWER_DOWN');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_POWER_DOWN = 0x81;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_SLEEP');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_SLEEP = 0x82;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_WAKE_UP');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_WAKE_UP = 0x83;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_CONTEXT_MENU');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_CONTEXT_MENU = 0x84;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_MAIN_MENU');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_MAIN_MENU = 0x85;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_APP_MENU');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_APP_MENU = 0x86;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_MENU_HELP');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_MENU_HELP = 0x87;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_MENU_EXIT');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_MENU_EXIT = 0x88;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_MENU_SELECT');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_MENU_SELECT = 0x89;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_MENU_RIGHT');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_MENU_RIGHT = 0x8a;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_MENU_LEFT');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_MENU_LEFT = 0x8b;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_MENU_UP');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_MENU_UP = 0x8c;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_MENU_DOWN');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_MENU_DOWN = 0x8d;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_COLD_RESTART');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_COLD_RESTART = 0x8e;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_WARM_RESTART');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_WARM_RESTART = 0x8f;
goog.provide('device.mojom.GENERIC_DESKTOP_D_PAD_UP');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_D_PAD_UP = 0x90;
goog.provide('device.mojom.GENERIC_DESKTOP_D_PAD_DOWN');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_D_PAD_DOWN = 0x91;
goog.provide('device.mojom.GENERIC_DESKTOP_D_PAD_LEFT');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_D_PAD_LEFT = 0x92;
goog.provide('device.mojom.GENERIC_DESKTOP_D_PAD_RIGHT');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_D_PAD_RIGHT = 0x93;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_DOCK');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_DOCK = 0xa0;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_UNDOCK');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_UNDOCK = 0xa1;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_SETUP');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_SETUP = 0xa2;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_BREAK');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_BREAK = 0xa3;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_DEBUGGER_BREAK');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_DEBUGGER_BREAK = 0xa4;
goog.provide('device.mojom.GENERIC_DESKTOP_APPLICATION_BREAK');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_APPLICATION_BREAK = 0xa5;
goog.provide('device.mojom.GENERIC_DESKTOP_APPLICATION_DEBUGGER_BREAK');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_APPLICATION_DEBUGGER_BREAK = 0xa6;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_SPEAKER_MUTE');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_SPEAKER_MUTE = 0xa7;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_HIBERNATE');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_HIBERNATE = 0xa8;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_DISPLAY_INVERT');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_DISPLAY_INVERT = 0xb0;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_DISPLAY_INTERNAL');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_DISPLAY_INTERNAL = 0xb1;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_DISPLAY_EXTERNAL');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_DISPLAY_EXTERNAL = 0xb2;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_DISPLAY_BOTH');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_DISPLAY_BOTH = 0xb3;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_DISPLAY_DUAL');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_DISPLAY_DUAL = 0xb4;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_DISPLAY_TOGGLE');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_DISPLAY_TOGGLE = 0xb5;
goog.provide('device.mojom.GENERIC_DESKTOP_SYSTEM_DISPLAY_SWAP');
/**
 * @const { !number }
 * @export
 */
device.mojom.GENERIC_DESKTOP_SYSTEM_DISPLAY_SWAP = 0xb6;
goog.provide('device.mojom.HID_COLLECTION_TYPE_PHYSICAL');
/**
 * @const { !number }
 * @export
 */
device.mojom.HID_COLLECTION_TYPE_PHYSICAL = 0x00;
goog.provide('device.mojom.HID_COLLECTION_TYPE_APPLICATION');
/**
 * @const { !number }
 * @export
 */
device.mojom.HID_COLLECTION_TYPE_APPLICATION = 0x01;
goog.provide('device.mojom.HID_COLLECTION_TYPE_LOGICAL');
/**
 * @const { !number }
 * @export
 */
device.mojom.HID_COLLECTION_TYPE_LOGICAL = 0x02;
goog.provide('device.mojom.HID_COLLECTION_TYPE_REPORT');
/**
 * @const { !number }
 * @export
 */
device.mojom.HID_COLLECTION_TYPE_REPORT = 0x03;
goog.provide('device.mojom.HID_COLLECTION_TYPE_NAMED_ARRAY');
/**
 * @const { !number }
 * @export
 */
device.mojom.HID_COLLECTION_TYPE_NAMED_ARRAY = 0x04;
goog.provide('device.mojom.HID_COLLECTION_TYPE_USAGE_SWITCH');
/**
 * @const { !number }
 * @export
 */
device.mojom.HID_COLLECTION_TYPE_USAGE_SWITCH = 0x05;
goog.provide('device.mojom.HID_COLLECTION_TYPE_USAGE_MODIFIER');
/**
 * @const { !number }
 * @export
 */
device.mojom.HID_COLLECTION_TYPE_USAGE_MODIFIER = 0x06;
goog.provide('device.mojom.HID_COLLECTION_TYPE_VENDOR_MIN');
/**
 * @const { !number }
 * @export
 */
device.mojom.HID_COLLECTION_TYPE_VENDOR_MIN = 0x80;
goog.provide('device.mojom.HID_COLLECTION_TYPE_VENDOR_MAX');
/**
 * @const { !number }
 * @export
 */
device.mojom.HID_COLLECTION_TYPE_VENDOR_MAX = 0xff;

goog.provide('device.mojom.HidBusType');
goog.provide('device.mojom.HidBusTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.HidBusTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.HidBusType = {
  
  kHIDBusTypeUSB: 0,
  kHIDBusTypeBluetooth: 1,
  kHIDBusTypeUnknown: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



goog.provide('device.mojom.HidManagerClient');
goog.provide('device.mojom.HidManagerClientReceiver');
goog.provide('device.mojom.HidManagerClientCallbackRouter');
goog.provide('device.mojom.HidManagerClientInterface');
goog.provide('device.mojom.HidManagerClientRemote');
goog.provide('device.mojom.HidManagerClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.HidManagerClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.HidManagerClient.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.HidManagerClientInterface = class {
  
  /**
   * @param { !device.mojom.HidDeviceInfo } deviceInfo
   */

  deviceAdded(deviceInfo) {}
  
  /**
   * @param { !device.mojom.HidDeviceInfo } deviceInfo
   */

  deviceRemoved(deviceInfo) {}
  
  /**
   * @param { !device.mojom.HidDeviceInfo } deviceInfo
   */

  deviceChanged(deviceInfo) {}
};

/**
 * @export
 * @implements { device.mojom.HidManagerClientInterface }
 */
device.mojom.HidManagerClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.HidManagerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.HidManagerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.HidManagerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.HidDeviceInfo } deviceInfo
   */

  deviceAdded(
      deviceInfo) {
    this.proxy.sendMessage(
        0,
        device.mojom.HidManagerClient_DeviceAdded_ParamsSpec.$,
        null,
        [
          deviceInfo
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.HidDeviceInfo } deviceInfo
   */

  deviceRemoved(
      deviceInfo) {
    this.proxy.sendMessage(
        1,
        device.mojom.HidManagerClient_DeviceRemoved_ParamsSpec.$,
        null,
        [
          deviceInfo
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.HidDeviceInfo } deviceInfo
   */

  deviceChanged(
      deviceInfo) {
    this.proxy.sendMessage(
        2,
        device.mojom.HidManagerClient_DeviceChanged_ParamsSpec.$,
        null,
        [
          deviceInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the HidManagerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.HidManagerClientReceiver = class {
  /**
   * @param {!device.mojom.HidManagerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.HidManagerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.HidManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.HidManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.HidManagerClient_DeviceAdded_ParamsSpec.$,
        null,
        impl.deviceAdded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.HidManagerClient_DeviceRemoved_ParamsSpec.$,
        null,
        impl.deviceRemoved.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.HidManagerClient_DeviceChanged_ParamsSpec.$,
        null,
        impl.deviceChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.HidManagerClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.HidManagerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.HidManagerClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.HidManagerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the HidManagerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.HidManagerClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.HidManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.HidManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deviceAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.HidManagerClient_DeviceAdded_ParamsSpec.$,
        null,
        this.deviceAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deviceRemoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.HidManagerClient_DeviceRemoved_ParamsSpec.$,
        null,
        this.deviceRemoved.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deviceChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.HidManagerClient_DeviceChanged_ParamsSpec.$,
        null,
        this.deviceChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.HidManager');
goog.provide('device.mojom.HidManagerReceiver');
goog.provide('device.mojom.HidManagerCallbackRouter');
goog.provide('device.mojom.HidManagerInterface');
goog.provide('device.mojom.HidManagerRemote');
goog.provide('device.mojom.HidManagerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.HidManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.HidManager.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.HidManagerInterface = class {
  
  /**
   * @param { !Object } client
   * @return {!Promise<{
        devices: !Array<!device.mojom.HidDeviceInfo>,
   *  }>}
   */

  getDevicesAndSetClient(client) {}
  
  /**
   * @return {!Promise<{
        devices: !Array<!device.mojom.HidDeviceInfo>,
   *  }>}
   */

  getDevices() {}
  
  /**
   * @param { !string } deviceGuid
   * @param { ?device.mojom.HidConnectionClientRemote } connectionClient
   * @param { ?device.mojom.HidConnectionWatcherRemote } watcher
   * @param { !boolean } allowProtectedReports
   * @param { !boolean } allowFidoReports
   * @return {!Promise<{
        connection: ?device.mojom.HidConnectionRemote,
   *  }>}
   */

  connect(deviceGuid, connectionClient, watcher, allowProtectedReports, allowFidoReports) {}
  
  /**
   * @param { !device.mojom.HidManagerPendingReceiver } receiver
   */

  addReceiver(receiver) {}
};

/**
 * @export
 * @implements { device.mojom.HidManagerInterface }
 */
device.mojom.HidManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.HidManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.HidManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.HidManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } client
   * @return {!Promise<{
        devices: !Array<!device.mojom.HidDeviceInfo>,
   *  }>}
   */

  getDevicesAndSetClient(
      client) {
    return this.proxy.sendMessage(
        0,
        device.mojom.HidManager_GetDevicesAndSetClient_ParamsSpec.$,
        device.mojom.HidManager_GetDevicesAndSetClient_ResponseParamsSpec.$,
        [
          client
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        devices: !Array<!device.mojom.HidDeviceInfo>,
   *  }>}
   */

  getDevices() {
    return this.proxy.sendMessage(
        1,
        device.mojom.HidManager_GetDevices_ParamsSpec.$,
        device.mojom.HidManager_GetDevices_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } deviceGuid
   * @param { ?device.mojom.HidConnectionClientRemote } connectionClient
   * @param { ?device.mojom.HidConnectionWatcherRemote } watcher
   * @param { !boolean } allowProtectedReports
   * @param { !boolean } allowFidoReports
   * @return {!Promise<{
        connection: ?device.mojom.HidConnectionRemote,
   *  }>}
   */

  connect(
      deviceGuid,
      connectionClient,
      watcher,
      allowProtectedReports,
      allowFidoReports) {
    return this.proxy.sendMessage(
        2,
        device.mojom.HidManager_Connect_ParamsSpec.$,
        device.mojom.HidManager_Connect_ResponseParamsSpec.$,
        [
          deviceGuid,
          connectionClient,
          watcher,
          allowProtectedReports,
          allowFidoReports
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.HidManagerPendingReceiver } receiver
   */

  addReceiver(
      receiver) {
    this.proxy.sendMessage(
        3,
        device.mojom.HidManager_AddReceiver_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the HidManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.HidManagerReceiver = class {
  /**
   * @param {!device.mojom.HidManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.HidManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.HidManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.HidManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.HidManager_GetDevicesAndSetClient_ParamsSpec.$,
        device.mojom.HidManager_GetDevicesAndSetClient_ResponseParamsSpec.$,
        impl.getDevicesAndSetClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.HidManager_GetDevices_ParamsSpec.$,
        device.mojom.HidManager_GetDevices_ResponseParamsSpec.$,
        impl.getDevices.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.HidManager_Connect_ParamsSpec.$,
        device.mojom.HidManager_Connect_ResponseParamsSpec.$,
        impl.connect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        device.mojom.HidManager_AddReceiver_ParamsSpec.$,
        null,
        impl.addReceiver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.HidManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.HidManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.HidManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.HidManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the HidManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.HidManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.HidManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.HidManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDevicesAndSetClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.HidManager_GetDevicesAndSetClient_ParamsSpec.$,
        device.mojom.HidManager_GetDevicesAndSetClient_ResponseParamsSpec.$,
        this.getDevicesAndSetClient.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDevices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.HidManager_GetDevices_ParamsSpec.$,
        device.mojom.HidManager_GetDevices_ResponseParamsSpec.$,
        this.getDevices.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.HidManager_Connect_ParamsSpec.$,
        device.mojom.HidManager_Connect_ResponseParamsSpec.$,
        this.connect.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addReceiver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        device.mojom.HidManager_AddReceiver_ParamsSpec.$,
        null,
        this.addReceiver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.HidConnection');
goog.provide('device.mojom.HidConnectionReceiver');
goog.provide('device.mojom.HidConnectionCallbackRouter');
goog.provide('device.mojom.HidConnectionInterface');
goog.provide('device.mojom.HidConnectionRemote');
goog.provide('device.mojom.HidConnectionPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.HidConnectionPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.HidConnection.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.HidConnectionInterface = class {
  
  /**
   * @return {!Promise<{
        success: !boolean,
        reportId: !number,
        buffer: ?Array<!number>,
   *  }>}
   */

  read() {}
  
  /**
   * @param { !number } reportId
   * @param { !Array<!number> } buffer
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  write(reportId, buffer) {}
  
  /**
   * @param { !number } reportId
   * @return {!Promise<{
        success: !boolean,
        buffer: ?Array<!number>,
   *  }>}
   */

  getFeatureReport(reportId) {}
  
  /**
   * @param { !number } reportId
   * @param { !Array<!number> } buffer
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  sendFeatureReport(reportId, buffer) {}
};

/**
 * @export
 * @implements { device.mojom.HidConnectionInterface }
 */
device.mojom.HidConnectionRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.HidConnectionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.HidConnectionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.HidConnectionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
        reportId: !number,
        buffer: ?Array<!number>,
   *  }>}
   */

  read() {
    return this.proxy.sendMessage(
        0,
        device.mojom.HidConnection_Read_ParamsSpec.$,
        device.mojom.HidConnection_Read_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } reportId
   * @param { !Array<!number> } buffer
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  write(
      reportId,
      buffer) {
    return this.proxy.sendMessage(
        1,
        device.mojom.HidConnection_Write_ParamsSpec.$,
        device.mojom.HidConnection_Write_ResponseParamsSpec.$,
        [
          reportId,
          buffer
        ],
        false);
  }

  
  /**
   * @param { !number } reportId
   * @return {!Promise<{
        success: !boolean,
        buffer: ?Array<!number>,
   *  }>}
   */

  getFeatureReport(
      reportId) {
    return this.proxy.sendMessage(
        2,
        device.mojom.HidConnection_GetFeatureReport_ParamsSpec.$,
        device.mojom.HidConnection_GetFeatureReport_ResponseParamsSpec.$,
        [
          reportId
        ],
        false);
  }

  
  /**
   * @param { !number } reportId
   * @param { !Array<!number> } buffer
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  sendFeatureReport(
      reportId,
      buffer) {
    return this.proxy.sendMessage(
        3,
        device.mojom.HidConnection_SendFeatureReport_ParamsSpec.$,
        device.mojom.HidConnection_SendFeatureReport_ResponseParamsSpec.$,
        [
          reportId,
          buffer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the HidConnection
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.HidConnectionReceiver = class {
  /**
   * @param {!device.mojom.HidConnectionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.HidConnectionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.HidConnectionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.HidConnectionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.HidConnection_Read_ParamsSpec.$,
        device.mojom.HidConnection_Read_ResponseParamsSpec.$,
        impl.read.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.HidConnection_Write_ParamsSpec.$,
        device.mojom.HidConnection_Write_ResponseParamsSpec.$,
        impl.write.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.HidConnection_GetFeatureReport_ParamsSpec.$,
        device.mojom.HidConnection_GetFeatureReport_ResponseParamsSpec.$,
        impl.getFeatureReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        device.mojom.HidConnection_SendFeatureReport_ParamsSpec.$,
        device.mojom.HidConnection_SendFeatureReport_ResponseParamsSpec.$,
        impl.sendFeatureReport.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.HidConnection = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.HidConnection";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.HidConnectionRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.HidConnectionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the HidConnection
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.HidConnectionCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.HidConnectionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.HidConnectionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.read =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.HidConnection_Read_ParamsSpec.$,
        device.mojom.HidConnection_Read_ResponseParamsSpec.$,
        this.read.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.write =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.HidConnection_Write_ParamsSpec.$,
        device.mojom.HidConnection_Write_ResponseParamsSpec.$,
        this.write.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFeatureReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.HidConnection_GetFeatureReport_ParamsSpec.$,
        device.mojom.HidConnection_GetFeatureReport_ResponseParamsSpec.$,
        this.getFeatureReport.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendFeatureReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        device.mojom.HidConnection_SendFeatureReport_ParamsSpec.$,
        device.mojom.HidConnection_SendFeatureReport_ResponseParamsSpec.$,
        this.sendFeatureReport.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.HidConnectionClient');
goog.provide('device.mojom.HidConnectionClientReceiver');
goog.provide('device.mojom.HidConnectionClientCallbackRouter');
goog.provide('device.mojom.HidConnectionClientInterface');
goog.provide('device.mojom.HidConnectionClientRemote');
goog.provide('device.mojom.HidConnectionClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.HidConnectionClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.HidConnectionClient.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.HidConnectionClientInterface = class {
  
  /**
   * @param { !number } reportId
   * @param { !Array<!number> } buffer
   */

  onInputReport(reportId, buffer) {}
};

/**
 * @export
 * @implements { device.mojom.HidConnectionClientInterface }
 */
device.mojom.HidConnectionClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.HidConnectionClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.HidConnectionClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.HidConnectionClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } reportId
   * @param { !Array<!number> } buffer
   */

  onInputReport(
      reportId,
      buffer) {
    this.proxy.sendMessage(
        0,
        device.mojom.HidConnectionClient_OnInputReport_ParamsSpec.$,
        null,
        [
          reportId,
          buffer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the HidConnectionClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.HidConnectionClientReceiver = class {
  /**
   * @param {!device.mojom.HidConnectionClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.HidConnectionClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.HidConnectionClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.HidConnectionClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.HidConnectionClient_OnInputReport_ParamsSpec.$,
        null,
        impl.onInputReport.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.HidConnectionClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.HidConnectionClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.HidConnectionClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.HidConnectionClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the HidConnectionClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.HidConnectionClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.HidConnectionClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.HidConnectionClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onInputReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.HidConnectionClient_OnInputReport_ParamsSpec.$,
        null,
        this.onInputReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.HidConnectionWatcher');
goog.provide('device.mojom.HidConnectionWatcherReceiver');
goog.provide('device.mojom.HidConnectionWatcherCallbackRouter');
goog.provide('device.mojom.HidConnectionWatcherInterface');
goog.provide('device.mojom.HidConnectionWatcherRemote');
goog.provide('device.mojom.HidConnectionWatcherPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.HidConnectionWatcherPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.HidConnectionWatcher.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.HidConnectionWatcherInterface = class {
};

/**
 * @export
 * @implements { device.mojom.HidConnectionWatcherInterface }
 */
device.mojom.HidConnectionWatcherRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.HidConnectionWatcherPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.HidConnectionWatcherPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.HidConnectionWatcherPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
};

/**
 * An object which receives request messages for the HidConnectionWatcher
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.HidConnectionWatcherReceiver = class {
  /**
   * @param {!device.mojom.HidConnectionWatcherInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.HidConnectionWatcherRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.HidConnectionWatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.HidConnectionWatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.HidConnectionWatcher = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.HidConnectionWatcher";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.HidConnectionWatcherRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.HidConnectionWatcherRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the HidConnectionWatcher
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.HidConnectionWatcherCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.HidConnectionWatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.HidConnectionWatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.HidUsageAndPageSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidUsageAndPageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidReportItemSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidReportItemSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidReportDescriptionSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidReportDescriptionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidCollectionInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidCollectionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidDeviceInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidDeviceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidManagerClient_DeviceAdded_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidManagerClient_DeviceAdded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidManagerClient_DeviceRemoved_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidManagerClient_DeviceRemoved_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidManagerClient_DeviceChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidManagerClient_DeviceChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidManager_GetDevicesAndSetClient_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidManager_GetDevicesAndSetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidManager_GetDevicesAndSetClient_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidManager_GetDevicesAndSetClient_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidManager_GetDevices_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidManager_GetDevices_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidManager_GetDevices_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidManager_GetDevices_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidManager_Connect_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidManager_Connect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidManager_Connect_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidManager_Connect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidManager_AddReceiver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidManager_AddReceiver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidConnection_Read_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidConnection_Read_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidConnection_Read_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidConnection_Read_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidConnection_Write_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidConnection_Write_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidConnection_Write_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidConnection_Write_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidConnection_GetFeatureReport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidConnection_GetFeatureReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidConnection_GetFeatureReport_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidConnection_GetFeatureReport_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidConnection_SendFeatureReport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidConnection_SendFeatureReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidConnection_SendFeatureReport_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidConnection_SendFeatureReport_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.HidConnectionClient_OnInputReport_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.HidConnectionClient_OnInputReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.HidUsageAndPageSpec.$,
    'HidUsageAndPage',
    [
      mojo.internal.StructField(
        'usage', 0,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'usagePage', 2,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.HidUsageAndPage');

/** @record */
device.mojom.HidUsageAndPage = class {
  constructor() {
    /** @export { !number } */
    this.usage;
    /** @export { !number } */
    this.usagePage;
  }
};



mojo.internal.Struct(
    device.mojom.HidReportItemSpec.$,
    'HidReportItem',
    [
      mojo.internal.StructField(
        'isRange', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isConstant', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isVariable', 0,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isRelative', 0,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wrap', 0,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isNonLinear', 0,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'noPreferredState', 0,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasNullPosition', 0,
        7,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isVolatile', 1,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isBufferedBytes', 1,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'usages', 8,
        0,
        mojo.internal.Array(device.mojom.HidUsageAndPageSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'usageMinimum', 16,
        0,
        device.mojom.HidUsageAndPageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'usageMaximum', 24,
        0,
        device.mojom.HidUsageAndPageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'designatorMinimum', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'designatorMaximum', 32,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'stringMinimum', 36,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'stringMaximum', 40,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'logicalMinimum', 44,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'logicalMaximum', 48,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'physicalMinimum', 52,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'physicalMaximum', 56,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'unitExponent', 60,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'unit', 64,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportSize', 68,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportCount', 72,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 88],]);



goog.provide('device.mojom.HidReportItem');

/** @record */
device.mojom.HidReportItem = class {
  constructor() {
    /** @export { !boolean } */
    this.isRange;
    /** @export { !boolean } */
    this.isConstant;
    /** @export { !boolean } */
    this.isVariable;
    /** @export { !boolean } */
    this.isRelative;
    /** @export { !boolean } */
    this.wrap;
    /** @export { !boolean } */
    this.isNonLinear;
    /** @export { !boolean } */
    this.noPreferredState;
    /** @export { !boolean } */
    this.hasNullPosition;
    /** @export { !boolean } */
    this.isVolatile;
    /** @export { !boolean } */
    this.isBufferedBytes;
    /** @export { !Array<!device.mojom.HidUsageAndPage> } */
    this.usages;
    /** @export { !device.mojom.HidUsageAndPage } */
    this.usageMinimum;
    /** @export { !device.mojom.HidUsageAndPage } */
    this.usageMaximum;
    /** @export { !number } */
    this.designatorMinimum;
    /** @export { !number } */
    this.designatorMaximum;
    /** @export { !number } */
    this.stringMinimum;
    /** @export { !number } */
    this.stringMaximum;
    /** @export { !number } */
    this.logicalMinimum;
    /** @export { !number } */
    this.logicalMaximum;
    /** @export { !number } */
    this.physicalMinimum;
    /** @export { !number } */
    this.physicalMaximum;
    /** @export { !number } */
    this.unitExponent;
    /** @export { !number } */
    this.unit;
    /** @export { !number } */
    this.reportSize;
    /** @export { !number } */
    this.reportCount;
  }
};



mojo.internal.Struct(
    device.mojom.HidReportDescriptionSpec.$,
    'HidReportDescription',
    [
      mojo.internal.StructField(
        'reportId', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'items', 8,
        0,
        mojo.internal.Array(device.mojom.HidReportItemSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.HidReportDescription');

/** @record */
device.mojom.HidReportDescription = class {
  constructor() {
    /** @export { !number } */
    this.reportId;
    /** @export { !Array<!device.mojom.HidReportItem> } */
    this.items;
  }
};



mojo.internal.Struct(
    device.mojom.HidCollectionInfoSpec.$,
    'HidCollectionInfo',
    [
      mojo.internal.StructField(
        'usage', 0,
        0,
        device.mojom.HidUsageAndPageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportIds', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'collectionType', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'inputReports', 24,
        0,
        mojo.internal.Array(device.mojom.HidReportDescriptionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'outputReports', 32,
        0,
        mojo.internal.Array(device.mojom.HidReportDescriptionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'featureReports', 40,
        0,
        mojo.internal.Array(device.mojom.HidReportDescriptionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'children', 48,
        0,
        mojo.internal.Array(device.mojom.HidCollectionInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 64],]);



goog.provide('device.mojom.HidCollectionInfo');

/** @record */
device.mojom.HidCollectionInfo = class {
  constructor() {
    /** @export { !device.mojom.HidUsageAndPage } */
    this.usage;
    /** @export { !Array<!number> } */
    this.reportIds;
    /** @export { !number } */
    this.collectionType;
    /** @export { !Array<!device.mojom.HidReportDescription> } */
    this.inputReports;
    /** @export { !Array<!device.mojom.HidReportDescription> } */
    this.outputReports;
    /** @export { !Array<!device.mojom.HidReportDescription> } */
    this.featureReports;
    /** @export { !Array<!device.mojom.HidCollectionInfo> } */
    this.children;
  }
};



mojo.internal.Struct(
    device.mojom.HidDeviceInfoSpec.$,
    'HidDeviceInfo',
    [
      mojo.internal.StructField(
        'guid', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'physicalDeviceId', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'vendorId', 16,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'productId', 18,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'productName', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serialNumber', 32,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'busType', 20,
        0,
        device.mojom.HidBusTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportDescriptor', 40,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'collections', 48,
        0,
        mojo.internal.Array(device.mojom.HidCollectionInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasReportId', 56,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxInputReportSize', 64,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxOutputReportSize', 72,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maxFeatureReportSize', 80,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceNode', 88,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'protectedInputReportIds', 96,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'protectedOutputReportIds', 104,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'protectedFeatureReportIds', 112,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isExcludedByBlocklist', 56,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 104],[1, 128],[3, 128],]);



goog.provide('device.mojom.HidDeviceInfo');

/** @record */
device.mojom.HidDeviceInfo = class {
  constructor() {
    /** @export { !string } */
    this.guid;
    /** @export { !string } */
    this.physicalDeviceId;
    /** @export { !number } */
    this.vendorId;
    /** @export { !number } */
    this.productId;
    /** @export { !string } */
    this.productName;
    /** @export { !string } */
    this.serialNumber;
    /** @export { !device.mojom.HidBusType } */
    this.busType;
    /** @export { !Array<!number> } */
    this.reportDescriptor;
    /** @export { !Array<!device.mojom.HidCollectionInfo> } */
    this.collections;
    /** @export { !boolean } */
    this.hasReportId;
    /** @export { !bigint } */
    this.maxInputReportSize;
    /** @export { !bigint } */
    this.maxOutputReportSize;
    /** @export { !bigint } */
    this.maxFeatureReportSize;
    /** @export { !string } */
    this.deviceNode;
    /** @export { (Array<!number>|undefined) } */
    this.protectedInputReportIds;
    /** @export { (Array<!number>|undefined) } */
    this.protectedOutputReportIds;
    /** @export { (Array<!number>|undefined) } */
    this.protectedFeatureReportIds;
    /** @export { !boolean } */
    this.isExcludedByBlocklist;
  }
};



mojo.internal.Struct(
    device.mojom.HidManagerClient_DeviceAdded_ParamsSpec.$,
    'HidManagerClient_DeviceAdded_Params',
    [
      mojo.internal.StructField(
        'deviceInfo', 0,
        0,
        device.mojom.HidDeviceInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.HidManagerClient_DeviceAdded_Params');

/** @record */
device.mojom.HidManagerClient_DeviceAdded_Params = class {
  constructor() {
    /** @export { !device.mojom.HidDeviceInfo } */
    this.deviceInfo;
  }
};



mojo.internal.Struct(
    device.mojom.HidManagerClient_DeviceRemoved_ParamsSpec.$,
    'HidManagerClient_DeviceRemoved_Params',
    [
      mojo.internal.StructField(
        'deviceInfo', 0,
        0,
        device.mojom.HidDeviceInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.HidManagerClient_DeviceRemoved_Params');

/** @record */
device.mojom.HidManagerClient_DeviceRemoved_Params = class {
  constructor() {
    /** @export { !device.mojom.HidDeviceInfo } */
    this.deviceInfo;
  }
};



mojo.internal.Struct(
    device.mojom.HidManagerClient_DeviceChanged_ParamsSpec.$,
    'HidManagerClient_DeviceChanged_Params',
    [
      mojo.internal.StructField(
        'deviceInfo', 0,
        0,
        device.mojom.HidDeviceInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.HidManagerClient_DeviceChanged_Params');

/** @record */
device.mojom.HidManagerClient_DeviceChanged_Params = class {
  constructor() {
    /** @export { !device.mojom.HidDeviceInfo } */
    this.deviceInfo;
  }
};



mojo.internal.Struct(
    device.mojom.HidManager_GetDevicesAndSetClient_ParamsSpec.$,
    'HidManager_GetDevicesAndSetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(device.mojom.HidManagerClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.HidManager_GetDevicesAndSetClient_Params');

/** @record */
device.mojom.HidManager_GetDevicesAndSetClient_Params = class {
  constructor() {
    /** @export { !Object } */
    this.client;
  }
};



mojo.internal.Struct(
    device.mojom.HidManager_GetDevicesAndSetClient_ResponseParamsSpec.$,
    'HidManager_GetDevicesAndSetClient_ResponseParams',
    [
      mojo.internal.StructField(
        'devices', 0,
        0,
        mojo.internal.Array(device.mojom.HidDeviceInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.HidManager_GetDevicesAndSetClient_ResponseParams');

/** @record */
device.mojom.HidManager_GetDevicesAndSetClient_ResponseParams = class {
  constructor() {
    /** @export { !Array<!device.mojom.HidDeviceInfo> } */
    this.devices;
  }
};



mojo.internal.Struct(
    device.mojom.HidManager_GetDevices_ParamsSpec.$,
    'HidManager_GetDevices_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.HidManager_GetDevices_Params');

/** @record */
device.mojom.HidManager_GetDevices_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.HidManager_GetDevices_ResponseParamsSpec.$,
    'HidManager_GetDevices_ResponseParams',
    [
      mojo.internal.StructField(
        'devices', 0,
        0,
        mojo.internal.Array(device.mojom.HidDeviceInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.HidManager_GetDevices_ResponseParams');

/** @record */
device.mojom.HidManager_GetDevices_ResponseParams = class {
  constructor() {
    /** @export { !Array<!device.mojom.HidDeviceInfo> } */
    this.devices;
  }
};



mojo.internal.Struct(
    device.mojom.HidManager_Connect_ParamsSpec.$,
    'HidManager_Connect_Params',
    [
      mojo.internal.StructField(
        'deviceGuid', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'connectionClient', 8,
        0,
        mojo.internal.InterfaceProxy(device.mojom.HidConnectionClientRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'watcher', 16,
        0,
        mojo.internal.InterfaceProxy(device.mojom.HidConnectionWatcherRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowProtectedReports', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowFidoReports', 24,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],[1, 40],[2, 40],]);



goog.provide('device.mojom.HidManager_Connect_Params');

/** @record */
device.mojom.HidManager_Connect_Params = class {
  constructor() {
    /** @export { !string } */
    this.deviceGuid;
    /** @export { (device.mojom.HidConnectionClientRemote|undefined) } */
    this.connectionClient;
    /** @export { (device.mojom.HidConnectionWatcherRemote|undefined) } */
    this.watcher;
    /** @export { !boolean } */
    this.allowProtectedReports;
    /** @export { !boolean } */
    this.allowFidoReports;
  }
};



mojo.internal.Struct(
    device.mojom.HidManager_Connect_ResponseParamsSpec.$,
    'HidManager_Connect_ResponseParams',
    [
      mojo.internal.StructField(
        'connection', 0,
        0,
        mojo.internal.InterfaceProxy(device.mojom.HidConnectionRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.HidManager_Connect_ResponseParams');

/** @record */
device.mojom.HidManager_Connect_ResponseParams = class {
  constructor() {
    /** @export { (device.mojom.HidConnectionRemote|undefined) } */
    this.connection;
  }
};



mojo.internal.Struct(
    device.mojom.HidManager_AddReceiver_ParamsSpec.$,
    'HidManager_AddReceiver_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(device.mojom.HidManagerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.HidManager_AddReceiver_Params');

/** @record */
device.mojom.HidManager_AddReceiver_Params = class {
  constructor() {
    /** @export { !device.mojom.HidManagerPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    device.mojom.HidConnection_Read_ParamsSpec.$,
    'HidConnection_Read_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.HidConnection_Read_Params');

/** @record */
device.mojom.HidConnection_Read_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.HidConnection_Read_ResponseParamsSpec.$,
    'HidConnection_Read_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportId', 1,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'buffer', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.HidConnection_Read_ResponseParams');

/** @record */
device.mojom.HidConnection_Read_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !number } */
    this.reportId;
    /** @export { (Array<!number>|undefined) } */
    this.buffer;
  }
};



mojo.internal.Struct(
    device.mojom.HidConnection_Write_ParamsSpec.$,
    'HidConnection_Write_Params',
    [
      mojo.internal.StructField(
        'reportId', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'buffer', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.HidConnection_Write_Params');

/** @record */
device.mojom.HidConnection_Write_Params = class {
  constructor() {
    /** @export { !number } */
    this.reportId;
    /** @export { !Array<!number> } */
    this.buffer;
  }
};



mojo.internal.Struct(
    device.mojom.HidConnection_Write_ResponseParamsSpec.$,
    'HidConnection_Write_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.HidConnection_Write_ResponseParams');

/** @record */
device.mojom.HidConnection_Write_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    device.mojom.HidConnection_GetFeatureReport_ParamsSpec.$,
    'HidConnection_GetFeatureReport_Params',
    [
      mojo.internal.StructField(
        'reportId', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.HidConnection_GetFeatureReport_Params');

/** @record */
device.mojom.HidConnection_GetFeatureReport_Params = class {
  constructor() {
    /** @export { !number } */
    this.reportId;
  }
};



mojo.internal.Struct(
    device.mojom.HidConnection_GetFeatureReport_ResponseParamsSpec.$,
    'HidConnection_GetFeatureReport_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'buffer', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.HidConnection_GetFeatureReport_ResponseParams');

/** @record */
device.mojom.HidConnection_GetFeatureReport_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { (Array<!number>|undefined) } */
    this.buffer;
  }
};



mojo.internal.Struct(
    device.mojom.HidConnection_SendFeatureReport_ParamsSpec.$,
    'HidConnection_SendFeatureReport_Params',
    [
      mojo.internal.StructField(
        'reportId', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'buffer', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.HidConnection_SendFeatureReport_Params');

/** @record */
device.mojom.HidConnection_SendFeatureReport_Params = class {
  constructor() {
    /** @export { !number } */
    this.reportId;
    /** @export { !Array<!number> } */
    this.buffer;
  }
};



mojo.internal.Struct(
    device.mojom.HidConnection_SendFeatureReport_ResponseParamsSpec.$,
    'HidConnection_SendFeatureReport_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.HidConnection_SendFeatureReport_ResponseParams');

/** @record */
device.mojom.HidConnection_SendFeatureReport_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    device.mojom.HidConnectionClient_OnInputReport_ParamsSpec.$,
    'HidConnectionClient_OnInputReport_Params',
    [
      mojo.internal.StructField(
        'reportId', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'buffer', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.HidConnectionClient_OnInputReport_Params');

/** @record */
device.mojom.HidConnectionClient_OnInputReport_Params = class {
  constructor() {
    /** @export { !number } */
    this.reportId;
    /** @export { !Array<!number> } */
    this.buffer;
  }
};

