// services/device/public/mojom/geoposition.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_GEOPOSITION_MOJOM_DATA_VIEW_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_GEOPOSITION_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/device/public/mojom/geoposition.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace device::mojom {
class GeopositionDataView;

class GeopositionErrorDataView;

class GeopositionResultDataView;


}  // device::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::GeopositionDataView> {
  using Data = ::device::mojom::internal::Geoposition_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::GeopositionErrorDataView> {
  using Data = ::device::mojom::internal::GeopositionError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::GeopositionResultDataView> {
  using Data = ::device::mojom::internal::GeopositionResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class GeopositionErrorCode : int32_t {
  
  kPermissionDenied = 1,
  
  kPositionUnavailable = 2,
  
  kWifiDisabled = 3,
  kMinValue = 1,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, GeopositionErrorCode value);
inline bool IsKnownEnumValue(GeopositionErrorCode value) {
  return internal::GeopositionErrorCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class GeopositionDataView {
 public:
  GeopositionDataView() = default;

  GeopositionDataView(
      internal::Geoposition_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  double latitude() const {
    return data_->latitude;
  }
  double longitude() const {
    return data_->longitude;
  }
  double altitude() const {
    return data_->altitude;
  }
  double accuracy() const {
    return data_->accuracy;
  }
  double altitude_accuracy() const {
    return data_->altitude_accuracy;
  }
  double heading() const {
    return data_->heading;
  }
  double speed() const {
    return data_->speed;
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  bool is_precise() const {
    return data_->is_precise;
  }
 private:
  internal::Geoposition_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GeopositionErrorDataView {
 public:
  GeopositionErrorDataView() = default;

  GeopositionErrorDataView(
      internal::GeopositionError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    auto data_value = data_->error_code;
    return mojo::internal::Deserialize<::device::mojom::GeopositionErrorCode>(
        data_value, output);
  }
  GeopositionErrorCode error_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::GeopositionErrorCode>(data_->error_code));
  }
  inline void GetErrorMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorMessage(UserType* output) {
    
    auto* pointer = data_->error_message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetErrorTechnicalDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorTechnical(UserType* output) {
    
    auto* pointer = data_->error_technical.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::GeopositionError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GeopositionResultDataView {
 public:
  using Tag = internal::GeopositionResult_Data::GeopositionResult_Tag;

  GeopositionResultDataView() = default;

  GeopositionResultDataView(
      internal::GeopositionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_position() const { return data_->tag == Tag::kPosition; }
  inline void GetPositionDataView(
      GeopositionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadPosition(UserType* output) const {
    
    CHECK(is_position());
    return mojo::internal::Deserialize<::device::mojom::GeopositionDataView>(
        data_->data.f_position.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  inline void GetErrorDataView(
      GeopositionErrorDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::GeopositionErrorDataView>(
        data_->data.f_error.Get(), output, message_);
  }

 private:
  internal::GeopositionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_GEOPOSITION_MOJOM_DATA_VIEW_H_