// services/device/public/mojom/geoposition.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_GEOPOSITION_MOJOM_BLINK_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_GEOPOSITION_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/geoposition.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/geoposition.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/geoposition.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace device::mojom::blink {






class BLINK_PLATFORM_EXPORT GeopositionError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GeopositionError, T>::value>;
  using DataView = GeopositionErrorDataView;
  using Data_ = internal::GeopositionError_Data;

  template <typename... Args>
  static GeopositionErrorPtr New(Args&&... args) {
    return GeopositionErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GeopositionErrorPtr From(const U& u) {
    return mojo::TypeConverter<GeopositionErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GeopositionError>::Convert(*this);
  }


  GeopositionError();

  GeopositionError(
      GeopositionErrorCode error_code,
      const ::blink::String& error_message,
      const ::blink::String& error_technical);


  ~GeopositionError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GeopositionErrorPtr>
  GeopositionErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GeopositionError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GeopositionError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GeopositionError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GeopositionError::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GeopositionError::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GeopositionError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GeopositionError_UnserializedMessageContext<
            UserType, GeopositionError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GeopositionError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GeopositionError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GeopositionError_UnserializedMessageContext<
            UserType, GeopositionError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GeopositionError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  GeopositionErrorCode error_code;
  
  ::blink::String error_message;
  
  ::blink::String error_technical;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GeopositionError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GeopositionError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GeopositionError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GeopositionError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT GeopositionResult {
 public:
  using DataView = GeopositionResultDataView;
  using Data_ = internal::GeopositionResult_Data;
  using Tag = Data_::GeopositionResult_Tag;

  template <typename... Args>
  static GeopositionResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |position|.
  static GeopositionResultPtr NewPosition(
      GeopositionPtr value);
  // Construct an instance holding |error|.
  static GeopositionResultPtr NewError(
      GeopositionErrorPtr value);

  template <typename U>
  static GeopositionResultPtr From(const U& u) {
    return mojo::TypeConverter<GeopositionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GeopositionResult>::Convert(*this);
  }
  ~GeopositionResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  GeopositionResult(const GeopositionResult& other) = delete;
  GeopositionResult& operator=(const GeopositionResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = GeopositionResultPtr>
  GeopositionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, GeopositionResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, GeopositionResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_position() const { return tag_ == Tag::kPosition; }
  const GeopositionPtr& get_position() const {
    CHECK(tag_ == Tag::kPosition);
    return data_.position;
  }
  GeopositionPtr& get_position() {
    CHECK(tag_ == Tag::kPosition);
    return data_.position;
  }
  void set_position(GeopositionPtr position);

  bool is_error() const { return tag_ == Tag::kError; }
  const GeopositionErrorPtr& get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  GeopositionErrorPtr& get_error() {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }
  void set_error(GeopositionErrorPtr error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GeopositionResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<GeopositionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPosition)>,
        GeopositionPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
        GeopositionErrorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    GeopositionPtr position;
    GeopositionErrorPtr error;
  };

  GeopositionResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kPosition)>,
      GeopositionPtr value);
  GeopositionResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
      GeopositionErrorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_PLATFORM_EXPORT Geoposition {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Geoposition, T>::value>;
  using DataView = GeopositionDataView;
  using Data_ = internal::Geoposition_Data;

  template <typename... Args>
  static GeopositionPtr New(Args&&... args) {
    return GeopositionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GeopositionPtr From(const U& u) {
    return mojo::TypeConverter<GeopositionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Geoposition>::Convert(*this);
  }


  Geoposition();

  Geoposition(
      double latitude,
      double longitude,
      double altitude,
      double accuracy,
      double altitude_accuracy,
      double heading,
      double speed,
      ::base::Time timestamp,
      bool is_precise);


  ~Geoposition();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GeopositionPtr>
  GeopositionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Geoposition::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Geoposition::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Geoposition::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Geoposition::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Geoposition::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Geoposition::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Geoposition_UnserializedMessageContext<
            UserType, Geoposition::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Geoposition::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Geoposition::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Geoposition_UnserializedMessageContext<
            UserType, Geoposition::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Geoposition::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double latitude;
  
  double longitude;
  
  double altitude;
  
  double accuracy;
  
  double altitude_accuracy;
  
  double heading;
  
  double speed;
  
  ::base::Time timestamp;
  
  bool is_precise;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Geoposition::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Geoposition::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Geoposition::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Geoposition::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename UnionPtrType>
GeopositionResultPtr GeopositionResult::Clone() const {
  switch (tag_) {
    case Tag::kPosition:
      return NewPosition(
          mojo::Clone(data_.position));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, GeopositionResult>::value>::type*>
bool GeopositionResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kPosition:
      return mojo::Equals(data_.position, other.data_.position);
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename StructPtrType>
GeopositionPtr Geoposition::Clone() const {
  return New(
      mojo::Clone(latitude),
      mojo::Clone(longitude),
      mojo::Clone(altitude),
      mojo::Clone(accuracy),
      mojo::Clone(altitude_accuracy),
      mojo::Clone(heading),
      mojo::Clone(speed),
      mojo::Clone(timestamp),
      mojo::Clone(is_precise)
  );
}

template <typename T, Geoposition::EnableIfSame<T>*>
bool Geoposition::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->latitude, other_struct.latitude))
    return false;
  if (!mojo::Equals(this->longitude, other_struct.longitude))
    return false;
  if (!mojo::Equals(this->altitude, other_struct.altitude))
    return false;
  if (!mojo::Equals(this->accuracy, other_struct.accuracy))
    return false;
  if (!mojo::Equals(this->altitude_accuracy, other_struct.altitude_accuracy))
    return false;
  if (!mojo::Equals(this->heading, other_struct.heading))
    return false;
  if (!mojo::Equals(this->speed, other_struct.speed))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->is_precise, other_struct.is_precise))
    return false;
  return true;
}

template <typename T, Geoposition::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.latitude < rhs.latitude)
    return true;
  if (rhs.latitude < lhs.latitude)
    return false;
  if (lhs.longitude < rhs.longitude)
    return true;
  if (rhs.longitude < lhs.longitude)
    return false;
  if (lhs.altitude < rhs.altitude)
    return true;
  if (rhs.altitude < lhs.altitude)
    return false;
  if (lhs.accuracy < rhs.accuracy)
    return true;
  if (rhs.accuracy < lhs.accuracy)
    return false;
  if (lhs.altitude_accuracy < rhs.altitude_accuracy)
    return true;
  if (rhs.altitude_accuracy < lhs.altitude_accuracy)
    return false;
  if (lhs.heading < rhs.heading)
    return true;
  if (rhs.heading < lhs.heading)
    return false;
  if (lhs.speed < rhs.speed)
    return true;
  if (rhs.speed < lhs.speed)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.is_precise < rhs.is_precise)
    return true;
  if (rhs.is_precise < lhs.is_precise)
    return false;
  return false;
}
template <typename StructPtrType>
GeopositionErrorPtr GeopositionError::Clone() const {
  return New(
      mojo::Clone(error_code),
      mojo::Clone(error_message),
      mojo::Clone(error_technical)
  );
}

template <typename T, GeopositionError::EnableIfSame<T>*>
bool GeopositionError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->error_code, other_struct.error_code))
    return false;
  if (!mojo::Equals(this->error_message, other_struct.error_message))
    return false;
  if (!mojo::Equals(this->error_technical, other_struct.error_technical))
    return false;
  return true;
}

template <typename T, GeopositionError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.error_code < rhs.error_code)
    return true;
  if (rhs.error_code < lhs.error_code)
    return false;
  if (lhs.error_message < rhs.error_message)
    return true;
  if (rhs.error_message < lhs.error_message)
    return false;
  if (lhs.error_technical < rhs.error_technical)
    return true;
  if (rhs.error_technical < lhs.error_technical)
    return false;
  return false;
}


}  // device::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::Geoposition::DataView,
                                         ::device::mojom::blink::GeopositionPtr> {
  static bool IsNull(const ::device::mojom::blink::GeopositionPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::GeopositionPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::Geoposition::latitude) latitude(
      const ::device::mojom::blink::GeopositionPtr& input) {
    return input->latitude;
  }

  static decltype(::device::mojom::blink::Geoposition::longitude) longitude(
      const ::device::mojom::blink::GeopositionPtr& input) {
    return input->longitude;
  }

  static decltype(::device::mojom::blink::Geoposition::altitude) altitude(
      const ::device::mojom::blink::GeopositionPtr& input) {
    return input->altitude;
  }

  static decltype(::device::mojom::blink::Geoposition::accuracy) accuracy(
      const ::device::mojom::blink::GeopositionPtr& input) {
    return input->accuracy;
  }

  static decltype(::device::mojom::blink::Geoposition::altitude_accuracy) altitude_accuracy(
      const ::device::mojom::blink::GeopositionPtr& input) {
    return input->altitude_accuracy;
  }

  static decltype(::device::mojom::blink::Geoposition::heading) heading(
      const ::device::mojom::blink::GeopositionPtr& input) {
    return input->heading;
  }

  static decltype(::device::mojom::blink::Geoposition::speed) speed(
      const ::device::mojom::blink::GeopositionPtr& input) {
    return input->speed;
  }

  static const decltype(::device::mojom::blink::Geoposition::timestamp)& timestamp(
      const ::device::mojom::blink::GeopositionPtr& input) {
    return input->timestamp;
  }

  static decltype(::device::mojom::blink::Geoposition::is_precise) is_precise(
      const ::device::mojom::blink::GeopositionPtr& input) {
    return input->is_precise;
  }

  static bool Read(::device::mojom::blink::Geoposition::DataView input, ::device::mojom::blink::GeopositionPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::GeopositionError::DataView,
                                         ::device::mojom::blink::GeopositionErrorPtr> {
  static bool IsNull(const ::device::mojom::blink::GeopositionErrorPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::GeopositionErrorPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::GeopositionError::error_code) error_code(
      const ::device::mojom::blink::GeopositionErrorPtr& input) {
    return input->error_code;
  }

  static const decltype(::device::mojom::blink::GeopositionError::error_message)& error_message(
      const ::device::mojom::blink::GeopositionErrorPtr& input) {
    return input->error_message;
  }

  static const decltype(::device::mojom::blink::GeopositionError::error_technical)& error_technical(
      const ::device::mojom::blink::GeopositionErrorPtr& input) {
    return input->error_technical;
  }

  static bool Read(::device::mojom::blink::GeopositionError::DataView input, ::device::mojom::blink::GeopositionErrorPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::device::mojom::blink::GeopositionResult::DataView,
                                        ::device::mojom::blink::GeopositionResultPtr> {
  static bool IsNull(const ::device::mojom::blink::GeopositionResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::GeopositionResultPtr* output) { output->reset(); }

  static ::device::mojom::blink::GeopositionResult::Tag GetTag(const ::device::mojom::blink::GeopositionResultPtr& input) {
    return input->which();
  }

  static const ::device::mojom::blink::GeopositionPtr& position(const ::device::mojom::blink::GeopositionResultPtr& input) {
    return input->get_position();
  }

  static const ::device::mojom::blink::GeopositionErrorPtr& error(const ::device::mojom::blink::GeopositionResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::device::mojom::blink::GeopositionResult::DataView input, ::device::mojom::blink::GeopositionResultPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_GEOPOSITION_MOJOM_BLINK_H_