// services/device/public/mojom/geolocation_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_INTERNALS_MOJOM_SHARED_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/geolocation_internals.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/device/public/mojom/geoposition.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/device/public/mojom/geolocation_internals.mojom-data-view.h"




namespace std {

template <>
struct hash<::device::mojom::LocationProviderManagerMode>
    : public mojo::internal::EnumHashImpl<::device::mojom::LocationProviderManagerMode> {};

template <>
struct hash<::device::mojom::GeolocationDiagnostics_ProviderState>
    : public mojo::internal::EnumHashImpl<::device::mojom::GeolocationDiagnostics_ProviderState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::LocationProviderManagerMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::LocationProviderManagerMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::LocationProviderManagerMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GeolocationDiagnostics_ProviderState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::GeolocationDiagnostics_ProviderState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::GeolocationDiagnostics_ProviderState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::AccessPointDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::AccessPointDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::AccessPointData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::mac_address(input)) in_mac_address = Traits::mac_address(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mac_address)::BaseType> mac_address_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_mac_address,
      mac_address_fragment);

    fragment->mac_address.Set(
        mac_address_fragment.is_null() ? nullptr : mac_address_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mac_address.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mac_address in AccessPointData struct");

    fragment->radio_signal_strength = Traits::radio_signal_strength(input);

    fragment->channel = Traits::channel(input);

    fragment->signal_to_noise = Traits::signal_to_noise(input);

    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_timestamp,
      timestamp_fragment);

    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());
  }

  static bool Deserialize(::device::mojom::internal::AccessPointData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::AccessPointDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::NetworkLocationDiagnosticsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::NetworkLocationDiagnosticsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::NetworkLocationDiagnostics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::access_point_data(input)) in_access_point_data = Traits::access_point_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->access_point_data)::BaseType>
        access_point_data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& access_point_data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::AccessPointDataDataView>>(
      in_access_point_data,
      access_point_data_fragment,
      &access_point_data_validate_params);

    fragment->access_point_data.Set(
        access_point_data_fragment.is_null() ? nullptr : access_point_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->access_point_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null access_point_data in NetworkLocationDiagnostics struct");

    decltype(Traits::wifi_timestamp(input)) in_wifi_timestamp = Traits::wifi_timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->wifi_timestamp)::BaseType> wifi_timestamp_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_wifi_timestamp,
      wifi_timestamp_fragment);

    fragment->wifi_timestamp.Set(
        wifi_timestamp_fragment.is_null() ? nullptr : wifi_timestamp_fragment.data());
  }

  static bool Deserialize(::device::mojom::internal::NetworkLocationDiagnostics_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::NetworkLocationDiagnosticsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::PositionCacheDiagnosticsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::PositionCacheDiagnosticsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::PositionCacheDiagnostics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->cache_size = Traits::cache_size(input);

    decltype(Traits::last_hit(input)) in_last_hit = Traits::last_hit(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_hit)::BaseType> last_hit_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_hit,
      last_hit_fragment);

    fragment->last_hit.Set(
        last_hit_fragment.is_null() ? nullptr : last_hit_fragment.data());

    decltype(Traits::last_miss(input)) in_last_miss = Traits::last_miss(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_miss)::BaseType> last_miss_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_miss,
      last_miss_fragment);

    fragment->last_miss.Set(
        last_miss_fragment.is_null() ? nullptr : last_miss_fragment.data());
    fragment->hit_rate_$flag = Traits::hit_rate(input).has_value();
    if (Traits::hit_rate(input).has_value()) {
      fragment->hit_rate_$value = Traits::hit_rate(input).value();
    }

    decltype(Traits::last_network_result(input)) in_last_network_result = Traits::last_network_result(input);
    mojo::internal::MessageFragment<decltype(fragment->last_network_result)>
        last_network_result_fragment(fragment.message());
    last_network_result_fragment.Claim(&fragment->last_network_result);
    
    mojo::internal::Serialize<::device::mojom::GeopositionResultDataView>(
      in_last_network_result,
      last_network_result_fragment,
      true);
  }

  static bool Deserialize(::device::mojom::internal::PositionCacheDiagnostics_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::PositionCacheDiagnosticsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::WifiPollingPolicyDiagnosticsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::WifiPollingPolicyDiagnosticsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::WifiPollingPolicyDiagnostics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::interval_start(input)) in_interval_start = Traits::interval_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->interval_start)::BaseType> interval_start_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_interval_start,
      interval_start_fragment);

    fragment->interval_start.Set(
        interval_start_fragment.is_null() ? nullptr : interval_start_fragment.data());

    decltype(Traits::interval_duration(input)) in_interval_duration = Traits::interval_duration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->interval_duration)::BaseType> interval_duration_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_interval_duration,
      interval_duration_fragment);

    fragment->interval_duration.Set(
        interval_duration_fragment.is_null() ? nullptr : interval_duration_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->interval_duration.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null interval_duration in WifiPollingPolicyDiagnostics struct");

    decltype(Traits::polling_interval(input)) in_polling_interval = Traits::polling_interval(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->polling_interval)::BaseType> polling_interval_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_polling_interval,
      polling_interval_fragment);

    fragment->polling_interval.Set(
        polling_interval_fragment.is_null() ? nullptr : polling_interval_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->polling_interval.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null polling_interval in WifiPollingPolicyDiagnostics struct");

    decltype(Traits::default_interval(input)) in_default_interval = Traits::default_interval(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->default_interval)::BaseType> default_interval_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_default_interval,
      default_interval_fragment);

    fragment->default_interval.Set(
        default_interval_fragment.is_null() ? nullptr : default_interval_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->default_interval.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_interval in WifiPollingPolicyDiagnostics struct");

    decltype(Traits::no_change_interval(input)) in_no_change_interval = Traits::no_change_interval(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->no_change_interval)::BaseType> no_change_interval_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_no_change_interval,
      no_change_interval_fragment);

    fragment->no_change_interval.Set(
        no_change_interval_fragment.is_null() ? nullptr : no_change_interval_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->no_change_interval.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null no_change_interval in WifiPollingPolicyDiagnostics struct");

    decltype(Traits::two_no_change_interval(input)) in_two_no_change_interval = Traits::two_no_change_interval(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->two_no_change_interval)::BaseType> two_no_change_interval_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_two_no_change_interval,
      two_no_change_interval_fragment);

    fragment->two_no_change_interval.Set(
        two_no_change_interval_fragment.is_null() ? nullptr : two_no_change_interval_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->two_no_change_interval.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null two_no_change_interval in WifiPollingPolicyDiagnostics struct");

    decltype(Traits::no_wifi_interval(input)) in_no_wifi_interval = Traits::no_wifi_interval(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->no_wifi_interval)::BaseType> no_wifi_interval_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_no_wifi_interval,
      no_wifi_interval_fragment);

    fragment->no_wifi_interval.Set(
        no_wifi_interval_fragment.is_null() ? nullptr : no_wifi_interval_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->no_wifi_interval.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null no_wifi_interval in WifiPollingPolicyDiagnostics struct");
  }

  static bool Deserialize(::device::mojom::internal::WifiPollingPolicyDiagnostics_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::WifiPollingPolicyDiagnosticsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::GeolocationDiagnosticsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GeolocationDiagnosticsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GeolocationDiagnostics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::device::mojom::GeolocationDiagnostics_ProviderState>(
      Traits::provider_state(input),
      &fragment->provider_state);

    decltype(Traits::network_location_diagnostics(input)) in_network_location_diagnostics = Traits::network_location_diagnostics(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->network_location_diagnostics)::BaseType> network_location_diagnostics_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::NetworkLocationDiagnosticsDataView>(
      in_network_location_diagnostics,
      network_location_diagnostics_fragment);

    fragment->network_location_diagnostics.Set(
        network_location_diagnostics_fragment.is_null() ? nullptr : network_location_diagnostics_fragment.data());

    decltype(Traits::position_cache_diagnostics(input)) in_position_cache_diagnostics = Traits::position_cache_diagnostics(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->position_cache_diagnostics)::BaseType> position_cache_diagnostics_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::PositionCacheDiagnosticsDataView>(
      in_position_cache_diagnostics,
      position_cache_diagnostics_fragment);

    fragment->position_cache_diagnostics.Set(
        position_cache_diagnostics_fragment.is_null() ? nullptr : position_cache_diagnostics_fragment.data());

    decltype(Traits::wifi_polling_policy_diagnostics(input)) in_wifi_polling_policy_diagnostics = Traits::wifi_polling_policy_diagnostics(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->wifi_polling_policy_diagnostics)::BaseType> wifi_polling_policy_diagnostics_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::device::mojom::WifiPollingPolicyDiagnosticsDataView>(
      in_wifi_polling_policy_diagnostics,
      wifi_polling_policy_diagnostics_fragment);

    fragment->wifi_polling_policy_diagnostics.Set(
        wifi_polling_policy_diagnostics_fragment.is_null() ? nullptr : wifi_polling_policy_diagnostics_fragment.data());
    fragment->location_provider_manager_mode_$flag = Traits::location_provider_manager_mode(input).has_value();
    if (Traits::location_provider_manager_mode(input).has_value()) {
      
      mojo::internal::Serialize<::device::mojom::LocationProviderManagerMode>(
        Traits::location_provider_manager_mode(input).value(),
        &fragment->location_provider_manager_mode_$value);
    } else {
      fragment->location_provider_manager_mode_$value =
          static_cast<int32_t>(::device::mojom::LocationProviderManagerMode::kMinValue);
    }
  }

  static bool Deserialize(::device::mojom::internal::GeolocationDiagnostics_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::GeolocationDiagnosticsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::NetworkLocationResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::NetworkLocationResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::NetworkLocationResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->latitude = Traits::latitude(input);

    fragment->longitude = Traits::longitude(input);
    fragment->accuracy_$flag = Traits::accuracy(input).has_value();
    if (Traits::accuracy(input).has_value()) {
      fragment->accuracy_$value = Traits::accuracy(input).value();
    }
  }

  static bool Deserialize(::device::mojom::internal::NetworkLocationResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::NetworkLocationResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {

inline void AccessPointDataDataView::GetMacAddressDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mac_address.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AccessPointDataDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void NetworkLocationDiagnosticsDataView::GetAccessPointDataDataView(
    mojo::ArrayDataView<AccessPointDataDataView>* output) {
  auto pointer = data_->access_point_data.Get();
  *output = mojo::ArrayDataView<AccessPointDataDataView>(pointer, message_);
}
inline void NetworkLocationDiagnosticsDataView::GetWifiTimestampDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->wifi_timestamp.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void PositionCacheDiagnosticsDataView::GetLastHitDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_hit.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void PositionCacheDiagnosticsDataView::GetLastMissDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_miss.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void PositionCacheDiagnosticsDataView::GetLastNetworkResultDataView(
    ::device::mojom::GeopositionResultDataView* output) {
  auto pointer = &data_->last_network_result;
  *output = ::device::mojom::GeopositionResultDataView(pointer, message_);
}


inline void WifiPollingPolicyDiagnosticsDataView::GetIntervalStartDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->interval_start.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void WifiPollingPolicyDiagnosticsDataView::GetIntervalDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->interval_duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void WifiPollingPolicyDiagnosticsDataView::GetPollingIntervalDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->polling_interval.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void WifiPollingPolicyDiagnosticsDataView::GetDefaultIntervalDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->default_interval.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void WifiPollingPolicyDiagnosticsDataView::GetNoChangeIntervalDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->no_change_interval.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void WifiPollingPolicyDiagnosticsDataView::GetTwoNoChangeIntervalDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->two_no_change_interval.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void WifiPollingPolicyDiagnosticsDataView::GetNoWifiIntervalDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->no_wifi_interval.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void GeolocationDiagnosticsDataView::GetNetworkLocationDiagnosticsDataView(
    NetworkLocationDiagnosticsDataView* output) {
  auto pointer = data_->network_location_diagnostics.Get();
  *output = NetworkLocationDiagnosticsDataView(pointer, message_);
}
inline void GeolocationDiagnosticsDataView::GetPositionCacheDiagnosticsDataView(
    PositionCacheDiagnosticsDataView* output) {
  auto pointer = data_->position_cache_diagnostics.Get();
  *output = PositionCacheDiagnosticsDataView(pointer, message_);
}
inline void GeolocationDiagnosticsDataView::GetWifiPollingPolicyDiagnosticsDataView(
    WifiPollingPolicyDiagnosticsDataView* output) {
  auto pointer = data_->wifi_polling_policy_diagnostics.Get();
  *output = WifiPollingPolicyDiagnosticsDataView(pointer, message_);
}





}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::LocationProviderManagerMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::LocationProviderManagerMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::GeolocationDiagnostics_ProviderState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::GeolocationDiagnostics_ProviderState value);
};

} // namespace perfetto

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_INTERNALS_MOJOM_SHARED_H_