// services/device/public/mojom/geolocation_internals.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_INTERNALS_MOJOM_SEND_VALIDATION_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_INTERNALS_MOJOM_SEND_VALIDATION_H_

#include "services/device/public/mojom/geolocation_internals.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/device/public/mojom/geoposition.mojom-shared.h"

#include "services/device/public/mojom/geolocation_internals.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::LocationProviderManagerMode, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::AccessPointDataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::AccessPointDataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::AccessPointData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::mac_address(input)) in_mac_address = Traits::mac_address(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->mac_address)::BaseType> mac_address_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_mac_address,
        mac_address_fragment);

      fragment->mac_address.Set(
          mac_address_fragment.is_null() ? nullptr : mac_address_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->mac_address.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mac_address in AccessPointData struct");

      fragment->radio_signal_strength = Traits::radio_signal_strength(input);

      fragment->channel = Traits::channel(input);

      fragment->signal_to_noise = Traits::signal_to_noise(input);

      decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_timestamp,
        timestamp_fragment);

      fragment->timestamp.Set(
          timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::NetworkLocationDiagnosticsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::NetworkLocationDiagnosticsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::NetworkLocationDiagnostics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::access_point_data(input)) in_access_point_data = Traits::access_point_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->access_point_data)::BaseType>
          access_point_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& access_point_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::AccessPointDataDataView>, send_validation>(
        in_access_point_data,
        access_point_data_fragment,
        &access_point_data_validate_params);

      fragment->access_point_data.Set(
          access_point_data_fragment.is_null() ? nullptr : access_point_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->access_point_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null access_point_data in NetworkLocationDiagnostics struct");

      decltype(Traits::wifi_timestamp(input)) in_wifi_timestamp = Traits::wifi_timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->wifi_timestamp)::BaseType> wifi_timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_wifi_timestamp,
        wifi_timestamp_fragment);

      fragment->wifi_timestamp.Set(
          wifi_timestamp_fragment.is_null() ? nullptr : wifi_timestamp_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::PositionCacheDiagnosticsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::PositionCacheDiagnosticsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::PositionCacheDiagnostics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->cache_size = Traits::cache_size(input);

      decltype(Traits::last_hit(input)) in_last_hit = Traits::last_hit(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_hit)::BaseType> last_hit_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_hit,
        last_hit_fragment);

      fragment->last_hit.Set(
          last_hit_fragment.is_null() ? nullptr : last_hit_fragment.data());

      decltype(Traits::last_miss(input)) in_last_miss = Traits::last_miss(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_miss)::BaseType> last_miss_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_last_miss,
        last_miss_fragment);

      fragment->last_miss.Set(
          last_miss_fragment.is_null() ? nullptr : last_miss_fragment.data());
      fragment->hit_rate_$flag = Traits::hit_rate(input).has_value();
      if (Traits::hit_rate(input).has_value()) {
        fragment->hit_rate_$value = Traits::hit_rate(input).value();
      }

      decltype(Traits::last_network_result(input)) in_last_network_result = Traits::last_network_result(input);
      mojo::internal::MessageFragment<decltype(fragment->last_network_result)>
          last_network_result_fragment(fragment.message());
      last_network_result_fragment.Claim(&fragment->last_network_result);
      
      mojo::internal::Serialize<::device::mojom::GeopositionResultDataView, send_validation>(
        in_last_network_result,
        last_network_result_fragment,
        true);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::WifiPollingPolicyDiagnosticsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::WifiPollingPolicyDiagnosticsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::WifiPollingPolicyDiagnostics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::interval_start(input)) in_interval_start = Traits::interval_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->interval_start)::BaseType> interval_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_interval_start,
        interval_start_fragment);

      fragment->interval_start.Set(
          interval_start_fragment.is_null() ? nullptr : interval_start_fragment.data());

      decltype(Traits::interval_duration(input)) in_interval_duration = Traits::interval_duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->interval_duration)::BaseType> interval_duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_interval_duration,
        interval_duration_fragment);

      fragment->interval_duration.Set(
          interval_duration_fragment.is_null() ? nullptr : interval_duration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->interval_duration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null interval_duration in WifiPollingPolicyDiagnostics struct");

      decltype(Traits::polling_interval(input)) in_polling_interval = Traits::polling_interval(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->polling_interval)::BaseType> polling_interval_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_polling_interval,
        polling_interval_fragment);

      fragment->polling_interval.Set(
          polling_interval_fragment.is_null() ? nullptr : polling_interval_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->polling_interval.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null polling_interval in WifiPollingPolicyDiagnostics struct");

      decltype(Traits::default_interval(input)) in_default_interval = Traits::default_interval(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->default_interval)::BaseType> default_interval_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_default_interval,
        default_interval_fragment);

      fragment->default_interval.Set(
          default_interval_fragment.is_null() ? nullptr : default_interval_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->default_interval.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null default_interval in WifiPollingPolicyDiagnostics struct");

      decltype(Traits::no_change_interval(input)) in_no_change_interval = Traits::no_change_interval(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->no_change_interval)::BaseType> no_change_interval_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_no_change_interval,
        no_change_interval_fragment);

      fragment->no_change_interval.Set(
          no_change_interval_fragment.is_null() ? nullptr : no_change_interval_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->no_change_interval.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null no_change_interval in WifiPollingPolicyDiagnostics struct");

      decltype(Traits::two_no_change_interval(input)) in_two_no_change_interval = Traits::two_no_change_interval(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->two_no_change_interval)::BaseType> two_no_change_interval_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_two_no_change_interval,
        two_no_change_interval_fragment);

      fragment->two_no_change_interval.Set(
          two_no_change_interval_fragment.is_null() ? nullptr : two_no_change_interval_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->two_no_change_interval.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null two_no_change_interval in WifiPollingPolicyDiagnostics struct");

      decltype(Traits::no_wifi_interval(input)) in_no_wifi_interval = Traits::no_wifi_interval(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->no_wifi_interval)::BaseType> no_wifi_interval_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_no_wifi_interval,
        no_wifi_interval_fragment);

      fragment->no_wifi_interval.Set(
          no_wifi_interval_fragment.is_null() ? nullptr : no_wifi_interval_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->no_wifi_interval.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null no_wifi_interval in WifiPollingPolicyDiagnostics struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::GeolocationDiagnosticsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::GeolocationDiagnosticsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::GeolocationDiagnostics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::device::mojom::GeolocationDiagnostics_ProviderState>(
        Traits::provider_state(input),
        &fragment->provider_state);

      decltype(Traits::network_location_diagnostics(input)) in_network_location_diagnostics = Traits::network_location_diagnostics(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->network_location_diagnostics)::BaseType> network_location_diagnostics_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::NetworkLocationDiagnosticsDataView, send_validation>(
        in_network_location_diagnostics,
        network_location_diagnostics_fragment);

      fragment->network_location_diagnostics.Set(
          network_location_diagnostics_fragment.is_null() ? nullptr : network_location_diagnostics_fragment.data());

      decltype(Traits::position_cache_diagnostics(input)) in_position_cache_diagnostics = Traits::position_cache_diagnostics(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->position_cache_diagnostics)::BaseType> position_cache_diagnostics_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::PositionCacheDiagnosticsDataView, send_validation>(
        in_position_cache_diagnostics,
        position_cache_diagnostics_fragment);

      fragment->position_cache_diagnostics.Set(
          position_cache_diagnostics_fragment.is_null() ? nullptr : position_cache_diagnostics_fragment.data());

      decltype(Traits::wifi_polling_policy_diagnostics(input)) in_wifi_polling_policy_diagnostics = Traits::wifi_polling_policy_diagnostics(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->wifi_polling_policy_diagnostics)::BaseType> wifi_polling_policy_diagnostics_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::WifiPollingPolicyDiagnosticsDataView, send_validation>(
        in_wifi_polling_policy_diagnostics,
        wifi_polling_policy_diagnostics_fragment);

      fragment->wifi_polling_policy_diagnostics.Set(
          wifi_polling_policy_diagnostics_fragment.is_null() ? nullptr : wifi_polling_policy_diagnostics_fragment.data());
      fragment->location_provider_manager_mode_$flag = Traits::location_provider_manager_mode(input).has_value();
      if (Traits::location_provider_manager_mode(input).has_value()) {
        
        mojo::internal::Serialize<::device::mojom::LocationProviderManagerMode>(
          Traits::location_provider_manager_mode(input).value(),
          &fragment->location_provider_manager_mode_$value);
      } else {
        fragment->location_provider_manager_mode_$value =
            static_cast<int32_t>(::device::mojom::LocationProviderManagerMode::kMinValue);
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::NetworkLocationResponseDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::NetworkLocationResponseDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::NetworkLocationResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->latitude = Traits::latitude(input);

      fragment->longitude = Traits::longitude(input);
      fragment->accuracy_$flag = Traits::accuracy(input).has_value();
      if (Traits::accuracy(input).has_value()) {
        fragment->accuracy_$value = Traits::accuracy(input).value();
      }
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_INTERNALS_MOJOM_SEND_VALIDATION_H_