// services/device/public/mojom/geolocation_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_INTERNALS_MOJOM_DATA_VIEW_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/device/public/mojom/geolocation_internals.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/device/public/mojom/geoposition.mojom-shared.h"


namespace device::mojom {
class AccessPointDataDataView;

class NetworkLocationDiagnosticsDataView;

class PositionCacheDiagnosticsDataView;

class WifiPollingPolicyDiagnosticsDataView;

class GeolocationDiagnosticsDataView;

class NetworkLocationResponseDataView;



}  // device::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::AccessPointDataDataView> {
  using Data = ::device::mojom::internal::AccessPointData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::NetworkLocationDiagnosticsDataView> {
  using Data = ::device::mojom::internal::NetworkLocationDiagnostics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::PositionCacheDiagnosticsDataView> {
  using Data = ::device::mojom::internal::PositionCacheDiagnostics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::WifiPollingPolicyDiagnosticsDataView> {
  using Data = ::device::mojom::internal::WifiPollingPolicyDiagnostics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::GeolocationDiagnosticsDataView> {
  using Data = ::device::mojom::internal::GeolocationDiagnostics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::NetworkLocationResponseDataView> {
  using Data = ::device::mojom::internal::NetworkLocationResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class LocationProviderManagerMode : int32_t {
  
  kNetworkOnly = 0,
  
  kPlatformOnly = 1,
  
  kCustomOnly = 2,
  
  kHybridPlatform = 3,
  
  kHybridFallbackNetwork = 4,
  
  kHybridPlatform2 = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, LocationProviderManagerMode value);
inline bool IsKnownEnumValue(LocationProviderManagerMode value) {
  return internal::LocationProviderManagerMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GeolocationDiagnostics_ProviderState : int32_t {
  
  kStopped = 0,
  
  kHighAccuracy = 1,
  
  kLowAccuracy = 2,
  
  kBlockedBySystemPermission = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, GeolocationDiagnostics_ProviderState value);
inline bool IsKnownEnumValue(GeolocationDiagnostics_ProviderState value) {
  return internal::GeolocationDiagnostics_ProviderState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline GeolocationDiagnostics_ProviderState ToKnownEnumValue(GeolocationDiagnostics_ProviderState value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return GeolocationDiagnostics_ProviderState::kDefaultValue;
}
// Interface base classes. They are used for type safety check.
class GeolocationInternalsObserverInterfaceBase {};

using GeolocationInternalsObserverPtrDataView =
    mojo::InterfacePtrDataView<GeolocationInternalsObserverInterfaceBase>;
using GeolocationInternalsObserverRequestDataView =
    mojo::InterfaceRequestDataView<GeolocationInternalsObserverInterfaceBase>;
using GeolocationInternalsObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GeolocationInternalsObserverInterfaceBase>;
using GeolocationInternalsObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GeolocationInternalsObserverInterfaceBase>;
class GeolocationInternalsInterfaceBase {};

using GeolocationInternalsPtrDataView =
    mojo::InterfacePtrDataView<GeolocationInternalsInterfaceBase>;
using GeolocationInternalsRequestDataView =
    mojo::InterfaceRequestDataView<GeolocationInternalsInterfaceBase>;
using GeolocationInternalsAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GeolocationInternalsInterfaceBase>;
using GeolocationInternalsAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GeolocationInternalsInterfaceBase>;


class AccessPointDataDataView {
 public:
  AccessPointDataDataView() = default;

  AccessPointDataDataView(
      internal::AccessPointData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMacAddressDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMacAddress(UserType* output) {
    
    auto* pointer = data_->mac_address.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t radio_signal_strength() const {
    return data_->radio_signal_strength;
  }
  int32_t channel() const {
    return data_->channel;
  }
  int32_t signal_to_noise() const {
    return data_->signal_to_noise;
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `timestamp` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTimestamp` instead "
    "of `ReadTimestamp if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::AccessPointData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkLocationDiagnosticsDataView {
 public:
  NetworkLocationDiagnosticsDataView() = default;

  NetworkLocationDiagnosticsDataView(
      internal::NetworkLocationDiagnostics_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAccessPointDataDataView(
      mojo::ArrayDataView<AccessPointDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccessPointData(UserType* output) {
    
    auto* pointer = data_->access_point_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::AccessPointDataDataView>>(
        pointer, output, message_);
  }
  inline void GetWifiTimestampDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWifiTimestamp(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `wifi_timestamp` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWifiTimestamp` instead "
    "of `ReadWifiTimestamp if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->wifi_timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetworkLocationDiagnostics_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PositionCacheDiagnosticsDataView {
 public:
  PositionCacheDiagnosticsDataView() = default;

  PositionCacheDiagnosticsDataView(
      internal::PositionCacheDiagnostics_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t cache_size() const {
    return data_->cache_size;
  }
  inline void GetLastHitDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastHit(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `last_hit` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLastHit` instead "
    "of `ReadLastHit if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->last_hit.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetLastMissDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastMiss(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `last_miss` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLastMiss` instead "
    "of `ReadLastMiss if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->last_miss.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  std::optional<double> hit_rate() const {

    return data_->hit_rate_$flag
        ? std::make_optional(data_->hit_rate_$value)
        : std::nullopt;
  }
  inline void GetLastNetworkResultDataView(
      ::device::mojom::GeopositionResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastNetworkResult(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::GeopositionResultDataView, UserType>(),
    "Attempting to read the optional `last_network_result` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLastNetworkResult` instead "
    "of `ReadLastNetworkResult if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->last_network_result.is_null() ? &data_->last_network_result : nullptr;
    return mojo::internal::Deserialize<::device::mojom::GeopositionResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::PositionCacheDiagnostics_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WifiPollingPolicyDiagnosticsDataView {
 public:
  WifiPollingPolicyDiagnosticsDataView() = default;

  WifiPollingPolicyDiagnosticsDataView(
      internal::WifiPollingPolicyDiagnostics_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIntervalStartDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIntervalStart(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDataView, UserType>(),
    "Attempting to read the optional `interval_start` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIntervalStart` instead "
    "of `ReadIntervalStart if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->interval_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetIntervalDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIntervalDuration(UserType* output) {
    
    auto* pointer = data_->interval_duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetPollingIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPollingInterval(UserType* output) {
    
    auto* pointer = data_->polling_interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDefaultIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDefaultInterval(UserType* output) {
    
    auto* pointer = data_->default_interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetNoChangeIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNoChangeInterval(UserType* output) {
    
    auto* pointer = data_->no_change_interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetTwoNoChangeIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTwoNoChangeInterval(UserType* output) {
    
    auto* pointer = data_->two_no_change_interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetNoWifiIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNoWifiInterval(UserType* output) {
    
    auto* pointer = data_->no_wifi_interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::WifiPollingPolicyDiagnostics_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GeolocationDiagnosticsDataView {
 public:
  GeolocationDiagnosticsDataView() = default;

  GeolocationDiagnosticsDataView(
      internal::GeolocationDiagnostics_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadProviderState(UserType* output) const {
    auto data_value = data_->provider_state;
    return mojo::internal::Deserialize<::device::mojom::GeolocationDiagnostics_ProviderState>(
        data_value, output);
  }
  GeolocationDiagnostics_ProviderState provider_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::GeolocationDiagnostics_ProviderState>(data_->provider_state));
  }
  inline void GetNetworkLocationDiagnosticsDataView(
      NetworkLocationDiagnosticsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNetworkLocationDiagnostics(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::NetworkLocationDiagnosticsDataView, UserType>(),
    "Attempting to read the optional `network_location_diagnostics` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNetworkLocationDiagnostics` instead "
    "of `ReadNetworkLocationDiagnostics if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->network_location_diagnostics.Get();
    return mojo::internal::Deserialize<::device::mojom::NetworkLocationDiagnosticsDataView>(
        pointer, output, message_);
  }
  inline void GetPositionCacheDiagnosticsDataView(
      PositionCacheDiagnosticsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPositionCacheDiagnostics(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::PositionCacheDiagnosticsDataView, UserType>(),
    "Attempting to read the optional `position_cache_diagnostics` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPositionCacheDiagnostics` instead "
    "of `ReadPositionCacheDiagnostics if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->position_cache_diagnostics.Get();
    return mojo::internal::Deserialize<::device::mojom::PositionCacheDiagnosticsDataView>(
        pointer, output, message_);
  }
  inline void GetWifiPollingPolicyDiagnosticsDataView(
      WifiPollingPolicyDiagnosticsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWifiPollingPolicyDiagnostics(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::WifiPollingPolicyDiagnosticsDataView, UserType>(),
    "Attempting to read the optional `wifi_polling_policy_diagnostics` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWifiPollingPolicyDiagnostics` instead "
    "of `ReadWifiPollingPolicyDiagnostics if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->wifi_polling_policy_diagnostics.Get();
    return mojo::internal::Deserialize<::device::mojom::WifiPollingPolicyDiagnosticsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadLocationProviderManagerMode(UserType* output) const {
    if (!data_->location_provider_manager_mode_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::device::mojom::LocationProviderManagerMode>(
        data_->location_provider_manager_mode_$value, &output->emplace());
  }
  std::optional<LocationProviderManagerMode> location_provider_manager_mode() const {
    if (!data_->location_provider_manager_mode_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::LocationProviderManagerMode>(data_->location_provider_manager_mode_$value));
  }
 private:
  internal::GeolocationDiagnostics_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkLocationResponseDataView {
 public:
  NetworkLocationResponseDataView() = default;

  NetworkLocationResponseDataView(
      internal::NetworkLocationResponse_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double latitude() const {
    return data_->latitude;
  }
  double longitude() const {
    return data_->longitude;
  }
  std::optional<double> accuracy() const {

    return data_->accuracy_$flag
        ? std::make_optional(data_->accuracy_$value)
        : std::nullopt;
  }
 private:
  internal::NetworkLocationResponse_Data* data_ = nullptr;
};


}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_INTERNALS_MOJOM_DATA_VIEW_H_