// services/device/public/mojom/geolocation_control.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class GeolocationControlPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.GeolocationControl', scope);
  }
}

/** @interface */
export class GeolocationControlInterface {
  
  /**
   */

  userDidOptIntoLocationServices() {}
}

/**
 * @implements { GeolocationControlInterface }
 */
export class GeolocationControlRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!GeolocationControlPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          GeolocationControlPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!GeolocationControlPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  userDidOptIntoLocationServices() {
    this.proxy.sendMessage(
        0,
        GeolocationControl_UserDidOptIntoLocationServices_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the GeolocationControl
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class GeolocationControlReceiver {
  /**
   * @param {!GeolocationControlInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!GeolocationControlRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        GeolocationControlRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GeolocationControlRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        GeolocationControl_UserDidOptIntoLocationServices_ParamsSpec.$,
        null,
        impl.userDidOptIntoLocationServices.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class GeolocationControl {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.GeolocationControl";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!GeolocationControlRemote}
   */
  static getRemote() {
    let remote = new GeolocationControlRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the GeolocationControl
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class GeolocationControlCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      GeolocationControlRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!GeolocationControlRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.userDidOptIntoLocationServices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        GeolocationControl_UserDidOptIntoLocationServices_ParamsSpec.$,
        null,
        this.userDidOptIntoLocationServices.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GeolocationControl_UserDidOptIntoLocationServices_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    GeolocationControl_UserDidOptIntoLocationServices_ParamsSpec.$,
    'GeolocationControl_UserDidOptIntoLocationServices_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class GeolocationControl_UserDidOptIntoLocationServices_Params {
  constructor() {
  }
}

