// services/device/public/mojom/geolocation_context.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/device/public/mojom/geolocation_context.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('device.mojom');
  var geolocation$ =
      mojo.internal.exposeNamespace('device.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/device/public/mojom/geolocation.mojom', 'geolocation.mojom.js');
  }
  var geolocation_client_id$ =
      mojo.internal.exposeNamespace('device.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/device/public/mojom/geolocation_client_id.mojom', 'geolocation_client_id.mojom.js');
  }
  var geoposition$ =
      mojo.internal.exposeNamespace('device.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/device/public/mojom/geoposition.mojom', 'geoposition.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../url/mojom/origin.mojom.js');
  }


  var GeolocationPermissionLevel = {};
  GeolocationPermissionLevel.kDenied = 0;
  GeolocationPermissionLevel.kApproximate = 1;
  GeolocationPermissionLevel.kPrecise = 2;
  GeolocationPermissionLevel.MIN_VALUE = 0;
  GeolocationPermissionLevel.MAX_VALUE = 2;

  GeolocationPermissionLevel.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  GeolocationPermissionLevel.toKnownEnumValue = function(value) {
    return value;
  };

  GeolocationPermissionLevel.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function GeolocationContext_BindGeolocation_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GeolocationContext_BindGeolocation_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
    this.clientId = 0;
    this.requestingUrl = null;
    this.hasPrecisePermission = false;
  };
  GeolocationContext_BindGeolocation_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GeolocationContext_BindGeolocation_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GeolocationContext_BindGeolocation_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate GeolocationContext_BindGeolocation_Params.requestingUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GeolocationContext_BindGeolocation_Params.clientId
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, geolocation_client_id$.GeolocationClientId);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  GeolocationContext_BindGeolocation_Params.encodedSize = codec.kStructHeaderSize + 24;

  GeolocationContext_BindGeolocation_Params.decode = function(decoder) {
    var packed;
    var val = new GeolocationContext_BindGeolocation_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.clientId =
        decoder.decodeStruct(new codec.Enum(geolocation_client_id$.GeolocationClientId));
    val.requestingUrl =
        decoder.decodeStructPointer(url$.Url);
    packed = decoder.readUint8();
    val.hasPrecisePermission = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  GeolocationContext_BindGeolocation_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GeolocationContext_BindGeolocation_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.encodeStruct(codec.Int32, val.clientId);
    encoder.encodeStructPointer(url$.Url, val.requestingUrl);
    packed = 0;
    packed |= (val.hasPrecisePermission & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function GeolocationContext_OnPermissionUpdated_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GeolocationContext_OnPermissionUpdated_Params.prototype.initDefaults_ = function() {
    this.origin = null;
    this.permissionLevel = 0;
  };
  GeolocationContext_OnPermissionUpdated_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GeolocationContext_OnPermissionUpdated_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GeolocationContext_OnPermissionUpdated_Params.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GeolocationContext_OnPermissionUpdated_Params.permissionLevel
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, GeolocationPermissionLevel);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GeolocationContext_OnPermissionUpdated_Params.encodedSize = codec.kStructHeaderSize + 16;

  GeolocationContext_OnPermissionUpdated_Params.decode = function(decoder) {
    var packed;
    var val = new GeolocationContext_OnPermissionUpdated_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    val.permissionLevel =
        decoder.decodeStruct(new codec.Enum(GeolocationPermissionLevel));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  GeolocationContext_OnPermissionUpdated_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GeolocationContext_OnPermissionUpdated_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
    encoder.encodeStruct(codec.Int32, val.permissionLevel);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function GeolocationContext_SetOverride_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GeolocationContext_SetOverride_Params.prototype.initDefaults_ = function() {
    this.result = null;
  };
  GeolocationContext_SetOverride_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GeolocationContext_SetOverride_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GeolocationContext_SetOverride_Params.result
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 0, geoposition$.GeopositionResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GeolocationContext_SetOverride_Params.encodedSize = codec.kStructHeaderSize + 16;

  GeolocationContext_SetOverride_Params.decode = function(decoder) {
    var packed;
    var val = new GeolocationContext_SetOverride_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStruct(geoposition$.GeopositionResult);
    return val;
  };

  GeolocationContext_SetOverride_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GeolocationContext_SetOverride_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(geoposition$.GeopositionResult, val.result);
  };
  function GeolocationContext_ClearOverride_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GeolocationContext_ClearOverride_Params.prototype.initDefaults_ = function() {
  };
  GeolocationContext_ClearOverride_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GeolocationContext_ClearOverride_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GeolocationContext_ClearOverride_Params.encodedSize = codec.kStructHeaderSize + 0;

  GeolocationContext_ClearOverride_Params.decode = function(decoder) {
    var packed;
    var val = new GeolocationContext_ClearOverride_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  GeolocationContext_ClearOverride_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GeolocationContext_ClearOverride_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kGeolocationContext_BindGeolocation_Name = 0;
  var kGeolocationContext_OnPermissionUpdated_Name = 1;
  var kGeolocationContext_SetOverride_Name = 2;
  var kGeolocationContext_ClearOverride_Name = 3;

  function GeolocationContextPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(GeolocationContext,
                                                   handleOrPtrInfo);
  }

  function GeolocationContextAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        GeolocationContext, associatedInterfacePtrInfo);
  }

  GeolocationContextAssociatedPtr.prototype =
      Object.create(GeolocationContextPtr.prototype);
  GeolocationContextAssociatedPtr.prototype.constructor =
      GeolocationContextAssociatedPtr;

  function GeolocationContextProxy(receiver) {
    this.receiver_ = receiver;
  }
  GeolocationContextPtr.prototype.bindGeolocation = function() {
    return GeolocationContextProxy.prototype.bindGeolocation
        .apply(this.ptr.getProxy(), arguments);
  };

  GeolocationContextProxy.prototype.bindGeolocation = function(receiver, requestingUrl, clientId, hasPrecisePermission) {
    var params_ = new GeolocationContext_BindGeolocation_Params();
    params_.receiver = receiver;
    params_.requestingUrl = requestingUrl;
    params_.clientId = clientId;
    params_.hasPrecisePermission = hasPrecisePermission;
    var builder = new codec.MessageV0Builder(
        kGeolocationContext_BindGeolocation_Name,
        codec.align(GeolocationContext_BindGeolocation_Params.encodedSize));
    builder.encodeStruct(GeolocationContext_BindGeolocation_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  GeolocationContextPtr.prototype.onPermissionUpdated = function() {
    return GeolocationContextProxy.prototype.onPermissionUpdated
        .apply(this.ptr.getProxy(), arguments);
  };

  GeolocationContextProxy.prototype.onPermissionUpdated = function(origin, permissionLevel) {
    var params_ = new GeolocationContext_OnPermissionUpdated_Params();
    params_.origin = origin;
    params_.permissionLevel = permissionLevel;
    var builder = new codec.MessageV0Builder(
        kGeolocationContext_OnPermissionUpdated_Name,
        codec.align(GeolocationContext_OnPermissionUpdated_Params.encodedSize));
    builder.encodeStruct(GeolocationContext_OnPermissionUpdated_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  GeolocationContextPtr.prototype.setOverride = function() {
    return GeolocationContextProxy.prototype.setOverride
        .apply(this.ptr.getProxy(), arguments);
  };

  GeolocationContextProxy.prototype.setOverride = function(result) {
    var params_ = new GeolocationContext_SetOverride_Params();
    params_.result = result;
    var builder = new codec.MessageV0Builder(
        kGeolocationContext_SetOverride_Name,
        codec.align(GeolocationContext_SetOverride_Params.encodedSize));
    builder.encodeStruct(GeolocationContext_SetOverride_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  GeolocationContextPtr.prototype.clearOverride = function() {
    return GeolocationContextProxy.prototype.clearOverride
        .apply(this.ptr.getProxy(), arguments);
  };

  GeolocationContextProxy.prototype.clearOverride = function() {
    var params_ = new GeolocationContext_ClearOverride_Params();
    var builder = new codec.MessageV0Builder(
        kGeolocationContext_ClearOverride_Name,
        codec.align(GeolocationContext_ClearOverride_Params.encodedSize));
    builder.encodeStruct(GeolocationContext_ClearOverride_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function GeolocationContextStub(delegate) {
    this.delegate_ = delegate;
  }
  GeolocationContextStub.prototype.bindGeolocation = function(receiver, requestingUrl, clientId, hasPrecisePermission) {
    return this.delegate_ && this.delegate_.bindGeolocation && this.delegate_.bindGeolocation(receiver, requestingUrl, clientId, hasPrecisePermission);
  }
  GeolocationContextStub.prototype.onPermissionUpdated = function(origin, permissionLevel) {
    return this.delegate_ && this.delegate_.onPermissionUpdated && this.delegate_.onPermissionUpdated(origin, permissionLevel);
  }
  GeolocationContextStub.prototype.setOverride = function(result) {
    return this.delegate_ && this.delegate_.setOverride && this.delegate_.setOverride(result);
  }
  GeolocationContextStub.prototype.clearOverride = function() {
    return this.delegate_ && this.delegate_.clearOverride && this.delegate_.clearOverride();
  }

  GeolocationContextStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kGeolocationContext_BindGeolocation_Name:
      var params = reader.decodeStruct(GeolocationContext_BindGeolocation_Params);
      this.bindGeolocation(params.receiver, params.requestingUrl, params.clientId, params.hasPrecisePermission);
      return true;
    case kGeolocationContext_OnPermissionUpdated_Name:
      var params = reader.decodeStruct(GeolocationContext_OnPermissionUpdated_Params);
      this.onPermissionUpdated(params.origin, params.permissionLevel);
      return true;
    case kGeolocationContext_SetOverride_Name:
      var params = reader.decodeStruct(GeolocationContext_SetOverride_Params);
      this.setOverride(params.result);
      return true;
    case kGeolocationContext_ClearOverride_Name:
      var params = reader.decodeStruct(GeolocationContext_ClearOverride_Params);
      this.clearOverride();
      return true;
    default:
      return false;
    }
  };

  GeolocationContextStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateGeolocationContextRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kGeolocationContext_BindGeolocation_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = GeolocationContext_BindGeolocation_Params;
      break;
      case kGeolocationContext_OnPermissionUpdated_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = GeolocationContext_OnPermissionUpdated_Params;
      break;
      case kGeolocationContext_SetOverride_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = GeolocationContext_SetOverride_Params;
      break;
      case kGeolocationContext_ClearOverride_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = GeolocationContext_ClearOverride_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateGeolocationContextResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var GeolocationContext = {
    name: 'device.mojom.GeolocationContext',
    kVersion: 0,
    ptrClass: GeolocationContextPtr,
    proxyClass: GeolocationContextProxy,
    stubClass: GeolocationContextStub,
    validateRequest: validateGeolocationContextRequest,
    validateResponse: null,
  };
  GeolocationContextStub.prototype.validator = validateGeolocationContextRequest;
  GeolocationContextProxy.prototype.validator = null;
  exports.GeolocationPermissionLevel = GeolocationPermissionLevel;
  exports.GeolocationContext = GeolocationContext;
  exports.GeolocationContextPtr = GeolocationContextPtr;
  exports.GeolocationContextAssociatedPtr = GeolocationContextAssociatedPtr;
})();