// services/device/public/mojom/fingerprint.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/fingerprint.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/fingerprint.mojom-params-data.h"
#include "services/device/public/mojom/fingerprint.mojom-shared-message-ids.h"

#include "services/device/public/mojom/fingerprint.mojom-import-headers.h"
#include "services/device/public/mojom/fingerprint.mojom-test-utils.h"


namespace device::mojom {
FingerprintMessagePtr
FingerprintMessage::NewFingerprintError(
    FingerprintError value) {
  return FingerprintMessagePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFingerprintError)>,
      std::move(value));
}

FingerprintMessagePtr
FingerprintMessage::NewScanResult(
    ScanResult value) {
  return FingerprintMessagePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kScanResult)>,
      std::move(value));
}

FingerprintMessage::FingerprintMessage(
    std::in_place_index_t<static_cast<size_t>(Tag::kFingerprintError)>,
    FingerprintError value)
    : tag_(Tag::kFingerprintError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFingerprintError)>,
            std::move(value)) {}

FingerprintMessage::FingerprintMessage(
    std::in_place_index_t<static_cast<size_t>(Tag::kScanResult)>,
    ScanResult value)
    : tag_(Tag::kScanResult),
      data_(std::in_place_index<static_cast<size_t>(Tag::kScanResult)>,
            std::move(value)) {}
FingerprintMessage::~FingerprintMessage() {
  DestroyActive();
}

void FingerprintMessage::set_fingerprint_error(FingerprintError fingerprint_error) {
  if (tag_ != Tag::kFingerprintError) {
    DestroyActive();
    tag_ = Tag::kFingerprintError;
  }
  data_.fingerprint_error = fingerprint_error;
}

void FingerprintMessage::set_scan_result(ScanResult scan_result) {
  if (tag_ != Tag::kScanResult) {
    DestroyActive();
    tag_ = Tag::kScanResult;
  }
  data_.scan_result = scan_result;
}


FingerprintMessage::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFingerprintError)>,
    FingerprintError value)
    : fingerprint_error(std::move(value)) {}

FingerprintMessage::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kScanResult)>,
    ScanResult value)
    : scan_result(std::move(value)) {}

void FingerprintMessage::DestroyActive() {
  switch (tag_) {

    case Tag::kFingerprintError:
      std::destroy_at(&data_.fingerprint_error);
      break;
    case Tag::kScanResult:
      std::destroy_at(&data_.scan_result);
      break;
  }
}
size_t FingerprintMessage::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kFingerprintError:
      return mojo::internal::Hash(seed, data_.fingerprint_error);
    case Tag::kScanResult:
      return mojo::internal::Hash(seed, data_.scan_result);
    default:
      NOTREACHED();
  }
}

bool FingerprintMessage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

FingerprintObserver::IPCStableHashFunction FingerprintObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FingerprintObserver>(message.name())) {
    case messages::FingerprintObserver::kOnRestarted: {
      return &FingerprintObserver::OnRestarted_Sym::IPCStableHash;
    }
    case messages::FingerprintObserver::kOnStatusChanged: {
      return &FingerprintObserver::OnStatusChanged_Sym::IPCStableHash;
    }
    case messages::FingerprintObserver::kOnEnrollScanDone: {
      return &FingerprintObserver::OnEnrollScanDone_Sym::IPCStableHash;
    }
    case messages::FingerprintObserver::kOnAuthScanDone: {
      return &FingerprintObserver::OnAuthScanDone_Sym::IPCStableHash;
    }
    case messages::FingerprintObserver::kOnSessionFailed: {
      return &FingerprintObserver::OnSessionFailed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FingerprintObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FingerprintObserver>(message.name())) {
      case messages::FingerprintObserver::kOnRestarted:
            return "Receive device::mojom::FingerprintObserver::OnRestarted";
      case messages::FingerprintObserver::kOnStatusChanged:
            return "Receive device::mojom::FingerprintObserver::OnStatusChanged";
      case messages::FingerprintObserver::kOnEnrollScanDone:
            return "Receive device::mojom::FingerprintObserver::OnEnrollScanDone";
      case messages::FingerprintObserver::kOnAuthScanDone:
            return "Receive device::mojom::FingerprintObserver::OnAuthScanDone";
      case messages::FingerprintObserver::kOnSessionFailed:
            return "Receive device::mojom::FingerprintObserver::OnSessionFailed";
    }
  } else {
    switch (static_cast<messages::FingerprintObserver>(message.name())) {
      case messages::FingerprintObserver::kOnRestarted:
            return "Receive reply device::mojom::FingerprintObserver::OnRestarted";
      case messages::FingerprintObserver::kOnStatusChanged:
            return "Receive reply device::mojom::FingerprintObserver::OnStatusChanged";
      case messages::FingerprintObserver::kOnEnrollScanDone:
            return "Receive reply device::mojom::FingerprintObserver::OnEnrollScanDone";
      case messages::FingerprintObserver::kOnAuthScanDone:
            return "Receive reply device::mojom::FingerprintObserver::OnAuthScanDone";
      case messages::FingerprintObserver::kOnSessionFailed:
            return "Receive reply device::mojom::FingerprintObserver::OnSessionFailed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FingerprintObserver::OnRestarted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x225b1728;  // IPCStableHash for device::mojom::FingerprintObserver::OnRestarted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FingerprintObserver::OnStatusChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x55380c12;  // IPCStableHash for device::mojom::FingerprintObserver::OnStatusChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FingerprintObserver::OnEnrollScanDone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x372e4fd1;  // IPCStableHash for device::mojom::FingerprintObserver::OnEnrollScanDone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FingerprintObserver::OnAuthScanDone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdcf0f9c7;  // IPCStableHash for device::mojom::FingerprintObserver::OnAuthScanDone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FingerprintObserver::OnSessionFailed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x41964317;  // IPCStableHash for device::mojom::FingerprintObserver::OnSessionFailed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

FingerprintObserverProxy::FingerprintObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FingerprintObserverProxy::OnRestarted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::FingerprintObserver::OnRestarted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FingerprintObserver::kOnRestarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::FingerprintObserver_OnRestarted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FingerprintObserver::Name_);
  message.set_method_name("OnRestarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FingerprintObserverProxy::OnStatusChanged(
    BiometricsManagerStatus in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::FingerprintObserver::OnStatusChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type BiometricsManagerStatus>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FingerprintObserver::kOnStatusChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::FingerprintObserver_OnStatusChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::BiometricsManagerStatus>(
    in_status,
    &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FingerprintObserver::Name_);
  message.set_method_name("OnStatusChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FingerprintObserverProxy::OnEnrollScanDone(
    ScanResult in_scan_result, bool in_is_complete, int32_t in_percent_complete) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::FingerprintObserver::OnEnrollScanDone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("scan_result"), in_scan_result,
                        "<value of type ScanResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_complete"), in_is_complete,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("percent_complete"), in_percent_complete,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FingerprintObserver::kOnEnrollScanDone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::FingerprintObserver_OnEnrollScanDone_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::ScanResult>(
    in_scan_result,
    &params->scan_result);

  params->is_complete = in_is_complete;

  params->percent_complete = in_percent_complete;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FingerprintObserver::Name_);
  message.set_method_name("OnEnrollScanDone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FingerprintObserverProxy::OnAuthScanDone(
    FingerprintMessagePtr in_msg, const base::flat_map<std::string, std::vector<std::string>>& in_matches) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::FingerprintObserver::OnAuthScanDone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("msg"), in_msg,
                        "<value of type FingerprintMessagePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("matches"), in_matches,
                        "<value of type const base::flat_map<std::string, std::vector<std::string>>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FingerprintObserver::kOnAuthScanDone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::FingerprintObserver_OnAuthScanDone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->msg)>
      msg_fragment(params.message());
  msg_fragment.Claim(&params->msg);
  
  mojo::internal::Serialize<::device::mojom::FingerprintMessageDataView>(
    in_msg,
    msg_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->msg.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null msg in FingerprintObserver.OnAuthScanDone request");
  mojo::internal::MessageFragment<
      typename decltype(params->matches)::BaseType>
      matches_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& matches_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::ArrayDataView<mojo::StringDataView>>>(
    in_matches,
    matches_fragment,
    &matches_validate_params);

  params->matches.Set(
      matches_fragment.is_null() ? nullptr : matches_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->matches.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null matches in FingerprintObserver.OnAuthScanDone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FingerprintObserver::Name_);
  message.set_method_name("OnAuthScanDone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FingerprintObserverProxy::OnSessionFailed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::FingerprintObserver::OnSessionFailed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FingerprintObserver::kOnSessionFailed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::FingerprintObserver_OnSessionFailed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FingerprintObserver::Name_);
  message.set_method_name("OnSessionFailed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool FingerprintObserverStubDispatch::Accept(
    FingerprintObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FingerprintObserver>(message->header()->name)) {
    case messages::FingerprintObserver::kOnRestarted: {
      DCHECK(message->is_serialized());
      internal::FingerprintObserver_OnRestarted_Params_Data* params =
          reinterpret_cast<internal::FingerprintObserver_OnRestarted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FingerprintObserver.0
      bool success = true;
      FingerprintObserver_OnRestarted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FingerprintObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRestarted(        );
      return true;
    }
    case messages::FingerprintObserver::kOnStatusChanged: {
      DCHECK(message->is_serialized());
      internal::FingerprintObserver_OnStatusChanged_Params_Data* params =
          reinterpret_cast<internal::FingerprintObserver_OnStatusChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FingerprintObserver.1
      bool success = true;
      BiometricsManagerStatus p_status{};
      FingerprintObserver_OnStatusChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FingerprintObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnStatusChanged(        
        std::move(p_status));
      return true;
    }
    case messages::FingerprintObserver::kOnEnrollScanDone: {
      DCHECK(message->is_serialized());
      internal::FingerprintObserver_OnEnrollScanDone_Params_Data* params =
          reinterpret_cast<internal::FingerprintObserver_OnEnrollScanDone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FingerprintObserver.2
      bool success = true;
      ScanResult p_scan_result{};
      bool p_is_complete{};
      int32_t p_percent_complete{};
      FingerprintObserver_OnEnrollScanDone_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadScanResult(&p_scan_result))
        success = false;
      if (success)
        p_is_complete = input_data_view.is_complete();
      if (success)
        p_percent_complete = input_data_view.percent_complete();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FingerprintObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnEnrollScanDone(        
        std::move(p_scan_result), 
        std::move(p_is_complete), 
        std::move(p_percent_complete));
      return true;
    }
    case messages::FingerprintObserver::kOnAuthScanDone: {
      DCHECK(message->is_serialized());
      internal::FingerprintObserver_OnAuthScanDone_Params_Data* params =
          reinterpret_cast<internal::FingerprintObserver_OnAuthScanDone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FingerprintObserver.3
      bool success = true;
      FingerprintMessagePtr p_msg{};
      base::flat_map<std::string, std::vector<std::string>> p_matches{};
      FingerprintObserver_OnAuthScanDone_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMsg(&p_msg))
        success = false;
      if (success && !input_data_view.ReadMatches(&p_matches))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FingerprintObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAuthScanDone(        
        std::move(p_msg), 
        std::move(p_matches));
      return true;
    }
    case messages::FingerprintObserver::kOnSessionFailed: {
      DCHECK(message->is_serialized());
      internal::FingerprintObserver_OnSessionFailed_Params_Data* params =
          reinterpret_cast<internal::FingerprintObserver_OnSessionFailed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FingerprintObserver.4
      bool success = true;
      FingerprintObserver_OnSessionFailed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FingerprintObserver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSessionFailed(        );
      return true;
    }
  }
  return false;
}

// static
bool FingerprintObserverStubDispatch::AcceptWithResponder(
    FingerprintObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FingerprintObserver>(message->header()->name)) {
    case messages::FingerprintObserver::kOnRestarted: {
      break;
    }
    case messages::FingerprintObserver::kOnStatusChanged: {
      break;
    }
    case messages::FingerprintObserver::kOnEnrollScanDone: {
      break;
    }
    case messages::FingerprintObserver::kOnAuthScanDone: {
      break;
    }
    case messages::FingerprintObserver::kOnSessionFailed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFingerprintObserverValidationInfo[] = {
    { &internal::FingerprintObserver_OnRestarted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FingerprintObserver_OnStatusChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FingerprintObserver_OnEnrollScanDone_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FingerprintObserver_OnAuthScanDone_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::FingerprintObserver_OnSessionFailed_Params_Data::Validate,
     nullptr /* no response */},
};

bool FingerprintObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::FingerprintObserver::Name_,
    kFingerprintObserverValidationInfo);
}

// The declaration includes the definition on other builds.

Fingerprint::IPCStableHashFunction Fingerprint::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Fingerprint>(message.name())) {
    case messages::Fingerprint::kGetRecordsForUser: {
      return &Fingerprint::GetRecordsForUser_Sym::IPCStableHash;
    }
    case messages::Fingerprint::kStartEnrollSession: {
      return &Fingerprint::StartEnrollSession_Sym::IPCStableHash;
    }
    case messages::Fingerprint::kCancelCurrentEnrollSession: {
      return &Fingerprint::CancelCurrentEnrollSession_Sym::IPCStableHash;
    }
    case messages::Fingerprint::kRequestRecordLabel: {
      return &Fingerprint::RequestRecordLabel_Sym::IPCStableHash;
    }
    case messages::Fingerprint::kSetRecordLabel: {
      return &Fingerprint::SetRecordLabel_Sym::IPCStableHash;
    }
    case messages::Fingerprint::kRemoveRecord: {
      return &Fingerprint::RemoveRecord_Sym::IPCStableHash;
    }
    case messages::Fingerprint::kStartAuthSession: {
      return &Fingerprint::StartAuthSession_Sym::IPCStableHash;
    }
    case messages::Fingerprint::kEndCurrentAuthSession: {
      return &Fingerprint::EndCurrentAuthSession_Sym::IPCStableHash;
    }
    case messages::Fingerprint::kDestroyAllRecords: {
      return &Fingerprint::DestroyAllRecords_Sym::IPCStableHash;
    }
    case messages::Fingerprint::kAddFingerprintObserver: {
      return &Fingerprint::AddFingerprintObserver_Sym::IPCStableHash;
    }
    case messages::Fingerprint::kRequestType: {
      return &Fingerprint::RequestType_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Fingerprint::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Fingerprint>(message.name())) {
      case messages::Fingerprint::kGetRecordsForUser:
            return "Receive device::mojom::Fingerprint::GetRecordsForUser";
      case messages::Fingerprint::kStartEnrollSession:
            return "Receive device::mojom::Fingerprint::StartEnrollSession";
      case messages::Fingerprint::kCancelCurrentEnrollSession:
            return "Receive device::mojom::Fingerprint::CancelCurrentEnrollSession";
      case messages::Fingerprint::kRequestRecordLabel:
            return "Receive device::mojom::Fingerprint::RequestRecordLabel";
      case messages::Fingerprint::kSetRecordLabel:
            return "Receive device::mojom::Fingerprint::SetRecordLabel";
      case messages::Fingerprint::kRemoveRecord:
            return "Receive device::mojom::Fingerprint::RemoveRecord";
      case messages::Fingerprint::kStartAuthSession:
            return "Receive device::mojom::Fingerprint::StartAuthSession";
      case messages::Fingerprint::kEndCurrentAuthSession:
            return "Receive device::mojom::Fingerprint::EndCurrentAuthSession";
      case messages::Fingerprint::kDestroyAllRecords:
            return "Receive device::mojom::Fingerprint::DestroyAllRecords";
      case messages::Fingerprint::kAddFingerprintObserver:
            return "Receive device::mojom::Fingerprint::AddFingerprintObserver";
      case messages::Fingerprint::kRequestType:
            return "Receive device::mojom::Fingerprint::RequestType";
    }
  } else {
    switch (static_cast<messages::Fingerprint>(message.name())) {
      case messages::Fingerprint::kGetRecordsForUser:
            return "Receive reply device::mojom::Fingerprint::GetRecordsForUser";
      case messages::Fingerprint::kStartEnrollSession:
            return "Receive reply device::mojom::Fingerprint::StartEnrollSession";
      case messages::Fingerprint::kCancelCurrentEnrollSession:
            return "Receive reply device::mojom::Fingerprint::CancelCurrentEnrollSession";
      case messages::Fingerprint::kRequestRecordLabel:
            return "Receive reply device::mojom::Fingerprint::RequestRecordLabel";
      case messages::Fingerprint::kSetRecordLabel:
            return "Receive reply device::mojom::Fingerprint::SetRecordLabel";
      case messages::Fingerprint::kRemoveRecord:
            return "Receive reply device::mojom::Fingerprint::RemoveRecord";
      case messages::Fingerprint::kStartAuthSession:
            return "Receive reply device::mojom::Fingerprint::StartAuthSession";
      case messages::Fingerprint::kEndCurrentAuthSession:
            return "Receive reply device::mojom::Fingerprint::EndCurrentAuthSession";
      case messages::Fingerprint::kDestroyAllRecords:
            return "Receive reply device::mojom::Fingerprint::DestroyAllRecords";
      case messages::Fingerprint::kAddFingerprintObserver:
            return "Receive reply device::mojom::Fingerprint::AddFingerprintObserver";
      case messages::Fingerprint::kRequestType:
            return "Receive reply device::mojom::Fingerprint::RequestType";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Fingerprint::GetRecordsForUser_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0f9aed42;  // IPCStableHash for device::mojom::Fingerprint::GetRecordsForUser
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Fingerprint::StartEnrollSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0b08d611;  // IPCStableHash for device::mojom::Fingerprint::StartEnrollSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Fingerprint::CancelCurrentEnrollSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb9f1956f;  // IPCStableHash for device::mojom::Fingerprint::CancelCurrentEnrollSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Fingerprint::RequestRecordLabel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1fdd77a0;  // IPCStableHash for device::mojom::Fingerprint::RequestRecordLabel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Fingerprint::SetRecordLabel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb203ef54;  // IPCStableHash for device::mojom::Fingerprint::SetRecordLabel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Fingerprint::RemoveRecord_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9a7f80c7;  // IPCStableHash for device::mojom::Fingerprint::RemoveRecord
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Fingerprint::StartAuthSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0dd12c8b;  // IPCStableHash for device::mojom::Fingerprint::StartAuthSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Fingerprint::EndCurrentAuthSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe1dc09e7;  // IPCStableHash for device::mojom::Fingerprint::EndCurrentAuthSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Fingerprint::DestroyAllRecords_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x348fea88;  // IPCStableHash for device::mojom::Fingerprint::DestroyAllRecords
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Fingerprint::AddFingerprintObserver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaa015a6d;  // IPCStableHash for device::mojom::Fingerprint::AddFingerprintObserver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Fingerprint::RequestType_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x61d742eb;  // IPCStableHash for device::mojom::Fingerprint::RequestType
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Fingerprint_GetRecordsForUser_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Fingerprint_GetRecordsForUser_ForwardToCallback(
      Fingerprint::GetRecordsForUserCallback callback
      ) : callback_(std::move(callback)) {
  }

  Fingerprint_GetRecordsForUser_ForwardToCallback(const Fingerprint_GetRecordsForUser_ForwardToCallback&) = delete;
  Fingerprint_GetRecordsForUser_ForwardToCallback& operator=(const Fingerprint_GetRecordsForUser_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Fingerprint::GetRecordsForUserCallback callback_;
};

class Fingerprint_CancelCurrentEnrollSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Fingerprint_CancelCurrentEnrollSession_ForwardToCallback(
      Fingerprint::CancelCurrentEnrollSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  Fingerprint_CancelCurrentEnrollSession_ForwardToCallback(const Fingerprint_CancelCurrentEnrollSession_ForwardToCallback&) = delete;
  Fingerprint_CancelCurrentEnrollSession_ForwardToCallback& operator=(const Fingerprint_CancelCurrentEnrollSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Fingerprint::CancelCurrentEnrollSessionCallback callback_;
};

class Fingerprint_RequestRecordLabel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Fingerprint_RequestRecordLabel_ForwardToCallback(
      Fingerprint::RequestRecordLabelCallback callback
      ) : callback_(std::move(callback)) {
  }

  Fingerprint_RequestRecordLabel_ForwardToCallback(const Fingerprint_RequestRecordLabel_ForwardToCallback&) = delete;
  Fingerprint_RequestRecordLabel_ForwardToCallback& operator=(const Fingerprint_RequestRecordLabel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Fingerprint::RequestRecordLabelCallback callback_;
};

class Fingerprint_SetRecordLabel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Fingerprint_SetRecordLabel_ForwardToCallback(
      Fingerprint::SetRecordLabelCallback callback
      ) : callback_(std::move(callback)) {
  }

  Fingerprint_SetRecordLabel_ForwardToCallback(const Fingerprint_SetRecordLabel_ForwardToCallback&) = delete;
  Fingerprint_SetRecordLabel_ForwardToCallback& operator=(const Fingerprint_SetRecordLabel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Fingerprint::SetRecordLabelCallback callback_;
};

class Fingerprint_RemoveRecord_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Fingerprint_RemoveRecord_ForwardToCallback(
      Fingerprint::RemoveRecordCallback callback
      ) : callback_(std::move(callback)) {
  }

  Fingerprint_RemoveRecord_ForwardToCallback(const Fingerprint_RemoveRecord_ForwardToCallback&) = delete;
  Fingerprint_RemoveRecord_ForwardToCallback& operator=(const Fingerprint_RemoveRecord_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Fingerprint::RemoveRecordCallback callback_;
};

class Fingerprint_EndCurrentAuthSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Fingerprint_EndCurrentAuthSession_ForwardToCallback(
      Fingerprint::EndCurrentAuthSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  Fingerprint_EndCurrentAuthSession_ForwardToCallback(const Fingerprint_EndCurrentAuthSession_ForwardToCallback&) = delete;
  Fingerprint_EndCurrentAuthSession_ForwardToCallback& operator=(const Fingerprint_EndCurrentAuthSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Fingerprint::EndCurrentAuthSessionCallback callback_;
};

class Fingerprint_DestroyAllRecords_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Fingerprint_DestroyAllRecords_ForwardToCallback(
      Fingerprint::DestroyAllRecordsCallback callback
      ) : callback_(std::move(callback)) {
  }

  Fingerprint_DestroyAllRecords_ForwardToCallback(const Fingerprint_DestroyAllRecords_ForwardToCallback&) = delete;
  Fingerprint_DestroyAllRecords_ForwardToCallback& operator=(const Fingerprint_DestroyAllRecords_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Fingerprint::DestroyAllRecordsCallback callback_;
};

class Fingerprint_RequestType_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Fingerprint_RequestType_ForwardToCallback(
      Fingerprint::RequestTypeCallback callback
      ) : callback_(std::move(callback)) {
  }

  Fingerprint_RequestType_ForwardToCallback(const Fingerprint_RequestType_ForwardToCallback&) = delete;
  Fingerprint_RequestType_ForwardToCallback& operator=(const Fingerprint_RequestType_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Fingerprint::RequestTypeCallback callback_;
};

FingerprintProxy::FingerprintProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FingerprintProxy::GetRecordsForUser(
    const std::string& in_user_id, GetRecordsForUserCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::Fingerprint::GetRecordsForUser", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_id"), in_user_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kGetRecordsForUser), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_GetRecordsForUser_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->user_id)::BaseType> user_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_user_id,
    user_id_fragment);

  params->user_id.Set(
      user_id_fragment.is_null() ? nullptr : user_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->user_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null user_id in Fingerprint.GetRecordsForUser request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("GetRecordsForUser");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Fingerprint_GetRecordsForUser_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FingerprintProxy::StartEnrollSession(
    const std::string& in_user_id, const std::string& in_label) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::Fingerprint::StartEnrollSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_id"), in_user_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kStartEnrollSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_StartEnrollSession_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->user_id)::BaseType> user_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_user_id,
    user_id_fragment);

  params->user_id.Set(
      user_id_fragment.is_null() ? nullptr : user_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->user_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null user_id in Fingerprint.StartEnrollSession request");
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_label,
    label_fragment);

  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->label.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null label in Fingerprint.StartEnrollSession request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("StartEnrollSession");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FingerprintProxy::CancelCurrentEnrollSession(
    CancelCurrentEnrollSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::Fingerprint::CancelCurrentEnrollSession");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kCancelCurrentEnrollSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_CancelCurrentEnrollSession_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("CancelCurrentEnrollSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Fingerprint_CancelCurrentEnrollSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FingerprintProxy::RequestRecordLabel(
    const std::string& in_record_path, RequestRecordLabelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::Fingerprint::RequestRecordLabel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("record_path"), in_record_path,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kRequestRecordLabel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_RequestRecordLabel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->record_path)::BaseType> record_path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_record_path,
    record_path_fragment);

  params->record_path.Set(
      record_path_fragment.is_null() ? nullptr : record_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->record_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null record_path in Fingerprint.RequestRecordLabel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("RequestRecordLabel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Fingerprint_RequestRecordLabel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FingerprintProxy::SetRecordLabel(
    const std::string& in_record_path, const std::string& in_new_label, SetRecordLabelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::Fingerprint::SetRecordLabel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("record_path"), in_record_path,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_label"), in_new_label,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kSetRecordLabel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_SetRecordLabel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->record_path)::BaseType> record_path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_record_path,
    record_path_fragment);

  params->record_path.Set(
      record_path_fragment.is_null() ? nullptr : record_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->record_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null record_path in Fingerprint.SetRecordLabel request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_label)::BaseType> new_label_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_new_label,
    new_label_fragment);

  params->new_label.Set(
      new_label_fragment.is_null() ? nullptr : new_label_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_label.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_label in Fingerprint.SetRecordLabel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("SetRecordLabel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Fingerprint_SetRecordLabel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FingerprintProxy::RemoveRecord(
    const std::string& in_record_path, RemoveRecordCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::Fingerprint::RemoveRecord", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("record_path"), in_record_path,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kRemoveRecord), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_RemoveRecord_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->record_path)::BaseType> record_path_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_record_path,
    record_path_fragment);

  params->record_path.Set(
      record_path_fragment.is_null() ? nullptr : record_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->record_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null record_path in Fingerprint.RemoveRecord request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("RemoveRecord");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Fingerprint_RemoveRecord_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FingerprintProxy::StartAuthSession(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::Fingerprint::StartAuthSession");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kStartAuthSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_StartAuthSession_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("StartAuthSession");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FingerprintProxy::EndCurrentAuthSession(
    EndCurrentAuthSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::Fingerprint::EndCurrentAuthSession");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kEndCurrentAuthSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_EndCurrentAuthSession_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("EndCurrentAuthSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Fingerprint_EndCurrentAuthSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FingerprintProxy::DestroyAllRecords(
    DestroyAllRecordsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::Fingerprint::DestroyAllRecords");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kDestroyAllRecords), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_DestroyAllRecords_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("DestroyAllRecords");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Fingerprint_DestroyAllRecords_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FingerprintProxy::AddFingerprintObserver(
    ::mojo::PendingRemote<FingerprintObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::Fingerprint::AddFingerprintObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<FingerprintObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kAddFingerprintObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_AddFingerprintObserver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::FingerprintObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in Fingerprint.AddFingerprintObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("AddFingerprintObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void FingerprintProxy::RequestType(
    RequestTypeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::Fingerprint::RequestType");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kRequestType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_RequestType_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("RequestType");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Fingerprint_RequestType_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Fingerprint_GetRecordsForUser_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Fingerprint::GetRecordsForUserCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Fingerprint_GetRecordsForUser_ProxyToResponder> proxy(
        new Fingerprint_GetRecordsForUser_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Fingerprint_GetRecordsForUser_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Fingerprint_GetRecordsForUser_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Fingerprint_GetRecordsForUser_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Fingerprint::GetRecordsForUserCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const base::flat_map<std::string, std::string>& in_records, bool in_success);
};

bool Fingerprint_GetRecordsForUser_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Fingerprint_GetRecordsForUser_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Fingerprint_GetRecordsForUser_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Fingerprint.0
  bool success = true;
  base::flat_map<std::string, std::string> p_records{};
  bool p_success{};
  Fingerprint_GetRecordsForUser_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRecords(&p_records))
    success = false;
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Fingerprint::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_records), 
std::move(p_success));
  }
  return true;
}

void Fingerprint_GetRecordsForUser_ProxyToResponder::Run(
    const base::flat_map<std::string, std::string>& in_records, bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::Fingerprint::GetRecordsForUser", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("records"), in_records,
                        "<value of type const base::flat_map<std::string, std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kGetRecordsForUser), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_GetRecordsForUser_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->records)::BaseType>
      records_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& records_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
    in_records,
    records_fragment,
    &records_validate_params);

  params->records.Set(
      records_fragment.is_null() ? nullptr : records_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->records.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null records in ");

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("GetRecordsForUser");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Fingerprint_CancelCurrentEnrollSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Fingerprint::CancelCurrentEnrollSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Fingerprint_CancelCurrentEnrollSession_ProxyToResponder> proxy(
        new Fingerprint_CancelCurrentEnrollSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Fingerprint_CancelCurrentEnrollSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Fingerprint_CancelCurrentEnrollSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Fingerprint_CancelCurrentEnrollSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Fingerprint::CancelCurrentEnrollSessionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool Fingerprint_CancelCurrentEnrollSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Fingerprint_CancelCurrentEnrollSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Fingerprint_CancelCurrentEnrollSession_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Fingerprint.2
  bool success = true;
  bool p_success{};
  Fingerprint_CancelCurrentEnrollSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Fingerprint::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void Fingerprint_CancelCurrentEnrollSession_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::Fingerprint::CancelCurrentEnrollSession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kCancelCurrentEnrollSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_CancelCurrentEnrollSession_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("CancelCurrentEnrollSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Fingerprint_RequestRecordLabel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Fingerprint::RequestRecordLabelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Fingerprint_RequestRecordLabel_ProxyToResponder> proxy(
        new Fingerprint_RequestRecordLabel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Fingerprint_RequestRecordLabel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Fingerprint_RequestRecordLabel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Fingerprint_RequestRecordLabel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Fingerprint::RequestRecordLabelCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_label);
};

bool Fingerprint_RequestRecordLabel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Fingerprint_RequestRecordLabel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Fingerprint_RequestRecordLabel_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Fingerprint.3
  bool success = true;
  std::string p_label{};
  Fingerprint_RequestRecordLabel_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadLabel(&p_label))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Fingerprint::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_label));
  }
  return true;
}

void Fingerprint_RequestRecordLabel_ProxyToResponder::Run(
    const std::string& in_label) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::Fingerprint::RequestRecordLabel", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kRequestRecordLabel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_RequestRecordLabel_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_label,
    label_fragment);

  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->label.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null label in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("RequestRecordLabel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Fingerprint_SetRecordLabel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Fingerprint::SetRecordLabelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Fingerprint_SetRecordLabel_ProxyToResponder> proxy(
        new Fingerprint_SetRecordLabel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Fingerprint_SetRecordLabel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Fingerprint_SetRecordLabel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Fingerprint_SetRecordLabel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Fingerprint::SetRecordLabelCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool Fingerprint_SetRecordLabel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Fingerprint_SetRecordLabel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Fingerprint_SetRecordLabel_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Fingerprint.4
  bool success = true;
  bool p_success{};
  Fingerprint_SetRecordLabel_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Fingerprint::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void Fingerprint_SetRecordLabel_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::Fingerprint::SetRecordLabel", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kSetRecordLabel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_SetRecordLabel_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("SetRecordLabel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Fingerprint_RemoveRecord_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Fingerprint::RemoveRecordCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Fingerprint_RemoveRecord_ProxyToResponder> proxy(
        new Fingerprint_RemoveRecord_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Fingerprint_RemoveRecord_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Fingerprint_RemoveRecord_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Fingerprint_RemoveRecord_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Fingerprint::RemoveRecordCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool Fingerprint_RemoveRecord_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Fingerprint_RemoveRecord_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Fingerprint_RemoveRecord_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Fingerprint.5
  bool success = true;
  bool p_success{};
  Fingerprint_RemoveRecord_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Fingerprint::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void Fingerprint_RemoveRecord_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::Fingerprint::RemoveRecord", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kRemoveRecord), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_RemoveRecord_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("RemoveRecord");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Fingerprint_EndCurrentAuthSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Fingerprint::EndCurrentAuthSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Fingerprint_EndCurrentAuthSession_ProxyToResponder> proxy(
        new Fingerprint_EndCurrentAuthSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Fingerprint_EndCurrentAuthSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Fingerprint_EndCurrentAuthSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Fingerprint_EndCurrentAuthSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Fingerprint::EndCurrentAuthSessionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool Fingerprint_EndCurrentAuthSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Fingerprint_EndCurrentAuthSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Fingerprint_EndCurrentAuthSession_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Fingerprint.7
  bool success = true;
  bool p_success{};
  Fingerprint_EndCurrentAuthSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Fingerprint::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void Fingerprint_EndCurrentAuthSession_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::Fingerprint::EndCurrentAuthSession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kEndCurrentAuthSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_EndCurrentAuthSession_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("EndCurrentAuthSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Fingerprint_DestroyAllRecords_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Fingerprint::DestroyAllRecordsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Fingerprint_DestroyAllRecords_ProxyToResponder> proxy(
        new Fingerprint_DestroyAllRecords_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Fingerprint_DestroyAllRecords_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Fingerprint_DestroyAllRecords_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Fingerprint_DestroyAllRecords_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Fingerprint::DestroyAllRecordsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool Fingerprint_DestroyAllRecords_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Fingerprint_DestroyAllRecords_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Fingerprint_DestroyAllRecords_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Fingerprint.8
  bool success = true;
  bool p_success{};
  Fingerprint_DestroyAllRecords_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Fingerprint::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void Fingerprint_DestroyAllRecords_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::Fingerprint::DestroyAllRecords", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kDestroyAllRecords), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_DestroyAllRecords_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("DestroyAllRecords");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Fingerprint_RequestType_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Fingerprint::RequestTypeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Fingerprint_RequestType_ProxyToResponder> proxy(
        new Fingerprint_RequestType_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Fingerprint_RequestType_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Fingerprint_RequestType_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Fingerprint_RequestType_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Fingerprint::RequestTypeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      BiometricType in_type);
};

bool Fingerprint_RequestType_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Fingerprint_RequestType_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Fingerprint_RequestType_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Fingerprint.10
  bool success = true;
  BiometricType p_type{};
  Fingerprint_RequestType_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadType(&p_type))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Fingerprint::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_type));
  }
  return true;
}

void Fingerprint_RequestType_ProxyToResponder::Run(
    BiometricType in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::Fingerprint::RequestType", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type BiometricType>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Fingerprint::kRequestType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Fingerprint_RequestType_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::BiometricType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Fingerprint::Name_);
  message.set_method_name("RequestType");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FingerprintStubDispatch::Accept(
    Fingerprint* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Fingerprint>(message->header()->name)) {
    case messages::Fingerprint::kGetRecordsForUser: {
      break;
    }
    case messages::Fingerprint::kStartEnrollSession: {
      DCHECK(message->is_serialized());
      internal::Fingerprint_StartEnrollSession_Params_Data* params =
          reinterpret_cast<internal::Fingerprint_StartEnrollSession_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Fingerprint.1
      bool success = true;
      std::string p_user_id{};
      std::string p_label{};
      Fingerprint_StartEnrollSession_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUserId(&p_user_id))
        success = false;
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Fingerprint::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartEnrollSession(        
        std::move(p_user_id), 
        std::move(p_label));
      return true;
    }
    case messages::Fingerprint::kCancelCurrentEnrollSession: {
      break;
    }
    case messages::Fingerprint::kRequestRecordLabel: {
      break;
    }
    case messages::Fingerprint::kSetRecordLabel: {
      break;
    }
    case messages::Fingerprint::kRemoveRecord: {
      break;
    }
    case messages::Fingerprint::kStartAuthSession: {
      DCHECK(message->is_serialized());
      internal::Fingerprint_StartAuthSession_Params_Data* params =
          reinterpret_cast<internal::Fingerprint_StartAuthSession_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Fingerprint.6
      bool success = true;
      Fingerprint_StartAuthSession_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Fingerprint::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartAuthSession(        );
      return true;
    }
    case messages::Fingerprint::kEndCurrentAuthSession: {
      break;
    }
    case messages::Fingerprint::kDestroyAllRecords: {
      break;
    }
    case messages::Fingerprint::kAddFingerprintObserver: {
      DCHECK(message->is_serialized());
      internal::Fingerprint_AddFingerprintObserver_Params_Data* params =
          reinterpret_cast<internal::Fingerprint_AddFingerprintObserver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Fingerprint.9
      bool success = true;
      ::mojo::PendingRemote<FingerprintObserver> p_observer{};
      Fingerprint_AddFingerprintObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Fingerprint::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddFingerprintObserver(        
        std::move(p_observer));
      return true;
    }
    case messages::Fingerprint::kRequestType: {
      break;
    }
  }
  return false;
}

// static
bool FingerprintStubDispatch::AcceptWithResponder(
    Fingerprint* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Fingerprint>(message->header()->name)) {
    case messages::Fingerprint::kGetRecordsForUser: {
      internal::Fingerprint_GetRecordsForUser_Params_Data* params =
          reinterpret_cast<
              internal::Fingerprint_GetRecordsForUser_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Fingerprint.0
      bool success = true;
      std::string p_user_id{};
      Fingerprint_GetRecordsForUser_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUserId(&p_user_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Fingerprint::Name_, 0, false);
        return false;
      }
      auto callback =
          Fingerprint_GetRecordsForUser_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRecordsForUser(        
        std::move(p_user_id), std::move(callback));
      return true;
    }
    case messages::Fingerprint::kStartEnrollSession: {
      break;
    }
    case messages::Fingerprint::kCancelCurrentEnrollSession: {
      internal::Fingerprint_CancelCurrentEnrollSession_Params_Data* params =
          reinterpret_cast<
              internal::Fingerprint_CancelCurrentEnrollSession_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Fingerprint.2
      bool success = true;
      Fingerprint_CancelCurrentEnrollSession_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Fingerprint::Name_, 2, false);
        return false;
      }
      auto callback =
          Fingerprint_CancelCurrentEnrollSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelCurrentEnrollSession(std::move(callback));
      return true;
    }
    case messages::Fingerprint::kRequestRecordLabel: {
      internal::Fingerprint_RequestRecordLabel_Params_Data* params =
          reinterpret_cast<
              internal::Fingerprint_RequestRecordLabel_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Fingerprint.3
      bool success = true;
      std::string p_record_path{};
      Fingerprint_RequestRecordLabel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRecordPath(&p_record_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Fingerprint::Name_, 3, false);
        return false;
      }
      auto callback =
          Fingerprint_RequestRecordLabel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestRecordLabel(        
        std::move(p_record_path), std::move(callback));
      return true;
    }
    case messages::Fingerprint::kSetRecordLabel: {
      internal::Fingerprint_SetRecordLabel_Params_Data* params =
          reinterpret_cast<
              internal::Fingerprint_SetRecordLabel_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Fingerprint.4
      bool success = true;
      std::string p_record_path{};
      std::string p_new_label{};
      Fingerprint_SetRecordLabel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRecordPath(&p_record_path))
        success = false;
      if (success && !input_data_view.ReadNewLabel(&p_new_label))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Fingerprint::Name_, 4, false);
        return false;
      }
      auto callback =
          Fingerprint_SetRecordLabel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRecordLabel(        
        std::move(p_record_path), 
        std::move(p_new_label), std::move(callback));
      return true;
    }
    case messages::Fingerprint::kRemoveRecord: {
      internal::Fingerprint_RemoveRecord_Params_Data* params =
          reinterpret_cast<
              internal::Fingerprint_RemoveRecord_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Fingerprint.5
      bool success = true;
      std::string p_record_path{};
      Fingerprint_RemoveRecord_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRecordPath(&p_record_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Fingerprint::Name_, 5, false);
        return false;
      }
      auto callback =
          Fingerprint_RemoveRecord_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveRecord(        
        std::move(p_record_path), std::move(callback));
      return true;
    }
    case messages::Fingerprint::kStartAuthSession: {
      break;
    }
    case messages::Fingerprint::kEndCurrentAuthSession: {
      internal::Fingerprint_EndCurrentAuthSession_Params_Data* params =
          reinterpret_cast<
              internal::Fingerprint_EndCurrentAuthSession_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Fingerprint.7
      bool success = true;
      Fingerprint_EndCurrentAuthSession_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Fingerprint::Name_, 7, false);
        return false;
      }
      auto callback =
          Fingerprint_EndCurrentAuthSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EndCurrentAuthSession(std::move(callback));
      return true;
    }
    case messages::Fingerprint::kDestroyAllRecords: {
      internal::Fingerprint_DestroyAllRecords_Params_Data* params =
          reinterpret_cast<
              internal::Fingerprint_DestroyAllRecords_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Fingerprint.8
      bool success = true;
      Fingerprint_DestroyAllRecords_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Fingerprint::Name_, 8, false);
        return false;
      }
      auto callback =
          Fingerprint_DestroyAllRecords_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyAllRecords(std::move(callback));
      return true;
    }
    case messages::Fingerprint::kAddFingerprintObserver: {
      break;
    }
    case messages::Fingerprint::kRequestType: {
      internal::Fingerprint_RequestType_Params_Data* params =
          reinterpret_cast<
              internal::Fingerprint_RequestType_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Fingerprint.10
      bool success = true;
      Fingerprint_RequestType_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Fingerprint::Name_, 10, false);
        return false;
      }
      auto callback =
          Fingerprint_RequestType_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestType(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFingerprintValidationInfo[] = {
    { &internal::Fingerprint_GetRecordsForUser_Params_Data::Validate,
     &internal::Fingerprint_GetRecordsForUser_ResponseParams_Data::Validate},
    { &internal::Fingerprint_StartEnrollSession_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Fingerprint_CancelCurrentEnrollSession_Params_Data::Validate,
     &internal::Fingerprint_CancelCurrentEnrollSession_ResponseParams_Data::Validate},
    { &internal::Fingerprint_RequestRecordLabel_Params_Data::Validate,
     &internal::Fingerprint_RequestRecordLabel_ResponseParams_Data::Validate},
    { &internal::Fingerprint_SetRecordLabel_Params_Data::Validate,
     &internal::Fingerprint_SetRecordLabel_ResponseParams_Data::Validate},
    { &internal::Fingerprint_RemoveRecord_Params_Data::Validate,
     &internal::Fingerprint_RemoveRecord_ResponseParams_Data::Validate},
    { &internal::Fingerprint_StartAuthSession_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Fingerprint_EndCurrentAuthSession_Params_Data::Validate,
     &internal::Fingerprint_EndCurrentAuthSession_ResponseParams_Data::Validate},
    { &internal::Fingerprint_DestroyAllRecords_Params_Data::Validate,
     &internal::Fingerprint_DestroyAllRecords_ResponseParams_Data::Validate},
    { &internal::Fingerprint_AddFingerprintObserver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Fingerprint_RequestType_Params_Data::Validate,
     &internal::Fingerprint_RequestType_ResponseParams_Data::Validate},
};

bool FingerprintRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::Fingerprint::Name_,
    kFingerprintValidationInfo);
}

bool FingerprintResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device::mojom::Fingerprint::Name_,
    kFingerprintValidationInfo);
}


}  // device::mojom


namespace mojo {

// static
bool UnionTraits<::device::mojom::FingerprintMessage::DataView, ::device::mojom::FingerprintMessagePtr>::Read(
    ::device::mojom::FingerprintMessage::DataView input,
    ::device::mojom::FingerprintMessagePtr* output) {
  using UnionType = ::device::mojom::FingerprintMessage;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kFingerprintError: {
      ::device::mojom::FingerprintError result_fingerprint_error;
      if (!input.ReadFingerprintError(&result_fingerprint_error))
        return false;

      *output = UnionType::NewFingerprintError(result_fingerprint_error);
      break;
    }
    case Tag::kScanResult: {
      ::device::mojom::ScanResult result_scan_result;
      if (!input.ReadScanResult(&result_scan_result))
        return false;

      *output = UnionType::NewScanResult(result_scan_result);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom {


void FingerprintObserverInterceptorForTesting::OnRestarted() {
  GetForwardingInterface()->OnRestarted();
}
void FingerprintObserverInterceptorForTesting::OnStatusChanged(BiometricsManagerStatus status) {
  GetForwardingInterface()->OnStatusChanged(
    std::move(status)
    );
}
void FingerprintObserverInterceptorForTesting::OnEnrollScanDone(ScanResult scan_result, bool is_complete, int32_t percent_complete) {
  GetForwardingInterface()->OnEnrollScanDone(
    std::move(scan_result)
    , 
    std::move(is_complete)
    , 
    std::move(percent_complete)
    );
}
void FingerprintObserverInterceptorForTesting::OnAuthScanDone(FingerprintMessagePtr msg, const base::flat_map<std::string, std::vector<std::string>>& matches) {
  GetForwardingInterface()->OnAuthScanDone(
    std::move(msg)
    , 
    std::move(matches)
    );
}
void FingerprintObserverInterceptorForTesting::OnSessionFailed() {
  GetForwardingInterface()->OnSessionFailed();
}
FingerprintObserverAsyncWaiter::FingerprintObserverAsyncWaiter(
    FingerprintObserver* proxy) : proxy_(proxy) {}

FingerprintObserverAsyncWaiter::~FingerprintObserverAsyncWaiter() = default;





void FingerprintInterceptorForTesting::GetRecordsForUser(const std::string& user_id, GetRecordsForUserCallback callback) {
  GetForwardingInterface()->GetRecordsForUser(
    std::move(user_id)
    , std::move(callback));
}
void FingerprintInterceptorForTesting::StartEnrollSession(const std::string& user_id, const std::string& label) {
  GetForwardingInterface()->StartEnrollSession(
    std::move(user_id)
    , 
    std::move(label)
    );
}
void FingerprintInterceptorForTesting::CancelCurrentEnrollSession(CancelCurrentEnrollSessionCallback callback) {
  GetForwardingInterface()->CancelCurrentEnrollSession(std::move(callback));
}
void FingerprintInterceptorForTesting::RequestRecordLabel(const std::string& record_path, RequestRecordLabelCallback callback) {
  GetForwardingInterface()->RequestRecordLabel(
    std::move(record_path)
    , std::move(callback));
}
void FingerprintInterceptorForTesting::SetRecordLabel(const std::string& record_path, const std::string& new_label, SetRecordLabelCallback callback) {
  GetForwardingInterface()->SetRecordLabel(
    std::move(record_path)
    , 
    std::move(new_label)
    , std::move(callback));
}
void FingerprintInterceptorForTesting::RemoveRecord(const std::string& record_path, RemoveRecordCallback callback) {
  GetForwardingInterface()->RemoveRecord(
    std::move(record_path)
    , std::move(callback));
}
void FingerprintInterceptorForTesting::StartAuthSession() {
  GetForwardingInterface()->StartAuthSession();
}
void FingerprintInterceptorForTesting::EndCurrentAuthSession(EndCurrentAuthSessionCallback callback) {
  GetForwardingInterface()->EndCurrentAuthSession(std::move(callback));
}
void FingerprintInterceptorForTesting::DestroyAllRecords(DestroyAllRecordsCallback callback) {
  GetForwardingInterface()->DestroyAllRecords(std::move(callback));
}
void FingerprintInterceptorForTesting::AddFingerprintObserver(::mojo::PendingRemote<FingerprintObserver> observer) {
  GetForwardingInterface()->AddFingerprintObserver(
    std::move(observer)
    );
}
void FingerprintInterceptorForTesting::RequestType(RequestTypeCallback callback) {
  GetForwardingInterface()->RequestType(std::move(callback));
}
FingerprintAsyncWaiter::FingerprintAsyncWaiter(
    Fingerprint* proxy) : proxy_(proxy) {}

FingerprintAsyncWaiter::~FingerprintAsyncWaiter() = default;


void FingerprintAsyncWaiter::GetRecordsForUser(
    const std::string& user_id, base::flat_map<std::string, std::string>* out_records, bool* out_success) {
  base::RunLoop loop;
  proxy_->GetRecordsForUser(
      std::move(user_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             base::flat_map<std::string, std::string>* out_records
,
             bool* out_success
,
             const base::flat_map<std::string, std::string>& records,
             bool success) {*out_records = std::move(records);*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_records,
          out_success));
  loop.Run();
}



void FingerprintAsyncWaiter::CancelCurrentEnrollSession(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->CancelCurrentEnrollSession(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FingerprintAsyncWaiter::CancelCurrentEnrollSession(
    ) {
  bool async_wait_result;
  CancelCurrentEnrollSession(&async_wait_result);
  return async_wait_result;
}

void FingerprintAsyncWaiter::RequestRecordLabel(
    const std::string& record_path, std::string* out_label) {
  base::RunLoop loop;
  proxy_->RequestRecordLabel(
      std::move(record_path),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_label
,
             const std::string& label) {*out_label = std::move(label);
            loop->Quit();
          },
          &loop,
          out_label));
  loop.Run();
}

std::string FingerprintAsyncWaiter::RequestRecordLabel(
    const std::string& record_path) {
  std::string async_wait_result;
  RequestRecordLabel(std::move(record_path),&async_wait_result);
  return async_wait_result;
}

void FingerprintAsyncWaiter::SetRecordLabel(
    const std::string& record_path, const std::string& new_label, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetRecordLabel(
      std::move(record_path),
      std::move(new_label),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FingerprintAsyncWaiter::SetRecordLabel(
    const std::string& record_path, const std::string& new_label) {
  bool async_wait_result;
  SetRecordLabel(std::move(record_path),std::move(new_label),&async_wait_result);
  return async_wait_result;
}

void FingerprintAsyncWaiter::RemoveRecord(
    const std::string& record_path, bool* out_success) {
  base::RunLoop loop;
  proxy_->RemoveRecord(
      std::move(record_path),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FingerprintAsyncWaiter::RemoveRecord(
    const std::string& record_path) {
  bool async_wait_result;
  RemoveRecord(std::move(record_path),&async_wait_result);
  return async_wait_result;
}

void FingerprintAsyncWaiter::EndCurrentAuthSession(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->EndCurrentAuthSession(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FingerprintAsyncWaiter::EndCurrentAuthSession(
    ) {
  bool async_wait_result;
  EndCurrentAuthSession(&async_wait_result);
  return async_wait_result;
}

void FingerprintAsyncWaiter::DestroyAllRecords(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->DestroyAllRecords(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool FingerprintAsyncWaiter::DestroyAllRecords(
    ) {
  bool async_wait_result;
  DestroyAllRecords(&async_wait_result);
  return async_wait_result;
}

void FingerprintAsyncWaiter::RequestType(
    BiometricType* out_type) {
  base::RunLoop loop;
  proxy_->RequestType(
      base::BindOnce(
          [](base::RunLoop* loop,
             BiometricType* out_type
,
             BiometricType type) {*out_type = std::move(type);
            loop->Quit();
          },
          &loop,
          out_type));
  loop.Run();
}

BiometricType FingerprintAsyncWaiter::RequestType(
    ) {
  BiometricType async_wait_result;
  RequestType(&async_wait_result);
  return async_wait_result;
}






}  // device::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif