// services/device/public/mojom/fingerprint.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_FINGERPRINT_MOJOM_TEST_UTILS_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_FINGERPRINT_MOJOM_TEST_UTILS_H_

#include "services/device/public/mojom/fingerprint.mojom.h"


namespace device::mojom {


class  FingerprintObserverInterceptorForTesting : public FingerprintObserver {
  virtual FingerprintObserver* GetForwardingInterface() = 0;
  void OnRestarted() override;
  void OnStatusChanged(BiometricsManagerStatus status) override;
  void OnEnrollScanDone(ScanResult scan_result, bool is_complete, int32_t percent_complete) override;
  void OnAuthScanDone(FingerprintMessagePtr msg, const base::flat_map<std::string, std::vector<std::string>>& matches) override;
  void OnSessionFailed() override;
};
class  FingerprintObserverAsyncWaiter {
 public:
  explicit FingerprintObserverAsyncWaiter(FingerprintObserver* proxy);

  FingerprintObserverAsyncWaiter(const FingerprintObserverAsyncWaiter&) = delete;
  FingerprintObserverAsyncWaiter& operator=(const FingerprintObserverAsyncWaiter&) = delete;

  ~FingerprintObserverAsyncWaiter();

 private:
  FingerprintObserver* const proxy_;
};


class  FingerprintInterceptorForTesting : public Fingerprint {
  virtual Fingerprint* GetForwardingInterface() = 0;
  void GetRecordsForUser(const std::string& user_id, GetRecordsForUserCallback callback) override;
  void StartEnrollSession(const std::string& user_id, const std::string& label) override;
  void CancelCurrentEnrollSession(CancelCurrentEnrollSessionCallback callback) override;
  void RequestRecordLabel(const std::string& record_path, RequestRecordLabelCallback callback) override;
  void SetRecordLabel(const std::string& record_path, const std::string& new_label, SetRecordLabelCallback callback) override;
  void RemoveRecord(const std::string& record_path, RemoveRecordCallback callback) override;
  void StartAuthSession() override;
  void EndCurrentAuthSession(EndCurrentAuthSessionCallback callback) override;
  void DestroyAllRecords(DestroyAllRecordsCallback callback) override;
  void AddFingerprintObserver(::mojo::PendingRemote<FingerprintObserver> observer) override;
  void RequestType(RequestTypeCallback callback) override;
};
class  FingerprintAsyncWaiter {
 public:
  explicit FingerprintAsyncWaiter(Fingerprint* proxy);

  FingerprintAsyncWaiter(const FingerprintAsyncWaiter&) = delete;
  FingerprintAsyncWaiter& operator=(const FingerprintAsyncWaiter&) = delete;

  ~FingerprintAsyncWaiter();
  void GetRecordsForUser(
      const std::string& user_id, base::flat_map<std::string, std::string>* out_records, bool* out_success);
  
  void CancelCurrentEnrollSession(
      bool* out_success);
  bool CancelCurrentEnrollSession();
  void RequestRecordLabel(
      const std::string& record_path, std::string* out_label);
  std::string RequestRecordLabel(const std::string& record_path);
  void SetRecordLabel(
      const std::string& record_path, const std::string& new_label, bool* out_success);
  bool SetRecordLabel(const std::string& record_path, const std::string& new_label);
  void RemoveRecord(
      const std::string& record_path, bool* out_success);
  bool RemoveRecord(const std::string& record_path);
  void EndCurrentAuthSession(
      bool* out_success);
  bool EndCurrentAuthSession();
  void DestroyAllRecords(
      bool* out_success);
  bool DestroyAllRecords();
  void RequestType(
      BiometricType* out_type);
  BiometricType RequestType();

 private:
  Fingerprint* const proxy_;
};




}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_FINGERPRINT_MOJOM_TEST_UTILS_H_