// services/device/public/mojom/fingerprint.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_FINGERPRINT_MOJOM_SEND_VALIDATION_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_FINGERPRINT_MOJOM_SEND_VALIDATION_H_

#include "services/device/public/mojom/fingerprint.mojom-shared-internal.h"

#include "services/device/public/mojom/fingerprint.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::ScanResult, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::FingerprintError, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::BiometricType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::BiometricsManagerStatus, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::FingerprintMessageDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::FingerprintMessageDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::FingerprintMessage_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::FingerprintMessageDataView::Tag::kFingerprintError: {
    decltype(Traits::fingerprint_error(input))
    in_fingerprint_error = Traits::fingerprint_error(input);
        
mojo::internal::Serialize<::device::mojom::FingerprintError, send_validation>(
  in_fingerprint_error,
  &fragment->data.f_fingerprint_error);
    break;
  }
  case ::device::mojom::FingerprintMessageDataView::Tag::kScanResult: {
    decltype(Traits::scan_result(input))
    in_scan_result = Traits::scan_result(input);
        
mojo::internal::Serialize<::device::mojom::ScanResult, send_validation>(
  in_scan_result,
  &fragment->data.f_scan_result);
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_FINGERPRINT_MOJOM_SEND_VALIDATION_H_