// services/device/public/mojom/fingerprint.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');





goog.provide('device.mojom.ScanResult');
goog.provide('device.mojom.ScanResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.ScanResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.ScanResult = {
  
  SUCCESS: 0,
  PARTIAL: 1,
  INSUFFICIENT: 2,
  SENSOR_DIRTY: 3,
  TOO_SLOW: 4,
  TOO_FAST: 5,
  IMMOBILE: 6,
  NO_MATCH: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

goog.provide('device.mojom.FingerprintError');
goog.provide('device.mojom.FingerprintErrorSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.FingerprintErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.FingerprintError = {
  
  UNKNOWN: 0,
  HW_UNAVAILABLE: 1,
  UNABLE_TO_PROCESS: 2,
  TIMEOUT: 3,
  NO_SPACE: 4,
  CANCELED: 5,
  UNABLE_TO_REMOVE: 6,
  LOCKOUT: 7,
  NO_TEMPLATES: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};

goog.provide('device.mojom.BiometricType');
goog.provide('device.mojom.BiometricTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.BiometricTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.BiometricType = {
  
  UNKNOWN: 0,
  FINGERPRINT: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('device.mojom.BiometricsManagerStatus');
goog.provide('device.mojom.BiometricsManagerStatusSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.BiometricsManagerStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.BiometricsManagerStatus = {
  
  UNKNOWN: 0,
  INITIALIZED: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



goog.provide('device.mojom.FingerprintObserver');
goog.provide('device.mojom.FingerprintObserverReceiver');
goog.provide('device.mojom.FingerprintObserverCallbackRouter');
goog.provide('device.mojom.FingerprintObserverInterface');
goog.provide('device.mojom.FingerprintObserverRemote');
goog.provide('device.mojom.FingerprintObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.FingerprintObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.FingerprintObserver.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.FingerprintObserverInterface = class {
  
  /**
   */

  onRestarted() {}
  
  /**
   * @param { !device.mojom.BiometricsManagerStatus } status
   */

  onStatusChanged(status) {}
  
  /**
   * @param { !device.mojom.ScanResult } scanResult
   * @param { !boolean } isComplete
   * @param { !number } percentComplete
   */

  onEnrollScanDone(scanResult, isComplete, percentComplete) {}
  
  /**
   * @param { !device.mojom.FingerprintMessage } msg
   * @param { !Object<!string, !Array<!string>> } matches
   */

  onAuthScanDone(msg, matches) {}
  
  /**
   */

  onSessionFailed() {}
};

/**
 * @export
 * @implements { device.mojom.FingerprintObserverInterface }
 */
device.mojom.FingerprintObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.FingerprintObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.FingerprintObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.FingerprintObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onRestarted() {
    this.proxy.sendMessage(
        0,
        device.mojom.FingerprintObserver_OnRestarted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.BiometricsManagerStatus } status
   */

  onStatusChanged(
      status) {
    this.proxy.sendMessage(
        1,
        device.mojom.FingerprintObserver_OnStatusChanged_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.ScanResult } scanResult
   * @param { !boolean } isComplete
   * @param { !number } percentComplete
   */

  onEnrollScanDone(
      scanResult,
      isComplete,
      percentComplete) {
    this.proxy.sendMessage(
        2,
        device.mojom.FingerprintObserver_OnEnrollScanDone_ParamsSpec.$,
        null,
        [
          scanResult,
          isComplete,
          percentComplete
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.FingerprintMessage } msg
   * @param { !Object<!string, !Array<!string>> } matches
   */

  onAuthScanDone(
      msg,
      matches) {
    this.proxy.sendMessage(
        3,
        device.mojom.FingerprintObserver_OnAuthScanDone_ParamsSpec.$,
        null,
        [
          msg,
          matches
        ],
        false);
  }

  
  /**
   */

  onSessionFailed() {
    this.proxy.sendMessage(
        4,
        device.mojom.FingerprintObserver_OnSessionFailed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FingerprintObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.FingerprintObserverReceiver = class {
  /**
   * @param {!device.mojom.FingerprintObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.FingerprintObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.FingerprintObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.FingerprintObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.FingerprintObserver_OnRestarted_ParamsSpec.$,
        null,
        impl.onRestarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.FingerprintObserver_OnStatusChanged_ParamsSpec.$,
        null,
        impl.onStatusChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.FingerprintObserver_OnEnrollScanDone_ParamsSpec.$,
        null,
        impl.onEnrollScanDone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        device.mojom.FingerprintObserver_OnAuthScanDone_ParamsSpec.$,
        null,
        impl.onAuthScanDone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        device.mojom.FingerprintObserver_OnSessionFailed_ParamsSpec.$,
        null,
        impl.onSessionFailed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.FingerprintObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.FingerprintObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.FingerprintObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.FingerprintObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FingerprintObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.FingerprintObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.FingerprintObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.FingerprintObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRestarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.FingerprintObserver_OnRestarted_ParamsSpec.$,
        null,
        this.onRestarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStatusChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.FingerprintObserver_OnStatusChanged_ParamsSpec.$,
        null,
        this.onStatusChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEnrollScanDone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.FingerprintObserver_OnEnrollScanDone_ParamsSpec.$,
        null,
        this.onEnrollScanDone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAuthScanDone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        device.mojom.FingerprintObserver_OnAuthScanDone_ParamsSpec.$,
        null,
        this.onAuthScanDone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSessionFailed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        device.mojom.FingerprintObserver_OnSessionFailed_ParamsSpec.$,
        null,
        this.onSessionFailed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.Fingerprint');
goog.provide('device.mojom.FingerprintReceiver');
goog.provide('device.mojom.FingerprintCallbackRouter');
goog.provide('device.mojom.FingerprintInterface');
goog.provide('device.mojom.FingerprintRemote');
goog.provide('device.mojom.FingerprintPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.FingerprintPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.Fingerprint.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.FingerprintInterface = class {
  
  /**
   * @param { !string } userId
   * @return {!Promise<{
        records: !Object<!string, !string>,
        success: !boolean,
   *  }>}
   */

  getRecordsForUser(userId) {}
  
  /**
   * @param { !string } userId
   * @param { !string } label
   */

  startEnrollSession(userId, label) {}
  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  cancelCurrentEnrollSession() {}
  
  /**
   * @param { !string } recordPath
   * @return {!Promise<{
        label: !string,
   *  }>}
   */

  requestRecordLabel(recordPath) {}
  
  /**
   * @param { !string } recordPath
   * @param { !string } newLabel
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setRecordLabel(recordPath, newLabel) {}
  
  /**
   * @param { !string } recordPath
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  removeRecord(recordPath) {}
  
  /**
   */

  startAuthSession() {}
  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  endCurrentAuthSession() {}
  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  destroyAllRecords() {}
  
  /**
   * @param { !device.mojom.FingerprintObserverRemote } observer
   */

  addFingerprintObserver(observer) {}
  
  /**
   * @return {!Promise<{
        type: !device.mojom.BiometricType,
   *  }>}
   */

  requestType() {}
};

/**
 * @export
 * @implements { device.mojom.FingerprintInterface }
 */
device.mojom.FingerprintRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.FingerprintPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.FingerprintPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.FingerprintPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } userId
   * @return {!Promise<{
        records: !Object<!string, !string>,
        success: !boolean,
   *  }>}
   */

  getRecordsForUser(
      userId) {
    return this.proxy.sendMessage(
        0,
        device.mojom.Fingerprint_GetRecordsForUser_ParamsSpec.$,
        device.mojom.Fingerprint_GetRecordsForUser_ResponseParamsSpec.$,
        [
          userId
        ],
        false);
  }

  
  /**
   * @param { !string } userId
   * @param { !string } label
   */

  startEnrollSession(
      userId,
      label) {
    this.proxy.sendMessage(
        1,
        device.mojom.Fingerprint_StartEnrollSession_ParamsSpec.$,
        null,
        [
          userId,
          label
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  cancelCurrentEnrollSession() {
    return this.proxy.sendMessage(
        2,
        device.mojom.Fingerprint_CancelCurrentEnrollSession_ParamsSpec.$,
        device.mojom.Fingerprint_CancelCurrentEnrollSession_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } recordPath
   * @return {!Promise<{
        label: !string,
   *  }>}
   */

  requestRecordLabel(
      recordPath) {
    return this.proxy.sendMessage(
        3,
        device.mojom.Fingerprint_RequestRecordLabel_ParamsSpec.$,
        device.mojom.Fingerprint_RequestRecordLabel_ResponseParamsSpec.$,
        [
          recordPath
        ],
        false);
  }

  
  /**
   * @param { !string } recordPath
   * @param { !string } newLabel
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setRecordLabel(
      recordPath,
      newLabel) {
    return this.proxy.sendMessage(
        4,
        device.mojom.Fingerprint_SetRecordLabel_ParamsSpec.$,
        device.mojom.Fingerprint_SetRecordLabel_ResponseParamsSpec.$,
        [
          recordPath,
          newLabel
        ],
        false);
  }

  
  /**
   * @param { !string } recordPath
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  removeRecord(
      recordPath) {
    return this.proxy.sendMessage(
        5,
        device.mojom.Fingerprint_RemoveRecord_ParamsSpec.$,
        device.mojom.Fingerprint_RemoveRecord_ResponseParamsSpec.$,
        [
          recordPath
        ],
        false);
  }

  
  /**
   */

  startAuthSession() {
    this.proxy.sendMessage(
        6,
        device.mojom.Fingerprint_StartAuthSession_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  endCurrentAuthSession() {
    return this.proxy.sendMessage(
        7,
        device.mojom.Fingerprint_EndCurrentAuthSession_ParamsSpec.$,
        device.mojom.Fingerprint_EndCurrentAuthSession_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  destroyAllRecords() {
    return this.proxy.sendMessage(
        8,
        device.mojom.Fingerprint_DestroyAllRecords_ParamsSpec.$,
        device.mojom.Fingerprint_DestroyAllRecords_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.FingerprintObserverRemote } observer
   */

  addFingerprintObserver(
      observer) {
    this.proxy.sendMessage(
        9,
        device.mojom.Fingerprint_AddFingerprintObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        type: !device.mojom.BiometricType,
   *  }>}
   */

  requestType() {
    return this.proxy.sendMessage(
        10,
        device.mojom.Fingerprint_RequestType_ParamsSpec.$,
        device.mojom.Fingerprint_RequestType_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Fingerprint
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.FingerprintReceiver = class {
  /**
   * @param {!device.mojom.FingerprintInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.FingerprintRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.FingerprintRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.FingerprintRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.Fingerprint_GetRecordsForUser_ParamsSpec.$,
        device.mojom.Fingerprint_GetRecordsForUser_ResponseParamsSpec.$,
        impl.getRecordsForUser.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.Fingerprint_StartEnrollSession_ParamsSpec.$,
        null,
        impl.startEnrollSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.Fingerprint_CancelCurrentEnrollSession_ParamsSpec.$,
        device.mojom.Fingerprint_CancelCurrentEnrollSession_ResponseParamsSpec.$,
        impl.cancelCurrentEnrollSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        device.mojom.Fingerprint_RequestRecordLabel_ParamsSpec.$,
        device.mojom.Fingerprint_RequestRecordLabel_ResponseParamsSpec.$,
        impl.requestRecordLabel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        device.mojom.Fingerprint_SetRecordLabel_ParamsSpec.$,
        device.mojom.Fingerprint_SetRecordLabel_ResponseParamsSpec.$,
        impl.setRecordLabel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        device.mojom.Fingerprint_RemoveRecord_ParamsSpec.$,
        device.mojom.Fingerprint_RemoveRecord_ResponseParamsSpec.$,
        impl.removeRecord.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        device.mojom.Fingerprint_StartAuthSession_ParamsSpec.$,
        null,
        impl.startAuthSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        device.mojom.Fingerprint_EndCurrentAuthSession_ParamsSpec.$,
        device.mojom.Fingerprint_EndCurrentAuthSession_ResponseParamsSpec.$,
        impl.endCurrentAuthSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        device.mojom.Fingerprint_DestroyAllRecords_ParamsSpec.$,
        device.mojom.Fingerprint_DestroyAllRecords_ResponseParamsSpec.$,
        impl.destroyAllRecords.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        device.mojom.Fingerprint_AddFingerprintObserver_ParamsSpec.$,
        null,
        impl.addFingerprintObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        device.mojom.Fingerprint_RequestType_ParamsSpec.$,
        device.mojom.Fingerprint_RequestType_ResponseParamsSpec.$,
        impl.requestType.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.Fingerprint = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.Fingerprint";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.FingerprintRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.FingerprintRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the Fingerprint
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.FingerprintCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.FingerprintRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.FingerprintRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getRecordsForUser =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.Fingerprint_GetRecordsForUser_ParamsSpec.$,
        device.mojom.Fingerprint_GetRecordsForUser_ResponseParamsSpec.$,
        this.getRecordsForUser.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startEnrollSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.Fingerprint_StartEnrollSession_ParamsSpec.$,
        null,
        this.startEnrollSession.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelCurrentEnrollSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.Fingerprint_CancelCurrentEnrollSession_ParamsSpec.$,
        device.mojom.Fingerprint_CancelCurrentEnrollSession_ResponseParamsSpec.$,
        this.cancelCurrentEnrollSession.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestRecordLabel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        device.mojom.Fingerprint_RequestRecordLabel_ParamsSpec.$,
        device.mojom.Fingerprint_RequestRecordLabel_ResponseParamsSpec.$,
        this.requestRecordLabel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setRecordLabel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        device.mojom.Fingerprint_SetRecordLabel_ParamsSpec.$,
        device.mojom.Fingerprint_SetRecordLabel_ResponseParamsSpec.$,
        this.setRecordLabel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeRecord =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        device.mojom.Fingerprint_RemoveRecord_ParamsSpec.$,
        device.mojom.Fingerprint_RemoveRecord_ResponseParamsSpec.$,
        this.removeRecord.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startAuthSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        device.mojom.Fingerprint_StartAuthSession_ParamsSpec.$,
        null,
        this.startAuthSession.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.endCurrentAuthSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        device.mojom.Fingerprint_EndCurrentAuthSession_ParamsSpec.$,
        device.mojom.Fingerprint_EndCurrentAuthSession_ResponseParamsSpec.$,
        this.endCurrentAuthSession.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.destroyAllRecords =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        device.mojom.Fingerprint_DestroyAllRecords_ParamsSpec.$,
        device.mojom.Fingerprint_DestroyAllRecords_ResponseParamsSpec.$,
        this.destroyAllRecords.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addFingerprintObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        device.mojom.Fingerprint_AddFingerprintObserver_ParamsSpec.$,
        null,
        this.addFingerprintObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        device.mojom.Fingerprint_RequestType_ParamsSpec.$,
        device.mojom.Fingerprint_RequestType_ResponseParamsSpec.$,
        this.requestType.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.FingerprintObserver_OnRestarted_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.FingerprintObserver_OnRestarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.FingerprintObserver_OnStatusChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.FingerprintObserver_OnStatusChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.FingerprintObserver_OnEnrollScanDone_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.FingerprintObserver_OnEnrollScanDone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.FingerprintObserver_OnAuthScanDone_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.FingerprintObserver_OnAuthScanDone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.FingerprintObserver_OnSessionFailed_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.FingerprintObserver_OnSessionFailed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_GetRecordsForUser_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_GetRecordsForUser_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_GetRecordsForUser_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_GetRecordsForUser_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_StartEnrollSession_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_StartEnrollSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_CancelCurrentEnrollSession_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_CancelCurrentEnrollSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_CancelCurrentEnrollSession_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_CancelCurrentEnrollSession_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_RequestRecordLabel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_RequestRecordLabel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_RequestRecordLabel_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_RequestRecordLabel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_SetRecordLabel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_SetRecordLabel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_SetRecordLabel_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_SetRecordLabel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_RemoveRecord_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_RemoveRecord_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_RemoveRecord_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_RemoveRecord_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_StartAuthSession_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_StartAuthSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_EndCurrentAuthSession_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_EndCurrentAuthSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_EndCurrentAuthSession_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_EndCurrentAuthSession_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_DestroyAllRecords_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_DestroyAllRecords_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_DestroyAllRecords_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_DestroyAllRecords_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_AddFingerprintObserver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_AddFingerprintObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_RequestType_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_RequestType_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.Fingerprint_RequestType_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.Fingerprint_RequestType_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.FingerprintMessageSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
device.mojom.FingerprintMessageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.FingerprintObserver_OnRestarted_ParamsSpec.$,
    'FingerprintObserver_OnRestarted_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.FingerprintObserver_OnRestarted_Params');

/** @record */
device.mojom.FingerprintObserver_OnRestarted_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.FingerprintObserver_OnStatusChanged_ParamsSpec.$,
    'FingerprintObserver_OnStatusChanged_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        device.mojom.BiometricsManagerStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.FingerprintObserver_OnStatusChanged_Params');

/** @record */
device.mojom.FingerprintObserver_OnStatusChanged_Params = class {
  constructor() {
    /** @export { !device.mojom.BiometricsManagerStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    device.mojom.FingerprintObserver_OnEnrollScanDone_ParamsSpec.$,
    'FingerprintObserver_OnEnrollScanDone_Params',
    [
      mojo.internal.StructField(
        'scanResult', 0,
        0,
        device.mojom.ScanResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isComplete', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'percentComplete', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.FingerprintObserver_OnEnrollScanDone_Params');

/** @record */
device.mojom.FingerprintObserver_OnEnrollScanDone_Params = class {
  constructor() {
    /** @export { !device.mojom.ScanResult } */
    this.scanResult;
    /** @export { !boolean } */
    this.isComplete;
    /** @export { !number } */
    this.percentComplete;
  }
};



mojo.internal.Struct(
    device.mojom.FingerprintObserver_OnAuthScanDone_ParamsSpec.$,
    'FingerprintObserver_OnAuthScanDone_Params',
    [
      mojo.internal.StructField(
        'msg', 0,
        0,
        device.mojom.FingerprintMessageSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'matches', 16,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Array(mojo.internal.String, false), false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('device.mojom.FingerprintObserver_OnAuthScanDone_Params');

/** @record */
device.mojom.FingerprintObserver_OnAuthScanDone_Params = class {
  constructor() {
    /** @export { !device.mojom.FingerprintMessage } */
    this.msg;
    /** @export { !Object<!string, !Array<!string>> } */
    this.matches;
  }
};



mojo.internal.Struct(
    device.mojom.FingerprintObserver_OnSessionFailed_ParamsSpec.$,
    'FingerprintObserver_OnSessionFailed_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.FingerprintObserver_OnSessionFailed_Params');

/** @record */
device.mojom.FingerprintObserver_OnSessionFailed_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_GetRecordsForUser_ParamsSpec.$,
    'Fingerprint_GetRecordsForUser_Params',
    [
      mojo.internal.StructField(
        'userId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.Fingerprint_GetRecordsForUser_Params');

/** @record */
device.mojom.Fingerprint_GetRecordsForUser_Params = class {
  constructor() {
    /** @export { !string } */
    this.userId;
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_GetRecordsForUser_ResponseParamsSpec.$,
    'Fingerprint_GetRecordsForUser_ResponseParams',
    [
      mojo.internal.StructField(
        'records', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'success', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.Fingerprint_GetRecordsForUser_ResponseParams');

/** @record */
device.mojom.Fingerprint_GetRecordsForUser_ResponseParams = class {
  constructor() {
    /** @export { !Object<!string, !string> } */
    this.records;
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_StartEnrollSession_ParamsSpec.$,
    'Fingerprint_StartEnrollSession_Params',
    [
      mojo.internal.StructField(
        'userId', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.Fingerprint_StartEnrollSession_Params');

/** @record */
device.mojom.Fingerprint_StartEnrollSession_Params = class {
  constructor() {
    /** @export { !string } */
    this.userId;
    /** @export { !string } */
    this.label;
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_CancelCurrentEnrollSession_ParamsSpec.$,
    'Fingerprint_CancelCurrentEnrollSession_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.Fingerprint_CancelCurrentEnrollSession_Params');

/** @record */
device.mojom.Fingerprint_CancelCurrentEnrollSession_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_CancelCurrentEnrollSession_ResponseParamsSpec.$,
    'Fingerprint_CancelCurrentEnrollSession_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.Fingerprint_CancelCurrentEnrollSession_ResponseParams');

/** @record */
device.mojom.Fingerprint_CancelCurrentEnrollSession_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_RequestRecordLabel_ParamsSpec.$,
    'Fingerprint_RequestRecordLabel_Params',
    [
      mojo.internal.StructField(
        'recordPath', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.Fingerprint_RequestRecordLabel_Params');

/** @record */
device.mojom.Fingerprint_RequestRecordLabel_Params = class {
  constructor() {
    /** @export { !string } */
    this.recordPath;
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_RequestRecordLabel_ResponseParamsSpec.$,
    'Fingerprint_RequestRecordLabel_ResponseParams',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.Fingerprint_RequestRecordLabel_ResponseParams');

/** @record */
device.mojom.Fingerprint_RequestRecordLabel_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.label;
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_SetRecordLabel_ParamsSpec.$,
    'Fingerprint_SetRecordLabel_Params',
    [
      mojo.internal.StructField(
        'recordPath', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newLabel', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.Fingerprint_SetRecordLabel_Params');

/** @record */
device.mojom.Fingerprint_SetRecordLabel_Params = class {
  constructor() {
    /** @export { !string } */
    this.recordPath;
    /** @export { !string } */
    this.newLabel;
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_SetRecordLabel_ResponseParamsSpec.$,
    'Fingerprint_SetRecordLabel_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.Fingerprint_SetRecordLabel_ResponseParams');

/** @record */
device.mojom.Fingerprint_SetRecordLabel_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_RemoveRecord_ParamsSpec.$,
    'Fingerprint_RemoveRecord_Params',
    [
      mojo.internal.StructField(
        'recordPath', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.Fingerprint_RemoveRecord_Params');

/** @record */
device.mojom.Fingerprint_RemoveRecord_Params = class {
  constructor() {
    /** @export { !string } */
    this.recordPath;
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_RemoveRecord_ResponseParamsSpec.$,
    'Fingerprint_RemoveRecord_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.Fingerprint_RemoveRecord_ResponseParams');

/** @record */
device.mojom.Fingerprint_RemoveRecord_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_StartAuthSession_ParamsSpec.$,
    'Fingerprint_StartAuthSession_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.Fingerprint_StartAuthSession_Params');

/** @record */
device.mojom.Fingerprint_StartAuthSession_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_EndCurrentAuthSession_ParamsSpec.$,
    'Fingerprint_EndCurrentAuthSession_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.Fingerprint_EndCurrentAuthSession_Params');

/** @record */
device.mojom.Fingerprint_EndCurrentAuthSession_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_EndCurrentAuthSession_ResponseParamsSpec.$,
    'Fingerprint_EndCurrentAuthSession_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.Fingerprint_EndCurrentAuthSession_ResponseParams');

/** @record */
device.mojom.Fingerprint_EndCurrentAuthSession_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_DestroyAllRecords_ParamsSpec.$,
    'Fingerprint_DestroyAllRecords_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.Fingerprint_DestroyAllRecords_Params');

/** @record */
device.mojom.Fingerprint_DestroyAllRecords_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_DestroyAllRecords_ResponseParamsSpec.$,
    'Fingerprint_DestroyAllRecords_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.Fingerprint_DestroyAllRecords_ResponseParams');

/** @record */
device.mojom.Fingerprint_DestroyAllRecords_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_AddFingerprintObserver_ParamsSpec.$,
    'Fingerprint_AddFingerprintObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(device.mojom.FingerprintObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.Fingerprint_AddFingerprintObserver_Params');

/** @record */
device.mojom.Fingerprint_AddFingerprintObserver_Params = class {
  constructor() {
    /** @export { !device.mojom.FingerprintObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_RequestType_ParamsSpec.$,
    'Fingerprint_RequestType_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.Fingerprint_RequestType_Params');

/** @record */
device.mojom.Fingerprint_RequestType_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.Fingerprint_RequestType_ResponseParamsSpec.$,
    'Fingerprint_RequestType_ResponseParams',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device.mojom.BiometricTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.Fingerprint_RequestType_ResponseParams');

/** @record */
device.mojom.Fingerprint_RequestType_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.BiometricType } */
    this.type;
  }
};

goog.provide('device.mojom.FingerprintMessage');


mojo.internal.Union(
    device.mojom.FingerprintMessageSpec.$, 'FingerprintMessage',
    {
      'fingerprintError': {
        'ordinal': 0,
        'type': device.mojom.FingerprintErrorSpec.$,
      },
      'scanResult': {
        'ordinal': 1,
        'type': device.mojom.ScanResultSpec.$,
      },
    });

/**
 * @typedef { {
 *   fingerprintError: (!device.mojom.FingerprintError|undefined),
 *   scanResult: (!device.mojom.ScanResult|undefined),
 * } }
 */
device.mojom.FingerprintMessage;
