// services/device/public/mojom/fingerprint.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_FINGERPRINT_MOJOM_BLINK_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_FINGERPRINT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/fingerprint.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/fingerprint.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/fingerprint.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace device::mojom::blink {

class FingerprintObserverProxy;

template <typename ImplRefTraits>
class FingerprintObserverStub;

class FingerprintObserverRequestValidator;


class BLINK_PLATFORM_EXPORT FingerprintObserver
    : public FingerprintObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.FingerprintObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FingerprintObserverInterfaceBase;
  using Proxy_ = FingerprintObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = FingerprintObserverStub<ImplRefTraits>;

  using RequestValidator_ = FingerprintObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnRestartedMinVersion = 0,
    kOnStatusChangedMinVersion = 0,
    kOnEnrollScanDoneMinVersion = 0,
    kOnAuthScanDoneMinVersion = 0,
    kOnSessionFailedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnRestarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnStatusChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnEnrollScanDone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAuthScanDone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnSessionFailed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FingerprintObserver() = default;

  virtual void OnRestarted() = 0;

  virtual void OnStatusChanged(BiometricsManagerStatus status) = 0;

  virtual void OnEnrollScanDone(ScanResult scan_result, bool is_complete, int32_t percent_complete) = 0;

  virtual void OnAuthScanDone(FingerprintMessagePtr msg, const ::blink::HashMap<::blink::String, ::blink::Vector<::blink::String>>& matches) = 0;

  virtual void OnSessionFailed() = 0;
};

class FingerprintProxy;

template <typename ImplRefTraits>
class FingerprintStub;

class FingerprintRequestValidator;
class FingerprintResponseValidator;


class BLINK_PLATFORM_EXPORT Fingerprint
    : public FingerprintInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.Fingerprint";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FingerprintInterfaceBase;
  using Proxy_ = FingerprintProxy;

  template <typename ImplRefTraits>
  using Stub_ = FingerprintStub<ImplRefTraits>;

  using RequestValidator_ = FingerprintRequestValidator;
  using ResponseValidator_ = FingerprintResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetRecordsForUserMinVersion = 0,
    kStartEnrollSessionMinVersion = 0,
    kCancelCurrentEnrollSessionMinVersion = 0,
    kRequestRecordLabelMinVersion = 0,
    kSetRecordLabelMinVersion = 0,
    kRemoveRecordMinVersion = 0,
    kStartAuthSessionMinVersion = 0,
    kEndCurrentAuthSessionMinVersion = 0,
    kDestroyAllRecordsMinVersion = 0,
    kAddFingerprintObserverMinVersion = 0,
    kRequestTypeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetRecordsForUser_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartEnrollSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelCurrentEnrollSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestRecordLabel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetRecordLabel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveRecord_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartAuthSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EndCurrentAuthSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DestroyAllRecords_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddFingerprintObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestType_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Fingerprint() = default;

  using GetRecordsForUserCallback = base::OnceCallback<void(const ::blink::HashMap<::blink::String, ::blink::String>&, bool)>;
  using GetRecordsForUserMojoCallback = base::OnceCallback<void(const ::blink::HashMap<::blink::String, ::blink::String>&, bool)>;

  virtual void GetRecordsForUser(const ::blink::String& user_id, GetRecordsForUserCallback callback) = 0;

  virtual void StartEnrollSession(const ::blink::String& user_id, const ::blink::String& label) = 0;

  using CancelCurrentEnrollSessionCallback = base::OnceCallback<void(bool)>;
  using CancelCurrentEnrollSessionMojoCallback = base::OnceCallback<void(bool)>;

  virtual void CancelCurrentEnrollSession(CancelCurrentEnrollSessionCallback callback) = 0;

  using RequestRecordLabelCallback = base::OnceCallback<void(const ::blink::String&)>;
  using RequestRecordLabelMojoCallback = base::OnceCallback<void(const ::blink::String&)>;

  virtual void RequestRecordLabel(const ::blink::String& record_path, RequestRecordLabelCallback callback) = 0;

  using SetRecordLabelCallback = base::OnceCallback<void(bool)>;
  using SetRecordLabelMojoCallback = base::OnceCallback<void(bool)>;

  virtual void SetRecordLabel(const ::blink::String& record_path, const ::blink::String& new_label, SetRecordLabelCallback callback) = 0;

  using RemoveRecordCallback = base::OnceCallback<void(bool)>;
  using RemoveRecordMojoCallback = base::OnceCallback<void(bool)>;

  virtual void RemoveRecord(const ::blink::String& record_path, RemoveRecordCallback callback) = 0;

  virtual void StartAuthSession() = 0;

  using EndCurrentAuthSessionCallback = base::OnceCallback<void(bool)>;
  using EndCurrentAuthSessionMojoCallback = base::OnceCallback<void(bool)>;

  virtual void EndCurrentAuthSession(EndCurrentAuthSessionCallback callback) = 0;

  using DestroyAllRecordsCallback = base::OnceCallback<void(bool)>;
  using DestroyAllRecordsMojoCallback = base::OnceCallback<void(bool)>;

  virtual void DestroyAllRecords(DestroyAllRecordsCallback callback) = 0;

  virtual void AddFingerprintObserver(::mojo::PendingRemote<FingerprintObserver> observer) = 0;

  using RequestTypeCallback = base::OnceCallback<void(BiometricType)>;
  using RequestTypeMojoCallback = base::OnceCallback<void(BiometricType)>;

  virtual void RequestType(RequestTypeCallback callback) = 0;
};



class BLINK_PLATFORM_EXPORT FingerprintObserverProxy
    : public FingerprintObserver {
 public:
  using InterfaceType = FingerprintObserver;

  explicit FingerprintObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnRestarted() final;
  
  void OnStatusChanged(BiometricsManagerStatus status) final;
  
  void OnEnrollScanDone(ScanResult scan_result, bool is_complete, int32_t percent_complete) final;
  
  void OnAuthScanDone(FingerprintMessagePtr msg, const ::blink::HashMap<::blink::String, ::blink::Vector<::blink::String>>& matches) final;
  
  void OnSessionFailed() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT FingerprintProxy
    : public Fingerprint {
 public:
  using InterfaceType = Fingerprint;

  explicit FingerprintProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetRecordsForUser(const ::blink::String& user_id, GetRecordsForUserCallback callback) final;
  
  void StartEnrollSession(const ::blink::String& user_id, const ::blink::String& label) final;
  
  void CancelCurrentEnrollSession(CancelCurrentEnrollSessionCallback callback) final;
  
  void RequestRecordLabel(const ::blink::String& record_path, RequestRecordLabelCallback callback) final;
  
  void SetRecordLabel(const ::blink::String& record_path, const ::blink::String& new_label, SetRecordLabelCallback callback) final;
  
  void RemoveRecord(const ::blink::String& record_path, RemoveRecordCallback callback) final;
  
  void StartAuthSession() final;
  
  void EndCurrentAuthSession(EndCurrentAuthSessionCallback callback) final;
  
  void DestroyAllRecords(DestroyAllRecordsCallback callback) final;
  
  void AddFingerprintObserver(::mojo::PendingRemote<FingerprintObserver> observer) final;
  
  void RequestType(RequestTypeCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT FingerprintObserverStubDispatch {
 public:
  static bool Accept(FingerprintObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FingerprintObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FingerprintObserver>>
class FingerprintObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FingerprintObserverStub() = default;
  ~FingerprintObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FingerprintObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FingerprintObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT FingerprintStubDispatch {
 public:
  static bool Accept(Fingerprint* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Fingerprint* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Fingerprint>>
class FingerprintStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FingerprintStub() = default;
  ~FingerprintStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FingerprintStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FingerprintStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT FingerprintObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT FingerprintRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT FingerprintResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_PLATFORM_EXPORT FingerprintMessage {
 public:
  using DataView = FingerprintMessageDataView;
  using Data_ = internal::FingerprintMessage_Data;
  using Tag = Data_::FingerprintMessage_Tag;

  template <typename... Args>
  static FingerprintMessagePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |fingerprint_error|.
  static FingerprintMessagePtr NewFingerprintError(
      FingerprintError value);
  // Construct an instance holding |scan_result|.
  static FingerprintMessagePtr NewScanResult(
      ScanResult value);

  template <typename U>
  static FingerprintMessagePtr From(const U& u) {
    return mojo::TypeConverter<FingerprintMessagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FingerprintMessage>::Convert(*this);
  }
  ~FingerprintMessage();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = FingerprintMessagePtr>
  FingerprintMessagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, FingerprintMessage>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, FingerprintMessage>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_fingerprint_error() const { return tag_ == Tag::kFingerprintError; }
  FingerprintError get_fingerprint_error() const {
    CHECK(tag_ == Tag::kFingerprintError);
    return data_.fingerprint_error;
  }
  void set_fingerprint_error(FingerprintError fingerprint_error);

  bool is_scan_result() const { return tag_ == Tag::kScanResult; }
  ScanResult get_scan_result() const {
    CHECK(tag_ == Tag::kScanResult);
    return data_.scan_result;
  }
  void set_scan_result(ScanResult scan_result);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FingerprintMessage::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<FingerprintMessage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFingerprintError)>,
        FingerprintError value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kScanResult)>,
        ScanResult value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    FingerprintError fingerprint_error;
    ScanResult scan_result;
  };

  FingerprintMessage(
      std::in_place_index_t<static_cast<size_t>(Tag::kFingerprintError)>,
      FingerprintError value);
  FingerprintMessage(
      std::in_place_index_t<static_cast<size_t>(Tag::kScanResult)>,
      ScanResult value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};

template <typename UnionPtrType>
FingerprintMessagePtr FingerprintMessage::Clone() const {
  switch (tag_) {
    case Tag::kFingerprintError:
      return NewFingerprintError(
          mojo::Clone(data_.fingerprint_error));
    case Tag::kScanResult:
      return NewScanResult(
          mojo::Clone(data_.scan_result));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, FingerprintMessage>::value>::type*>
bool FingerprintMessage::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kFingerprintError:
      return mojo::Equals(data_.fingerprint_error, other.data_.fingerprint_error);
    case Tag::kScanResult:
      return mojo::Equals(data_.scan_result, other.data_.scan_result);
  }

  return false;
}


}  // device::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT UnionTraits<::device::mojom::blink::FingerprintMessage::DataView,
                                        ::device::mojom::blink::FingerprintMessagePtr> {
  static bool IsNull(const ::device::mojom::blink::FingerprintMessagePtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::FingerprintMessagePtr* output) { output->reset(); }

  static ::device::mojom::blink::FingerprintMessage::Tag GetTag(const ::device::mojom::blink::FingerprintMessagePtr& input) {
    return input->which();
  }

  static  ::device::mojom::blink::FingerprintError fingerprint_error(const ::device::mojom::blink::FingerprintMessagePtr& input) {
    return input->get_fingerprint_error();
  }

  static  ::device::mojom::blink::ScanResult scan_result(const ::device::mojom::blink::FingerprintMessagePtr& input) {
    return input->get_scan_result();
  }

  static bool Read(::device::mojom::blink::FingerprintMessage::DataView input, ::device::mojom::blink::FingerprintMessagePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_FINGERPRINT_MOJOM_BLINK_H_