// services/data_decoder/public/mojom/xml_parser.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_XML_PARSER_MOJOM_PARAMS_DATA_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_XML_PARSER_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace data_decoder::mojom {
namespace internal {
class  XmlParser_Parse_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> xml;
  int32_t whitespace_behavior;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<XmlParser_Parse_Params_Data>;

  XmlParser_Parse_Params_Data();
  ~XmlParser_Parse_Params_Data() = delete;
};
static_assert(sizeof(XmlParser_Parse_Params_Data) == 24,
              "Bad sizeof(XmlParser_Parse_Params_Data)");
class  XmlParser_Parse_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  ::mojo_base::mojom::internal::Value_Data result;
  mojo::internal::Pointer<mojo::internal::String_Data> error;

 private:
  friend class mojo::internal::MessageFragment<XmlParser_Parse_ResponseParams_Data>;

  XmlParser_Parse_ResponseParams_Data();
  ~XmlParser_Parse_ResponseParams_Data() = delete;
};
static_assert(sizeof(XmlParser_Parse_ResponseParams_Data) == 32,
              "Bad sizeof(XmlParser_Parse_ResponseParams_Data)");

}  // namespace internal


class XmlParser_Parse_ParamsDataView {
 public:
  XmlParser_Parse_ParamsDataView() = default;

  XmlParser_Parse_ParamsDataView(
      internal::XmlParser_Parse_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetXmlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadXml(UserType* output) {
    
    auto* pointer = data_->xml.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWhitespaceBehavior(UserType* output) const {
    auto data_value = data_->whitespace_behavior;
    return mojo::internal::Deserialize<::data_decoder::mojom::XmlParser_WhitespaceBehavior>(
        data_value, output);
  }
  XmlParser_WhitespaceBehavior whitespace_behavior() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::data_decoder::mojom::XmlParser_WhitespaceBehavior>(data_->whitespace_behavior));
  }
 private:
  internal::XmlParser_Parse_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XmlParser_Parse_ResponseParamsDataView {
 public:
  XmlParser_Parse_ResponseParamsDataView() = default;

  XmlParser_Parse_ResponseParamsDataView(
      internal::XmlParser_Parse_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      ::mojo_base::mojom::ValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ValueDataView, UserType>(),
    "Attempting to read the optional `result` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResult` instead "
    "of `ReadResult if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->result.is_null() ? &data_->result : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::ValueDataView>(
        pointer, output, message_);
  }
  inline void GetErrorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `error` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadError` instead "
    "of `ReadError if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->error.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::XmlParser_Parse_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void XmlParser_Parse_ParamsDataView::GetXmlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->xml.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void XmlParser_Parse_ResponseParamsDataView::GetResultDataView(
    ::mojo_base::mojom::ValueDataView* output) {
  auto pointer = &data_->result;
  *output = ::mojo_base::mojom::ValueDataView(pointer, message_);
}
inline void XmlParser_Parse_ResponseParamsDataView::GetErrorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // data_decoder::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_DATA_DECODER_PUBLIC_MOJOM_XML_PARSER_MOJOM_PARAMS_DATA_H_