// services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_CERT_VERIFIER_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_FACTORY_MOJOM_H_
#define SERVICES_CERT_VERIFIER_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_FACTORY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-features.h"  // IWYU pragma: export
#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-shared.h"  // IWYU pragma: export
#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom-forward.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-forward.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/cert_verifier_service.mojom-forward.h"
#include "services/network/public/mojom/cert_verifier_service_updater.mojom.h"
#include "services/network/public/mojom/ct_policy.mojom.h"
#include "services/network/public/mojom/network_param.mojom-forward.h"
#include "services/network/public/mojom/ct_log_info.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace cert_verifier::mojom {

class CertVerifierServiceFactoryProxy;

template <typename ImplRefTraits>
class CertVerifierServiceFactoryStub;

class CertVerifierServiceFactoryRequestValidator;
class CertVerifierServiceFactoryResponseValidator;


class CertVerifierServiceFactory
    : public CertVerifierServiceFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "cert_verifier.mojom.CertVerifierServiceFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CertVerifierServiceFactoryInterfaceBase;
  using Proxy_ = CertVerifierServiceFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = CertVerifierServiceFactoryStub<ImplRefTraits>;

  using RequestValidator_ = CertVerifierServiceFactoryRequestValidator;
  using ResponseValidator_ = CertVerifierServiceFactoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetNewCertVerifierMinVersion = 0,
    kUpdateCRLSetMinVersion = 0,
    kUpdateCtLogListMinVersion = 0,
    kDisableCtEnforcementMinVersion = 0,
    kUpdateChromeRootStoreMinVersion = 0,
    kUpdateMtcMetadataMinVersion = 0,
    kGetChromeRootStoreInfoMinVersion = 0,
    kGetPlatformRootStoreInfoMinVersion = 0,
    kUpdateNetworkTimeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetNewCertVerifier_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateCRLSet_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateCtLogList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisableCtEnforcement_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateChromeRootStore_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateMtcMetadata_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetChromeRootStoreInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPlatformRootStoreInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateNetworkTime_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CertVerifierServiceFactory() = default;

  virtual void GetNewCertVerifier(::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierService> receiver, ::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierServiceUpdater> updater, ::mojo::PendingRemote<::cert_verifier::mojom::CertVerifierServiceClient> client, CertVerifierCreationParamsPtr creation_params) = 0;

  using UpdateCRLSetCallback = base::OnceCallback<void()>;
  using UpdateCRLSetMojoCallback = base::OnceCallback<void()>;

  virtual void UpdateCRLSet(::mojo_base::BigBuffer crl_set, UpdateCRLSetCallback callback) = 0;

  using UpdateCtLogListCallback = base::OnceCallback<void()>;
  using UpdateCtLogListMojoCallback = base::OnceCallback<void()>;

  virtual void UpdateCtLogList(std::vector<::network::mojom::CTLogInfoPtr> log_list, ::base::Time update_time, UpdateCtLogListCallback callback) = 0;

  using DisableCtEnforcementCallback = base::OnceCallback<void()>;
  using DisableCtEnforcementMojoCallback = base::OnceCallback<void()>;

  virtual void DisableCtEnforcement(DisableCtEnforcementCallback callback) = 0;

  using UpdateChromeRootStoreCallback = base::OnceCallback<void()>;
  using UpdateChromeRootStoreMojoCallback = base::OnceCallback<void()>;

  virtual void UpdateChromeRootStore(::mojo_base::ProtoWrapper new_root_store, UpdateChromeRootStoreCallback callback) = 0;

  using UpdateMtcMetadataCallback = base::OnceCallback<void()>;
  using UpdateMtcMetadataMojoCallback = base::OnceCallback<void()>;

  virtual void UpdateMtcMetadata(::mojo_base::ProtoWrapper new_mtc_metadata, UpdateMtcMetadataCallback callback) = 0;

  using GetChromeRootStoreInfoCallback = base::OnceCallback<void(ChromeRootStoreInfoPtr)>;
  using GetChromeRootStoreInfoMojoCallback = base::OnceCallback<void(ChromeRootStoreInfoPtr)>;

  virtual void GetChromeRootStoreInfo(GetChromeRootStoreInfoCallback callback) = 0;

  using GetPlatformRootStoreInfoCallback = base::OnceCallback<void(PlatformRootStoreInfoPtr)>;
  using GetPlatformRootStoreInfoMojoCallback = base::OnceCallback<void(PlatformRootStoreInfoPtr)>;

  virtual void GetPlatformRootStoreInfo(GetPlatformRootStoreInfoCallback callback) = 0;

  virtual void UpdateNetworkTime(::base::Time system_time, ::base::TimeTicks system_ticks, ::base::Time current_time) = 0;
};



class  CertVerifierServiceFactoryProxy
    : public CertVerifierServiceFactory {
 public:
  using InterfaceType = CertVerifierServiceFactory;

  explicit CertVerifierServiceFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetNewCertVerifier(::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierService> receiver, ::mojo::PendingReceiver<::cert_verifier::mojom::CertVerifierServiceUpdater> updater, ::mojo::PendingRemote<::cert_verifier::mojom::CertVerifierServiceClient> client, CertVerifierCreationParamsPtr creation_params) final;
  
  void UpdateCRLSet(::mojo_base::BigBuffer crl_set, UpdateCRLSetCallback callback) final;
  
  void UpdateCtLogList(std::vector<::network::mojom::CTLogInfoPtr> log_list, ::base::Time update_time, UpdateCtLogListCallback callback) final;
  
  void DisableCtEnforcement(DisableCtEnforcementCallback callback) final;
  
  void UpdateChromeRootStore(::mojo_base::ProtoWrapper new_root_store, UpdateChromeRootStoreCallback callback) final;
  
  void UpdateMtcMetadata(::mojo_base::ProtoWrapper new_mtc_metadata, UpdateMtcMetadataCallback callback) final;
  
  void GetChromeRootStoreInfo(GetChromeRootStoreInfoCallback callback) final;
  
  void GetPlatformRootStoreInfo(GetPlatformRootStoreInfoCallback callback) final;
  
  void UpdateNetworkTime(::base::Time system_time, ::base::TimeTicks system_ticks, ::base::Time current_time) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CertVerifierServiceFactoryStubDispatch {
 public:
  static bool Accept(CertVerifierServiceFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CertVerifierServiceFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CertVerifierServiceFactory>>
class CertVerifierServiceFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CertVerifierServiceFactoryStub() = default;
  ~CertVerifierServiceFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertVerifierServiceFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertVerifierServiceFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CertVerifierServiceFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CertVerifierServiceFactoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};












class  CertVerifierCreationParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CertVerifierCreationParams, T>::value>;
  using DataView = CertVerifierCreationParamsDataView;
  using Data_ = internal::CertVerifierCreationParams_Data;

  template <typename... Args>
  static CertVerifierCreationParamsPtr New(Args&&... args) {
    return CertVerifierCreationParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CertVerifierCreationParamsPtr From(const U& u) {
    return mojo::TypeConverter<CertVerifierCreationParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CertVerifierCreationParams>::Convert(*this);
  }


  CertVerifierCreationParams();

  CertVerifierCreationParams(
      ::cert_verifier::mojom::AdditionalCertificatesPtr initial_additional_certificates,
      bool wait_for_update,
      ::network::mojom::CTPolicyPtr ct_policy);

CertVerifierCreationParams(const CertVerifierCreationParams&) = delete;
CertVerifierCreationParams& operator=(const CertVerifierCreationParams&) = delete;

  ~CertVerifierCreationParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CertVerifierCreationParamsPtr>
  CertVerifierCreationParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CertVerifierCreationParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CertVerifierCreationParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CertVerifierCreationParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CertVerifierCreationParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CertVerifierCreationParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CertVerifierCreationParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CertVerifierCreationParams_UnserializedMessageContext<
            UserType, CertVerifierCreationParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CertVerifierCreationParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CertVerifierCreationParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CertVerifierCreationParams_UnserializedMessageContext<
            UserType, CertVerifierCreationParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CertVerifierCreationParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::cert_verifier::mojom::AdditionalCertificatesPtr initial_additional_certificates;
  
  bool wait_for_update;
  
  ::network::mojom::CTPolicyPtr ct_policy;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CertVerifierCreationParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CertVerifierCreationParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CertVerifierCreationParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CertVerifierCreationParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ChromeRootCertInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ChromeRootCertInfo, T>::value>;
  using DataView = ChromeRootCertInfoDataView;
  using Data_ = internal::ChromeRootCertInfo_Data;

  template <typename... Args>
  static ChromeRootCertInfoPtr New(Args&&... args) {
    return ChromeRootCertInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ChromeRootCertInfoPtr From(const U& u) {
    return mojo::TypeConverter<ChromeRootCertInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ChromeRootCertInfo>::Convert(*this);
  }


  ChromeRootCertInfo();

  ChromeRootCertInfo(
      const std::string& sha256hash_hex,
      std::vector<uint8_t> cert);


  ~ChromeRootCertInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ChromeRootCertInfoPtr>
  ChromeRootCertInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ChromeRootCertInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ChromeRootCertInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ChromeRootCertInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChromeRootCertInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChromeRootCertInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ChromeRootCertInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ChromeRootCertInfo_UnserializedMessageContext<
            UserType, ChromeRootCertInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ChromeRootCertInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ChromeRootCertInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ChromeRootCertInfo_UnserializedMessageContext<
            UserType, ChromeRootCertInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ChromeRootCertInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string sha256hash_hex;
  
  std::vector<uint8_t> cert;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ChromeRootCertInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ChromeRootCertInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ChromeRootCertInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ChromeRootCertInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ChromeRootStoreInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ChromeRootStoreInfo, T>::value>;
  using DataView = ChromeRootStoreInfoDataView;
  using Data_ = internal::ChromeRootStoreInfo_Data;

  template <typename... Args>
  static ChromeRootStoreInfoPtr New(Args&&... args) {
    return ChromeRootStoreInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ChromeRootStoreInfoPtr From(const U& u) {
    return mojo::TypeConverter<ChromeRootStoreInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ChromeRootStoreInfo>::Convert(*this);
  }


  ChromeRootStoreInfo();

  ChromeRootStoreInfo(
      int64_t version,
      std::vector<ChromeRootCertInfoPtr> root_cert_info);

ChromeRootStoreInfo(const ChromeRootStoreInfo&) = delete;
ChromeRootStoreInfo& operator=(const ChromeRootStoreInfo&) = delete;

  ~ChromeRootStoreInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ChromeRootStoreInfoPtr>
  ChromeRootStoreInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ChromeRootStoreInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ChromeRootStoreInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ChromeRootStoreInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChromeRootStoreInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChromeRootStoreInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ChromeRootStoreInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ChromeRootStoreInfo_UnserializedMessageContext<
            UserType, ChromeRootStoreInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ChromeRootStoreInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ChromeRootStoreInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ChromeRootStoreInfo_UnserializedMessageContext<
            UserType, ChromeRootStoreInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ChromeRootStoreInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t version;
  
  std::vector<ChromeRootCertInfoPtr> root_cert_info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ChromeRootStoreInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ChromeRootStoreInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ChromeRootStoreInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ChromeRootStoreInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PlatformCertInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PlatformCertInfo, T>::value>;
  using DataView = PlatformCertInfoDataView;
  using Data_ = internal::PlatformCertInfo_Data;

  template <typename... Args>
  static PlatformCertInfoPtr New(Args&&... args) {
    return PlatformCertInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PlatformCertInfoPtr From(const U& u) {
    return mojo::TypeConverter<PlatformCertInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PlatformCertInfo>::Convert(*this);
  }


  PlatformCertInfo();

  PlatformCertInfo(
      std::vector<uint8_t> cert,
      CertificateTrust trust_setting);


  ~PlatformCertInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PlatformCertInfoPtr>
  PlatformCertInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PlatformCertInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PlatformCertInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PlatformCertInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PlatformCertInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PlatformCertInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PlatformCertInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PlatformCertInfo_UnserializedMessageContext<
            UserType, PlatformCertInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PlatformCertInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PlatformCertInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PlatformCertInfo_UnserializedMessageContext<
            UserType, PlatformCertInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PlatformCertInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> cert;
  
  CertificateTrust trust_setting;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PlatformCertInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PlatformCertInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PlatformCertInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PlatformCertInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PlatformRootStoreInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PlatformRootStoreInfo, T>::value>;
  using DataView = PlatformRootStoreInfoDataView;
  using Data_ = internal::PlatformRootStoreInfo_Data;

  template <typename... Args>
  static PlatformRootStoreInfoPtr New(Args&&... args) {
    return PlatformRootStoreInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PlatformRootStoreInfoPtr From(const U& u) {
    return mojo::TypeConverter<PlatformRootStoreInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PlatformRootStoreInfo>::Convert(*this);
  }


  PlatformRootStoreInfo();

  explicit PlatformRootStoreInfo(
      std::vector<PlatformCertInfoPtr> user_added_certs);

PlatformRootStoreInfo(const PlatformRootStoreInfo&) = delete;
PlatformRootStoreInfo& operator=(const PlatformRootStoreInfo&) = delete;

  ~PlatformRootStoreInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PlatformRootStoreInfoPtr>
  PlatformRootStoreInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PlatformRootStoreInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PlatformRootStoreInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PlatformRootStoreInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PlatformRootStoreInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PlatformRootStoreInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PlatformRootStoreInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PlatformRootStoreInfo_UnserializedMessageContext<
            UserType, PlatformRootStoreInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PlatformRootStoreInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PlatformRootStoreInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PlatformRootStoreInfo_UnserializedMessageContext<
            UserType, PlatformRootStoreInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PlatformRootStoreInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<PlatformCertInfoPtr> user_added_certs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PlatformRootStoreInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PlatformRootStoreInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PlatformRootStoreInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PlatformRootStoreInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CertVerifierCreationParamsPtr CertVerifierCreationParams::Clone() const {
  return New(
      mojo::Clone(initial_additional_certificates),
      mojo::Clone(wait_for_update),
      mojo::Clone(ct_policy)
  );
}

template <typename T, CertVerifierCreationParams::EnableIfSame<T>*>
bool CertVerifierCreationParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->initial_additional_certificates, other_struct.initial_additional_certificates))
    return false;
  if (!mojo::Equals(this->wait_for_update, other_struct.wait_for_update))
    return false;
  if (!mojo::Equals(this->ct_policy, other_struct.ct_policy))
    return false;
  return true;
}

template <typename T, CertVerifierCreationParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.initial_additional_certificates < rhs.initial_additional_certificates)
    return true;
  if (rhs.initial_additional_certificates < lhs.initial_additional_certificates)
    return false;
  if (lhs.wait_for_update < rhs.wait_for_update)
    return true;
  if (rhs.wait_for_update < lhs.wait_for_update)
    return false;
  if (lhs.ct_policy < rhs.ct_policy)
    return true;
  if (rhs.ct_policy < lhs.ct_policy)
    return false;
  return false;
}
template <typename StructPtrType>
ChromeRootCertInfoPtr ChromeRootCertInfo::Clone() const {
  return New(
      mojo::Clone(sha256hash_hex),
      mojo::Clone(cert)
  );
}

template <typename T, ChromeRootCertInfo::EnableIfSame<T>*>
bool ChromeRootCertInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sha256hash_hex, other_struct.sha256hash_hex))
    return false;
  if (!mojo::Equals(this->cert, other_struct.cert))
    return false;
  return true;
}

template <typename T, ChromeRootCertInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sha256hash_hex < rhs.sha256hash_hex)
    return true;
  if (rhs.sha256hash_hex < lhs.sha256hash_hex)
    return false;
  if (lhs.cert < rhs.cert)
    return true;
  if (rhs.cert < lhs.cert)
    return false;
  return false;
}
template <typename StructPtrType>
ChromeRootStoreInfoPtr ChromeRootStoreInfo::Clone() const {
  return New(
      mojo::Clone(version),
      mojo::Clone(root_cert_info)
  );
}

template <typename T, ChromeRootStoreInfo::EnableIfSame<T>*>
bool ChromeRootStoreInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->root_cert_info, other_struct.root_cert_info))
    return false;
  return true;
}

template <typename T, ChromeRootStoreInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.root_cert_info < rhs.root_cert_info)
    return true;
  if (rhs.root_cert_info < lhs.root_cert_info)
    return false;
  return false;
}
template <typename StructPtrType>
PlatformCertInfoPtr PlatformCertInfo::Clone() const {
  return New(
      mojo::Clone(cert),
      mojo::Clone(trust_setting)
  );
}

template <typename T, PlatformCertInfo::EnableIfSame<T>*>
bool PlatformCertInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cert, other_struct.cert))
    return false;
  if (!mojo::Equals(this->trust_setting, other_struct.trust_setting))
    return false;
  return true;
}

template <typename T, PlatformCertInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cert < rhs.cert)
    return true;
  if (rhs.cert < lhs.cert)
    return false;
  if (lhs.trust_setting < rhs.trust_setting)
    return true;
  if (rhs.trust_setting < lhs.trust_setting)
    return false;
  return false;
}
template <typename StructPtrType>
PlatformRootStoreInfoPtr PlatformRootStoreInfo::Clone() const {
  return New(
      mojo::Clone(user_added_certs)
  );
}

template <typename T, PlatformRootStoreInfo::EnableIfSame<T>*>
bool PlatformRootStoreInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->user_added_certs, other_struct.user_added_certs))
    return false;
  return true;
}

template <typename T, PlatformRootStoreInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.user_added_certs < rhs.user_added_certs)
    return true;
  if (rhs.user_added_certs < lhs.user_added_certs)
    return false;
  return false;
}


}  // cert_verifier::mojom

namespace mojo {


template <>
struct  StructTraits<::cert_verifier::mojom::CertVerifierCreationParams::DataView,
                                         ::cert_verifier::mojom::CertVerifierCreationParamsPtr> {
  static bool IsNull(const ::cert_verifier::mojom::CertVerifierCreationParamsPtr& input) { return !input; }
  static void SetToNull(::cert_verifier::mojom::CertVerifierCreationParamsPtr* output) { output->reset(); }

  static const decltype(::cert_verifier::mojom::CertVerifierCreationParams::initial_additional_certificates)& initial_additional_certificates(
      const ::cert_verifier::mojom::CertVerifierCreationParamsPtr& input) {
    return input->initial_additional_certificates;
  }

  static decltype(::cert_verifier::mojom::CertVerifierCreationParams::wait_for_update) wait_for_update(
      const ::cert_verifier::mojom::CertVerifierCreationParamsPtr& input) {
    return input->wait_for_update;
  }

  static const decltype(::cert_verifier::mojom::CertVerifierCreationParams::ct_policy)& ct_policy(
      const ::cert_verifier::mojom::CertVerifierCreationParamsPtr& input) {
    return input->ct_policy;
  }

  static bool Read(::cert_verifier::mojom::CertVerifierCreationParams::DataView input, ::cert_verifier::mojom::CertVerifierCreationParamsPtr* output);
};


template <>
struct  StructTraits<::cert_verifier::mojom::ChromeRootCertInfo::DataView,
                                         ::cert_verifier::mojom::ChromeRootCertInfoPtr> {
  static bool IsNull(const ::cert_verifier::mojom::ChromeRootCertInfoPtr& input) { return !input; }
  static void SetToNull(::cert_verifier::mojom::ChromeRootCertInfoPtr* output) { output->reset(); }

  static const decltype(::cert_verifier::mojom::ChromeRootCertInfo::sha256hash_hex)& sha256hash_hex(
      const ::cert_verifier::mojom::ChromeRootCertInfoPtr& input) {
    return input->sha256hash_hex;
  }

  static const decltype(::cert_verifier::mojom::ChromeRootCertInfo::cert)& cert(
      const ::cert_verifier::mojom::ChromeRootCertInfoPtr& input) {
    return input->cert;
  }

  static bool Read(::cert_verifier::mojom::ChromeRootCertInfo::DataView input, ::cert_verifier::mojom::ChromeRootCertInfoPtr* output);
};


template <>
struct  StructTraits<::cert_verifier::mojom::ChromeRootStoreInfo::DataView,
                                         ::cert_verifier::mojom::ChromeRootStoreInfoPtr> {
  static bool IsNull(const ::cert_verifier::mojom::ChromeRootStoreInfoPtr& input) { return !input; }
  static void SetToNull(::cert_verifier::mojom::ChromeRootStoreInfoPtr* output) { output->reset(); }

  static decltype(::cert_verifier::mojom::ChromeRootStoreInfo::version) version(
      const ::cert_verifier::mojom::ChromeRootStoreInfoPtr& input) {
    return input->version;
  }

  static const decltype(::cert_verifier::mojom::ChromeRootStoreInfo::root_cert_info)& root_cert_info(
      const ::cert_verifier::mojom::ChromeRootStoreInfoPtr& input) {
    return input->root_cert_info;
  }

  static bool Read(::cert_verifier::mojom::ChromeRootStoreInfo::DataView input, ::cert_verifier::mojom::ChromeRootStoreInfoPtr* output);
};


template <>
struct  StructTraits<::cert_verifier::mojom::PlatformCertInfo::DataView,
                                         ::cert_verifier::mojom::PlatformCertInfoPtr> {
  static bool IsNull(const ::cert_verifier::mojom::PlatformCertInfoPtr& input) { return !input; }
  static void SetToNull(::cert_verifier::mojom::PlatformCertInfoPtr* output) { output->reset(); }

  static const decltype(::cert_verifier::mojom::PlatformCertInfo::cert)& cert(
      const ::cert_verifier::mojom::PlatformCertInfoPtr& input) {
    return input->cert;
  }

  static decltype(::cert_verifier::mojom::PlatformCertInfo::trust_setting) trust_setting(
      const ::cert_verifier::mojom::PlatformCertInfoPtr& input) {
    return input->trust_setting;
  }

  static bool Read(::cert_verifier::mojom::PlatformCertInfo::DataView input, ::cert_verifier::mojom::PlatformCertInfoPtr* output);
};


template <>
struct  StructTraits<::cert_verifier::mojom::PlatformRootStoreInfo::DataView,
                                         ::cert_verifier::mojom::PlatformRootStoreInfoPtr> {
  static bool IsNull(const ::cert_verifier::mojom::PlatformRootStoreInfoPtr& input) { return !input; }
  static void SetToNull(::cert_verifier::mojom::PlatformRootStoreInfoPtr* output) { output->reset(); }

  static const decltype(::cert_verifier::mojom::PlatformRootStoreInfo::user_added_certs)& user_added_certs(
      const ::cert_verifier::mojom::PlatformRootStoreInfoPtr& input) {
    return input->user_added_certs;
  }

  static bool Read(::cert_verifier::mojom::PlatformRootStoreInfo::DataView input, ::cert_verifier::mojom::PlatformRootStoreInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_CERT_VERIFIER_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_FACTORY_MOJOM_H_