// services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_CERT_VERIFIER_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_FACTORY_MOJOM_SEND_VALIDATION_H_
#define SERVICES_CERT_VERIFIER_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_FACTORY_MOJOM_SEND_VALIDATION_H_

#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom-shared.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/cert_verifier_service.mojom-shared.h"
#include "services/network/public/mojom/cert_verifier_service_updater.mojom-shared.h"
#include "services/network/public/mojom/ct_policy.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/ct_log_info.mojom-shared.h"

#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::cert_verifier::mojom::CertificateTrust, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::cert_verifier::mojom::CertVerifierCreationParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::CertVerifierCreationParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::CertVerifierCreationParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::initial_additional_certificates(input)) in_initial_additional_certificates = Traits::initial_additional_certificates(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->initial_additional_certificates)::BaseType> initial_additional_certificates_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::cert_verifier::mojom::AdditionalCertificatesDataView, send_validation>(
        in_initial_additional_certificates,
        initial_additional_certificates_fragment);

      fragment->initial_additional_certificates.Set(
          initial_additional_certificates_fragment.is_null() ? nullptr : initial_additional_certificates_fragment.data());

      fragment->wait_for_update = Traits::wait_for_update(input);

      decltype(Traits::ct_policy(input)) in_ct_policy = Traits::ct_policy(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ct_policy)::BaseType> ct_policy_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CTPolicyDataView, send_validation>(
        in_ct_policy,
        ct_policy_fragment);

      fragment->ct_policy.Set(
          ct_policy_fragment.is_null() ? nullptr : ct_policy_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::cert_verifier::mojom::ChromeRootCertInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::ChromeRootCertInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::ChromeRootCertInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::sha256hash_hex(input)) in_sha256hash_hex = Traits::sha256hash_hex(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sha256hash_hex)::BaseType> sha256hash_hex_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_sha256hash_hex,
        sha256hash_hex_fragment);

      fragment->sha256hash_hex.Set(
          sha256hash_hex_fragment.is_null() ? nullptr : sha256hash_hex_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sha256hash_hex.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sha256hash_hex in ChromeRootCertInfo struct");

      decltype(Traits::cert(input)) in_cert = Traits::cert(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cert)::BaseType>
          cert_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& cert_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_cert,
        cert_fragment,
        &cert_validate_params);

      fragment->cert.Set(
          cert_fragment.is_null() ? nullptr : cert_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cert.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cert in ChromeRootCertInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::cert_verifier::mojom::ChromeRootStoreInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::ChromeRootStoreInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::ChromeRootStoreInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->version = Traits::version(input);

      decltype(Traits::root_cert_info(input)) in_root_cert_info = Traits::root_cert_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->root_cert_info)::BaseType>
          root_cert_info_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& root_cert_info_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::cert_verifier::mojom::ChromeRootCertInfoDataView>, send_validation>(
        in_root_cert_info,
        root_cert_info_fragment,
        &root_cert_info_validate_params);

      fragment->root_cert_info.Set(
          root_cert_info_fragment.is_null() ? nullptr : root_cert_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->root_cert_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null root_cert_info in ChromeRootStoreInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::cert_verifier::mojom::PlatformCertInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::PlatformCertInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::PlatformCertInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::cert(input)) in_cert = Traits::cert(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cert)::BaseType>
          cert_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& cert_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_cert,
        cert_fragment,
        &cert_validate_params);

      fragment->cert.Set(
          cert_fragment.is_null() ? nullptr : cert_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cert.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cert in PlatformCertInfo struct");

      
      mojo::internal::Serialize<::cert_verifier::mojom::CertificateTrust>(
        Traits::trust_setting(input),
        &fragment->trust_setting);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::cert_verifier::mojom::PlatformRootStoreInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::PlatformRootStoreInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::PlatformRootStoreInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::user_added_certs(input)) in_user_added_certs = Traits::user_added_certs(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->user_added_certs)::BaseType>
          user_added_certs_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& user_added_certs_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::cert_verifier::mojom::PlatformCertInfoDataView>, send_validation>(
        in_user_added_certs,
        user_added_certs_fragment,
        &user_added_certs_validate_params);

      fragment->user_added_certs.Set(
          user_added_certs_fragment.is_null() ? nullptr : user_added_certs_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->user_added_certs.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null user_added_certs in PlatformRootStoreInfo struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_CERT_VERIFIER_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_FACTORY_MOJOM_SEND_VALIDATION_H_