// services/audio/public/mojom/system_info.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/audio/public/mojom/system_info.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/audio/public/mojom/system_info.mojom-params-data.h"
#include "services/audio/public/mojom/system_info.mojom-shared-message-ids.h"

#include "services/audio/public/mojom/system_info.mojom-import-headers.h"
#include "services/audio/public/mojom/system_info.mojom-test-utils.h"


namespace audio::mojom {
// The declaration includes the definition on other builds.

SystemInfo::IPCStableHashFunction SystemInfo::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SystemInfo>(message.name())) {
    case messages::SystemInfo::kGetInputStreamParameters: {
      return &SystemInfo::GetInputStreamParameters_Sym::IPCStableHash;
    }
    case messages::SystemInfo::kGetOutputStreamParameters: {
      return &SystemInfo::GetOutputStreamParameters_Sym::IPCStableHash;
    }
    case messages::SystemInfo::kHasInputDevices: {
      return &SystemInfo::HasInputDevices_Sym::IPCStableHash;
    }
    case messages::SystemInfo::kHasOutputDevices: {
      return &SystemInfo::HasOutputDevices_Sym::IPCStableHash;
    }
    case messages::SystemInfo::kGetInputDeviceDescriptions: {
      return &SystemInfo::GetInputDeviceDescriptions_Sym::IPCStableHash;
    }
    case messages::SystemInfo::kGetOutputDeviceDescriptions: {
      return &SystemInfo::GetOutputDeviceDescriptions_Sym::IPCStableHash;
    }
    case messages::SystemInfo::kGetAssociatedOutputDeviceID: {
      return &SystemInfo::GetAssociatedOutputDeviceID_Sym::IPCStableHash;
    }
    case messages::SystemInfo::kGetInputDeviceInfo: {
      return &SystemInfo::GetInputDeviceInfo_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SystemInfo::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SystemInfo>(message.name())) {
      case messages::SystemInfo::kGetInputStreamParameters:
            return "Receive audio::mojom::SystemInfo::GetInputStreamParameters";
      case messages::SystemInfo::kGetOutputStreamParameters:
            return "Receive audio::mojom::SystemInfo::GetOutputStreamParameters";
      case messages::SystemInfo::kHasInputDevices:
            return "Receive audio::mojom::SystemInfo::HasInputDevices";
      case messages::SystemInfo::kHasOutputDevices:
            return "Receive audio::mojom::SystemInfo::HasOutputDevices";
      case messages::SystemInfo::kGetInputDeviceDescriptions:
            return "Receive audio::mojom::SystemInfo::GetInputDeviceDescriptions";
      case messages::SystemInfo::kGetOutputDeviceDescriptions:
            return "Receive audio::mojom::SystemInfo::GetOutputDeviceDescriptions";
      case messages::SystemInfo::kGetAssociatedOutputDeviceID:
            return "Receive audio::mojom::SystemInfo::GetAssociatedOutputDeviceID";
      case messages::SystemInfo::kGetInputDeviceInfo:
            return "Receive audio::mojom::SystemInfo::GetInputDeviceInfo";
    }
  } else {
    switch (static_cast<messages::SystemInfo>(message.name())) {
      case messages::SystemInfo::kGetInputStreamParameters:
            return "Receive reply audio::mojom::SystemInfo::GetInputStreamParameters";
      case messages::SystemInfo::kGetOutputStreamParameters:
            return "Receive reply audio::mojom::SystemInfo::GetOutputStreamParameters";
      case messages::SystemInfo::kHasInputDevices:
            return "Receive reply audio::mojom::SystemInfo::HasInputDevices";
      case messages::SystemInfo::kHasOutputDevices:
            return "Receive reply audio::mojom::SystemInfo::HasOutputDevices";
      case messages::SystemInfo::kGetInputDeviceDescriptions:
            return "Receive reply audio::mojom::SystemInfo::GetInputDeviceDescriptions";
      case messages::SystemInfo::kGetOutputDeviceDescriptions:
            return "Receive reply audio::mojom::SystemInfo::GetOutputDeviceDescriptions";
      case messages::SystemInfo::kGetAssociatedOutputDeviceID:
            return "Receive reply audio::mojom::SystemInfo::GetAssociatedOutputDeviceID";
      case messages::SystemInfo::kGetInputDeviceInfo:
            return "Receive reply audio::mojom::SystemInfo::GetInputDeviceInfo";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SystemInfo::GetInputStreamParameters_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7db3fe18;  // IPCStableHash for audio::mojom::SystemInfo::GetInputStreamParameters
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemInfo::GetOutputStreamParameters_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x60354922;  // IPCStableHash for audio::mojom::SystemInfo::GetOutputStreamParameters
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemInfo::HasInputDevices_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbac5d4c5;  // IPCStableHash for audio::mojom::SystemInfo::HasInputDevices
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemInfo::HasOutputDevices_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb75a99e0;  // IPCStableHash for audio::mojom::SystemInfo::HasOutputDevices
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemInfo::GetInputDeviceDescriptions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1a196416;  // IPCStableHash for audio::mojom::SystemInfo::GetInputDeviceDescriptions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemInfo::GetOutputDeviceDescriptions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3ca919d8;  // IPCStableHash for audio::mojom::SystemInfo::GetOutputDeviceDescriptions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemInfo::GetAssociatedOutputDeviceID_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa1b004a9;  // IPCStableHash for audio::mojom::SystemInfo::GetAssociatedOutputDeviceID
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SystemInfo::GetInputDeviceInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10662566;  // IPCStableHash for audio::mojom::SystemInfo::GetInputDeviceInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SystemInfo_GetInputStreamParameters_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SystemInfo_GetInputStreamParameters_ForwardToCallback(
      SystemInfo::GetInputStreamParametersCallback callback
      ) : callback_(std::move(callback)) {
  }

  SystemInfo_GetInputStreamParameters_ForwardToCallback(const SystemInfo_GetInputStreamParameters_ForwardToCallback&) = delete;
  SystemInfo_GetInputStreamParameters_ForwardToCallback& operator=(const SystemInfo_GetInputStreamParameters_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SystemInfo::GetInputStreamParametersCallback callback_;
};

class SystemInfo_GetOutputStreamParameters_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SystemInfo_GetOutputStreamParameters_ForwardToCallback(
      SystemInfo::GetOutputStreamParametersCallback callback
      ) : callback_(std::move(callback)) {
  }

  SystemInfo_GetOutputStreamParameters_ForwardToCallback(const SystemInfo_GetOutputStreamParameters_ForwardToCallback&) = delete;
  SystemInfo_GetOutputStreamParameters_ForwardToCallback& operator=(const SystemInfo_GetOutputStreamParameters_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SystemInfo::GetOutputStreamParametersCallback callback_;
};

class SystemInfo_HasInputDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SystemInfo_HasInputDevices_ForwardToCallback(
      SystemInfo::HasInputDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }

  SystemInfo_HasInputDevices_ForwardToCallback(const SystemInfo_HasInputDevices_ForwardToCallback&) = delete;
  SystemInfo_HasInputDevices_ForwardToCallback& operator=(const SystemInfo_HasInputDevices_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SystemInfo::HasInputDevicesCallback callback_;
};

class SystemInfo_HasOutputDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SystemInfo_HasOutputDevices_ForwardToCallback(
      SystemInfo::HasOutputDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }

  SystemInfo_HasOutputDevices_ForwardToCallback(const SystemInfo_HasOutputDevices_ForwardToCallback&) = delete;
  SystemInfo_HasOutputDevices_ForwardToCallback& operator=(const SystemInfo_HasOutputDevices_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SystemInfo::HasOutputDevicesCallback callback_;
};

class SystemInfo_GetInputDeviceDescriptions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SystemInfo_GetInputDeviceDescriptions_ForwardToCallback(
      SystemInfo::GetInputDeviceDescriptionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  SystemInfo_GetInputDeviceDescriptions_ForwardToCallback(const SystemInfo_GetInputDeviceDescriptions_ForwardToCallback&) = delete;
  SystemInfo_GetInputDeviceDescriptions_ForwardToCallback& operator=(const SystemInfo_GetInputDeviceDescriptions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SystemInfo::GetInputDeviceDescriptionsCallback callback_;
};

class SystemInfo_GetOutputDeviceDescriptions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SystemInfo_GetOutputDeviceDescriptions_ForwardToCallback(
      SystemInfo::GetOutputDeviceDescriptionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  SystemInfo_GetOutputDeviceDescriptions_ForwardToCallback(const SystemInfo_GetOutputDeviceDescriptions_ForwardToCallback&) = delete;
  SystemInfo_GetOutputDeviceDescriptions_ForwardToCallback& operator=(const SystemInfo_GetOutputDeviceDescriptions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SystemInfo::GetOutputDeviceDescriptionsCallback callback_;
};

class SystemInfo_GetAssociatedOutputDeviceID_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SystemInfo_GetAssociatedOutputDeviceID_ForwardToCallback(
      SystemInfo::GetAssociatedOutputDeviceIDCallback callback
      ) : callback_(std::move(callback)) {
  }

  SystemInfo_GetAssociatedOutputDeviceID_ForwardToCallback(const SystemInfo_GetAssociatedOutputDeviceID_ForwardToCallback&) = delete;
  SystemInfo_GetAssociatedOutputDeviceID_ForwardToCallback& operator=(const SystemInfo_GetAssociatedOutputDeviceID_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SystemInfo::GetAssociatedOutputDeviceIDCallback callback_;
};

class SystemInfo_GetInputDeviceInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SystemInfo_GetInputDeviceInfo_ForwardToCallback(
      SystemInfo::GetInputDeviceInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  SystemInfo_GetInputDeviceInfo_ForwardToCallback(const SystemInfo_GetInputDeviceInfo_ForwardToCallback&) = delete;
  SystemInfo_GetInputDeviceInfo_ForwardToCallback& operator=(const SystemInfo_GetInputDeviceInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SystemInfo::GetInputDeviceInfoCallback callback_;
};

SystemInfoProxy::SystemInfoProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SystemInfoProxy::GetInputStreamParameters(
    const std::string& in_device_id, GetInputStreamParametersCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send audio::mojom::SystemInfo::GetInputStreamParameters", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemInfo::kGetInputStreamParameters), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::SystemInfo_GetInputStreamParameters_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in SystemInfo.GetInputStreamParameters request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemInfo::Name_);
  message.set_method_name("GetInputStreamParameters");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SystemInfo_GetInputStreamParameters_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SystemInfoProxy::GetOutputStreamParameters(
    const std::string& in_device_id, GetOutputStreamParametersCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send audio::mojom::SystemInfo::GetOutputStreamParameters", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemInfo::kGetOutputStreamParameters), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::SystemInfo_GetOutputStreamParameters_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in SystemInfo.GetOutputStreamParameters request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemInfo::Name_);
  message.set_method_name("GetOutputStreamParameters");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SystemInfo_GetOutputStreamParameters_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SystemInfoProxy::HasInputDevices(
    HasInputDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send audio::mojom::SystemInfo::HasInputDevices");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemInfo::kHasInputDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::SystemInfo_HasInputDevices_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemInfo::Name_);
  message.set_method_name("HasInputDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SystemInfo_HasInputDevices_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SystemInfoProxy::HasOutputDevices(
    HasOutputDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send audio::mojom::SystemInfo::HasOutputDevices");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemInfo::kHasOutputDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::SystemInfo_HasOutputDevices_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemInfo::Name_);
  message.set_method_name("HasOutputDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SystemInfo_HasOutputDevices_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SystemInfoProxy::GetInputDeviceDescriptions(
    GetInputDeviceDescriptionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send audio::mojom::SystemInfo::GetInputDeviceDescriptions");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemInfo::kGetInputDeviceDescriptions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::SystemInfo_GetInputDeviceDescriptions_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemInfo::Name_);
  message.set_method_name("GetInputDeviceDescriptions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SystemInfo_GetInputDeviceDescriptions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SystemInfoProxy::GetOutputDeviceDescriptions(
    GetOutputDeviceDescriptionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send audio::mojom::SystemInfo::GetOutputDeviceDescriptions");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemInfo::kGetOutputDeviceDescriptions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::SystemInfo_GetOutputDeviceDescriptions_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemInfo::Name_);
  message.set_method_name("GetOutputDeviceDescriptions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SystemInfo_GetOutputDeviceDescriptions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SystemInfoProxy::GetAssociatedOutputDeviceID(
    const std::string& in_input_device_id, GetAssociatedOutputDeviceIDCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send audio::mojom::SystemInfo::GetAssociatedOutputDeviceID", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_device_id"), in_input_device_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemInfo::kGetAssociatedOutputDeviceID), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::SystemInfo_GetAssociatedOutputDeviceID_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input_device_id)::BaseType> input_device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_input_device_id,
    input_device_id_fragment);

  params->input_device_id.Set(
      input_device_id_fragment.is_null() ? nullptr : input_device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input_device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input_device_id in SystemInfo.GetAssociatedOutputDeviceID request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemInfo::Name_);
  message.set_method_name("GetAssociatedOutputDeviceID");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SystemInfo_GetAssociatedOutputDeviceID_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SystemInfoProxy::GetInputDeviceInfo(
    const std::string& in_input_device_id, GetInputDeviceInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send audio::mojom::SystemInfo::GetInputDeviceInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_device_id"), in_input_device_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemInfo::kGetInputDeviceInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::SystemInfo_GetInputDeviceInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input_device_id)::BaseType> input_device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_input_device_id,
    input_device_id_fragment);

  params->input_device_id.Set(
      input_device_id_fragment.is_null() ? nullptr : input_device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input_device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input_device_id in SystemInfo.GetInputDeviceInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemInfo::Name_);
  message.set_method_name("GetInputDeviceInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SystemInfo_GetInputDeviceInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SystemInfo_GetInputStreamParameters_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SystemInfo::GetInputStreamParametersCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SystemInfo_GetInputStreamParameters_ProxyToResponder> proxy(
        new SystemInfo_GetInputStreamParameters_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SystemInfo_GetInputStreamParameters_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SystemInfo_GetInputStreamParameters_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SystemInfo_GetInputStreamParameters_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SystemInfo::GetInputStreamParametersCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::media::AudioParameters>& in_params);
};

bool SystemInfo_GetInputStreamParameters_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SystemInfo_GetInputStreamParameters_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SystemInfo_GetInputStreamParameters_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SystemInfo.0
  bool success = true;
  std::optional<::media::AudioParameters> p_params{};
  SystemInfo_GetInputStreamParameters_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadParams(&p_params))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SystemInfo::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_params));
  }
  return true;
}

void SystemInfo_GetInputStreamParameters_ProxyToResponder::Run(
    const std::optional<::media::AudioParameters>& in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply audio::mojom::SystemInfo::GetInputStreamParameters", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type const std::optional<::media::AudioParameters>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemInfo::kGetInputStreamParameters), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::SystemInfo_GetInputStreamParameters_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemInfo::Name_);
  message.set_method_name("GetInputStreamParameters");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SystemInfo_GetOutputStreamParameters_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SystemInfo::GetOutputStreamParametersCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SystemInfo_GetOutputStreamParameters_ProxyToResponder> proxy(
        new SystemInfo_GetOutputStreamParameters_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SystemInfo_GetOutputStreamParameters_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SystemInfo_GetOutputStreamParameters_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SystemInfo_GetOutputStreamParameters_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SystemInfo::GetOutputStreamParametersCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::media::AudioParameters>& in_params);
};

bool SystemInfo_GetOutputStreamParameters_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SystemInfo_GetOutputStreamParameters_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SystemInfo_GetOutputStreamParameters_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SystemInfo.1
  bool success = true;
  std::optional<::media::AudioParameters> p_params{};
  SystemInfo_GetOutputStreamParameters_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadParams(&p_params))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SystemInfo::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_params));
  }
  return true;
}

void SystemInfo_GetOutputStreamParameters_ProxyToResponder::Run(
    const std::optional<::media::AudioParameters>& in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply audio::mojom::SystemInfo::GetOutputStreamParameters", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type const std::optional<::media::AudioParameters>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemInfo::kGetOutputStreamParameters), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::SystemInfo_GetOutputStreamParameters_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemInfo::Name_);
  message.set_method_name("GetOutputStreamParameters");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SystemInfo_HasInputDevices_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SystemInfo::HasInputDevicesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SystemInfo_HasInputDevices_ProxyToResponder> proxy(
        new SystemInfo_HasInputDevices_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SystemInfo_HasInputDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SystemInfo_HasInputDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SystemInfo_HasInputDevices_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SystemInfo::HasInputDevicesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_has_input_devices);
};

bool SystemInfo_HasInputDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SystemInfo_HasInputDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SystemInfo_HasInputDevices_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SystemInfo.2
  bool success = true;
  bool p_has_input_devices{};
  SystemInfo_HasInputDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_input_devices = input_data_view.has_input_devices();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SystemInfo::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_has_input_devices));
  }
  return true;
}

void SystemInfo_HasInputDevices_ProxyToResponder::Run(
    bool in_has_input_devices) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply audio::mojom::SystemInfo::HasInputDevices", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_input_devices"), in_has_input_devices,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemInfo::kHasInputDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::SystemInfo_HasInputDevices_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->has_input_devices = in_has_input_devices;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemInfo::Name_);
  message.set_method_name("HasInputDevices");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SystemInfo_HasOutputDevices_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SystemInfo::HasOutputDevicesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SystemInfo_HasOutputDevices_ProxyToResponder> proxy(
        new SystemInfo_HasOutputDevices_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SystemInfo_HasOutputDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SystemInfo_HasOutputDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SystemInfo_HasOutputDevices_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SystemInfo::HasOutputDevicesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_has_output_devices);
};

bool SystemInfo_HasOutputDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SystemInfo_HasOutputDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SystemInfo_HasOutputDevices_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SystemInfo.3
  bool success = true;
  bool p_has_output_devices{};
  SystemInfo_HasOutputDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_has_output_devices = input_data_view.has_output_devices();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SystemInfo::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_has_output_devices));
  }
  return true;
}

void SystemInfo_HasOutputDevices_ProxyToResponder::Run(
    bool in_has_output_devices) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply audio::mojom::SystemInfo::HasOutputDevices", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("has_output_devices"), in_has_output_devices,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemInfo::kHasOutputDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::SystemInfo_HasOutputDevices_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->has_output_devices = in_has_output_devices;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemInfo::Name_);
  message.set_method_name("HasOutputDevices");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SystemInfo_GetInputDeviceDescriptions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SystemInfo::GetInputDeviceDescriptionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SystemInfo_GetInputDeviceDescriptions_ProxyToResponder> proxy(
        new SystemInfo_GetInputDeviceDescriptions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SystemInfo_GetInputDeviceDescriptions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SystemInfo_GetInputDeviceDescriptions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SystemInfo_GetInputDeviceDescriptions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SystemInfo::GetInputDeviceDescriptionsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::media::AudioDeviceDescription> in_device_descriptions);
};

bool SystemInfo_GetInputDeviceDescriptions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SystemInfo_GetInputDeviceDescriptions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SystemInfo_GetInputDeviceDescriptions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SystemInfo.4
  bool success = true;
  std::vector<::media::AudioDeviceDescription> p_device_descriptions{};
  SystemInfo_GetInputDeviceDescriptions_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDeviceDescriptions(&p_device_descriptions))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SystemInfo::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_device_descriptions));
  }
  return true;
}

void SystemInfo_GetInputDeviceDescriptions_ProxyToResponder::Run(
    std::vector<::media::AudioDeviceDescription> in_device_descriptions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply audio::mojom::SystemInfo::GetInputDeviceDescriptions", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_descriptions"), in_device_descriptions,
                        "<value of type std::vector<::media::AudioDeviceDescription>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemInfo::kGetInputDeviceDescriptions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::SystemInfo_GetInputDeviceDescriptions_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_descriptions)::BaseType>
      device_descriptions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& device_descriptions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::audio::mojom::AudioDeviceDescriptionDataView>>(
    in_device_descriptions,
    device_descriptions_fragment,
    &device_descriptions_validate_params);

  params->device_descriptions.Set(
      device_descriptions_fragment.is_null() ? nullptr : device_descriptions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_descriptions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_descriptions in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemInfo::Name_);
  message.set_method_name("GetInputDeviceDescriptions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SystemInfo_GetOutputDeviceDescriptions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SystemInfo::GetOutputDeviceDescriptionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SystemInfo_GetOutputDeviceDescriptions_ProxyToResponder> proxy(
        new SystemInfo_GetOutputDeviceDescriptions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SystemInfo_GetOutputDeviceDescriptions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SystemInfo_GetOutputDeviceDescriptions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SystemInfo_GetOutputDeviceDescriptions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SystemInfo::GetOutputDeviceDescriptionsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<::media::AudioDeviceDescription> in_device_descriptions);
};

bool SystemInfo_GetOutputDeviceDescriptions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SystemInfo_GetOutputDeviceDescriptions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SystemInfo_GetOutputDeviceDescriptions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SystemInfo.5
  bool success = true;
  std::vector<::media::AudioDeviceDescription> p_device_descriptions{};
  SystemInfo_GetOutputDeviceDescriptions_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDeviceDescriptions(&p_device_descriptions))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SystemInfo::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_device_descriptions));
  }
  return true;
}

void SystemInfo_GetOutputDeviceDescriptions_ProxyToResponder::Run(
    std::vector<::media::AudioDeviceDescription> in_device_descriptions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply audio::mojom::SystemInfo::GetOutputDeviceDescriptions", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_descriptions"), in_device_descriptions,
                        "<value of type std::vector<::media::AudioDeviceDescription>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemInfo::kGetOutputDeviceDescriptions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::SystemInfo_GetOutputDeviceDescriptions_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_descriptions)::BaseType>
      device_descriptions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& device_descriptions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::audio::mojom::AudioDeviceDescriptionDataView>>(
    in_device_descriptions,
    device_descriptions_fragment,
    &device_descriptions_validate_params);

  params->device_descriptions.Set(
      device_descriptions_fragment.is_null() ? nullptr : device_descriptions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_descriptions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_descriptions in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemInfo::Name_);
  message.set_method_name("GetOutputDeviceDescriptions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SystemInfo_GetAssociatedOutputDeviceID_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SystemInfo::GetAssociatedOutputDeviceIDCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SystemInfo_GetAssociatedOutputDeviceID_ProxyToResponder> proxy(
        new SystemInfo_GetAssociatedOutputDeviceID_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SystemInfo_GetAssociatedOutputDeviceID_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SystemInfo_GetAssociatedOutputDeviceID_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SystemInfo_GetAssociatedOutputDeviceID_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SystemInfo::GetAssociatedOutputDeviceIDCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::string>& in_associated_output_device_id);
};

bool SystemInfo_GetAssociatedOutputDeviceID_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SystemInfo_GetAssociatedOutputDeviceID_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SystemInfo_GetAssociatedOutputDeviceID_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SystemInfo.6
  bool success = true;
  std::optional<std::string> p_associated_output_device_id{};
  SystemInfo_GetAssociatedOutputDeviceID_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadAssociatedOutputDeviceId(&p_associated_output_device_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SystemInfo::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_associated_output_device_id));
  }
  return true;
}

void SystemInfo_GetAssociatedOutputDeviceID_ProxyToResponder::Run(
    const std::optional<std::string>& in_associated_output_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply audio::mojom::SystemInfo::GetAssociatedOutputDeviceID", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("associated_output_device_id"), in_associated_output_device_id,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemInfo::kGetAssociatedOutputDeviceID), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::SystemInfo_GetAssociatedOutputDeviceID_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->associated_output_device_id)::BaseType> associated_output_device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_associated_output_device_id,
    associated_output_device_id_fragment);

  params->associated_output_device_id.Set(
      associated_output_device_id_fragment.is_null() ? nullptr : associated_output_device_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemInfo::Name_);
  message.set_method_name("GetAssociatedOutputDeviceID");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SystemInfo_GetInputDeviceInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SystemInfo::GetInputDeviceInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SystemInfo_GetInputDeviceInfo_ProxyToResponder> proxy(
        new SystemInfo_GetInputDeviceInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SystemInfo_GetInputDeviceInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SystemInfo_GetInputDeviceInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SystemInfo_GetInputDeviceInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SystemInfo::GetInputDeviceInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::media::AudioParameters>& in_input_params, const std::optional<std::string>& in_associated_output_device_id);
};

bool SystemInfo_GetInputDeviceInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SystemInfo_GetInputDeviceInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SystemInfo_GetInputDeviceInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SystemInfo.7
  bool success = true;
  std::optional<::media::AudioParameters> p_input_params{};
  std::optional<std::string> p_associated_output_device_id{};
  SystemInfo_GetInputDeviceInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInputParams(&p_input_params))
    success = false;
  if (success && !input_data_view.ReadAssociatedOutputDeviceId(&p_associated_output_device_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SystemInfo::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_input_params), 
std::move(p_associated_output_device_id));
  }
  return true;
}

void SystemInfo_GetInputDeviceInfo_ProxyToResponder::Run(
    const std::optional<::media::AudioParameters>& in_input_params, const std::optional<std::string>& in_associated_output_device_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply audio::mojom::SystemInfo::GetInputDeviceInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_params"), in_input_params,
                        "<value of type const std::optional<::media::AudioParameters>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("associated_output_device_id"), in_associated_output_device_id,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SystemInfo::kGetInputDeviceInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::SystemInfo_GetInputDeviceInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input_params)::BaseType> input_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::media::mojom::AudioParametersDataView>(
    in_input_params,
    input_params_fragment);

  params->input_params.Set(
      input_params_fragment.is_null() ? nullptr : input_params_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->associated_output_device_id)::BaseType> associated_output_device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_associated_output_device_id,
    associated_output_device_id_fragment);

  params->associated_output_device_id.Set(
      associated_output_device_id_fragment.is_null() ? nullptr : associated_output_device_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SystemInfo::Name_);
  message.set_method_name("GetInputDeviceInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SystemInfoStubDispatch::Accept(
    SystemInfo* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SystemInfo>(message->header()->name)) {
    case messages::SystemInfo::kGetInputStreamParameters: {
      break;
    }
    case messages::SystemInfo::kGetOutputStreamParameters: {
      break;
    }
    case messages::SystemInfo::kHasInputDevices: {
      break;
    }
    case messages::SystemInfo::kHasOutputDevices: {
      break;
    }
    case messages::SystemInfo::kGetInputDeviceDescriptions: {
      break;
    }
    case messages::SystemInfo::kGetOutputDeviceDescriptions: {
      break;
    }
    case messages::SystemInfo::kGetAssociatedOutputDeviceID: {
      break;
    }
    case messages::SystemInfo::kGetInputDeviceInfo: {
      break;
    }
  }
  return false;
}

// static
bool SystemInfoStubDispatch::AcceptWithResponder(
    SystemInfo* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SystemInfo>(message->header()->name)) {
    case messages::SystemInfo::kGetInputStreamParameters: {
      internal::SystemInfo_GetInputStreamParameters_Params_Data* params =
          reinterpret_cast<
              internal::SystemInfo_GetInputStreamParameters_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SystemInfo.0
      bool success = true;
      std::string p_device_id{};
      SystemInfo_GetInputStreamParameters_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemInfo::Name_, 0, false);
        return false;
      }
      auto callback =
          SystemInfo_GetInputStreamParameters_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInputStreamParameters(        
        std::move(p_device_id), std::move(callback));
      return true;
    }
    case messages::SystemInfo::kGetOutputStreamParameters: {
      internal::SystemInfo_GetOutputStreamParameters_Params_Data* params =
          reinterpret_cast<
              internal::SystemInfo_GetOutputStreamParameters_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SystemInfo.1
      bool success = true;
      std::string p_device_id{};
      SystemInfo_GetOutputStreamParameters_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemInfo::Name_, 1, false);
        return false;
      }
      auto callback =
          SystemInfo_GetOutputStreamParameters_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetOutputStreamParameters(        
        std::move(p_device_id), std::move(callback));
      return true;
    }
    case messages::SystemInfo::kHasInputDevices: {
      internal::SystemInfo_HasInputDevices_Params_Data* params =
          reinterpret_cast<
              internal::SystemInfo_HasInputDevices_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SystemInfo.2
      bool success = true;
      SystemInfo_HasInputDevices_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemInfo::Name_, 2, false);
        return false;
      }
      auto callback =
          SystemInfo_HasInputDevices_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasInputDevices(std::move(callback));
      return true;
    }
    case messages::SystemInfo::kHasOutputDevices: {
      internal::SystemInfo_HasOutputDevices_Params_Data* params =
          reinterpret_cast<
              internal::SystemInfo_HasOutputDevices_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SystemInfo.3
      bool success = true;
      SystemInfo_HasOutputDevices_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemInfo::Name_, 3, false);
        return false;
      }
      auto callback =
          SystemInfo_HasOutputDevices_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasOutputDevices(std::move(callback));
      return true;
    }
    case messages::SystemInfo::kGetInputDeviceDescriptions: {
      internal::SystemInfo_GetInputDeviceDescriptions_Params_Data* params =
          reinterpret_cast<
              internal::SystemInfo_GetInputDeviceDescriptions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SystemInfo.4
      bool success = true;
      SystemInfo_GetInputDeviceDescriptions_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemInfo::Name_, 4, false);
        return false;
      }
      auto callback =
          SystemInfo_GetInputDeviceDescriptions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInputDeviceDescriptions(std::move(callback));
      return true;
    }
    case messages::SystemInfo::kGetOutputDeviceDescriptions: {
      internal::SystemInfo_GetOutputDeviceDescriptions_Params_Data* params =
          reinterpret_cast<
              internal::SystemInfo_GetOutputDeviceDescriptions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SystemInfo.5
      bool success = true;
      SystemInfo_GetOutputDeviceDescriptions_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemInfo::Name_, 5, false);
        return false;
      }
      auto callback =
          SystemInfo_GetOutputDeviceDescriptions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetOutputDeviceDescriptions(std::move(callback));
      return true;
    }
    case messages::SystemInfo::kGetAssociatedOutputDeviceID: {
      internal::SystemInfo_GetAssociatedOutputDeviceID_Params_Data* params =
          reinterpret_cast<
              internal::SystemInfo_GetAssociatedOutputDeviceID_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SystemInfo.6
      bool success = true;
      std::string p_input_device_id{};
      SystemInfo_GetAssociatedOutputDeviceID_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInputDeviceId(&p_input_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemInfo::Name_, 6, false);
        return false;
      }
      auto callback =
          SystemInfo_GetAssociatedOutputDeviceID_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAssociatedOutputDeviceID(        
        std::move(p_input_device_id), std::move(callback));
      return true;
    }
    case messages::SystemInfo::kGetInputDeviceInfo: {
      internal::SystemInfo_GetInputDeviceInfo_Params_Data* params =
          reinterpret_cast<
              internal::SystemInfo_GetInputDeviceInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SystemInfo.7
      bool success = true;
      std::string p_input_device_id{};
      SystemInfo_GetInputDeviceInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInputDeviceId(&p_input_device_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SystemInfo::Name_, 7, false);
        return false;
      }
      auto callback =
          SystemInfo_GetInputDeviceInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInputDeviceInfo(        
        std::move(p_input_device_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSystemInfoValidationInfo[] = {
    { &internal::SystemInfo_GetInputStreamParameters_Params_Data::Validate,
     &internal::SystemInfo_GetInputStreamParameters_ResponseParams_Data::Validate},
    { &internal::SystemInfo_GetOutputStreamParameters_Params_Data::Validate,
     &internal::SystemInfo_GetOutputStreamParameters_ResponseParams_Data::Validate},
    { &internal::SystemInfo_HasInputDevices_Params_Data::Validate,
     &internal::SystemInfo_HasInputDevices_ResponseParams_Data::Validate},
    { &internal::SystemInfo_HasOutputDevices_Params_Data::Validate,
     &internal::SystemInfo_HasOutputDevices_ResponseParams_Data::Validate},
    { &internal::SystemInfo_GetInputDeviceDescriptions_Params_Data::Validate,
     &internal::SystemInfo_GetInputDeviceDescriptions_ResponseParams_Data::Validate},
    { &internal::SystemInfo_GetOutputDeviceDescriptions_Params_Data::Validate,
     &internal::SystemInfo_GetOutputDeviceDescriptions_ResponseParams_Data::Validate},
    { &internal::SystemInfo_GetAssociatedOutputDeviceID_Params_Data::Validate,
     &internal::SystemInfo_GetAssociatedOutputDeviceID_ResponseParams_Data::Validate},
    { &internal::SystemInfo_GetInputDeviceInfo_Params_Data::Validate,
     &internal::SystemInfo_GetInputDeviceInfo_ResponseParams_Data::Validate},
};

bool SystemInfoRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::audio::mojom::SystemInfo::Name_,
    kSystemInfoValidationInfo);
}

bool SystemInfoResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::audio::mojom::SystemInfo::Name_,
    kSystemInfoValidationInfo);
}


}  // audio::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace audio::mojom {


void SystemInfoInterceptorForTesting::GetInputStreamParameters(const std::string& device_id, GetInputStreamParametersCallback callback) {
  GetForwardingInterface()->GetInputStreamParameters(
    std::move(device_id)
    , std::move(callback));
}
void SystemInfoInterceptorForTesting::GetOutputStreamParameters(const std::string& device_id, GetOutputStreamParametersCallback callback) {
  GetForwardingInterface()->GetOutputStreamParameters(
    std::move(device_id)
    , std::move(callback));
}
void SystemInfoInterceptorForTesting::HasInputDevices(HasInputDevicesCallback callback) {
  GetForwardingInterface()->HasInputDevices(std::move(callback));
}
void SystemInfoInterceptorForTesting::HasOutputDevices(HasOutputDevicesCallback callback) {
  GetForwardingInterface()->HasOutputDevices(std::move(callback));
}
void SystemInfoInterceptorForTesting::GetInputDeviceDescriptions(GetInputDeviceDescriptionsCallback callback) {
  GetForwardingInterface()->GetInputDeviceDescriptions(std::move(callback));
}
void SystemInfoInterceptorForTesting::GetOutputDeviceDescriptions(GetOutputDeviceDescriptionsCallback callback) {
  GetForwardingInterface()->GetOutputDeviceDescriptions(std::move(callback));
}
void SystemInfoInterceptorForTesting::GetAssociatedOutputDeviceID(const std::string& input_device_id, GetAssociatedOutputDeviceIDCallback callback) {
  GetForwardingInterface()->GetAssociatedOutputDeviceID(
    std::move(input_device_id)
    , std::move(callback));
}
void SystemInfoInterceptorForTesting::GetInputDeviceInfo(const std::string& input_device_id, GetInputDeviceInfoCallback callback) {
  GetForwardingInterface()->GetInputDeviceInfo(
    std::move(input_device_id)
    , std::move(callback));
}
SystemInfoAsyncWaiter::SystemInfoAsyncWaiter(
    SystemInfo* proxy) : proxy_(proxy) {}

SystemInfoAsyncWaiter::~SystemInfoAsyncWaiter() = default;


void SystemInfoAsyncWaiter::GetInputStreamParameters(
    const std::string& device_id, std::optional<::media::AudioParameters>* out_params) {
  base::RunLoop loop;
  proxy_->GetInputStreamParameters(
      std::move(device_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::media::AudioParameters>* out_params
,
             const std::optional<::media::AudioParameters>& params) {*out_params = std::move(params);
            loop->Quit();
          },
          &loop,
          out_params));
  loop.Run();
}

std::optional<::media::AudioParameters> SystemInfoAsyncWaiter::GetInputStreamParameters(
    const std::string& device_id) {
  std::optional<::media::AudioParameters> async_wait_result;
  GetInputStreamParameters(std::move(device_id),&async_wait_result);
  return async_wait_result;
}

void SystemInfoAsyncWaiter::GetOutputStreamParameters(
    const std::string& device_id, std::optional<::media::AudioParameters>* out_params) {
  base::RunLoop loop;
  proxy_->GetOutputStreamParameters(
      std::move(device_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::media::AudioParameters>* out_params
,
             const std::optional<::media::AudioParameters>& params) {*out_params = std::move(params);
            loop->Quit();
          },
          &loop,
          out_params));
  loop.Run();
}

std::optional<::media::AudioParameters> SystemInfoAsyncWaiter::GetOutputStreamParameters(
    const std::string& device_id) {
  std::optional<::media::AudioParameters> async_wait_result;
  GetOutputStreamParameters(std::move(device_id),&async_wait_result);
  return async_wait_result;
}

void SystemInfoAsyncWaiter::HasInputDevices(
    bool* out_has_input_devices) {
  base::RunLoop loop;
  proxy_->HasInputDevices(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_has_input_devices
,
             bool has_input_devices) {*out_has_input_devices = std::move(has_input_devices);
            loop->Quit();
          },
          &loop,
          out_has_input_devices));
  loop.Run();
}

bool SystemInfoAsyncWaiter::HasInputDevices(
    ) {
  bool async_wait_result;
  HasInputDevices(&async_wait_result);
  return async_wait_result;
}

void SystemInfoAsyncWaiter::HasOutputDevices(
    bool* out_has_output_devices) {
  base::RunLoop loop;
  proxy_->HasOutputDevices(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_has_output_devices
,
             bool has_output_devices) {*out_has_output_devices = std::move(has_output_devices);
            loop->Quit();
          },
          &loop,
          out_has_output_devices));
  loop.Run();
}

bool SystemInfoAsyncWaiter::HasOutputDevices(
    ) {
  bool async_wait_result;
  HasOutputDevices(&async_wait_result);
  return async_wait_result;
}

void SystemInfoAsyncWaiter::GetInputDeviceDescriptions(
    std::vector<::media::AudioDeviceDescription>* out_device_descriptions) {
  base::RunLoop loop;
  proxy_->GetInputDeviceDescriptions(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::media::AudioDeviceDescription>* out_device_descriptions
,
             std::vector<::media::AudioDeviceDescription> device_descriptions) {*out_device_descriptions = std::move(device_descriptions);
            loop->Quit();
          },
          &loop,
          out_device_descriptions));
  loop.Run();
}

std::vector<::media::AudioDeviceDescription> SystemInfoAsyncWaiter::GetInputDeviceDescriptions(
    ) {
  std::vector<::media::AudioDeviceDescription> async_wait_result;
  GetInputDeviceDescriptions(&async_wait_result);
  return async_wait_result;
}

void SystemInfoAsyncWaiter::GetOutputDeviceDescriptions(
    std::vector<::media::AudioDeviceDescription>* out_device_descriptions) {
  base::RunLoop loop;
  proxy_->GetOutputDeviceDescriptions(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::media::AudioDeviceDescription>* out_device_descriptions
,
             std::vector<::media::AudioDeviceDescription> device_descriptions) {*out_device_descriptions = std::move(device_descriptions);
            loop->Quit();
          },
          &loop,
          out_device_descriptions));
  loop.Run();
}

std::vector<::media::AudioDeviceDescription> SystemInfoAsyncWaiter::GetOutputDeviceDescriptions(
    ) {
  std::vector<::media::AudioDeviceDescription> async_wait_result;
  GetOutputDeviceDescriptions(&async_wait_result);
  return async_wait_result;
}

void SystemInfoAsyncWaiter::GetAssociatedOutputDeviceID(
    const std::string& input_device_id, std::optional<std::string>* out_associated_output_device_id) {
  base::RunLoop loop;
  proxy_->GetAssociatedOutputDeviceID(
      std::move(input_device_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::string>* out_associated_output_device_id
,
             const std::optional<std::string>& associated_output_device_id) {*out_associated_output_device_id = std::move(associated_output_device_id);
            loop->Quit();
          },
          &loop,
          out_associated_output_device_id));
  loop.Run();
}

std::optional<std::string> SystemInfoAsyncWaiter::GetAssociatedOutputDeviceID(
    const std::string& input_device_id) {
  std::optional<std::string> async_wait_result;
  GetAssociatedOutputDeviceID(std::move(input_device_id),&async_wait_result);
  return async_wait_result;
}

void SystemInfoAsyncWaiter::GetInputDeviceInfo(
    const std::string& input_device_id, std::optional<::media::AudioParameters>* out_input_params, std::optional<std::string>* out_associated_output_device_id) {
  base::RunLoop loop;
  proxy_->GetInputDeviceInfo(
      std::move(input_device_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::media::AudioParameters>* out_input_params
,
             std::optional<std::string>* out_associated_output_device_id
,
             const std::optional<::media::AudioParameters>& input_params,
             const std::optional<std::string>& associated_output_device_id) {*out_input_params = std::move(input_params);*out_associated_output_device_id = std::move(associated_output_device_id);
            loop->Quit();
          },
          &loop,
          out_input_params,
          out_associated_output_device_id));
  loop.Run();
}








}  // audio::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif