// services/audio/public/mojom/ml_model_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_AUDIO_PUBLIC_MOJOM_ML_MODEL_MANAGER_MOJOM_H_
#define SERVICES_AUDIO_PUBLIC_MOJOM_ML_MODEL_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/audio/public/mojom/ml_model_manager.mojom-features.h"  // IWYU pragma: export
#include "services/audio/public/mojom/ml_model_manager.mojom-shared.h"  // IWYU pragma: export
#include "services/audio/public/mojom/ml_model_manager.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include "sandbox/policy/mojom/context.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace audio::mojom {

class MlModelManagerProxy;

template <typename ImplRefTraits>
class MlModelManagerStub;

class MlModelManagerRequestValidator;


class MlModelManager
    : public MlModelManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "audio.mojom.MlModelManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MlModelManagerInterfaceBase;
  using Proxy_ = MlModelManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = MlModelManagerStub<ImplRefTraits>;

  using RequestValidator_ = MlModelManagerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetResidualEchoEstimationModelMinVersion = 0,
    kStopServingResidualEchoEstimationModelMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetResidualEchoEstimationModel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopServingResidualEchoEstimationModel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MlModelManager() = default;

  virtual void SetResidualEchoEstimationModel(::base::File tflite_file) = 0;

  virtual void StopServingResidualEchoEstimationModel() = 0;
};



class  MlModelManagerProxy
    : public MlModelManager {
 public:
  using InterfaceType = MlModelManager;

  explicit MlModelManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetResidualEchoEstimationModel(::base::File tflite_file) final;
  
  void StopServingResidualEchoEstimationModel() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MlModelManagerStubDispatch {
 public:
  static bool Accept(MlModelManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MlModelManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MlModelManager>>
class MlModelManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MlModelManagerStub() = default;
  ~MlModelManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MlModelManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MlModelManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MlModelManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // audio::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_AUDIO_PUBLIC_MOJOM_ML_MODEL_MANAGER_MOJOM_H_