// services/audio/public/mojom/ml_model_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/audio/public/mojom/ml_model_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/audio/public/mojom/ml_model_manager.mojom-params-data.h"
#include "services/audio/public/mojom/ml_model_manager.mojom-shared-message-ids.h"

#include "services/audio/public/mojom/ml_model_manager.mojom-import-headers.h"
#include "services/audio/public/mojom/ml_model_manager.mojom-test-utils.h"


namespace audio::mojom {
// The declaration includes the definition on other builds.

MlModelManager::IPCStableHashFunction MlModelManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MlModelManager>(message.name())) {
    case messages::MlModelManager::kSetResidualEchoEstimationModel: {
      return &MlModelManager::SetResidualEchoEstimationModel_Sym::IPCStableHash;
    }
    case messages::MlModelManager::kStopServingResidualEchoEstimationModel: {
      return &MlModelManager::StopServingResidualEchoEstimationModel_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MlModelManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MlModelManager>(message.name())) {
      case messages::MlModelManager::kSetResidualEchoEstimationModel:
            return "Receive audio::mojom::MlModelManager::SetResidualEchoEstimationModel";
      case messages::MlModelManager::kStopServingResidualEchoEstimationModel:
            return "Receive audio::mojom::MlModelManager::StopServingResidualEchoEstimationModel";
    }
  } else {
    switch (static_cast<messages::MlModelManager>(message.name())) {
      case messages::MlModelManager::kSetResidualEchoEstimationModel:
            return "Receive reply audio::mojom::MlModelManager::SetResidualEchoEstimationModel";
      case messages::MlModelManager::kStopServingResidualEchoEstimationModel:
            return "Receive reply audio::mojom::MlModelManager::StopServingResidualEchoEstimationModel";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MlModelManager::SetResidualEchoEstimationModel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6f20b5cc;  // IPCStableHash for audio::mojom::MlModelManager::SetResidualEchoEstimationModel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MlModelManager::StopServingResidualEchoEstimationModel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2f4daa77;  // IPCStableHash for audio::mojom::MlModelManager::StopServingResidualEchoEstimationModel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MlModelManagerProxy::MlModelManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MlModelManagerProxy::SetResidualEchoEstimationModel(
    ::base::File in_tflite_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send audio::mojom::MlModelManager::SetResidualEchoEstimationModel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tflite_file"), in_tflite_file,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MlModelManager::kSetResidualEchoEstimationModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::MlModelManager_SetResidualEchoEstimationModel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tflite_file)::BaseType> tflite_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_tflite_file,
    tflite_file_fragment);

  params->tflite_file.Set(
      tflite_file_fragment.is_null() ? nullptr : tflite_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tflite_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tflite_file in MlModelManager.SetResidualEchoEstimationModel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MlModelManager::Name_);
  message.set_method_name("SetResidualEchoEstimationModel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MlModelManagerProxy::StopServingResidualEchoEstimationModel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send audio::mojom::MlModelManager::StopServingResidualEchoEstimationModel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MlModelManager::kStopServingResidualEchoEstimationModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::audio::mojom::internal::MlModelManager_StopServingResidualEchoEstimationModel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MlModelManager::Name_);
  message.set_method_name("StopServingResidualEchoEstimationModel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MlModelManagerStubDispatch::Accept(
    MlModelManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MlModelManager>(message->header()->name)) {
    case messages::MlModelManager::kSetResidualEchoEstimationModel: {
      DCHECK(message->is_serialized());
      internal::MlModelManager_SetResidualEchoEstimationModel_Params_Data* params =
          reinterpret_cast<internal::MlModelManager_SetResidualEchoEstimationModel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MlModelManager.0
      bool success = true;
      ::base::File p_tflite_file{};
      MlModelManager_SetResidualEchoEstimationModel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTfliteFile(&p_tflite_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MlModelManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetResidualEchoEstimationModel(        
        std::move(p_tflite_file));
      return true;
    }
    case messages::MlModelManager::kStopServingResidualEchoEstimationModel: {
      DCHECK(message->is_serialized());
      internal::MlModelManager_StopServingResidualEchoEstimationModel_Params_Data* params =
          reinterpret_cast<internal::MlModelManager_StopServingResidualEchoEstimationModel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MlModelManager.1
      bool success = true;
      MlModelManager_StopServingResidualEchoEstimationModel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MlModelManager::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopServingResidualEchoEstimationModel(        );
      return true;
    }
  }
  return false;
}

// static
bool MlModelManagerStubDispatch::AcceptWithResponder(
    MlModelManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MlModelManager>(message->header()->name)) {
    case messages::MlModelManager::kSetResidualEchoEstimationModel: {
      break;
    }
    case messages::MlModelManager::kStopServingResidualEchoEstimationModel: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMlModelManagerValidationInfo[] = {
    { &internal::MlModelManager_SetResidualEchoEstimationModel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MlModelManager_StopServingResidualEchoEstimationModel_Params_Data::Validate,
     nullptr /* no response */},
};

bool MlModelManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::audio::mojom::MlModelManager::Name_,
    kMlModelManagerValidationInfo);
}



}  // audio::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace audio::mojom {


void MlModelManagerInterceptorForTesting::SetResidualEchoEstimationModel(::base::File tflite_file) {
  GetForwardingInterface()->SetResidualEchoEstimationModel(
    std::move(tflite_file)
    );
}
void MlModelManagerInterceptorForTesting::StopServingResidualEchoEstimationModel() {
  GetForwardingInterface()->StopServingResidualEchoEstimationModel();
}
MlModelManagerAsyncWaiter::MlModelManagerAsyncWaiter(
    MlModelManager* proxy) : proxy_(proxy) {}

MlModelManagerAsyncWaiter::~MlModelManagerAsyncWaiter() = default;







}  // audio::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif