// services/audio/public/mojom/debug_recording.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_AUDIO_PUBLIC_MOJOM_DEBUG_RECORDING_MOJOM_H_
#define SERVICES_AUDIO_PUBLIC_MOJOM_DEBUG_RECORDING_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/audio/public/mojom/debug_recording.mojom-features.h"  // IWYU pragma: export
#include "services/audio/public/mojom/debug_recording.mojom-shared.h"  // IWYU pragma: export
#include "services/audio/public/mojom/debug_recording.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/file.mojom.h"
#include "sandbox/policy/mojom/context.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/audio/public/cpp/debug_recording_mojom_traits.h"




namespace audio::mojom {

class DebugRecordingFileProviderProxy;

template <typename ImplRefTraits>
class DebugRecordingFileProviderStub;

class DebugRecordingFileProviderRequestValidator;
class DebugRecordingFileProviderResponseValidator;


class DebugRecordingFileProvider
    : public DebugRecordingFileProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "audio.mojom.DebugRecordingFileProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DebugRecordingFileProviderInterfaceBase;
  using Proxy_ = DebugRecordingFileProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = DebugRecordingFileProviderStub<ImplRefTraits>;

  using RequestValidator_ = DebugRecordingFileProviderRequestValidator;
  using ResponseValidator_ = DebugRecordingFileProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateWavFileMinVersion = 0,
    kCreateAecdumpFileMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateWavFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateAecdumpFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DebugRecordingFileProvider() = default;

  using CreateWavFileCallback = base::OnceCallback<void(::base::File)>;
  using CreateWavFileMojoCallback = base::OnceCallback<void(::base::File)>;

  virtual void CreateWavFile(::media::AudioDebugRecordingStreamType stream_type, uint32_t id, CreateWavFileCallback callback) = 0;

  using CreateAecdumpFileCallback = base::OnceCallback<void(::base::File)>;
  using CreateAecdumpFileMojoCallback = base::OnceCallback<void(::base::File)>;

  virtual void CreateAecdumpFile(uint32_t id, CreateAecdumpFileCallback callback) = 0;
};

class DebugRecordingProxy;

template <typename ImplRefTraits>
class DebugRecordingStub;

class DebugRecordingRequestValidator;


class DebugRecording
    : public DebugRecordingInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "audio.mojom.DebugRecording";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DebugRecordingInterfaceBase;
  using Proxy_ = DebugRecordingProxy;

  template <typename ImplRefTraits>
  using Stub_ = DebugRecordingStub<ImplRefTraits>;

  using RequestValidator_ = DebugRecordingRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kEnableMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Enable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DebugRecording() = default;

  virtual void Enable(::mojo::PendingRemote<DebugRecordingFileProvider> file_provider) = 0;
};



class  DebugRecordingFileProviderProxy
    : public DebugRecordingFileProvider {
 public:
  using InterfaceType = DebugRecordingFileProvider;

  explicit DebugRecordingFileProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateWavFile(::media::AudioDebugRecordingStreamType stream_type, uint32_t id, CreateWavFileCallback callback) final;
  
  void CreateAecdumpFile(uint32_t id, CreateAecdumpFileCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DebugRecordingProxy
    : public DebugRecording {
 public:
  using InterfaceType = DebugRecording;

  explicit DebugRecordingProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Enable(::mojo::PendingRemote<DebugRecordingFileProvider> file_provider) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DebugRecordingFileProviderStubDispatch {
 public:
  static bool Accept(DebugRecordingFileProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DebugRecordingFileProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DebugRecordingFileProvider>>
class DebugRecordingFileProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DebugRecordingFileProviderStub() = default;
  ~DebugRecordingFileProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DebugRecordingFileProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DebugRecordingFileProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DebugRecordingStubDispatch {
 public:
  static bool Accept(DebugRecording* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DebugRecording* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DebugRecording>>
class DebugRecordingStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DebugRecordingStub() = default;
  ~DebugRecordingStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DebugRecordingStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DebugRecordingStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DebugRecordingFileProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DebugRecordingRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DebugRecordingFileProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // audio::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_AUDIO_PUBLIC_MOJOM_DEBUG_RECORDING_MOJOM_H_