// services/audio/public/mojom/audio_device_description.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_AUDIO_PUBLIC_MOJOM_AUDIO_DEVICE_DESCRIPTION_MOJOM_H_
#define SERVICES_AUDIO_PUBLIC_MOJOM_AUDIO_DEVICE_DESCRIPTION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/audio/public/mojom/audio_device_description.mojom-features.h"  // IWYU pragma: export
#include "services/audio/public/mojom/audio_device_description.mojom-shared.h"  // IWYU pragma: export
#include "services/audio/public/mojom/audio_device_description.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "services/audio/public/cpp/audio_device_description_mojom_traits.h"




namespace audio::mojom {








class  AudioDeviceDescription {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioDeviceDescription, T>::value>;
  using DataView = AudioDeviceDescriptionDataView;
  using Data_ = internal::AudioDeviceDescription_Data;

  template <typename... Args>
  static AudioDeviceDescriptionPtr New(Args&&... args) {
    return AudioDeviceDescriptionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioDeviceDescriptionPtr From(const U& u) {
    return mojo::TypeConverter<AudioDeviceDescriptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioDeviceDescription>::Convert(*this);
  }


  AudioDeviceDescription();

  AudioDeviceDescription(
      const std::string& device_name,
      const std::string& unique_id,
      const std::string& group_id,
      bool is_system_default,
      bool is_communications_device);


  ~AudioDeviceDescription();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioDeviceDescriptionPtr>
  AudioDeviceDescriptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioDeviceDescription::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AudioDeviceDescription::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AudioDeviceDescription::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioDeviceDescription::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioDeviceDescription::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioDeviceDescription::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioDeviceDescription_UnserializedMessageContext<
            UserType, AudioDeviceDescription::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AudioDeviceDescription::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AudioDeviceDescription::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioDeviceDescription_UnserializedMessageContext<
            UserType, AudioDeviceDescription::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioDeviceDescription::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string device_name;
  
  std::string unique_id;
  
  std::string group_id;
  
  bool is_system_default;
  
  bool is_communications_device;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioDeviceDescription::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioDeviceDescription::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioDeviceDescription::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioDeviceDescription::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AudioDeviceDescriptionPtr AudioDeviceDescription::Clone() const {
  return New(
      mojo::Clone(device_name),
      mojo::Clone(unique_id),
      mojo::Clone(group_id),
      mojo::Clone(is_system_default),
      mojo::Clone(is_communications_device)
  );
}

template <typename T, AudioDeviceDescription::EnableIfSame<T>*>
bool AudioDeviceDescription::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->device_name, other_struct.device_name))
    return false;
  if (!mojo::Equals(this->unique_id, other_struct.unique_id))
    return false;
  if (!mojo::Equals(this->group_id, other_struct.group_id))
    return false;
  if (!mojo::Equals(this->is_system_default, other_struct.is_system_default))
    return false;
  if (!mojo::Equals(this->is_communications_device, other_struct.is_communications_device))
    return false;
  return true;
}

template <typename T, AudioDeviceDescription::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.device_name < rhs.device_name)
    return true;
  if (rhs.device_name < lhs.device_name)
    return false;
  if (lhs.unique_id < rhs.unique_id)
    return true;
  if (rhs.unique_id < lhs.unique_id)
    return false;
  if (lhs.group_id < rhs.group_id)
    return true;
  if (rhs.group_id < lhs.group_id)
    return false;
  if (lhs.is_system_default < rhs.is_system_default)
    return true;
  if (rhs.is_system_default < lhs.is_system_default)
    return false;
  if (lhs.is_communications_device < rhs.is_communications_device)
    return true;
  if (rhs.is_communications_device < lhs.is_communications_device)
    return false;
  return false;
}


}  // audio::mojom

namespace mojo {


template <>
struct  StructTraits<::audio::mojom::AudioDeviceDescription::DataView,
                                         ::audio::mojom::AudioDeviceDescriptionPtr> {
  static bool IsNull(const ::audio::mojom::AudioDeviceDescriptionPtr& input) { return !input; }
  static void SetToNull(::audio::mojom::AudioDeviceDescriptionPtr* output) { output->reset(); }

  static const decltype(::audio::mojom::AudioDeviceDescription::device_name)& device_name(
      const ::audio::mojom::AudioDeviceDescriptionPtr& input) {
    return input->device_name;
  }

  static const decltype(::audio::mojom::AudioDeviceDescription::unique_id)& unique_id(
      const ::audio::mojom::AudioDeviceDescriptionPtr& input) {
    return input->unique_id;
  }

  static const decltype(::audio::mojom::AudioDeviceDescription::group_id)& group_id(
      const ::audio::mojom::AudioDeviceDescriptionPtr& input) {
    return input->group_id;
  }

  static decltype(::audio::mojom::AudioDeviceDescription::is_system_default) is_system_default(
      const ::audio::mojom::AudioDeviceDescriptionPtr& input) {
    return input->is_system_default;
  }

  static decltype(::audio::mojom::AudioDeviceDescription::is_communications_device) is_communications_device(
      const ::audio::mojom::AudioDeviceDescriptionPtr& input) {
    return input->is_communications_device;
  }

  static bool Read(::audio::mojom::AudioDeviceDescription::DataView input, ::audio::mojom::AudioDeviceDescriptionPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_AUDIO_PUBLIC_MOJOM_AUDIO_DEVICE_DESCRIPTION_MOJOM_H_