// services/accessibility/public/mojom/automation.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_ACCESSIBILITY_PUBLIC_MOJOM_AUTOMATION_MOJOM_H_
#define SERVICES_ACCESSIBILITY_PUBLIC_MOJOM_AUTOMATION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/accessibility/public/mojom/automation.mojom-features.h"  // IWYU pragma: export
#include "services/accessibility/public/mojom/automation.mojom-shared.h"  // IWYU pragma: export
#include "services/accessibility/public/mojom/automation.mojom-forward.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_action_data.mojom.h"
#include "ui/accessibility/mojom/ax_event.mojom.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace ax::mojom {

class AutomationProxy;

template <typename ImplRefTraits>
class AutomationStub;

class AutomationRequestValidator;


class Automation
    : public AutomationInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "ax.mojom.Automation";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AutomationInterfaceBase;
  using Proxy_ = AutomationProxy;

  template <typename ImplRefTraits>
  using Stub_ = AutomationStub<ImplRefTraits>;

  using RequestValidator_ = AutomationRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDispatchTreeDestroyedEventMinVersion = 0,
    kDispatchActionResultMinVersion = 0,
    kDispatchAccessibilityEventsMinVersion = 0,
    kDispatchAccessibilityLocationChangeMinVersion = 0,
    kDispatchAccessibilityScrollChangeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DispatchTreeDestroyedEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchActionResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchAccessibilityEvents_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchAccessibilityLocationChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DispatchAccessibilityScrollChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Automation() = default;

  virtual void DispatchTreeDestroyedEvent(const ::ui::AXTreeID& tree_id) = 0;

  virtual void DispatchActionResult(const ::ui::AXActionData& data, bool result) = 0;

  virtual void DispatchAccessibilityEvents(const ::ui::AXTreeID& tree_id, const std::vector<::ui::AXTreeUpdate>& updates, const ::gfx::Point& mouse_location, const std::vector<::ui::AXEvent>& events) = 0;

  virtual void DispatchAccessibilityLocationChange(const ::ui::AXTreeID& tree_id, int32_t node_id, const ::ui::AXRelativeBounds& bounds) = 0;

  virtual void DispatchAccessibilityScrollChange(const ::ui::AXTreeID& tree_id, int32_t node_id, int32_t scroll_x, int32_t scroll_y) = 0;
};



class  AutomationProxy
    : public Automation {
 public:
  using InterfaceType = Automation;

  explicit AutomationProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DispatchTreeDestroyedEvent(const ::ui::AXTreeID& tree_id) final;
  
  void DispatchActionResult(const ::ui::AXActionData& data, bool result) final;
  
  void DispatchAccessibilityEvents(const ::ui::AXTreeID& tree_id, const std::vector<::ui::AXTreeUpdate>& updates, const ::gfx::Point& mouse_location, const std::vector<::ui::AXEvent>& events) final;
  
  void DispatchAccessibilityLocationChange(const ::ui::AXTreeID& tree_id, int32_t node_id, const ::ui::AXRelativeBounds& bounds) final;
  
  void DispatchAccessibilityScrollChange(const ::ui::AXTreeID& tree_id, int32_t node_id, int32_t scroll_x, int32_t scroll_y) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  AutomationStubDispatch {
 public:
  static bool Accept(Automation* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Automation* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Automation>>
class AutomationStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AutomationStub() = default;
  ~AutomationStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutomationStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AutomationStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AutomationRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // ax::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_ACCESSIBILITY_PUBLIC_MOJOM_AUTOMATION_MOJOM_H_