// sandbox/policy/mojom/sandbox.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "sandbox/policy/mojom/sandbox.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "sandbox/policy/mojom/sandbox.mojom-params-data.h"
namespace sandbox {
namespace mojom {

NOINLINE static const char* SandboxToStringHelper(Sandbox value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Sandbox::kService:
      return "kService";
    case Sandbox::kServiceWithJit:
      return "kServiceWithJit";
    case Sandbox::kUtility:
      return "kUtility";
    case Sandbox::kAudio:
      return "kAudio";
    case Sandbox::kCdm:
      return "kCdm";
    case Sandbox::kNetwork:
      return "kNetwork";
    case Sandbox::kOnDeviceModelExecution:
      return "kOnDeviceModelExecution";
    case Sandbox::kNoSandbox:
      return "kNoSandbox";
    case Sandbox::kGpu:
      return "kGpu";
    case Sandbox::kPrintCompositor:
      return "kPrintCompositor";
    case Sandbox::kRenderer:
      return "kRenderer";
    case Sandbox::kSpeechRecognition:
      return "kSpeechRecognition";
    case Sandbox::kPrintBackend:
      return "kPrintBackend";
    case Sandbox::kScreenAI:
      return "kScreenAI";
    case Sandbox::kMirroring:
      return "kMirroring";
    case Sandbox::kOnDeviceTranslation:
      return "kOnDeviceTranslation";
    default:
      return nullptr;
  }
}

std::string SandboxToString(Sandbox value) {
  const char *str = SandboxToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Sandbox value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Sandbox value) {
  return os << SandboxToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace sandbox

namespace perfetto {

// static
void TraceFormatTraits<::sandbox::mojom::Sandbox>::WriteIntoTrace(
   perfetto::TracedValue context, ::sandbox::mojom::Sandbox value) {
  return std::move(context).WriteString(::sandbox::mojom::SandboxToString(value));
}

} // namespace perfetto