// sandbox/policy/mojom/context.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "sandbox/policy/mojom/context.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "sandbox/policy/mojom/context.mojom-params-data.h"
namespace sandbox {
namespace mojom {

NOINLINE static const char* ContextToStringHelper(Context value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Context::kBrowser:
      return "kBrowser";
    case Context::kPrivilegedUtility:
      return "kPrivilegedUtility";
    case Context::kLowest:
      return "kLowest";
    default:
      return nullptr;
  }
}

std::string ContextToString(Context value) {
  const char *str = ContextToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Context value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Context value) {
  return os << ContextToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace sandbox

namespace perfetto {

// static
void TraceFormatTraits<::sandbox::mojom::Context>::WriteIntoTrace(
   perfetto::TracedValue context, ::sandbox::mojom::Context value) {
  return std::move(context).WriteString(::sandbox::mojom::ContextToString(value));
}

} // namespace perfetto