// printing/mojom/printing_context.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PRINTING_MOJOM_PRINTING_CONTEXT_MOJOM_H_
#define PRINTING_MOJOM_PRINTING_CONTEXT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "printing/mojom/printing_context.mojom-features.h"  // IWYU pragma: export
#include "printing/mojom/printing_context.mojom-shared.h"  // IWYU pragma: export
#include "printing/mojom/printing_context.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "printing/mojom/print.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>




#include "printing/mojom/printing_context_mojom_traits.h"




namespace printing::mojom {











class  PageMargins {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PageMargins, T>::value>;
  using DataView = PageMarginsDataView;
  using Data_ = internal::PageMargins_Data;

  template <typename... Args>
  static PageMarginsPtr New(Args&&... args) {
    return PageMarginsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PageMarginsPtr From(const U& u) {
    return mojo::TypeConverter<PageMarginsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PageMargins>::Convert(*this);
  }


  PageMargins();

  PageMargins(
      int32_t header,
      int32_t footer,
      int32_t left,
      int32_t right,
      int32_t top,
      int32_t bottom);


  ~PageMargins();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PageMarginsPtr>
  PageMarginsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PageMargins::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PageMargins::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PageMargins::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageMargins::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageMargins::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PageMargins::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PageMargins_UnserializedMessageContext<
            UserType, PageMargins::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PageMargins::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PageMargins::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PageMargins_UnserializedMessageContext<
            UserType, PageMargins::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PageMargins::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t header;
  
  int32_t footer;
  
  int32_t left;
  
  int32_t right;
  
  int32_t top;
  
  int32_t bottom;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PageMargins::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PageMargins::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PageMargins::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PageMargins::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PageSetup {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PageSetup, T>::value>;
  using DataView = PageSetupDataView;
  using Data_ = internal::PageSetup_Data;

  template <typename... Args>
  static PageSetupPtr New(Args&&... args) {
    return PageSetupPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PageSetupPtr From(const U& u) {
    return mojo::TypeConverter<PageSetupPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PageSetup>::Convert(*this);
  }


  PageSetup();

  PageSetup(
      const ::gfx::Size& physical_size,
      const ::gfx::Rect& printable_area,
      const ::gfx::Rect& overlay_area,
      const ::gfx::Rect& content_area,
      const ::printing::PageMargins& effective_margins,
      const ::printing::PageMargins& requested_margins,
      bool forced_margins,
      int32_t text_height);


  ~PageSetup();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PageSetupPtr>
  PageSetupPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PageSetup::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PageSetup::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PageSetup::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageSetup::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageSetup::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PageSetup::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PageSetup_UnserializedMessageContext<
            UserType, PageSetup::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PageSetup::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PageSetup::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PageSetup_UnserializedMessageContext<
            UserType, PageSetup::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PageSetup::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Size physical_size;
  
  ::gfx::Rect printable_area;
  
  ::gfx::Rect overlay_area;
  
  ::gfx::Rect content_area;
  
  ::printing::PageMargins effective_margins;
  
  ::printing::PageMargins requested_margins;
  
  bool forced_margins;
  
  int32_t text_height;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PageSetup::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PageSetup::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PageSetup::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PageSetup::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  RequestedMedia {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RequestedMedia, T>::value>;
  using DataView = RequestedMediaDataView;
  using Data_ = internal::RequestedMedia_Data;

  template <typename... Args>
  static RequestedMediaPtr New(Args&&... args) {
    return RequestedMediaPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RequestedMediaPtr From(const U& u) {
    return mojo::TypeConverter<RequestedMediaPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RequestedMedia>::Convert(*this);
  }


  RequestedMedia();

  RequestedMedia(
      const ::gfx::Size& size_microns,
      const std::string& vendor_id);


  ~RequestedMedia();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RequestedMediaPtr>
  RequestedMediaPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RequestedMedia::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RequestedMedia::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RequestedMedia::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequestedMedia::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequestedMedia::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RequestedMedia::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RequestedMedia_UnserializedMessageContext<
            UserType, RequestedMedia::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RequestedMedia::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RequestedMedia::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RequestedMedia_UnserializedMessageContext<
            UserType, RequestedMedia::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RequestedMedia::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Size size_microns;
  
  std::string vendor_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RequestedMedia::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RequestedMedia::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RequestedMedia::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RequestedMedia::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PrintSettings {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrintSettings, T>::value>;
  using DataView = PrintSettingsDataView;
  using Data_ = internal::PrintSettings_Data;

  template <typename... Args>
  static PrintSettingsPtr New(Args&&... args) {
    return PrintSettingsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrintSettingsPtr From(const U& u) {
    return mojo::TypeConverter<PrintSettingsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrintSettings>::Convert(*this);
  }


  PrintSettings();

  PrintSettings(
      std::vector<::printing::PageRange> ranges,
      bool selection_only,
      ::printing::mojom::MarginType margin_type,
      const ::std::u16string& title,
      const ::std::u16string& url,
      bool display_header_footer,
      bool should_print_backgrounds,
      bool collate,
      ::printing::mojom::ColorModel color,
      int32_t copies,
      ::printing::mojom::DuplexMode duplex_mode,
      const ::std::u16string& device_name,
      const ::printing::PrintSettings::RequestedMedia& requested_media,
      const ::printing::PageSetup& page_setup_device_units,
      bool borderless,
      const std::string& media_type,
      const ::gfx::Size& dpi,
      double scale_factor,
      bool rasterize_pdf,
      bool landscape,
      bool is_modifiable,
      const ::printing::PageMargins& requested_custom_margins_in_microns,
      int32_t pages_per_sheet,
      ::base::Value::Dict system_print_dialog_data);

PrintSettings(const PrintSettings&) = delete;
PrintSettings& operator=(const PrintSettings&) = delete;

  ~PrintSettings();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrintSettingsPtr>
  PrintSettingsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrintSettings::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrintSettings::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrintSettings::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrintSettings::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrintSettings::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrintSettings::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrintSettings_UnserializedMessageContext<
            UserType, PrintSettings::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrintSettings::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrintSettings::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrintSettings_UnserializedMessageContext<
            UserType, PrintSettings::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrintSettings::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::printing::PageRange> ranges;
  
  bool selection_only;
  
  ::printing::mojom::MarginType margin_type;
  
  ::std::u16string title;
  
  ::std::u16string url;
  
  bool display_header_footer;
  
  bool should_print_backgrounds;
  
  bool collate;
  
  ::printing::mojom::ColorModel color;
  
  int32_t copies;
  
  ::printing::mojom::DuplexMode duplex_mode;
  
  ::std::u16string device_name;
  
  ::printing::PrintSettings::RequestedMedia requested_media;
  
  ::printing::PageSetup page_setup_device_units;
  
  bool borderless;
  
  std::string media_type;
  
  ::gfx::Size dpi;
  
  double scale_factor;
  
  bool rasterize_pdf;
  
  bool landscape;
  
  bool is_modifiable;
  
  ::printing::PageMargins requested_custom_margins_in_microns;
  
  int32_t pages_per_sheet;
  
  ::base::Value::Dict system_print_dialog_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrintSettings::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrintSettings::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrintSettings::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrintSettings::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PageMarginsPtr PageMargins::Clone() const {
  return New(
      mojo::Clone(header),
      mojo::Clone(footer),
      mojo::Clone(left),
      mojo::Clone(right),
      mojo::Clone(top),
      mojo::Clone(bottom)
  );
}

template <typename T, PageMargins::EnableIfSame<T>*>
bool PageMargins::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->header, other_struct.header))
    return false;
  if (!mojo::Equals(this->footer, other_struct.footer))
    return false;
  if (!mojo::Equals(this->left, other_struct.left))
    return false;
  if (!mojo::Equals(this->right, other_struct.right))
    return false;
  if (!mojo::Equals(this->top, other_struct.top))
    return false;
  if (!mojo::Equals(this->bottom, other_struct.bottom))
    return false;
  return true;
}

template <typename T, PageMargins::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.header < rhs.header)
    return true;
  if (rhs.header < lhs.header)
    return false;
  if (lhs.footer < rhs.footer)
    return true;
  if (rhs.footer < lhs.footer)
    return false;
  if (lhs.left < rhs.left)
    return true;
  if (rhs.left < lhs.left)
    return false;
  if (lhs.right < rhs.right)
    return true;
  if (rhs.right < lhs.right)
    return false;
  if (lhs.top < rhs.top)
    return true;
  if (rhs.top < lhs.top)
    return false;
  if (lhs.bottom < rhs.bottom)
    return true;
  if (rhs.bottom < lhs.bottom)
    return false;
  return false;
}
template <typename StructPtrType>
PageSetupPtr PageSetup::Clone() const {
  return New(
      mojo::Clone(physical_size),
      mojo::Clone(printable_area),
      mojo::Clone(overlay_area),
      mojo::Clone(content_area),
      mojo::Clone(effective_margins),
      mojo::Clone(requested_margins),
      mojo::Clone(forced_margins),
      mojo::Clone(text_height)
  );
}

template <typename T, PageSetup::EnableIfSame<T>*>
bool PageSetup::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->physical_size, other_struct.physical_size))
    return false;
  if (!mojo::Equals(this->printable_area, other_struct.printable_area))
    return false;
  if (!mojo::Equals(this->overlay_area, other_struct.overlay_area))
    return false;
  if (!mojo::Equals(this->content_area, other_struct.content_area))
    return false;
  if (!mojo::Equals(this->effective_margins, other_struct.effective_margins))
    return false;
  if (!mojo::Equals(this->requested_margins, other_struct.requested_margins))
    return false;
  if (!mojo::Equals(this->forced_margins, other_struct.forced_margins))
    return false;
  if (!mojo::Equals(this->text_height, other_struct.text_height))
    return false;
  return true;
}

template <typename T, PageSetup::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.physical_size < rhs.physical_size)
    return true;
  if (rhs.physical_size < lhs.physical_size)
    return false;
  if (lhs.printable_area < rhs.printable_area)
    return true;
  if (rhs.printable_area < lhs.printable_area)
    return false;
  if (lhs.overlay_area < rhs.overlay_area)
    return true;
  if (rhs.overlay_area < lhs.overlay_area)
    return false;
  if (lhs.content_area < rhs.content_area)
    return true;
  if (rhs.content_area < lhs.content_area)
    return false;
  if (lhs.effective_margins < rhs.effective_margins)
    return true;
  if (rhs.effective_margins < lhs.effective_margins)
    return false;
  if (lhs.requested_margins < rhs.requested_margins)
    return true;
  if (rhs.requested_margins < lhs.requested_margins)
    return false;
  if (lhs.forced_margins < rhs.forced_margins)
    return true;
  if (rhs.forced_margins < lhs.forced_margins)
    return false;
  if (lhs.text_height < rhs.text_height)
    return true;
  if (rhs.text_height < lhs.text_height)
    return false;
  return false;
}
template <typename StructPtrType>
RequestedMediaPtr RequestedMedia::Clone() const {
  return New(
      mojo::Clone(size_microns),
      mojo::Clone(vendor_id)
  );
}

template <typename T, RequestedMedia::EnableIfSame<T>*>
bool RequestedMedia::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->size_microns, other_struct.size_microns))
    return false;
  if (!mojo::Equals(this->vendor_id, other_struct.vendor_id))
    return false;
  return true;
}

template <typename T, RequestedMedia::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.size_microns < rhs.size_microns)
    return true;
  if (rhs.size_microns < lhs.size_microns)
    return false;
  if (lhs.vendor_id < rhs.vendor_id)
    return true;
  if (rhs.vendor_id < lhs.vendor_id)
    return false;
  return false;
}
template <typename StructPtrType>
PrintSettingsPtr PrintSettings::Clone() const {
  return New(
      mojo::Clone(ranges),
      mojo::Clone(selection_only),
      mojo::Clone(margin_type),
      mojo::Clone(title),
      mojo::Clone(url),
      mojo::Clone(display_header_footer),
      mojo::Clone(should_print_backgrounds),
      mojo::Clone(collate),
      mojo::Clone(color),
      mojo::Clone(copies),
      mojo::Clone(duplex_mode),
      mojo::Clone(device_name),
      mojo::Clone(requested_media),
      mojo::Clone(page_setup_device_units),
      mojo::Clone(borderless),
      mojo::Clone(media_type),
      mojo::Clone(dpi),
      mojo::Clone(scale_factor),
      mojo::Clone(rasterize_pdf),
      mojo::Clone(landscape),
      mojo::Clone(is_modifiable),
      mojo::Clone(requested_custom_margins_in_microns),
      mojo::Clone(pages_per_sheet),
      mojo::Clone(system_print_dialog_data)
  );
}

template <typename T, PrintSettings::EnableIfSame<T>*>
bool PrintSettings::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->ranges, other_struct.ranges))
    return false;
  if (!mojo::Equals(this->selection_only, other_struct.selection_only))
    return false;
  if (!mojo::Equals(this->margin_type, other_struct.margin_type))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->display_header_footer, other_struct.display_header_footer))
    return false;
  if (!mojo::Equals(this->should_print_backgrounds, other_struct.should_print_backgrounds))
    return false;
  if (!mojo::Equals(this->collate, other_struct.collate))
    return false;
  if (!mojo::Equals(this->color, other_struct.color))
    return false;
  if (!mojo::Equals(this->copies, other_struct.copies))
    return false;
  if (!mojo::Equals(this->duplex_mode, other_struct.duplex_mode))
    return false;
  if (!mojo::Equals(this->device_name, other_struct.device_name))
    return false;
  if (!mojo::Equals(this->requested_media, other_struct.requested_media))
    return false;
  if (!mojo::Equals(this->page_setup_device_units, other_struct.page_setup_device_units))
    return false;
  if (!mojo::Equals(this->borderless, other_struct.borderless))
    return false;
  if (!mojo::Equals(this->media_type, other_struct.media_type))
    return false;
  if (!mojo::Equals(this->dpi, other_struct.dpi))
    return false;
  if (!mojo::Equals(this->scale_factor, other_struct.scale_factor))
    return false;
  if (!mojo::Equals(this->rasterize_pdf, other_struct.rasterize_pdf))
    return false;
  if (!mojo::Equals(this->landscape, other_struct.landscape))
    return false;
  if (!mojo::Equals(this->is_modifiable, other_struct.is_modifiable))
    return false;
  if (!mojo::Equals(this->requested_custom_margins_in_microns, other_struct.requested_custom_margins_in_microns))
    return false;
  if (!mojo::Equals(this->pages_per_sheet, other_struct.pages_per_sheet))
    return false;
  if (!mojo::Equals(this->system_print_dialog_data, other_struct.system_print_dialog_data))
    return false;
  return true;
}

template <typename T, PrintSettings::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.ranges < rhs.ranges)
    return true;
  if (rhs.ranges < lhs.ranges)
    return false;
  if (lhs.selection_only < rhs.selection_only)
    return true;
  if (rhs.selection_only < lhs.selection_only)
    return false;
  if (lhs.margin_type < rhs.margin_type)
    return true;
  if (rhs.margin_type < lhs.margin_type)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.display_header_footer < rhs.display_header_footer)
    return true;
  if (rhs.display_header_footer < lhs.display_header_footer)
    return false;
  if (lhs.should_print_backgrounds < rhs.should_print_backgrounds)
    return true;
  if (rhs.should_print_backgrounds < lhs.should_print_backgrounds)
    return false;
  if (lhs.collate < rhs.collate)
    return true;
  if (rhs.collate < lhs.collate)
    return false;
  if (lhs.color < rhs.color)
    return true;
  if (rhs.color < lhs.color)
    return false;
  if (lhs.copies < rhs.copies)
    return true;
  if (rhs.copies < lhs.copies)
    return false;
  if (lhs.duplex_mode < rhs.duplex_mode)
    return true;
  if (rhs.duplex_mode < lhs.duplex_mode)
    return false;
  if (lhs.device_name < rhs.device_name)
    return true;
  if (rhs.device_name < lhs.device_name)
    return false;
  if (lhs.requested_media < rhs.requested_media)
    return true;
  if (rhs.requested_media < lhs.requested_media)
    return false;
  if (lhs.page_setup_device_units < rhs.page_setup_device_units)
    return true;
  if (rhs.page_setup_device_units < lhs.page_setup_device_units)
    return false;
  if (lhs.borderless < rhs.borderless)
    return true;
  if (rhs.borderless < lhs.borderless)
    return false;
  if (lhs.media_type < rhs.media_type)
    return true;
  if (rhs.media_type < lhs.media_type)
    return false;
  if (lhs.dpi < rhs.dpi)
    return true;
  if (rhs.dpi < lhs.dpi)
    return false;
  if (lhs.scale_factor < rhs.scale_factor)
    return true;
  if (rhs.scale_factor < lhs.scale_factor)
    return false;
  if (lhs.rasterize_pdf < rhs.rasterize_pdf)
    return true;
  if (rhs.rasterize_pdf < lhs.rasterize_pdf)
    return false;
  if (lhs.landscape < rhs.landscape)
    return true;
  if (rhs.landscape < lhs.landscape)
    return false;
  if (lhs.is_modifiable < rhs.is_modifiable)
    return true;
  if (rhs.is_modifiable < lhs.is_modifiable)
    return false;
  if (lhs.requested_custom_margins_in_microns < rhs.requested_custom_margins_in_microns)
    return true;
  if (rhs.requested_custom_margins_in_microns < lhs.requested_custom_margins_in_microns)
    return false;
  if (lhs.pages_per_sheet < rhs.pages_per_sheet)
    return true;
  if (rhs.pages_per_sheet < lhs.pages_per_sheet)
    return false;
  if (lhs.system_print_dialog_data < rhs.system_print_dialog_data)
    return true;
  if (rhs.system_print_dialog_data < lhs.system_print_dialog_data)
    return false;
  return false;
}


}  // printing::mojom

namespace mojo {


template <>
struct  StructTraits<::printing::mojom::PageMargins::DataView,
                                         ::printing::mojom::PageMarginsPtr> {
  static bool IsNull(const ::printing::mojom::PageMarginsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PageMarginsPtr* output) { output->reset(); }

  static decltype(::printing::mojom::PageMargins::header) header(
      const ::printing::mojom::PageMarginsPtr& input) {
    return input->header;
  }

  static decltype(::printing::mojom::PageMargins::footer) footer(
      const ::printing::mojom::PageMarginsPtr& input) {
    return input->footer;
  }

  static decltype(::printing::mojom::PageMargins::left) left(
      const ::printing::mojom::PageMarginsPtr& input) {
    return input->left;
  }

  static decltype(::printing::mojom::PageMargins::right) right(
      const ::printing::mojom::PageMarginsPtr& input) {
    return input->right;
  }

  static decltype(::printing::mojom::PageMargins::top) top(
      const ::printing::mojom::PageMarginsPtr& input) {
    return input->top;
  }

  static decltype(::printing::mojom::PageMargins::bottom) bottom(
      const ::printing::mojom::PageMarginsPtr& input) {
    return input->bottom;
  }

  static bool Read(::printing::mojom::PageMargins::DataView input, ::printing::mojom::PageMarginsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::PageSetup::DataView,
                                         ::printing::mojom::PageSetupPtr> {
  static bool IsNull(const ::printing::mojom::PageSetupPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PageSetupPtr* output) { output->reset(); }

  static const decltype(::printing::mojom::PageSetup::physical_size)& physical_size(
      const ::printing::mojom::PageSetupPtr& input) {
    return input->physical_size;
  }

  static const decltype(::printing::mojom::PageSetup::printable_area)& printable_area(
      const ::printing::mojom::PageSetupPtr& input) {
    return input->printable_area;
  }

  static const decltype(::printing::mojom::PageSetup::overlay_area)& overlay_area(
      const ::printing::mojom::PageSetupPtr& input) {
    return input->overlay_area;
  }

  static const decltype(::printing::mojom::PageSetup::content_area)& content_area(
      const ::printing::mojom::PageSetupPtr& input) {
    return input->content_area;
  }

  static const decltype(::printing::mojom::PageSetup::effective_margins)& effective_margins(
      const ::printing::mojom::PageSetupPtr& input) {
    return input->effective_margins;
  }

  static const decltype(::printing::mojom::PageSetup::requested_margins)& requested_margins(
      const ::printing::mojom::PageSetupPtr& input) {
    return input->requested_margins;
  }

  static decltype(::printing::mojom::PageSetup::forced_margins) forced_margins(
      const ::printing::mojom::PageSetupPtr& input) {
    return input->forced_margins;
  }

  static decltype(::printing::mojom::PageSetup::text_height) text_height(
      const ::printing::mojom::PageSetupPtr& input) {
    return input->text_height;
  }

  static bool Read(::printing::mojom::PageSetup::DataView input, ::printing::mojom::PageSetupPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::RequestedMedia::DataView,
                                         ::printing::mojom::RequestedMediaPtr> {
  static bool IsNull(const ::printing::mojom::RequestedMediaPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::RequestedMediaPtr* output) { output->reset(); }

  static const decltype(::printing::mojom::RequestedMedia::size_microns)& size_microns(
      const ::printing::mojom::RequestedMediaPtr& input) {
    return input->size_microns;
  }

  static const decltype(::printing::mojom::RequestedMedia::vendor_id)& vendor_id(
      const ::printing::mojom::RequestedMediaPtr& input) {
    return input->vendor_id;
  }

  static bool Read(::printing::mojom::RequestedMedia::DataView input, ::printing::mojom::RequestedMediaPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::PrintSettings::DataView,
                                         ::printing::mojom::PrintSettingsPtr> {
  static bool IsNull(const ::printing::mojom::PrintSettingsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PrintSettingsPtr* output) { output->reset(); }

  static const decltype(::printing::mojom::PrintSettings::ranges)& ranges(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->ranges;
  }

  static decltype(::printing::mojom::PrintSettings::selection_only) selection_only(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->selection_only;
  }

  static decltype(::printing::mojom::PrintSettings::margin_type) margin_type(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->margin_type;
  }

  static const decltype(::printing::mojom::PrintSettings::title)& title(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->title;
  }

  static const decltype(::printing::mojom::PrintSettings::url)& url(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->url;
  }

  static decltype(::printing::mojom::PrintSettings::display_header_footer) display_header_footer(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->display_header_footer;
  }

  static decltype(::printing::mojom::PrintSettings::should_print_backgrounds) should_print_backgrounds(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->should_print_backgrounds;
  }

  static decltype(::printing::mojom::PrintSettings::collate) collate(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->collate;
  }

  static decltype(::printing::mojom::PrintSettings::color) color(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->color;
  }

  static decltype(::printing::mojom::PrintSettings::copies) copies(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->copies;
  }

  static decltype(::printing::mojom::PrintSettings::duplex_mode) duplex_mode(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->duplex_mode;
  }

  static const decltype(::printing::mojom::PrintSettings::device_name)& device_name(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->device_name;
  }

  static const decltype(::printing::mojom::PrintSettings::requested_media)& requested_media(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->requested_media;
  }

  static const decltype(::printing::mojom::PrintSettings::page_setup_device_units)& page_setup_device_units(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->page_setup_device_units;
  }

  static decltype(::printing::mojom::PrintSettings::borderless) borderless(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->borderless;
  }

  static const decltype(::printing::mojom::PrintSettings::media_type)& media_type(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->media_type;
  }

  static const decltype(::printing::mojom::PrintSettings::dpi)& dpi(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->dpi;
  }

  static decltype(::printing::mojom::PrintSettings::scale_factor) scale_factor(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->scale_factor;
  }

  static decltype(::printing::mojom::PrintSettings::rasterize_pdf) rasterize_pdf(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->rasterize_pdf;
  }

  static decltype(::printing::mojom::PrintSettings::landscape) landscape(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->landscape;
  }

  static decltype(::printing::mojom::PrintSettings::is_modifiable) is_modifiable(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->is_modifiable;
  }

  static const decltype(::printing::mojom::PrintSettings::requested_custom_margins_in_microns)& requested_custom_margins_in_microns(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->requested_custom_margins_in_microns;
  }

  static decltype(::printing::mojom::PrintSettings::pages_per_sheet) pages_per_sheet(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->pages_per_sheet;
  }

  static const decltype(::printing::mojom::PrintSettings::system_print_dialog_data)& system_print_dialog_data(
      const ::printing::mojom::PrintSettingsPtr& input) {
    return input->system_print_dialog_data;
  }

  static bool Read(::printing::mojom::PrintSettings::DataView input, ::printing::mojom::PrintSettingsPtr* output);
};

}  // namespace mojo

#endif  // PRINTING_MOJOM_PRINTING_CONTEXT_MOJOM_H_