// printing/mojom/printing_context.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PRINTING_MOJOM_PRINTING_CONTEXT_MOJOM_DATA_VIEW_H_
#define PRINTING_MOJOM_PRINTING_CONTEXT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "printing/mojom/printing_context.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "printing/mojom/print.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace printing::mojom {
class PageMarginsDataView;

class PageSetupDataView;

class RequestedMediaDataView;

class PrintSettingsDataView;



}  // printing::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::printing::mojom::PageMarginsDataView> {
  using Data = ::printing::mojom::internal::PageMargins_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PageSetupDataView> {
  using Data = ::printing::mojom::internal::PageSetup_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::RequestedMediaDataView> {
  using Data = ::printing::mojom::internal::RequestedMedia_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintSettingsDataView> {
  using Data = ::printing::mojom::internal::PrintSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace printing::mojom {


class PageMarginsDataView {
 public:
  PageMarginsDataView() = default;

  PageMarginsDataView(
      internal::PageMargins_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t header() const {
    return data_->header;
  }
  int32_t footer() const {
    return data_->footer;
  }
  int32_t left() const {
    return data_->left;
  }
  int32_t right() const {
    return data_->right;
  }
  int32_t top() const {
    return data_->top;
  }
  int32_t bottom() const {
    return data_->bottom;
  }
 private:
  internal::PageMargins_Data* data_ = nullptr;
};


class PageSetupDataView {
 public:
  PageSetupDataView() = default;

  PageSetupDataView(
      internal::PageSetup_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPhysicalSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPhysicalSize(UserType* output) {
    
    auto* pointer = data_->physical_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetPrintableAreaDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrintableArea(UserType* output) {
    
    auto* pointer = data_->printable_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetOverlayAreaDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOverlayArea(UserType* output) {
    
    auto* pointer = data_->overlay_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetContentAreaDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentArea(UserType* output) {
    
    auto* pointer = data_->content_area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetEffectiveMarginsDataView(
      PageMarginsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEffectiveMargins(UserType* output) {
    
    auto* pointer = data_->effective_margins.Get();
    return mojo::internal::Deserialize<::printing::mojom::PageMarginsDataView>(
        pointer, output, message_);
  }
  inline void GetRequestedMarginsDataView(
      PageMarginsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestedMargins(UserType* output) {
    
    auto* pointer = data_->requested_margins.Get();
    return mojo::internal::Deserialize<::printing::mojom::PageMarginsDataView>(
        pointer, output, message_);
  }
  bool forced_margins() const {
    return data_->forced_margins;
  }
  int32_t text_height() const {
    return data_->text_height;
  }
 private:
  internal::PageSetup_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RequestedMediaDataView {
 public:
  RequestedMediaDataView() = default;

  RequestedMediaDataView(
      internal::RequestedMedia_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSizeMicronsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSizeMicrons(UserType* output) {
    
    auto* pointer = data_->size_microns.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetVendorIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVendorId(UserType* output) {
    
    auto* pointer = data_->vendor_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::RequestedMedia_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrintSettingsDataView {
 public:
  PrintSettingsDataView() = default;

  PrintSettingsDataView(
      internal::PrintSettings_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRangesDataView(
      mojo::ArrayDataView<::printing::mojom::PageRangeDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRanges(UserType* output) {
    
    auto* pointer = data_->ranges.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::printing::mojom::PageRangeDataView>>(
        pointer, output, message_);
  }
  bool selection_only() const {
    return data_->selection_only;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMarginType(UserType* output) const {
    auto data_value = data_->margin_type;
    return mojo::internal::Deserialize<::printing::mojom::MarginType>(
        data_value, output);
  }
  ::printing::mojom::MarginType margin_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::MarginType>(data_->margin_type));
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool display_header_footer() const {
    return data_->display_header_footer;
  }
  bool should_print_backgrounds() const {
    return data_->should_print_backgrounds;
  }
  bool collate() const {
    return data_->collate;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadColor(UserType* output) const {
    auto data_value = data_->color;
    return mojo::internal::Deserialize<::printing::mojom::ColorModel>(
        data_value, output);
  }
  ::printing::mojom::ColorModel color() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::ColorModel>(data_->color));
  }
  int32_t copies() const {
    return data_->copies;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDuplexMode(UserType* output) const {
    auto data_value = data_->duplex_mode;
    return mojo::internal::Deserialize<::printing::mojom::DuplexMode>(
        data_value, output);
  }
  ::printing::mojom::DuplexMode duplex_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::DuplexMode>(data_->duplex_mode));
  }
  inline void GetDeviceNameDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceName(UserType* output) {
    
    auto* pointer = data_->device_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetRequestedMediaDataView(
      RequestedMediaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestedMedia(UserType* output) {
    
    auto* pointer = data_->requested_media.Get();
    return mojo::internal::Deserialize<::printing::mojom::RequestedMediaDataView>(
        pointer, output, message_);
  }
  inline void GetPageSetupDeviceUnitsDataView(
      PageSetupDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageSetupDeviceUnits(UserType* output) {
    
    auto* pointer = data_->page_setup_device_units.Get();
    return mojo::internal::Deserialize<::printing::mojom::PageSetupDataView>(
        pointer, output, message_);
  }
  bool borderless() const {
    return data_->borderless;
  }
  inline void GetMediaTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaType(UserType* output) {
    
    auto* pointer = data_->media_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDpiDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDpi(UserType* output) {
    
    auto* pointer = data_->dpi.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  double scale_factor() const {
    return data_->scale_factor;
  }
  bool rasterize_pdf() const {
    return data_->rasterize_pdf;
  }
  bool landscape() const {
    return data_->landscape;
  }
  bool is_modifiable() const {
    return data_->is_modifiable;
  }
  inline void GetRequestedCustomMarginsInMicronsDataView(
      PageMarginsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestedCustomMarginsInMicrons(UserType* output) {
    
    auto* pointer = data_->requested_custom_margins_in_microns.Get();
    return mojo::internal::Deserialize<::printing::mojom::PageMarginsDataView>(
        pointer, output, message_);
  }
  int32_t pages_per_sheet() const {
    return data_->pages_per_sheet;
  }
  inline void GetSystemPrintDialogDataDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSystemPrintDialogData(UserType* output) {
    
    auto* pointer = data_->system_print_dialog_data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::PrintSettings_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // printing::mojom

#endif  // PRINTING_MOJOM_PRINTING_CONTEXT_MOJOM_DATA_VIEW_H_