// printing/backend/mojom/print_backend.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PRINTING_BACKEND_MOJOM_PRINT_BACKEND_MOJOM_H_
#define PRINTING_BACKEND_MOJOM_PRINT_BACKEND_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "printing/backend/mojom/print_backend.mojom-features.h"  // IWYU pragma: export
#include "printing/backend/mojom/print_backend.mojom-shared.h"  // IWYU pragma: export
#include "printing/backend/mojom/print_backend.mojom-forward.h"  // IWYU pragma: export
#include "printing/mojom/print.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>




#include "printing/backend/mojom/print_backend_mojom_traits.h"




namespace printing::mojom {







class  MediaType {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaType, T>::value>;
  using DataView = MediaTypeDataView;
  using Data_ = internal::MediaType_Data;

  template <typename... Args>
  static MediaTypePtr New(Args&&... args) {
    return MediaTypePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaTypePtr From(const U& u) {
    return mojo::TypeConverter<MediaTypePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaType>::Convert(*this);
  }


  MediaType();

  MediaType(
      const std::string& display_name,
      const std::string& vendor_id);


  ~MediaType();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaTypePtr>
  MediaTypePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaType::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaType::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaType::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaType::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaType::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaType::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaType_UnserializedMessageContext<
            UserType, MediaType::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaType::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaType::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaType_UnserializedMessageContext<
            UserType, MediaType::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaType::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string display_name;
  
  std::string vendor_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaType::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaType::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaType::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaType::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  PrinterBasicInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrinterBasicInfo, T>::value>;
  using DataView = PrinterBasicInfoDataView;
  using Data_ = internal::PrinterBasicInfo_Data;

  template <typename... Args>
  static PrinterBasicInfoPtr New(Args&&... args) {
    return PrinterBasicInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrinterBasicInfoPtr From(const U& u) {
    return mojo::TypeConverter<PrinterBasicInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrinterBasicInfo>::Convert(*this);
  }


  PrinterBasicInfo();

  PrinterBasicInfo(
      const std::string& printer_name,
      const std::string& display_name,
      const std::string& printer_description,
      const base::flat_map<std::string, std::string>& options);


  ~PrinterBasicInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrinterBasicInfoPtr>
  PrinterBasicInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrinterBasicInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrinterBasicInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrinterBasicInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrinterBasicInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrinterBasicInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrinterBasicInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrinterBasicInfo_UnserializedMessageContext<
            UserType, PrinterBasicInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrinterBasicInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrinterBasicInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrinterBasicInfo_UnserializedMessageContext<
            UserType, PrinterBasicInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrinterBasicInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string printer_name;
  
  std::string display_name;
  
  std::string printer_description;
  
  base::flat_map<std::string, std::string> options;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrinterBasicInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrinterBasicInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrinterBasicInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrinterBasicInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Paper {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Paper, T>::value>;
  using DataView = PaperDataView;
  using Data_ = internal::Paper_Data;

  template <typename... Args>
  static PaperPtr New(Args&&... args) {
    return PaperPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaperPtr From(const U& u) {
    return mojo::TypeConverter<PaperPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Paper>::Convert(*this);
  }


  Paper();

  Paper(
      const std::string& display_name,
      const std::string& vendor_id,
      const ::gfx::Size& size_um,
      const ::gfx::Rect& printable_area_um,
      int32_t max_height_um,
      bool has_borderless_variant);


  ~Paper();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaperPtr>
  PaperPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Paper::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Paper::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Paper::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Paper::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Paper::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Paper::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Paper_UnserializedMessageContext<
            UserType, Paper::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Paper::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Paper::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Paper_UnserializedMessageContext<
            UserType, Paper::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Paper::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string display_name;
  
  std::string vendor_id;
  
  ::gfx::Size size_um;
  
  ::gfx::Rect printable_area_um;
  
  int32_t max_height_um;
  
  bool has_borderless_variant;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Paper::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Paper::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Paper::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Paper::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  PrinterSemanticCapsAndDefaults {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PrinterSemanticCapsAndDefaults, T>::value>;
  using DataView = PrinterSemanticCapsAndDefaultsDataView;
  using Data_ = internal::PrinterSemanticCapsAndDefaults_Data;

  template <typename... Args>
  static PrinterSemanticCapsAndDefaultsPtr New(Args&&... args) {
    return PrinterSemanticCapsAndDefaultsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PrinterSemanticCapsAndDefaultsPtr From(const U& u) {
    return mojo::TypeConverter<PrinterSemanticCapsAndDefaultsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PrinterSemanticCapsAndDefaults>::Convert(*this);
  }


  PrinterSemanticCapsAndDefaults();

  PrinterSemanticCapsAndDefaults(
      bool collate_capable,
      bool collate_default,
      int32_t copies_max,
      std::vector<::printing::mojom::DuplexMode> duplex_modes,
      ::printing::mojom::DuplexMode duplex_default,
      bool color_changeable,
      bool color_default,
      ::printing::mojom::ColorModel color_model,
      ::printing::mojom::ColorModel bw_model,
      std::vector<::printing::PrinterSemanticCapsAndDefaults::Paper> papers,
      std::vector<::printing::PrinterSemanticCapsAndDefaults::Paper> user_defined_papers,
      const ::printing::PrinterSemanticCapsAndDefaults::Paper& default_paper,
      std::vector<::gfx::Size> dpis,
      const ::gfx::Size& default_dpi,
      std::optional<std::vector<MediaTypePtr>> media_types,
      MediaTypePtr default_media_type);

PrinterSemanticCapsAndDefaults(const PrinterSemanticCapsAndDefaults&) = delete;
PrinterSemanticCapsAndDefaults& operator=(const PrinterSemanticCapsAndDefaults&) = delete;

  ~PrinterSemanticCapsAndDefaults();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PrinterSemanticCapsAndDefaultsPtr>
  PrinterSemanticCapsAndDefaultsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PrinterSemanticCapsAndDefaults::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PrinterSemanticCapsAndDefaults::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PrinterSemanticCapsAndDefaults::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrinterSemanticCapsAndDefaults::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PrinterSemanticCapsAndDefaults::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PrinterSemanticCapsAndDefaults::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PrinterSemanticCapsAndDefaults_UnserializedMessageContext<
            UserType, PrinterSemanticCapsAndDefaults::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PrinterSemanticCapsAndDefaults::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PrinterSemanticCapsAndDefaults::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PrinterSemanticCapsAndDefaults_UnserializedMessageContext<
            UserType, PrinterSemanticCapsAndDefaults::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PrinterSemanticCapsAndDefaults::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool collate_capable;
  
  bool collate_default;
  
  int32_t copies_max;
  
  std::vector<::printing::mojom::DuplexMode> duplex_modes;
  
  ::printing::mojom::DuplexMode duplex_default;
  
  bool color_changeable;
  
  bool color_default;
  
  ::printing::mojom::ColorModel color_model;
  
  ::printing::mojom::ColorModel bw_model;
  
  std::vector<::printing::PrinterSemanticCapsAndDefaults::Paper> papers;
  
  std::vector<::printing::PrinterSemanticCapsAndDefaults::Paper> user_defined_papers;
  
  ::printing::PrinterSemanticCapsAndDefaults::Paper default_paper;
  
  std::vector<::gfx::Size> dpis;
  
  ::gfx::Size default_dpi;
  
  std::optional<std::vector<MediaTypePtr>> media_types;
  
  MediaTypePtr default_media_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PrinterSemanticCapsAndDefaults::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PrinterSemanticCapsAndDefaults::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PrinterSemanticCapsAndDefaults::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PrinterSemanticCapsAndDefaults::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PrinterBasicInfoPtr PrinterBasicInfo::Clone() const {
  return New(
      mojo::Clone(printer_name),
      mojo::Clone(display_name),
      mojo::Clone(printer_description),
      mojo::Clone(options)
  );
}

template <typename T, PrinterBasicInfo::EnableIfSame<T>*>
bool PrinterBasicInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->printer_name, other_struct.printer_name))
    return false;
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->printer_description, other_struct.printer_description))
    return false;
  if (!mojo::Equals(this->options, other_struct.options))
    return false;
  return true;
}

template <typename T, PrinterBasicInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.printer_name < rhs.printer_name)
    return true;
  if (rhs.printer_name < lhs.printer_name)
    return false;
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  if (lhs.printer_description < rhs.printer_description)
    return true;
  if (rhs.printer_description < lhs.printer_description)
    return false;
  if (lhs.options < rhs.options)
    return true;
  if (rhs.options < lhs.options)
    return false;
  return false;
}
template <typename StructPtrType>
PaperPtr Paper::Clone() const {
  return New(
      mojo::Clone(display_name),
      mojo::Clone(vendor_id),
      mojo::Clone(size_um),
      mojo::Clone(printable_area_um),
      mojo::Clone(max_height_um),
      mojo::Clone(has_borderless_variant)
  );
}

template <typename T, Paper::EnableIfSame<T>*>
bool Paper::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->vendor_id, other_struct.vendor_id))
    return false;
  if (!mojo::Equals(this->size_um, other_struct.size_um))
    return false;
  if (!mojo::Equals(this->printable_area_um, other_struct.printable_area_um))
    return false;
  if (!mojo::Equals(this->max_height_um, other_struct.max_height_um))
    return false;
  if (!mojo::Equals(this->has_borderless_variant, other_struct.has_borderless_variant))
    return false;
  return true;
}

template <typename T, Paper::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  if (lhs.vendor_id < rhs.vendor_id)
    return true;
  if (rhs.vendor_id < lhs.vendor_id)
    return false;
  if (lhs.size_um < rhs.size_um)
    return true;
  if (rhs.size_um < lhs.size_um)
    return false;
  if (lhs.printable_area_um < rhs.printable_area_um)
    return true;
  if (rhs.printable_area_um < lhs.printable_area_um)
    return false;
  if (lhs.max_height_um < rhs.max_height_um)
    return true;
  if (rhs.max_height_um < lhs.max_height_um)
    return false;
  if (lhs.has_borderless_variant < rhs.has_borderless_variant)
    return true;
  if (rhs.has_borderless_variant < lhs.has_borderless_variant)
    return false;
  return false;
}
template <typename StructPtrType>
MediaTypePtr MediaType::Clone() const {
  return New(
      mojo::Clone(display_name),
      mojo::Clone(vendor_id)
  );
}

template <typename T, MediaType::EnableIfSame<T>*>
bool MediaType::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->vendor_id, other_struct.vendor_id))
    return false;
  return true;
}

template <typename T, MediaType::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  if (lhs.vendor_id < rhs.vendor_id)
    return true;
  if (rhs.vendor_id < lhs.vendor_id)
    return false;
  return false;
}
template <typename StructPtrType>
PrinterSemanticCapsAndDefaultsPtr PrinterSemanticCapsAndDefaults::Clone() const {
  return New(
      mojo::Clone(collate_capable),
      mojo::Clone(collate_default),
      mojo::Clone(copies_max),
      mojo::Clone(duplex_modes),
      mojo::Clone(duplex_default),
      mojo::Clone(color_changeable),
      mojo::Clone(color_default),
      mojo::Clone(color_model),
      mojo::Clone(bw_model),
      mojo::Clone(papers),
      mojo::Clone(user_defined_papers),
      mojo::Clone(default_paper),
      mojo::Clone(dpis),
      mojo::Clone(default_dpi),
      mojo::Clone(media_types),
      mojo::Clone(default_media_type)
  );
}

template <typename T, PrinterSemanticCapsAndDefaults::EnableIfSame<T>*>
bool PrinterSemanticCapsAndDefaults::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->collate_capable, other_struct.collate_capable))
    return false;
  if (!mojo::Equals(this->collate_default, other_struct.collate_default))
    return false;
  if (!mojo::Equals(this->copies_max, other_struct.copies_max))
    return false;
  if (!mojo::Equals(this->duplex_modes, other_struct.duplex_modes))
    return false;
  if (!mojo::Equals(this->duplex_default, other_struct.duplex_default))
    return false;
  if (!mojo::Equals(this->color_changeable, other_struct.color_changeable))
    return false;
  if (!mojo::Equals(this->color_default, other_struct.color_default))
    return false;
  if (!mojo::Equals(this->color_model, other_struct.color_model))
    return false;
  if (!mojo::Equals(this->bw_model, other_struct.bw_model))
    return false;
  if (!mojo::Equals(this->papers, other_struct.papers))
    return false;
  if (!mojo::Equals(this->user_defined_papers, other_struct.user_defined_papers))
    return false;
  if (!mojo::Equals(this->default_paper, other_struct.default_paper))
    return false;
  if (!mojo::Equals(this->dpis, other_struct.dpis))
    return false;
  if (!mojo::Equals(this->default_dpi, other_struct.default_dpi))
    return false;
  if (!mojo::Equals(this->media_types, other_struct.media_types))
    return false;
  if (!mojo::Equals(this->default_media_type, other_struct.default_media_type))
    return false;
  return true;
}

template <typename T, PrinterSemanticCapsAndDefaults::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.collate_capable < rhs.collate_capable)
    return true;
  if (rhs.collate_capable < lhs.collate_capable)
    return false;
  if (lhs.collate_default < rhs.collate_default)
    return true;
  if (rhs.collate_default < lhs.collate_default)
    return false;
  if (lhs.copies_max < rhs.copies_max)
    return true;
  if (rhs.copies_max < lhs.copies_max)
    return false;
  if (lhs.duplex_modes < rhs.duplex_modes)
    return true;
  if (rhs.duplex_modes < lhs.duplex_modes)
    return false;
  if (lhs.duplex_default < rhs.duplex_default)
    return true;
  if (rhs.duplex_default < lhs.duplex_default)
    return false;
  if (lhs.color_changeable < rhs.color_changeable)
    return true;
  if (rhs.color_changeable < lhs.color_changeable)
    return false;
  if (lhs.color_default < rhs.color_default)
    return true;
  if (rhs.color_default < lhs.color_default)
    return false;
  if (lhs.color_model < rhs.color_model)
    return true;
  if (rhs.color_model < lhs.color_model)
    return false;
  if (lhs.bw_model < rhs.bw_model)
    return true;
  if (rhs.bw_model < lhs.bw_model)
    return false;
  if (lhs.papers < rhs.papers)
    return true;
  if (rhs.papers < lhs.papers)
    return false;
  if (lhs.user_defined_papers < rhs.user_defined_papers)
    return true;
  if (rhs.user_defined_papers < lhs.user_defined_papers)
    return false;
  if (lhs.default_paper < rhs.default_paper)
    return true;
  if (rhs.default_paper < lhs.default_paper)
    return false;
  if (lhs.dpis < rhs.dpis)
    return true;
  if (rhs.dpis < lhs.dpis)
    return false;
  if (lhs.default_dpi < rhs.default_dpi)
    return true;
  if (rhs.default_dpi < lhs.default_dpi)
    return false;
  if (lhs.media_types < rhs.media_types)
    return true;
  if (rhs.media_types < lhs.media_types)
    return false;
  if (lhs.default_media_type < rhs.default_media_type)
    return true;
  if (rhs.default_media_type < lhs.default_media_type)
    return false;
  return false;
}


}  // printing::mojom

namespace mojo {


template <>
struct  StructTraits<::printing::mojom::PrinterBasicInfo::DataView,
                                         ::printing::mojom::PrinterBasicInfoPtr> {
  static bool IsNull(const ::printing::mojom::PrinterBasicInfoPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PrinterBasicInfoPtr* output) { output->reset(); }

  static const decltype(::printing::mojom::PrinterBasicInfo::printer_name)& printer_name(
      const ::printing::mojom::PrinterBasicInfoPtr& input) {
    return input->printer_name;
  }

  static const decltype(::printing::mojom::PrinterBasicInfo::display_name)& display_name(
      const ::printing::mojom::PrinterBasicInfoPtr& input) {
    return input->display_name;
  }

  static const decltype(::printing::mojom::PrinterBasicInfo::printer_description)& printer_description(
      const ::printing::mojom::PrinterBasicInfoPtr& input) {
    return input->printer_description;
  }

  static const decltype(::printing::mojom::PrinterBasicInfo::options)& options(
      const ::printing::mojom::PrinterBasicInfoPtr& input) {
    return input->options;
  }

  static bool Read(::printing::mojom::PrinterBasicInfo::DataView input, ::printing::mojom::PrinterBasicInfoPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::Paper::DataView,
                                         ::printing::mojom::PaperPtr> {
  static bool IsNull(const ::printing::mojom::PaperPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PaperPtr* output) { output->reset(); }

  static const decltype(::printing::mojom::Paper::display_name)& display_name(
      const ::printing::mojom::PaperPtr& input) {
    return input->display_name;
  }

  static const decltype(::printing::mojom::Paper::vendor_id)& vendor_id(
      const ::printing::mojom::PaperPtr& input) {
    return input->vendor_id;
  }

  static const decltype(::printing::mojom::Paper::size_um)& size_um(
      const ::printing::mojom::PaperPtr& input) {
    return input->size_um;
  }

  static const decltype(::printing::mojom::Paper::printable_area_um)& printable_area_um(
      const ::printing::mojom::PaperPtr& input) {
    return input->printable_area_um;
  }

  static decltype(::printing::mojom::Paper::max_height_um) max_height_um(
      const ::printing::mojom::PaperPtr& input) {
    return input->max_height_um;
  }

  static decltype(::printing::mojom::Paper::has_borderless_variant) has_borderless_variant(
      const ::printing::mojom::PaperPtr& input) {
    return input->has_borderless_variant;
  }

  static bool Read(::printing::mojom::Paper::DataView input, ::printing::mojom::PaperPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::MediaType::DataView,
                                         ::printing::mojom::MediaTypePtr> {
  static bool IsNull(const ::printing::mojom::MediaTypePtr& input) { return !input; }
  static void SetToNull(::printing::mojom::MediaTypePtr* output) { output->reset(); }

  static const decltype(::printing::mojom::MediaType::display_name)& display_name(
      const ::printing::mojom::MediaTypePtr& input) {
    return input->display_name;
  }

  static const decltype(::printing::mojom::MediaType::vendor_id)& vendor_id(
      const ::printing::mojom::MediaTypePtr& input) {
    return input->vendor_id;
  }

  static bool Read(::printing::mojom::MediaType::DataView input, ::printing::mojom::MediaTypePtr* output);
};


template <>
struct  StructTraits<::printing::mojom::PrinterSemanticCapsAndDefaults::DataView,
                                         ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr> {
  static bool IsNull(const ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::PrinterSemanticCapsAndDefaultsPtr* output) { output->reset(); }

  static decltype(::printing::mojom::PrinterSemanticCapsAndDefaults::collate_capable) collate_capable(
      const ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr& input) {
    return input->collate_capable;
  }

  static decltype(::printing::mojom::PrinterSemanticCapsAndDefaults::collate_default) collate_default(
      const ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr& input) {
    return input->collate_default;
  }

  static decltype(::printing::mojom::PrinterSemanticCapsAndDefaults::copies_max) copies_max(
      const ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr& input) {
    return input->copies_max;
  }

  static const decltype(::printing::mojom::PrinterSemanticCapsAndDefaults::duplex_modes)& duplex_modes(
      const ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr& input) {
    return input->duplex_modes;
  }

  static decltype(::printing::mojom::PrinterSemanticCapsAndDefaults::duplex_default) duplex_default(
      const ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr& input) {
    return input->duplex_default;
  }

  static decltype(::printing::mojom::PrinterSemanticCapsAndDefaults::color_changeable) color_changeable(
      const ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr& input) {
    return input->color_changeable;
  }

  static decltype(::printing::mojom::PrinterSemanticCapsAndDefaults::color_default) color_default(
      const ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr& input) {
    return input->color_default;
  }

  static decltype(::printing::mojom::PrinterSemanticCapsAndDefaults::color_model) color_model(
      const ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr& input) {
    return input->color_model;
  }

  static decltype(::printing::mojom::PrinterSemanticCapsAndDefaults::bw_model) bw_model(
      const ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr& input) {
    return input->bw_model;
  }

  static const decltype(::printing::mojom::PrinterSemanticCapsAndDefaults::papers)& papers(
      const ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr& input) {
    return input->papers;
  }

  static const decltype(::printing::mojom::PrinterSemanticCapsAndDefaults::user_defined_papers)& user_defined_papers(
      const ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr& input) {
    return input->user_defined_papers;
  }

  static const decltype(::printing::mojom::PrinterSemanticCapsAndDefaults::default_paper)& default_paper(
      const ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr& input) {
    return input->default_paper;
  }

  static const decltype(::printing::mojom::PrinterSemanticCapsAndDefaults::dpis)& dpis(
      const ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr& input) {
    return input->dpis;
  }

  static const decltype(::printing::mojom::PrinterSemanticCapsAndDefaults::default_dpi)& default_dpi(
      const ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr& input) {
    return input->default_dpi;
  }

  static const decltype(::printing::mojom::PrinterSemanticCapsAndDefaults::media_types)& media_types(
      const ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr& input) {
    return input->media_types;
  }

  static const decltype(::printing::mojom::PrinterSemanticCapsAndDefaults::default_media_type)& default_media_type(
      const ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr& input) {
    return input->default_media_type;
  }

  static bool Read(::printing::mojom::PrinterSemanticCapsAndDefaults::DataView input, ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr* output);
};

}  // namespace mojo

#endif  // PRINTING_BACKEND_MOJOM_PRINT_BACKEND_MOJOM_H_