// printing/backend/mojom/print_backend.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "printing/backend/mojom/print_backend.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "printing/backend/mojom/print_backend.mojom-params-data.h"
#include "printing/backend/mojom/print_backend.mojom-shared-message-ids.h"

#include "printing/backend/mojom/print_backend.mojom-import-headers.h"
#include "printing/backend/mojom/print_backend.mojom-test-utils.h"


namespace printing::mojom {
PrinterBasicInfo::PrinterBasicInfo()
    : printer_name(),
      display_name(),
      printer_description(),
      options() {}

PrinterBasicInfo::PrinterBasicInfo(
    const std::string& printer_name_in,
    const std::string& display_name_in,
    const std::string& printer_description_in,
    const base::flat_map<std::string, std::string>& options_in)
    : printer_name(std::move(printer_name_in)),
      display_name(std::move(display_name_in)),
      printer_description(std::move(printer_description_in)),
      options(std::move(options_in)) {}

PrinterBasicInfo::~PrinterBasicInfo() = default;

void PrinterBasicInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printer_name"), this->printer_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printer_description"), this->printer_description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "options"), this->options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrinterBasicInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Paper::Paper()
    : display_name(),
      vendor_id(),
      size_um(),
      printable_area_um(),
      max_height_um(),
      has_borderless_variant() {}

Paper::Paper(
    const std::string& display_name_in,
    const std::string& vendor_id_in,
    const ::gfx::Size& size_um_in,
    const ::gfx::Rect& printable_area_um_in,
    int32_t max_height_um_in,
    bool has_borderless_variant_in)
    : display_name(std::move(display_name_in)),
      vendor_id(std::move(vendor_id_in)),
      size_um(std::move(size_um_in)),
      printable_area_um(std::move(printable_area_um_in)),
      max_height_um(std::move(max_height_um_in)),
      has_borderless_variant(std::move(has_borderless_variant_in)) {}

Paper::~Paper() = default;

void Paper::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vendor_id"), this->vendor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size_um"), this->size_um,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "printable_area_um"), this->printable_area_um,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_height_um"), this->max_height_um,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_borderless_variant"), this->has_borderless_variant,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Paper::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaType::MediaType()
    : display_name(),
      vendor_id() {}

MediaType::MediaType(
    const std::string& display_name_in,
    const std::string& vendor_id_in)
    : display_name(std::move(display_name_in)),
      vendor_id(std::move(vendor_id_in)) {}

MediaType::~MediaType() = default;
size_t MediaType::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->display_name);
  seed = mojo::internal::Hash(seed, this->vendor_id);
  return seed;
}

void MediaType::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vendor_id"), this->vendor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaType::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PrinterSemanticCapsAndDefaults::PrinterSemanticCapsAndDefaults()
    : collate_capable(false),
      collate_default(false),
      copies_max(1),
      duplex_modes(),
      duplex_default(::printing::mojom::DuplexMode::kUnknownDuplexMode),
      color_changeable(false),
      color_default(false),
      color_model(::printing::mojom::ColorModel::kUnknownColorModel),
      bw_model(::printing::mojom::ColorModel::kUnknownColorModel),
      papers(),
      user_defined_papers(),
      default_paper(),
      dpis(),
      default_dpi(),
      media_types(),
      default_media_type() {}

PrinterSemanticCapsAndDefaults::PrinterSemanticCapsAndDefaults(
    bool collate_capable_in,
    bool collate_default_in,
    int32_t copies_max_in,
    std::vector<::printing::mojom::DuplexMode> duplex_modes_in,
    ::printing::mojom::DuplexMode duplex_default_in,
    bool color_changeable_in,
    bool color_default_in,
    ::printing::mojom::ColorModel color_model_in,
    ::printing::mojom::ColorModel bw_model_in,
    std::vector<::printing::PrinterSemanticCapsAndDefaults::Paper> papers_in,
    std::vector<::printing::PrinterSemanticCapsAndDefaults::Paper> user_defined_papers_in,
    const ::printing::PrinterSemanticCapsAndDefaults::Paper& default_paper_in,
    std::vector<::gfx::Size> dpis_in,
    const ::gfx::Size& default_dpi_in,
    std::optional<std::vector<MediaTypePtr>> media_types_in,
    MediaTypePtr default_media_type_in)
    : collate_capable(std::move(collate_capable_in)),
      collate_default(std::move(collate_default_in)),
      copies_max(std::move(copies_max_in)),
      duplex_modes(std::move(duplex_modes_in)),
      duplex_default(std::move(duplex_default_in)),
      color_changeable(std::move(color_changeable_in)),
      color_default(std::move(color_default_in)),
      color_model(std::move(color_model_in)),
      bw_model(std::move(bw_model_in)),
      papers(std::move(papers_in)),
      user_defined_papers(std::move(user_defined_papers_in)),
      default_paper(std::move(default_paper_in)),
      dpis(std::move(dpis_in)),
      default_dpi(std::move(default_dpi_in)),
      media_types(std::move(media_types_in)),
      default_media_type(std::move(default_media_type_in)) {}

PrinterSemanticCapsAndDefaults::~PrinterSemanticCapsAndDefaults() = default;

void PrinterSemanticCapsAndDefaults::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "collate_capable"), this->collate_capable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "collate_default"), this->collate_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "copies_max"), this->copies_max,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duplex_modes"), this->duplex_modes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::printing::mojom::DuplexMode>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duplex_default"), this->duplex_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::DuplexMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_changeable"), this->color_changeable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_default"), this->color_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_model"), this->color_model,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::ColorModel>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bw_model"), this->bw_model,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::mojom::ColorModel>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "papers"), this->papers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::printing::PrinterSemanticCapsAndDefaults::Paper>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_defined_papers"), this->user_defined_papers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::printing::PrinterSemanticCapsAndDefaults::Paper>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "default_paper"), this->default_paper,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::printing::PrinterSemanticCapsAndDefaults::Paper&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dpis"), this->dpis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::gfx::Size>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "default_dpi"), this->default_dpi,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_types"), this->media_types,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<std::vector<MediaTypePtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "default_media_type"), this->default_media_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MediaTypePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PrinterSemanticCapsAndDefaults::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // printing::mojom


namespace mojo {


// static
bool StructTraits<::printing::mojom::PrinterBasicInfo::DataView, ::printing::mojom::PrinterBasicInfoPtr>::Read(
    ::printing::mojom::PrinterBasicInfo::DataView input,
    ::printing::mojom::PrinterBasicInfoPtr* output) {
  bool success = true;
  ::printing::mojom::PrinterBasicInfoPtr result(::printing::mojom::PrinterBasicInfo::New());
  
      if (success && !input.ReadPrinterName(&result->printer_name))
        success = false;
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success && !input.ReadPrinterDescription(&result->printer_description))
        success = false;
      if (success && !input.ReadOptions(&result->options))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::Paper::DataView, ::printing::mojom::PaperPtr>::Read(
    ::printing::mojom::Paper::DataView input,
    ::printing::mojom::PaperPtr* output) {
  bool success = true;
  ::printing::mojom::PaperPtr result(::printing::mojom::Paper::New());
  
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success && !input.ReadVendorId(&result->vendor_id))
        success = false;
      if (success && !input.ReadSizeUm(&result->size_um))
        success = false;
      if (success && !input.ReadPrintableAreaUm(&result->printable_area_um))
        success = false;
      if (success)
        result->max_height_um = input.max_height_um();
      if (success)
        result->has_borderless_variant = input.has_borderless_variant();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::MediaType::DataView, ::printing::mojom::MediaTypePtr>::Read(
    ::printing::mojom::MediaType::DataView input,
    ::printing::mojom::MediaTypePtr* output) {
  bool success = true;
  ::printing::mojom::MediaTypePtr result(::printing::mojom::MediaType::New());
  
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success && !input.ReadVendorId(&result->vendor_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::printing::mojom::PrinterSemanticCapsAndDefaults::DataView, ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr>::Read(
    ::printing::mojom::PrinterSemanticCapsAndDefaults::DataView input,
    ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr* output) {
  bool success = true;
  ::printing::mojom::PrinterSemanticCapsAndDefaultsPtr result(::printing::mojom::PrinterSemanticCapsAndDefaults::New());
  
      if (success)
        result->collate_capable = input.collate_capable();
      if (success)
        result->collate_default = input.collate_default();
      if (success)
        result->copies_max = input.copies_max();
      if (success && !input.ReadDuplexModes(&result->duplex_modes))
        success = false;
      if (success && !input.ReadDuplexDefault(&result->duplex_default))
        success = false;
      if (success)
        result->color_changeable = input.color_changeable();
      if (success)
        result->color_default = input.color_default();
      if (success && !input.ReadColorModel(&result->color_model))
        success = false;
      if (success && !input.ReadBwModel(&result->bw_model))
        success = false;
      if (success && !input.ReadPapers(&result->papers))
        success = false;
      if (success && !input.ReadUserDefinedPapers(&result->user_defined_papers))
        success = false;
      if (success && !input.ReadDefaultPaper(&result->default_paper))
        success = false;
      if (success && !input.ReadDpis(&result->dpis))
        success = false;
      if (success && !input.ReadDefaultDpi(&result->default_dpi))
        success = false;
      if (success && !input.ReadMediaTypes(&result->media_types))
        success = false;
      if (success && !input.ReadDefaultMediaType(&result->default_media_type))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace printing::mojom {




}  // printing::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif