// printing/backend/mojom/print_backend.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PRINTING_BACKEND_MOJOM_PRINT_BACKEND_MOJOM_SHARED_H_
#define PRINTING_BACKEND_MOJOM_PRINT_BACKEND_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "printing/backend/mojom/print_backend.mojom-shared-internal.h"
#include "printing/mojom/print.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"




#include "printing/backend/mojom/print_backend.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrinterBasicInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrinterBasicInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrinterBasicInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::printer_name(input)) in_printer_name = Traits::printer_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printer_name)::BaseType> printer_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_printer_name,
      printer_name_fragment);

    fragment->printer_name.Set(
        printer_name_fragment.is_null() ? nullptr : printer_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->printer_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null printer_name in PrinterBasicInfo struct");

    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_name,
      display_name_fragment);

    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_name in PrinterBasicInfo struct");

    decltype(Traits::printer_description(input)) in_printer_description = Traits::printer_description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printer_description)::BaseType> printer_description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_printer_description,
      printer_description_fragment);

    fragment->printer_description.Set(
        printer_description_fragment.is_null() ? nullptr : printer_description_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->printer_description.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null printer_description in PrinterBasicInfo struct");

    decltype(Traits::options(input)) in_options = Traits::options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->options)::BaseType>
        options_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& options_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
      in_options,
      options_fragment,
      &options_validate_params);

    fragment->options.Set(
        options_fragment.is_null() ? nullptr : options_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->options.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in PrinterBasicInfo struct");
  }

  static bool Deserialize(::printing::mojom::internal::PrinterBasicInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrinterBasicInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PaperDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PaperDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::Paper_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_name,
      display_name_fragment);

    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_name in Paper struct");

    decltype(Traits::vendor_id(input)) in_vendor_id = Traits::vendor_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->vendor_id)::BaseType> vendor_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_vendor_id,
      vendor_id_fragment);

    fragment->vendor_id.Set(
        vendor_id_fragment.is_null() ? nullptr : vendor_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->vendor_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vendor_id in Paper struct");

    decltype(Traits::size_um(input)) in_size_um = Traits::size_um(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size_um)::BaseType> size_um_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size_um,
      size_um_fragment);

    fragment->size_um.Set(
        size_um_fragment.is_null() ? nullptr : size_um_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->size_um.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size_um in Paper struct");

    decltype(Traits::printable_area_um(input)) in_printable_area_um = Traits::printable_area_um(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->printable_area_um)::BaseType> printable_area_um_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_printable_area_um,
      printable_area_um_fragment);

    fragment->printable_area_um.Set(
        printable_area_um_fragment.is_null() ? nullptr : printable_area_um_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->printable_area_um.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null printable_area_um in Paper struct");

    fragment->max_height_um = Traits::max_height_um(input);

    fragment->has_borderless_variant = Traits::has_borderless_variant(input);
  }

  static bool Deserialize(::printing::mojom::internal::Paper_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PaperDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::MediaTypeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::MediaTypeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::MediaType_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_name,
      display_name_fragment);

    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_name in MediaType struct");

    decltype(Traits::vendor_id(input)) in_vendor_id = Traits::vendor_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->vendor_id)::BaseType> vendor_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_vendor_id,
      vendor_id_fragment);

    fragment->vendor_id.Set(
        vendor_id_fragment.is_null() ? nullptr : vendor_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->vendor_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null vendor_id in MediaType struct");
  }

  static bool Deserialize(::printing::mojom::internal::MediaType_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::MediaTypeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrinterSemanticCapsAndDefaultsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PrinterSemanticCapsAndDefaultsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PrinterSemanticCapsAndDefaults_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->collate_capable = Traits::collate_capable(input);

    fragment->collate_default = Traits::collate_default(input);

    fragment->copies_max = Traits::copies_max(input);

    decltype(Traits::duplex_modes(input)) in_duplex_modes = Traits::duplex_modes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->duplex_modes)::BaseType>
        duplex_modes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& duplex_modes_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::printing::mojom::internal::DuplexMode_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::printing::mojom::DuplexMode>>(
      in_duplex_modes,
      duplex_modes_fragment,
      &duplex_modes_validate_params);

    fragment->duplex_modes.Set(
        duplex_modes_fragment.is_null() ? nullptr : duplex_modes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->duplex_modes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null duplex_modes in PrinterSemanticCapsAndDefaults struct");

    
    mojo::internal::Serialize<::printing::mojom::DuplexMode>(
      Traits::duplex_default(input),
      &fragment->duplex_default);

    fragment->color_changeable = Traits::color_changeable(input);

    fragment->color_default = Traits::color_default(input);

    
    mojo::internal::Serialize<::printing::mojom::ColorModel>(
      Traits::color_model(input),
      &fragment->color_model);

    
    mojo::internal::Serialize<::printing::mojom::ColorModel>(
      Traits::bw_model(input),
      &fragment->bw_model);

    decltype(Traits::papers(input)) in_papers = Traits::papers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->papers)::BaseType>
        papers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& papers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::printing::mojom::PaperDataView>>(
      in_papers,
      papers_fragment,
      &papers_validate_params);

    fragment->papers.Set(
        papers_fragment.is_null() ? nullptr : papers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->papers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null papers in PrinterSemanticCapsAndDefaults struct");

    decltype(Traits::user_defined_papers(input)) in_user_defined_papers = Traits::user_defined_papers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_defined_papers)::BaseType>
        user_defined_papers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& user_defined_papers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::printing::mojom::PaperDataView>>(
      in_user_defined_papers,
      user_defined_papers_fragment,
      &user_defined_papers_validate_params);

    fragment->user_defined_papers.Set(
        user_defined_papers_fragment.is_null() ? nullptr : user_defined_papers_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->user_defined_papers.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null user_defined_papers in PrinterSemanticCapsAndDefaults struct");

    decltype(Traits::default_paper(input)) in_default_paper = Traits::default_paper(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->default_paper)::BaseType> default_paper_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::printing::mojom::PaperDataView>(
      in_default_paper,
      default_paper_fragment);

    fragment->default_paper.Set(
        default_paper_fragment.is_null() ? nullptr : default_paper_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->default_paper.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_paper in PrinterSemanticCapsAndDefaults struct");

    decltype(Traits::dpis(input)) in_dpis = Traits::dpis(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dpis)::BaseType>
        dpis_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& dpis_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>>(
      in_dpis,
      dpis_fragment,
      &dpis_validate_params);

    fragment->dpis.Set(
        dpis_fragment.is_null() ? nullptr : dpis_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->dpis.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dpis in PrinterSemanticCapsAndDefaults struct");

    decltype(Traits::default_dpi(input)) in_default_dpi = Traits::default_dpi(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->default_dpi)::BaseType> default_dpi_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_default_dpi,
      default_dpi_fragment);

    fragment->default_dpi.Set(
        default_dpi_fragment.is_null() ? nullptr : default_dpi_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->default_dpi.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null default_dpi in PrinterSemanticCapsAndDefaults struct");

    decltype(Traits::media_types(input)) in_media_types = Traits::media_types(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->media_types)::BaseType>
        media_types_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& media_types_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::printing::mojom::MediaTypeDataView>>(
      in_media_types,
      media_types_fragment,
      &media_types_validate_params);

    fragment->media_types.Set(
        media_types_fragment.is_null() ? nullptr : media_types_fragment.data());

    decltype(Traits::default_media_type(input)) in_default_media_type = Traits::default_media_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->default_media_type)::BaseType> default_media_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::printing::mojom::MediaTypeDataView>(
      in_default_media_type,
      default_media_type_fragment);

    fragment->default_media_type.Set(
        default_media_type_fragment.is_null() ? nullptr : default_media_type_fragment.data());
  }

  static bool Deserialize(::printing::mojom::internal::PrinterSemanticCapsAndDefaults_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PrinterSemanticCapsAndDefaultsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace printing::mojom {

inline void PrinterBasicInfoDataView::GetPrinterNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->printer_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PrinterBasicInfoDataView::GetDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PrinterBasicInfoDataView::GetPrinterDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->printer_description.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PrinterBasicInfoDataView::GetOptionsDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->options.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, message_);
}


inline void PaperDataView::GetDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaperDataView::GetVendorIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->vendor_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PaperDataView::GetSizeUmDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size_um.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void PaperDataView::GetPrintableAreaUmDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->printable_area_um.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}


inline void MediaTypeDataView::GetDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaTypeDataView::GetVendorIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->vendor_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PrinterSemanticCapsAndDefaultsDataView::GetDuplexModesDataView(
    mojo::ArrayDataView<::printing::mojom::DuplexMode>* output) {
  auto pointer = data_->duplex_modes.Get();
  *output = mojo::ArrayDataView<::printing::mojom::DuplexMode>(pointer, message_);
}
inline void PrinterSemanticCapsAndDefaultsDataView::GetPapersDataView(
    mojo::ArrayDataView<PaperDataView>* output) {
  auto pointer = data_->papers.Get();
  *output = mojo::ArrayDataView<PaperDataView>(pointer, message_);
}
inline void PrinterSemanticCapsAndDefaultsDataView::GetUserDefinedPapersDataView(
    mojo::ArrayDataView<PaperDataView>* output) {
  auto pointer = data_->user_defined_papers.Get();
  *output = mojo::ArrayDataView<PaperDataView>(pointer, message_);
}
inline void PrinterSemanticCapsAndDefaultsDataView::GetDefaultPaperDataView(
    PaperDataView* output) {
  auto pointer = data_->default_paper.Get();
  *output = PaperDataView(pointer, message_);
}
inline void PrinterSemanticCapsAndDefaultsDataView::GetDpisDataView(
    mojo::ArrayDataView<::gfx::mojom::SizeDataView>* output) {
  auto pointer = data_->dpis.Get();
  *output = mojo::ArrayDataView<::gfx::mojom::SizeDataView>(pointer, message_);
}
inline void PrinterSemanticCapsAndDefaultsDataView::GetDefaultDpiDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->default_dpi.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void PrinterSemanticCapsAndDefaultsDataView::GetMediaTypesDataView(
    mojo::ArrayDataView<MediaTypeDataView>* output) {
  auto pointer = data_->media_types.Get();
  *output = mojo::ArrayDataView<MediaTypeDataView>(pointer, message_);
}
inline void PrinterSemanticCapsAndDefaultsDataView::GetDefaultMediaTypeDataView(
    MediaTypeDataView* output) {
  auto pointer = data_->default_media_type.Get();
  *output = MediaTypeDataView(pointer, message_);
}



}  // printing::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // PRINTING_BACKEND_MOJOM_PRINT_BACKEND_MOJOM_SHARED_H_